/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.AsyncLoadingCache;
import com.apple.foundationdb.record.LoggableTimeoutException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.ResolverStateProto;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreSubTimer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.BlockingInAsyncDetection;
import com.apple.foundationdb.record.provider.foundationdb.BlockingInAsyncException;
import com.apple.foundationdb.record.provider.foundationdb.EventKeeperTranslator;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunnerImpl;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBLatencySource;
import com.apple.foundationdb.record.provider.foundationdb.FDBLocalityProvider;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.InstrumentedTransaction;
import com.apple.foundationdb.record.provider.foundationdb.KeyCheckingTransaction;
import com.apple.foundationdb.record.provider.foundationdb.TransactionListener;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.LocatableResolver;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ResolverResult;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.ScopedValue;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.provider.foundationdb.storestate.PassThroughRecordStoreStateCache;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@API(value=API.Status.UNSTABLE)
public class FDBDatabase {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDatabase.class);
    protected static final String BLOCKING_IN_ASYNC_CONTEXT_MESSAGE = "Blocking in an asynchronous context";
    protected static final String BLOCKING_RETURNING_ASYNC_MESSAGE = "Blocking in future producing call";
    protected static final String BLOCKING_FOR_FUTURE_MESSAGE = "Blocking on a future that should be completed";
    @Nonnull
    private final FDBDatabaseFactory factory;
    @Nullable
    private final String clusterFile;
    @Nullable
    private Database database;
    @Nonnull
    private final ScheduledExecutorService scheduledExecutor;
    @Nullable
    private Function<StoreTimer.Wait, Duration> asyncToSyncTimeout;
    @Nonnull
    private ExceptionMapper asyncToSyncExceptionMapper;
    @Nonnull
    private AsyncLoadingCache<LocatableResolver, ResolverStateProto.State> resolverStateCache;
    @Nonnull
    private Cache<ScopedValue<String>, ResolverResult> directoryCache;
    @Nonnull
    private AtomicInteger directoryCacheVersion = new AtomicInteger();
    @Nonnull
    private Cache<ScopedValue<Long>, String> reverseDirectoryInMemoryCache;
    private boolean opened;
    private final Object reverseDirectoryCacheLock = new Object();
    private volatile FDBReverseDirectoryCache reverseDirectoryCache;
    private final int reverseDirectoryMaxRowsPerTransaction;
    private final long reverseDirectoryMaxMillisPerTransaction;
    @Nonnull
    private FDBRecordStoreStateCache storeStateCache = PassThroughRecordStoreStateCache.instance();
    private final Supplier<Boolean> transactionIsTracedSupplier;
    private final long warnAndCloseOpenContextsAfterSeconds;
    public static final int DEFAULT_MAX_REVERSE_CACHE_ENTRIES = 5000;
    public static final int DEFAULT_RESOLVER_STATE_CACHE_REFRESH_SECONDS = 30;
    private boolean trackLastSeenVersionOnRead = false;
    private boolean trackLastSeenVersionOnCommit = false;
    @Nonnull
    private final Supplier<BlockingInAsyncDetection> blockingInAsyncDetectionSupplier;
    @Nonnull
    private final Function<FDBLatencySource, Long> latencyInjector;
    private String datacenterId;
    @Nonnull
    private final FDBLocalityProvider localityProvider;
    @Nonnull
    private final APIVersion apiVersion;
    @Nonnull
    private static final Pair<Long, Long> initialVersionPair = Pair.of(null, null);
    @Nonnull
    private final AtomicReference<Pair<Long, Long>> lastSeenFDBVersion = new AtomicReference<Pair<Long, Long>>(initialVersionPair);
    private final NavigableMap<Long, FDBRecordContext> trackedOpenContexts = new ConcurrentSkipListMap<Long, FDBRecordContext>();

    @VisibleForTesting
    public FDBDatabase(@Nonnull FDBDatabaseFactory factory, @Nullable String clusterFile) {
        this.factory = factory;
        this.clusterFile = clusterFile;
        this.asyncToSyncExceptionMapper = (ex, ev) -> FDBExceptions.wrapException(ex);
        this.reverseDirectoryMaxRowsPerTransaction = factory.getReverseDirectoryRowsPerTransaction();
        this.reverseDirectoryMaxMillisPerTransaction = factory.getReverseDirectoryMaxMillisPerTransaction();
        this.transactionIsTracedSupplier = factory.getTransactionIsTracedSupplier();
        this.warnAndCloseOpenContextsAfterSeconds = factory.getWarnAndCloseOpenContextsAfterSeconds();
        this.blockingInAsyncDetectionSupplier = factory.getBlockingInAsyncDetectionSupplier();
        this.reverseDirectoryInMemoryCache = CacheBuilder.newBuilder().maximumSize(5000L).recordStats().build();
        this.directoryCache = CacheBuilder.newBuilder().maximumSize(factory.getDirectoryCacheSize()).recordStats().build();
        this.scheduledExecutor = factory.getScheduledExecutor();
        this.resolverStateCache = new AsyncLoadingCache(factory.getStateRefreshTimeMillis(), 5000L, Long.MAX_VALUE, this.scheduledExecutor);
        this.latencyInjector = factory.getLatencyInjector();
        this.datacenterId = factory.getDatacenterId();
        this.localityProvider = factory.getLocalityProvider();
        this.apiVersion = factory.getAPIVersion();
    }

    protected synchronized void openFDB() {
        if (!this.opened) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Opening FDB", new Object[]{LogMessageKeys.CLUSTER, this.clusterFile}));
            }
            this.database = this.factory.open(this.clusterFile);
            this.setDirectoryCacheSize(this.factory.getDirectoryCacheSize());
            this.opened = true;
        }
    }

    public synchronized void setDirectoryCacheSize(int size) {
        int maxSize = size > 0 ? size : 0;
        this.directoryCache = CacheBuilder.newBuilder().recordStats().maximumSize(maxSize).build();
    }

    public synchronized void setDatacenterId(String datacenterId) {
        this.datacenterId = datacenterId;
        this.database().options().setDatacenterId(datacenterId);
    }

    public synchronized String getDatacenterId() {
        return this.datacenterId;
    }

    @Nonnull
    public synchronized FDBLocalityProvider getLocalityProvider() {
        return this.localityProvider;
    }

    @API(value=API.Status.INTERNAL)
    public APIVersion getAPIVersion() {
        return this.apiVersion;
    }

    public synchronized void setTrackLastSeenVersionOnRead(boolean trackLastSeenVersion) {
        this.trackLastSeenVersionOnRead = trackLastSeenVersion;
    }

    public synchronized boolean isTrackLastSeenVersionOnRead() {
        return this.trackLastSeenVersionOnRead;
    }

    public synchronized void setTrackLastSeenVersionOnCommit(boolean trackLastSeenVersion) {
        this.trackLastSeenVersionOnCommit = trackLastSeenVersion;
    }

    public synchronized boolean isTrackLastSeenVersionOnCommit() {
        return this.trackLastSeenVersionOnCommit;
    }

    public synchronized void setTrackLastSeenVersion(boolean trackLastSeenVersion) {
        this.trackLastSeenVersionOnRead = trackLastSeenVersion;
        this.trackLastSeenVersionOnCommit = trackLastSeenVersion;
    }

    public synchronized boolean isTrackLastSeenVersion() {
        return this.trackLastSeenVersionOnRead || this.trackLastSeenVersionOnCommit;
    }

    @Nullable
    public String getClusterFile() {
        return this.clusterFile;
    }

    @Nonnull
    protected FDBDatabaseFactory getFactory() {
        return this.factory;
    }

    @Nonnull
    public Database database() {
        this.openFDB();
        return this.database;
    }

    @Nonnull
    public FDBRecordContext openContext() {
        return this.openContext(null, null);
    }

    @Nonnull
    public FDBRecordContext openContext(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer) {
        return this.openContext(mdcContext, timer, null);
    }

    @Nonnull
    public FDBRecordContext openContext(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer, @Nullable WeakReadSemantics weakReadSemantics) {
        return this.openContext(mdcContext, timer, weakReadSemantics, FDBTransactionPriority.DEFAULT);
    }

    @Nonnull
    public FDBRecordContext openContext(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer, @Nullable WeakReadSemantics weakReadSemantics, @Nonnull FDBTransactionPriority priority) {
        return this.openContext(mdcContext, timer, weakReadSemantics, priority, null);
    }

    @Nonnull
    public FDBRecordContext openContext(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer, @Nullable WeakReadSemantics weakReadSemantics, @Nonnull FDBTransactionPriority priority, @Nullable String transactionId) {
        FDBRecordContextConfig contextConfig = FDBRecordContextConfig.newBuilder().setMdcContext(mdcContext).setTimer(timer).setWeakReadSemantics(weakReadSemantics).setPriority(priority).setTransactionId(transactionId).build();
        return this.openContext(contextConfig);
    }

    @Nonnull
    public FDBRecordContext openContext(@Nonnull FDBRecordContextConfig contextConfig) {
        Pair<Long, Long> pair;
        this.openFDB();
        FDBStoreTimer delayedTimer = contextConfig.getTimer() == null ? null : new FDBStoreTimer();
        Executor executor = this.newContextExecutor(contextConfig.getMdcContext());
        Transaction transaction = this.createTransaction(contextConfig, delayedTimer, executor);
        if (this.transactionIsTracedSupplier.get().booleanValue()) {
            contextConfig = contextConfig.toBuilder().setTrackOpen(true).setLogTransaction(true).setSaveOpenStackTrace(true).build();
        }
        FDBRecordContext context = new FDBRecordContext(this, transaction, contextConfig, delayedTimer);
        WeakReadSemantics weakReadSemantics = context.getWeakReadSemantics();
        if (this.isTrackLastSeenVersion() && weakReadSemantics != null && (pair = this.lastSeenFDBVersion.get()) != initialVersionPair) {
            long version = pair.getLeft();
            long versionTimeMillis = pair.getRight();
            if (version >= weakReadSemantics.getMinVersion() && System.currentTimeMillis() - versionTimeMillis <= weakReadSemantics.getStalenessBoundMillis()) {
                context.setReadVersion(version);
                context.increment(FDBStoreTimer.Counts.SET_READ_VERSION_TO_LAST_SEEN);
            }
        }
        if (this.warnAndCloseOpenContextsAfterSeconds > 0L) {
            this.warnAndCloseOldTrackedOpenContexts(this.warnAndCloseOpenContextsAfterSeconds);
        }
        if (contextConfig.isTrackOpen()) {
            this.trackOpenContext(context);
        }
        return context;
    }

    @Nonnull
    public CompletableFuture<Void> performNoOpAsync() {
        return this.performNoOpAsync(null);
    }

    @Nonnull
    public CompletableFuture<Void> performNoOpAsync(@Nullable FDBStoreTimer timer) {
        return this.performNoOpAsync(null, timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompletableFuture<Void> performNoOpAsync(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer) {
        FDBRecordContext context = this.openContext(mdcContext, timer);
        boolean futureStarted = false;
        try {
            Transaction tr = context.ensureActive();
            long startTime = System.nanoTime();
            tr.setReadVersion(1066L);
            CompletableFuture<Long> future = tr.getReadVersion();
            if (timer != null) {
                future = context.instrument(FDBStoreTimer.Events.PERFORM_NO_OP, future, startTime);
            }
            futureStarted = true;
            CompletionStage completionStage = ((CompletableFuture)future.thenAccept(ignore -> {})).whenComplete((vignore, err) -> context.close());
            return completionStage;
        }
        catch (RuntimeException e) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            if (!futureStarted) {
                context.close();
            }
        }
    }

    public void performNoOp() {
        this.performNoOp(null);
    }

    public void performNoOp(@Nullable FDBStoreTimer timer) {
        this.performNoOp(null, timer);
    }

    public void performNoOp(@Nullable Map<String, String> mdcContext, @Nullable FDBStoreTimer timer) {
        this.asyncToSync(timer, FDBStoreTimer.Waits.WAIT_PERFORM_NO_OP, this.performNoOpAsync(mdcContext, timer));
    }

    private long versionTimeEstimate(long startMillis) {
        return startMillis + (System.currentTimeMillis() - startMillis) / 2L;
    }

    public long getResolverStateCacheRefreshTime() {
        return this.resolverStateCache.getRefreshTimeSeconds();
    }

    @VisibleForTesting
    public void setResolverStateRefreshTimeMillis(long resolverStateRefreshTimeMillis) {
        this.resolverStateCache.clear();
        this.resolverStateCache = new AsyncLoadingCache(resolverStateRefreshTimeMillis, this.resolverStateCache.getDeadlineTimeMillis(), this.resolverStateCache.getMaxSize(), this.getScheduledExecutor());
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<ResolverStateProto.State> getStateForResolver(@Nonnull LocatableResolver resolver, @Nonnull Supplier<CompletableFuture<ResolverStateProto.State>> loader) {
        return this.resolverStateCache.orElseGet(resolver, loader);
    }

    @API(value=API.Status.INTERNAL)
    public void updateLastSeenFDBVersion(long startTime, long readVersion) {
        this.lastSeenFDBVersion.updateAndGet(pair -> pair.getLeft() == null || readVersion > (Long)pair.getLeft() ? Pair.of(readVersion, this.versionTimeEstimate(startTime)) : pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @API(value=API.Status.INTERNAL)
    public FDBReverseDirectoryCache getReverseDirectoryCache() {
        if (this.reverseDirectoryCache == null) {
            Object object = this.reverseDirectoryCacheLock;
            synchronized (object) {
                if (this.reverseDirectoryCache == null) {
                    this.reverseDirectoryCache = new FDBReverseDirectoryCache(this, this.reverseDirectoryMaxRowsPerTransaction, this.reverseDirectoryMaxMillisPerTransaction);
                }
            }
        }
        return this.reverseDirectoryCache;
    }

    private void setDirectoryCacheVersion(int version) {
        this.directoryCacheVersion.set(version);
    }

    @API(value=API.Status.INTERNAL)
    public int getDirectoryCacheVersion() {
        return this.directoryCacheVersion.get();
    }

    public CacheStats getDirectoryCacheStats() {
        return this.directoryCache.stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @API(value=API.Status.INTERNAL)
    public Cache<ScopedValue<String>, ResolverResult> getDirectoryCache(int atVersion) {
        if (atVersion > this.getDirectoryCacheVersion()) {
            FDBDatabase fDBDatabase = this;
            synchronized (fDBDatabase) {
                if (atVersion > this.getDirectoryCacheVersion()) {
                    this.directoryCache = CacheBuilder.newBuilder().recordStats().maximumSize(this.factory.getDirectoryCacheSize()).build();
                    this.setDirectoryCacheVersion(atVersion);
                }
            }
        }
        return this.directoryCache;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public Cache<ScopedValue<Long>, String> getReverseDirectoryInMemoryCache() {
        return this.reverseDirectoryInMemoryCache;
    }

    @API(value=API.Status.INTERNAL)
    public void clearForwardDirectoryCache() {
        this.directoryCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @API(value=API.Status.INTERNAL)
    public void clearReverseDirectoryCache() {
        Object object = this.reverseDirectoryCacheLock;
        synchronized (object) {
            this.reverseDirectoryCache = null;
            this.reverseDirectoryInMemoryCache.invalidateAll();
        }
    }

    @Nonnull
    public FDBRecordStoreStateCache getStoreStateCache() {
        return this.storeStateCache;
    }

    public void setStoreStateCache(@Nonnull FDBRecordStoreStateCache storeStateCache) {
        storeStateCache.validateDatabase(this);
        this.storeStateCache = storeStateCache;
    }

    @VisibleForTesting
    @API(value=API.Status.INTERNAL)
    public void clearCaches() {
        this.resolverStateCache.clear();
        this.clearForwardDirectoryCache();
        this.clearReverseDirectoryCache();
        this.storeStateCache.clear();
    }

    public synchronized void close() {
        if (this.opened) {
            this.database.close();
            this.database = null;
            this.opened = false;
            this.directoryCacheVersion.set(0);
            this.clearCaches();
            this.reverseDirectoryInMemoryCache.invalidateAll();
        }
    }

    @Nonnull
    public Executor getExecutor() {
        return this.factory.getExecutor();
    }

    @API(value=API.Status.INTERNAL)
    public Executor newContextExecutor(@Nullable Map<String, String> mdcContext) {
        return this.factory.newContextExecutor(mdcContext);
    }

    @Nonnull
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    private Transaction createTransaction(@Nonnull FDBRecordContextConfig config, @Nullable FDBStoreTimer delayedTimer, @Nonnull Executor executor) {
        TransactionListener listener = config.getTransactionListener() == null ? this.factory.getTransactionListener() : config.getTransactionListener();
        StoreTimer timer = listener != null ? new StoreSubTimer(config.getTimer()) : config.getTimer();
        boolean enableAssertions = config.areAssertionsEnabled();
        Transaction transaction = this.database.createTransaction(executor, new EventKeeperTranslator(timer));
        if (timer != null || enableAssertions) {
            transaction = new InstrumentedTransaction(timer, delayedTimer, this, listener, transaction, enableAssertions);
        }
        if (config.getKeyChecker() != null) {
            transaction = new KeyCheckingTransaction(transaction, config.getKeyChecker());
        }
        return transaction;
    }

    @Nonnull
    public FDBDatabaseRunner newRunner(@Nonnull FDBRecordContextConfig.Builder contextConfigBuilder) {
        return new FDBDatabaseRunnerImpl(this, contextConfigBuilder);
    }

    @Nonnull
    public FDBDatabaseRunner newRunner() {
        return this.newRunner(FDBRecordContextConfig.newBuilder());
    }

    @Nonnull
    public FDBDatabaseRunner newRunner(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext) {
        return this.newRunner(FDBRecordContextConfig.newBuilder().setTimer(timer).setMdcContext(mdcContext));
    }

    @Nonnull
    public FDBDatabaseRunner newRunner(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nullable WeakReadSemantics weakReadSemantics) {
        return this.newRunner(FDBRecordContextConfig.newBuilder().setTimer(timer).setMdcContext(mdcContext).setWeakReadSemantics(weakReadSemantics));
    }

    public <T> T run(@Nonnull Function<? super FDBRecordContext, ? extends T> retriable) {
        try (FDBDatabaseRunner runner = this.newRunner();){
            T t2 = runner.run(retriable);
            return t2;
        }
    }

    public <T> T run(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nonnull Function<? super FDBRecordContext, ? extends T> retriable) {
        try (FDBDatabaseRunner runner = this.newRunner(timer, mdcContext);){
            T t2 = runner.run(retriable);
            return t2;
        }
    }

    public <T> T run(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nullable WeakReadSemantics weakReadSemantics, @Nonnull Function<? super FDBRecordContext, ? extends T> retriable) {
        try (FDBDatabaseRunner runner = this.newRunner(timer, mdcContext, weakReadSemantics);){
            T t2 = runner.run(retriable);
            return t2;
        }
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        return this.runAsync(retriable, null);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nullable List<Object> additionalLogMessageKeyValues) {
        FDBDatabaseRunner runner = this.newRunner();
        return runner.runAsync(retriable, additionalLogMessageKeyValues).whenComplete((t2, e) -> runner.close());
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public <T> CompletableFuture<T> runAsync(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        return this.runAsync(timer, mdcContext, retriable, null);
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public <T> CompletableFuture<T> runAsync(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nullable List<Object> additionalLogMessageKeyValues) {
        FDBDatabaseRunner runner = this.newRunner(timer, mdcContext);
        return runner.runAsync(retriable, additionalLogMessageKeyValues).whenComplete((t2, e) -> runner.close());
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public <T> CompletableFuture<T> runAsync(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, @Nullable WeakReadSemantics weakReadSemantics, @Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        FDBDatabaseRunner runner = this.newRunner(timer, mdcContext, weakReadSemantics);
        return runner.runAsync(retriable).whenComplete((t2, e) -> runner.close());
    }

    public boolean hasAsyncToSyncTimeout() {
        return this.asyncToSyncTimeout != null;
    }

    @Nullable
    public Duration getAsyncToSyncTimeout(StoreTimer.Wait event) {
        if (this.asyncToSyncTimeout == null) {
            return null;
        }
        return this.asyncToSyncTimeout.apply(event);
    }

    @Nullable
    public Function<StoreTimer.Wait, Duration> getAsyncToSyncTimeout() {
        return this.asyncToSyncTimeout;
    }

    public void setAsyncToSyncTimeout(@Nullable Function<StoreTimer.Wait, Duration> asyncToSyncTimeout) {
        this.asyncToSyncTimeout = asyncToSyncTimeout;
    }

    public void setAsyncToSyncTimeout(long asyncToSyncTimeout, @Nonnull TimeUnit asyncToSyncTimeoutUnit) {
        Duration timeout = Duration.ofNanos(asyncToSyncTimeoutUnit.toNanos(asyncToSyncTimeout));
        this.setAsyncToSyncTimeout(event -> timeout);
    }

    public void clearAsyncToSyncTimeout() {
        this.asyncToSyncTimeout = null;
    }

    public void setAsyncToSyncExceptionMapper(@Nonnull ExceptionMapper asyncToSyncExceptionMapper) {
        this.asyncToSyncExceptionMapper = asyncToSyncExceptionMapper;
    }

    protected RuntimeException mapAsyncToSyncException(@Nonnull Throwable ex) {
        return this.asyncToSyncExceptionMapper.apply(ex, null);
    }

    @Nullable
    public <T> T asyncToSync(@Nullable FDBStoreTimer timer, StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        this.checkIfBlockingInFuture(async);
        if (async.isDone()) {
            try {
                return async.get();
            }
            catch (ExecutionException ex) {
                throw this.asyncToSyncExceptionMapper.apply(ex, event);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw this.asyncToSyncExceptionMapper.apply(ex, event);
            }
        }
        Duration timeout = this.getAsyncToSyncTimeout(event);
        long startTime = System.nanoTime();
        try {
            if (timeout != null) {
                T t2 = async.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
                return t2;
            }
            T t3 = async.get();
            return t3;
        }
        catch (TimeoutException ex) {
            if (timer != null) {
                timer.recordTimeout(event, startTime);
                throw this.asyncToSyncExceptionMapper.apply(new LoggableTimeoutException(ex, new Object[]{LogMessageKeys.TIME_LIMIT.toString(), timeout.toNanos(), LogMessageKeys.TIME_UNIT.toString(), TimeUnit.NANOSECONDS}), event);
            }
            throw this.asyncToSyncExceptionMapper.apply(ex, event);
        }
        catch (ExecutionException ex) {
            throw this.asyncToSyncExceptionMapper.apply(ex, event);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw this.asyncToSyncExceptionMapper.apply(ex, event);
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime(event, startTime);
            }
        }
    }

    public <T> T join(CompletableFuture<T> future) {
        this.checkIfBlockingInFuture(future);
        return future.join();
    }

    public <T> T joinNow(CompletableFuture<T> future) {
        if (future.isDone()) {
            return future.join();
        }
        BlockingInAsyncDetection behavior = this.getBlockingInAsyncDetection();
        StackTraceElement caller = Thread.currentThread().getStackTrace()[1];
        this.logOrThrowBlockingInAsync(behavior, false, caller, BLOCKING_FOR_FUTURE_MESSAGE);
        return future.join();
    }

    public <T> T get(CompletableFuture<T> future) throws InterruptedException, ExecutionException {
        this.checkIfBlockingInFuture(future);
        return future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int warnAndCloseOldTrackedOpenContexts(long minAgeSeconds) {
        long cutoffTime = System.nanoTime() - TimeUnit.SECONDS.toNanos(minAgeSeconds);
        Map.Entry<Long, FDBRecordContext> firstEntry = this.trackedOpenContexts.firstEntry();
        if (firstEntry == null || firstEntry.getKey() > cutoffTime) {
            return 0;
        }
        Map<String, String> threadMdc = MDC.getCopyOfContextMap();
        MDC.clear();
        int count = 0;
        try {
            for (FDBRecordContext context : this.trackedOpenContexts.headMap(cutoffTime, true).values()) {
                KeyValueLogMessage msg = KeyValueLogMessage.build("context not closed", new Object[]{LogMessageKeys.AGE_SECONDS, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - context.getTrackOpenTimeNanos()), LogMessageKeys.TRANSACTION_ID, context.getTransactionId(), LogMessageKeys.CLUSTER, this.clusterFile});
                Map<String, String> contextMdc = context.getMdcContext();
                if (contextMdc != null) {
                    msg.addKeysAndValues(contextMdc);
                }
                if (LOGGER.isWarnEnabled()) {
                    if (context.getOpenStackTrace() != null) {
                        LOGGER.warn(msg.toString(), context.getOpenStackTrace());
                    } else {
                        LOGGER.warn(msg.toString());
                    }
                }
                context.closeTransaction(true);
                ++count;
            }
        }
        finally {
            if (threadMdc != null) {
                MDC.setContextMap(threadMdc);
            }
        }
        return count;
    }

    protected void trackOpenContext(FDBRecordContext context) {
        long key;
        for (key = System.nanoTime(); key == 0L || this.trackedOpenContexts.putIfAbsent(key, context) != null; ++key) {
        }
        context.setTrackOpenTimeNanos(key);
    }

    protected void untrackOpenContext(FDBRecordContext context) {
        FDBRecordContext found = (FDBRecordContext)this.trackedOpenContexts.remove(context.getTrackOpenTimeNanos());
        if (found != context) {
            throw new RecordCoreException("tracked context does not match", new Object[0]);
        }
    }

    @API(value=API.Status.INTERNAL)
    public BlockingInAsyncDetection getBlockingInAsyncDetection() {
        return this.blockingInAsyncDetectionSupplier.get();
    }

    protected long getLatencyToInject(FDBLatencySource fdbLatencySource) {
        return this.latencyInjector.apply(fdbLatencySource);
    }

    @API(value=API.Status.INTERNAL)
    public void checkIfBlockingInFuture(CompletableFuture<?> future) {
        BlockingInAsyncDetection behavior = this.getBlockingInAsyncDetection();
        if (behavior == BlockingInAsyncDetection.DISABLED) {
            return;
        }
        boolean isComplete = future.isDone();
        if (isComplete && behavior.ignoreComplete()) {
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement possiblyAsyncReturningLocation = null;
        for (StackTraceElement stackElement : stack) {
            if (stackElement.getClassName().startsWith(CompletableFuture.class.getName())) {
                this.logOrThrowBlockingInAsync(behavior, isComplete, stackElement, BLOCKING_IN_ASYNC_CONTEXT_MESSAGE);
                continue;
            }
            if (!stackElement.getMethodName().endsWith("Async")) continue;
            possiblyAsyncReturningLocation = stackElement;
        }
        if (possiblyAsyncReturningLocation != null && !isComplete) {
            this.logOrThrowBlockingInAsync(BlockingInAsyncDetection.IGNORE_COMPLETE_WARN_BLOCKING, isComplete, possiblyAsyncReturningLocation, BLOCKING_RETURNING_ASYNC_MESSAGE);
        }
    }

    private void logOrThrowBlockingInAsync(@Nonnull BlockingInAsyncDetection behavior, boolean isComplete, @Nonnull StackTraceElement stackElement, @Nonnull String title) {
        RecordCoreException exception = new BlockingInAsyncException(title).addLogInfo(new Object[]{LogMessageKeys.FUTURE_COMPLETED, isComplete, LogMessageKeys.CALLING_CLASS, stackElement.getClassName(), LogMessageKeys.CALLING_METHOD, stackElement.getMethodName(), LogMessageKeys.CALLING_LINE, stackElement.getLineNumber()});
        if (!isComplete && behavior.throwExceptionOnBlocking()) {
            throw exception;
        }
        if (LOGGER.isWarnEnabled()) {
            KeyValueLogMessage logMessage = KeyValueLogMessage.build(title, new Object[0]).addKeysAndValues(exception.getLogInfo());
            LOGGER.warn(logMessage.toString(), exception);
        }
    }

    public CompletableFuture<Tuple> loadBoundaryKeys(@Nonnull FDBTransactionContext context, Tuple key) {
        CompletionStage result = context.ensureActive().get(key.pack()).thenApply(bytes -> bytes == null ? null : Tuple.fromBytes(bytes));
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.LOAD_BOUNDARY_KEYS, result);
    }

    @FunctionalInterface
    public static interface ExceptionMapper {
        public RuntimeException apply(@Nonnull Throwable var1, @Nullable StoreTimer.Event var2);
    }

    public static class WeakReadSemantics {
        private long minVersion;
        private long stalenessBoundMillis;
        private boolean isCausalReadRisky;

        public WeakReadSemantics(long minVersion, long stalenessBoundMillis, boolean isCausalReadRisky) {
            this.minVersion = minVersion;
            this.stalenessBoundMillis = stalenessBoundMillis;
            this.isCausalReadRisky = isCausalReadRisky;
        }

        public long getMinVersion() {
            return this.minVersion;
        }

        public long getStalenessBoundMillis() {
            return this.stalenessBoundMillis;
        }

        public boolean isCausalReadRisky() {
            return this.isCausalReadRisky;
        }
    }
}

