/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.BlockingInAsyncDetection;
import com.apple.foundationdb.record.provider.foundationdb.ContextRestoringExecutor;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactoryImpl;
import com.apple.foundationdb.record.provider.foundationdb.FDBLatencySource;
import com.apple.foundationdb.record.provider.foundationdb.FDBLocalityProvider;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBTraceFormat;
import com.apple.foundationdb.record.provider.foundationdb.TransactionListener;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCacheFactory;
import com.apple.foundationdb.record.provider.foundationdb.storestate.PassThroughRecordStoreStateCacheFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FDBDatabaseFactory {
    public static final int DEFAULT_DIRECTORY_CACHE_SIZE = 5000;
    public static final long DEFAULT_TR_TIMEOUT_MILLIS = -1L;
    public static final long UNLIMITED_TR_TIMEOUT_MILLIS = 0L;
    protected static final Function<FDBLatencySource, Long> DEFAULT_LATENCY_INJECTOR = api -> 0L;
    protected final Map<String, FDBDatabase> databases = new HashMap<String, FDBDatabase>();
    @Nullable
    protected volatile Executor networkExecutor = null;
    @Nonnull
    protected Function<Executor, Executor> contextExecutor = Function.identity();
    protected boolean unclosedWarning = true;
    @Nonnull
    protected Supplier<BlockingInAsyncDetection> blockingInAsyncDetectionSupplier = () -> BlockingInAsyncDetection.DISABLED;
    @Nonnull
    protected FDBRecordStoreStateCacheFactory storeStateCacheFactory = PassThroughRecordStoreStateCacheFactory.instance();
    @Nonnull
    private Executor executor = ForkJoinPool.commonPool();
    @Nonnull
    private Supplier<ScheduledExecutorService> scheduledExecutorSupplier = MoreAsyncUtil::getDefaultScheduledExecutor;
    private int directoryCacheSize = 5000;
    private boolean trackLastSeenVersion;
    private String datacenterId;
    private int maxAttempts = 10;
    private long maxDelayMillis = 1000L;
    private long initialDelayMillis = 10L;
    private int reverseDirectoryRowsPerTransaction = 10000;
    private long reverseDirectoryMaxMillisPerTransaction = FDBReverseDirectoryCache.MAX_MILLIS_PER_TRANSACTION;
    private long stateRefreshTimeMillis = TimeUnit.SECONDS.toMillis(30L);
    private long transactionTimeoutMillis = -1L;
    private long warnAndCloseOpenContextsAfterSeconds;
    @Nullable
    private TransactionListener transactionListener;
    private Function<FDBLatencySource, Long> latencyInjector = DEFAULT_LATENCY_INJECTOR;

    @Nonnull
    public static FDBDatabaseFactoryImpl instance() {
        return FDBDatabaseFactoryImpl.instance();
    }

    @Nullable
    public Executor getNetworkExecutor() {
        return this.networkExecutor;
    }

    public void setNetworkExecutor(@Nonnull Executor networkExecutor) {
        this.networkExecutor = networkExecutor;
    }

    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(@Nonnull Executor executor) {
        this.executor = executor;
    }

    @Nonnull
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutorSupplier.get();
    }

    public void setScheduledExecutor(@Nonnull ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutorSupplier = () -> scheduledExecutor;
    }

    public void setScheduledExecutorSupplier(@Nonnull Supplier<ScheduledExecutorService> scheduledExecutorSupplier) {
        this.scheduledExecutorSupplier = scheduledExecutorSupplier;
    }

    public void setContextExecutor(@Nonnull Function<Executor, Executor> contextExecutor) {
        this.contextExecutor = contextExecutor;
    }

    public synchronized void clear() {
        for (FDBDatabase database : this.databases.values()) {
            database.close();
        }
        this.databases.clear();
    }

    public boolean isUnclosedWarning() {
        return this.unclosedWarning;
    }

    public void setUnclosedWarning(boolean unclosedWarning) {
        this.unclosedWarning = unclosedWarning;
    }

    public synchronized int getDirectoryCacheSize() {
        return this.directoryCacheSize;
    }

    public synchronized boolean getTrackLastSeenVersion() {
        return this.trackLastSeenVersion;
    }

    public synchronized String getDatacenterId() {
        return this.datacenterId;
    }

    public synchronized void setDirectoryCacheSize(int directoryCacheSize) {
        this.directoryCacheSize = directoryCacheSize;
        for (FDBDatabase database : this.databases.values()) {
            database.setDirectoryCacheSize(directoryCacheSize);
        }
    }

    public synchronized void setTrackLastSeenVersion(boolean trackLastSeenVersion) {
        this.trackLastSeenVersion = trackLastSeenVersion;
        for (FDBDatabase database : this.databases.values()) {
            database.setTrackLastSeenVersion(trackLastSeenVersion);
        }
    }

    public synchronized void setDatacenterId(String datacenterId) {
        this.datacenterId = datacenterId;
        for (FDBDatabase database : this.databases.values()) {
            database.setDatacenterId(datacenterId);
        }
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new RecordCoreException("Cannot set maximum number of attempts to less than or equal to zero", new Object[0]);
        }
        this.maxAttempts = maxAttempts;
    }

    public long getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    public void setMaxDelayMillis(long maxDelayMillis) {
        if (maxDelayMillis < 0L) {
            throw new RecordCoreException("Cannot set maximum delay milliseconds to less than or equal to zero", new Object[0]);
        }
        if (maxDelayMillis < this.initialDelayMillis) {
            throw new RecordCoreException("Cannot set maximum delay to less than minimum delay", new Object[0]);
        }
        this.maxDelayMillis = maxDelayMillis;
    }

    public long getInitialDelayMillis() {
        return this.initialDelayMillis;
    }

    public void setInitialDelayMillis(long initialDelayMillis) {
        if (initialDelayMillis < 0L) {
            throw new RecordCoreException("Cannot set initial delay milliseconds to less than zero", new Object[0]);
        }
        if (initialDelayMillis > this.maxDelayMillis) {
            throw new RecordCoreException("Cannot set initial delay to greater than maximum delay", new Object[0]);
        }
        this.initialDelayMillis = initialDelayMillis;
    }

    public void setReverseDirectoryRowsPerTransaction(int rowsPerTransaction) {
        this.reverseDirectoryRowsPerTransaction = rowsPerTransaction;
    }

    public int getReverseDirectoryRowsPerTransaction() {
        return this.reverseDirectoryRowsPerTransaction;
    }

    public void setReverseDirectoryMaxMillisPerTransaction(long millisPerTransaction) {
        this.reverseDirectoryMaxMillisPerTransaction = millisPerTransaction;
    }

    public long getReverseDirectoryMaxMillisPerTransaction() {
        return this.reverseDirectoryMaxMillisPerTransaction;
    }

    public long getWarnAndCloseOpenContextsAfterSeconds() {
        return this.warnAndCloseOpenContextsAfterSeconds;
    }

    public void setWarnAndCloseOpenContextsAfterSeconds(long warnAndCloseOpenContextsAfterSeconds) {
        this.warnAndCloseOpenContextsAfterSeconds = warnAndCloseOpenContextsAfterSeconds;
    }

    public void setBlockingInAsyncDetection(@Nonnull BlockingInAsyncDetection behavior) {
        this.setBlockingInAsyncDetection(() -> behavior);
    }

    public void setBlockingInAsyncDetection(@Nonnull Supplier<BlockingInAsyncDetection> supplier) {
        this.blockingInAsyncDetectionSupplier = supplier;
    }

    public void setLatencyInjector(@Nonnull Function<FDBLatencySource, Long> latencyInjector) {
        this.latencyInjector = latencyInjector;
    }

    @Nonnull
    public Function<FDBLatencySource, Long> getLatencyInjector() {
        return this.latencyInjector;
    }

    public void clearLatencyInjector() {
        this.latencyInjector = DEFAULT_LATENCY_INJECTOR;
    }

    public long getStateRefreshTimeMillis() {
        return this.stateRefreshTimeMillis;
    }

    public void setStateRefreshTimeMillis(long stateRefreshTimeMillis) {
        this.stateRefreshTimeMillis = stateRefreshTimeMillis;
    }

    public void setTransactionTimeoutMillis(long transactionTimeoutMillis) {
        if (transactionTimeoutMillis < -1L) {
            throw new RecordCoreArgumentException("cannot set transaction timeout millis to " + transactionTimeoutMillis, new Object[0]);
        }
        this.transactionTimeoutMillis = transactionTimeoutMillis;
    }

    public long getTransactionTimeoutMillis() {
        return this.transactionTimeoutMillis;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public FDBRecordStoreStateCacheFactory getStoreStateCacheFactory() {
        return this.storeStateCacheFactory;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public void setStoreStateCacheFactory(@Nonnull FDBRecordStoreStateCacheFactory storeStateCacheFactory) {
        this.storeStateCacheFactory = storeStateCacheFactory;
    }

    @Nonnull
    public Executor newContextExecutor(@Nullable Map<String, String> mdcContext) {
        Executor newExecutor = this.contextExecutor.apply(this.getExecutor());
        if (mdcContext != null) {
            newExecutor = new ContextRestoringExecutor(newExecutor, mdcContext);
        }
        return newExecutor;
    }

    @Deprecated
    public static void setThreadsPerClientVersion(int threadsPerClientV) {
        FDBDatabaseFactoryImpl.setThreadsPerClientVersion(threadsPerClientV);
    }

    @Deprecated
    public static int getThreadsPerClientVersion() {
        return FDBDatabaseFactoryImpl.getThreadsPerClientVersion();
    }

    @Nonnull
    public Supplier<BlockingInAsyncDetection> getBlockingInAsyncDetectionSupplier() {
        return this.blockingInAsyncDetectionSupplier;
    }

    @Nonnull
    public FDBDatabaseFactory setTransactionListener(@Nullable TransactionListener listener) {
        this.transactionListener = listener;
        return this;
    }

    @Nullable
    public TransactionListener getTransactionListener() {
        return this.transactionListener;
    }

    public abstract void shutdown();

    @SpotBugsSuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public abstract void setTrace(@Nullable String var1, @Nullable String var2);

    public abstract void setTraceFormat(@Nonnull FDBTraceFormat var1);

    public abstract void setRunLoopProfilingEnabled(boolean var1);

    public abstract boolean isRunLoopProfilingEnabled();

    public abstract void setTransactionIsTracedSupplier(Supplier<Boolean> var1);

    public abstract Supplier<Boolean> getTransactionIsTracedSupplier();

    @API(value=API.Status.EXPERIMENTAL)
    public abstract void setAPIVersion(@Nonnull APIVersion var1);

    @API(value=API.Status.INTERNAL)
    public abstract APIVersion getAPIVersion();

    @Nonnull
    public abstract FDBDatabase getDatabase(@Nullable String var1);

    @Nonnull
    public FDBDatabase getDatabase() {
        return this.getDatabase(null);
    }

    @Nonnull
    public abstract FDBLocalityProvider getLocalityProvider();

    public abstract void setLocalityProvider(@Nonnull FDBLocalityProvider var1);

    @Nonnull
    public abstract Database open(String var1);
}

