/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.NetworkOptions;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBLocalityProvider;
import com.apple.foundationdb.record.provider.foundationdb.FDBLocalityUtil;
import com.apple.foundationdb.record.provider.foundationdb.FDBTraceFormat;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class FDBDatabaseFactoryImpl
extends FDBDatabaseFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDatabaseFactory.class);
    @Nonnull
    private static final FDBDatabaseFactoryImpl INSTANCE = new FDBDatabaseFactoryImpl();
    protected static volatile boolean staticOptionsSet = false;
    protected static volatile int threadsPerClientVersion = 1;
    @Nonnull
    private FDBLocalityProvider localityProvider = FDBLocalityUtil.instance();
    @Nullable
    private FDB fdb;
    private boolean inited;
    @Nullable
    private String traceDirectory = null;
    @Nullable
    private String traceLogGroup = null;
    @Nonnull
    private FDBTraceFormat traceFormat = FDBTraceFormat.DEFAULT;
    @Nonnull
    private APIVersion apiVersion = APIVersion.getDefault();
    private boolean runLoopProfilingEnabled = false;
    @Nonnull
    private Supplier<Boolean> transactionIsTracedSupplier = LOGGER::isTraceEnabled;

    @API(value=API.Status.INTERNAL)
    @VisibleForTesting
    public static FDBDatabaseFactoryImpl testInstance(@Nonnull FDB initedFDB) {
        FDBDatabaseFactoryImpl impl = new FDBDatabaseFactoryImpl();
        impl.fdb = initedFDB;
        impl.apiVersion = APIVersion.fromVersionNumber(initedFDB.getAPIVersion());
        impl.inited = true;
        return impl;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Returned static object is mutable to allow caching database objects")
    public static FDBDatabaseFactoryImpl instance() {
        return INSTANCE;
    }

    protected synchronized FDB initFDB() {
        if (!this.inited) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.build("Starting FDB", new Object[0]).addKeyAndValue((Object)LogMessageKeys.API_VERSION, this.apiVersion.getVersionNumber()).addKeyAndValue((Object)LogMessageKeys.UNCLOSED_WARNING, this.unclosedWarning).addKeyAndValue((Object)LogMessageKeys.TRACE_FORMAT, (Object)this.traceFormat).addKeyAndValue((Object)LogMessageKeys.TRACE_DIRECTORY, this.traceDirectory).addKeyAndValue((Object)LogMessageKeys.TRACE_LOG_GROUP, this.traceLogGroup).addKeyAndValue((Object)LogMessageKeys.RUN_LOOP_PROFILING, this.runLoopProfilingEnabled).addKeyAndValue((Object)LogMessageKeys.THREADS_PER_CLIENT_VERSION, threadsPerClientVersion).getMessageWithKeys());
            }
            this.fdb = FDB.selectAPIVersion(this.apiVersion.getVersionNumber());
            this.fdb.setUnclosedWarning(this.unclosedWarning);
            FDBDatabaseFactoryImpl.setStaticOptions(this.fdb);
            NetworkOptions options = this.fdb.options();
            if (!this.traceFormat.isDefaultValue()) {
                options.setTraceFormat(this.traceFormat.getOptionValue());
            }
            if (this.traceDirectory != null) {
                options.setTraceEnable(this.traceDirectory);
            }
            if (this.traceLogGroup != null) {
                options.setTraceLogGroup(this.traceLogGroup);
            }
            if (this.runLoopProfilingEnabled) {
                options.setEnableRunLoopProfiling();
            }
            if (this.networkExecutor == null) {
                this.fdb.startNetwork();
            } else {
                this.fdb.startNetwork(this.networkExecutor);
            }
            this.inited = true;
        }
        return this.fdb;
    }

    private static synchronized void setStaticOptions(FDB fdb) {
        if (!staticOptionsSet) {
            fdb.options().setClientThreadsPerVersion(threadsPerClientVersion);
            staticOptionsSet = true;
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.inited) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Shutting down FDB", new Object[0]));
            }
            for (FDBDatabase database : this.databases.values()) {
                database.close();
            }
            this.fdb.stopNetwork();
            this.inited = false;
        }
    }

    @Override
    @SpotBugsSuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public void setTrace(@Nullable String traceDirectory, @Nullable String traceLogGroup) {
        this.traceDirectory = traceDirectory;
        this.traceLogGroup = traceLogGroup;
    }

    @Override
    public void setTraceFormat(@Nonnull FDBTraceFormat traceFormat) {
        this.traceFormat = traceFormat;
    }

    @Override
    public synchronized void setAPIVersion(@Nonnull APIVersion apiVersion) {
        if (this.apiVersion == apiVersion) {
            return;
        }
        if (this.inited) {
            throw new RecordCoreException("API version cannot be changed after client has already started", new Object[0]);
        }
        this.apiVersion = apiVersion;
    }

    @Override
    public synchronized APIVersion getAPIVersion() {
        return this.apiVersion;
    }

    @Override
    public synchronized void setRunLoopProfilingEnabled(boolean runLoopProfilingEnabled) {
        if (this.inited) {
            throw new RecordCoreException("run loop profiling can not be enabled as the client has already started", new Object[0]);
        }
        this.runLoopProfilingEnabled = runLoopProfilingEnabled;
    }

    @Override
    public boolean isRunLoopProfilingEnabled() {
        return this.runLoopProfilingEnabled;
    }

    @Override
    public void setTransactionIsTracedSupplier(Supplier<Boolean> transactionIsTracedSupplier) {
        this.transactionIsTracedSupplier = transactionIsTracedSupplier;
    }

    @Override
    public Supplier<Boolean> getTransactionIsTracedSupplier() {
        return this.transactionIsTracedSupplier;
    }

    @Override
    @Nonnull
    public synchronized FDBDatabase getDatabase(@Nullable String clusterFile) {
        FDBDatabase database = (FDBDatabase)this.databases.get(clusterFile);
        if (database == null) {
            database = new FDBDatabase(this, clusterFile);
            database.setDirectoryCacheSize(this.getDirectoryCacheSize());
            database.setTrackLastSeenVersion(this.getTrackLastSeenVersion());
            database.setResolverStateRefreshTimeMillis(this.getStateRefreshTimeMillis());
            database.setDatacenterId(this.getDatacenterId());
            database.setStoreStateCache(this.storeStateCacheFactory.getCache(database));
            this.databases.put(clusterFile, database);
        }
        return database;
    }

    @Override
    @Nonnull
    public FDBLocalityProvider getLocalityProvider() {
        return this.localityProvider;
    }

    @Override
    public void setLocalityProvider(@Nonnull FDBLocalityProvider localityProvider) {
        this.localityProvider = localityProvider;
    }

    public static void setThreadsPerClientVersion(int threadsPerClientV) {
        if (staticOptionsSet) {
            throw new RecordCoreException("threads per client version cannot be changed as the version has already been initiated", new Object[0]);
        }
        if (threadsPerClientV < 1) {
            threadsPerClientV = 1;
        }
        threadsPerClientVersion = threadsPerClientV;
    }

    public static int getThreadsPerClientVersion() {
        return threadsPerClientVersion;
    }

    @Override
    @Nonnull
    public Database open(String clusterFile) {
        FDB fdb = this.initFDB();
        return fdb.open(clusterFile);
    }
}

