/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.provider.foundationdb.runners.ExponentialDelay;
import com.apple.foundationdb.record.provider.foundationdb.synchronizedsession.SynchronizedSessionRunner;
import com.apple.foundationdb.record.util.Result;
import com.apple.foundationdb.subspace.Subspace;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface FDBDatabaseRunner
extends AutoCloseable {
    @Nonnull
    public FDBDatabase getDatabase();

    @Nonnull
    public FDBRecordContextConfig.Builder getContextConfigBuilder();

    public void setContextConfigBuilder(FDBRecordContextConfig.Builder var1);

    public Executor getExecutor();

    default public ScheduledExecutorService getScheduledExecutor() {
        return this.getDatabase().getScheduledExecutor();
    }

    @Nullable
    default public FDBStoreTimer getTimer() {
        return this.getContextConfigBuilder().getTimer();
    }

    default public void setTimer(@Nullable FDBStoreTimer timer) {
        this.getContextConfigBuilder().setTimer(timer);
    }

    @Nullable
    default public Map<String, String> getMdcContext() {
        return this.getContextConfigBuilder().getMdcContext();
    }

    default public void setMdcContext(@Nullable Map<String, String> mdcContext) {
        this.getContextConfigBuilder().setMdcContext(mdcContext);
    }

    @Nullable
    default public FDBDatabase.WeakReadSemantics getWeakReadSemantics() {
        return this.getContextConfigBuilder().getWeakReadSemantics();
    }

    default public void setWeakReadSemantics(@Nullable FDBDatabase.WeakReadSemantics weakReadSemantics) {
        this.getContextConfigBuilder().setWeakReadSemantics(weakReadSemantics);
    }

    @Nonnull
    default public FDBTransactionPriority getPriority() {
        return this.getContextConfigBuilder().getPriority();
    }

    default public void setPriority(@Nonnull FDBTransactionPriority priority) {
        this.getContextConfigBuilder().setPriority(priority);
    }

    default public long getTransactionTimeoutMillis() {
        return this.getContextConfigBuilder().getTransactionTimeoutMillis();
    }

    default public void setTransactionTimeoutMillis(long transactionTimeoutMillis) {
        this.getContextConfigBuilder().setTransactionTimeoutMillis(transactionTimeoutMillis);
    }

    default public void setRecordLayerPropertyStorage(@Nonnull RecordLayerPropertyStorage propertyStorage) {
        this.getContextConfigBuilder().setRecordContextProperties(propertyStorage);
    }

    public int getMaxAttempts();

    public void setMaxAttempts(int var1);

    public long getMinDelayMillis();

    public long getMaxDelayMillis();

    public void setMaxDelayMillis(long var1);

    public long getInitialDelayMillis();

    public void setInitialDelayMillis(long var1);

    @Nonnull
    public FDBRecordContext openContext();

    @Nonnull
    @API(value=API.Status.INTERNAL)
    default public ExponentialDelay createExponentialDelay() {
        return new ExponentialDelay(this.getInitialDelayMillis(), this.getMaxDelayMillis(), this.getDatabase().getScheduledExecutor());
    }

    default public <T> T run(@Nonnull Function<? super FDBRecordContext, ? extends T> retriable) {
        return this.run(retriable, null);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public <T> T run(@Nonnull Function<? super FDBRecordContext, ? extends T> var1, @Nullable List<Object> var2);

    @Nonnull
    default public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        return this.runAsync(retriable, Result::of);
    }

    @Nonnull
    default public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nullable List<Object> additionalLogMessageKeyValues) {
        return this.runAsync(retriable, Result::of, additionalLogMessageKeyValues);
    }

    @Nonnull
    default public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nonnull BiFunction<? super T, Throwable, Result<? extends T, ? extends Throwable>> handlePostTransaction) {
        return this.runAsync(retriable, handlePostTransaction, null);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> var1, @Nonnull BiFunction<? super T, Throwable, Result<? extends T, ? extends Throwable>> var2, @Nullable List<Object> var3);

    @Nullable
    public <T> T asyncToSync(StoreTimer.Wait var1, @Nonnull CompletableFuture<T> var2);

    @Override
    public void close();

    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<SynchronizedSessionRunner> startSynchronizedSessionAsync(@Nonnull Subspace var1, long var2);

    @API(value=API.Status.EXPERIMENTAL)
    public SynchronizedSessionRunner startSynchronizedSession(@Nonnull Subspace var1, long var2);

    @API(value=API.Status.EXPERIMENTAL)
    public SynchronizedSessionRunner joinSynchronizedSession(@Nonnull Subspace var1, @Nonnull UUID var2, long var3);

    public static class RunnerClosed
    extends RecordCoreException {
        public RunnerClosed() {
            super("runner has been closed", new Object[0]);
        }
    }
}

