/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreRetriableTransactionException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.runners.ExponentialDelay;
import com.apple.foundationdb.record.provider.foundationdb.runners.FutureAutoClose;
import com.apple.foundationdb.record.provider.foundationdb.runners.TransactionalRunner;
import com.apple.foundationdb.record.provider.foundationdb.synchronizedsession.SynchronizedSessionRunner;
import com.apple.foundationdb.record.util.Result;
import com.apple.foundationdb.subspace.Subspace;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class FDBDatabaseRunnerImpl
implements FDBDatabaseRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDatabaseRunnerImpl.class);
    @Nonnull
    private final FDBDatabase database;
    private final TransactionalRunner transactionalRunner;
    private final FutureAutoClose futureManager;
    @Nonnull
    private FDBRecordContextConfig.Builder contextConfigBuilder;
    @Nonnull
    private Executor executor;
    private int maxAttempts;
    private long maxDelayMillis;
    private long initialDelayMillis;
    private boolean closed;

    @API(value=API.Status.INTERNAL)
    FDBDatabaseRunnerImpl(@Nonnull FDBDatabase database, FDBRecordContextConfig.Builder contextConfigBuilder) {
        this.database = database;
        this.contextConfigBuilder = contextConfigBuilder;
        this.executor = database.newContextExecutor(contextConfigBuilder.getMdcContext());
        this.transactionalRunner = new TransactionalRunner(database, contextConfigBuilder);
        this.futureManager = new FutureAutoClose();
        FDBDatabaseFactory factory = database.getFactory();
        this.maxAttempts = factory.getMaxAttempts();
        this.maxDelayMillis = factory.getMaxDelayMillis();
        this.initialDelayMillis = factory.getInitialDelayMillis();
    }

    @Override
    @Nonnull
    public FDBDatabase getDatabase() {
        return this.database;
    }

    @Override
    @Nonnull
    public FDBRecordContextConfig.Builder getContextConfigBuilder() {
        return this.contextConfigBuilder;
    }

    @Override
    public void setContextConfigBuilder(@Nonnull FDBRecordContextConfig.Builder contextConfigBuilder) {
        this.contextConfigBuilder = contextConfigBuilder;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setMdcContext(@Nullable Map<String, String> mdcContext) {
        FDBDatabaseRunner.super.setMdcContext(mdcContext);
        this.executor = this.database.newContextExecutor(mdcContext);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public void setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new RecordCoreException("Cannot set maximum number of attempts to less than or equal to zero", new Object[0]);
        }
        this.maxAttempts = maxAttempts;
    }

    @Override
    public long getMinDelayMillis() {
        return 2L;
    }

    @Override
    public long getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    @Override
    public void setMaxDelayMillis(long maxDelayMillis) {
        if (maxDelayMillis < 0L) {
            throw new RecordCoreException("Cannot set maximum delay milliseconds to less than or equal to zero", new Object[0]);
        }
        if (maxDelayMillis < this.initialDelayMillis) {
            throw new RecordCoreException("Cannot set maximum delay to less than minimum delay", new Object[0]);
        }
        this.maxDelayMillis = maxDelayMillis;
    }

    @Override
    public long getInitialDelayMillis() {
        return this.initialDelayMillis;
    }

    @Override
    public void setInitialDelayMillis(long initialDelayMillis) {
        if (initialDelayMillis < 0L) {
            throw new RecordCoreException("Cannot set initial delay milleseconds to less than zero", new Object[0]);
        }
        if (initialDelayMillis > this.maxDelayMillis) {
            throw new RecordCoreException("Cannot set initial delay to greater than maximum delay", new Object[0]);
        }
        this.initialDelayMillis = initialDelayMillis;
    }

    @Override
    @Nonnull
    public FDBRecordContext openContext() {
        return this.transactionalRunner.openContext();
    }

    @Override
    @API(value=API.Status.EXPERIMENTAL)
    public <T> T run(@Nonnull Function<? super FDBRecordContext, ? extends T> retriable, @Nullable List<Object> additionalLogMessageKeyValues) {
        return new RunRetriable<T>(additionalLogMessageKeyValues).run(retriable);
    }

    @Override
    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public <T> CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nonnull BiFunction<? super T, Throwable, Result<? extends T, ? extends Throwable>> handlePostTransaction, @Nullable List<Object> additionalLogMessageKeyValues) {
        return new RunRetriable<T>(additionalLogMessageKeyValues).runAsync(retriable, handlePostTransaction);
    }

    @Override
    @Nullable
    public <T> T asyncToSync(StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        return this.database.asyncToSync(this.getTimer(), event, async);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        RuntimeException caught = null;
        try {
            this.futureManager.close();
        }
        catch (RuntimeException e) {
            caught = e;
        }
        try {
            this.transactionalRunner.close();
        }
        catch (RuntimeException e) {
            if (caught != null) {
                caught.addSuppressed(e);
            }
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }

    @Override
    public CompletableFuture<SynchronizedSessionRunner> startSynchronizedSessionAsync(@Nonnull Subspace lockSubspace, long leaseLengthMillis) {
        return SynchronizedSessionRunner.startSessionAsync(lockSubspace, leaseLengthMillis, this);
    }

    @Override
    public SynchronizedSessionRunner startSynchronizedSession(@Nonnull Subspace lockSubspace, long leaseLengthMillis) {
        return SynchronizedSessionRunner.startSession(lockSubspace, leaseLengthMillis, this);
    }

    @Override
    public SynchronizedSessionRunner joinSynchronizedSession(@Nonnull Subspace lockSubspace, @Nonnull UUID sessionId, long leaseLengthMillis) {
        return SynchronizedSessionRunner.joinSession(lockSubspace, sessionId, leaseLengthMillis, this);
    }

    private class RunRetriable<T> {
        @Nonnull
        private final ExponentialDelay delay;
        private int currAttempt = 0;
        @Nullable
        T retVal = null;
        @Nullable
        RuntimeException exception = null;
        @Nullable
        private final List<Object> additionalLogMessageKeyValues;

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        private RunRetriable(List<Object> additionalLogMessageKeyValues) {
            this.additionalLogMessageKeyValues = additionalLogMessageKeyValues;
            this.delay = FDBDatabaseRunnerImpl.this.createExponentialDelay();
        }

        @Nonnull
        private CompletableFuture<Boolean> handle(@Nullable T val, @Nullable Throwable e) {
            if (FDBDatabaseRunnerImpl.this.closed) {
                this.exception = new FDBDatabaseRunner.RunnerClosed();
                return AsyncUtil.READY_FALSE;
            }
            if (e == null) {
                this.retVal = val;
                return AsyncUtil.READY_FALSE;
            }
            String fdbMessage = null;
            int code = -1;
            boolean retry = false;
            for (Throwable t2 = e; t2 != null; t2 = t2.getCause()) {
                if (t2 instanceof FDBException) {
                    FDBException fdbE = (FDBException)t2;
                    retry = retry || fdbE.isRetryable();
                    fdbMessage = fdbE.getMessage();
                    code = fdbE.getCode();
                    continue;
                }
                if (!(t2 instanceof RecordCoreRetriableTransactionException)) continue;
                retry = true;
            }
            if (this.currAttempt + 1 < FDBDatabaseRunnerImpl.this.getMaxAttempts() && retry) {
                if (LOGGER.isWarnEnabled()) {
                    KeyValueLogMessage message = KeyValueLogMessage.build("Retrying FDB Exception", new Object[]{LogMessageKeys.MESSAGE, fdbMessage, LogMessageKeys.CODE, code, LogMessageKeys.CURR_ATTEMPT, this.currAttempt, LogMessageKeys.MAX_ATTEMPTS, FDBDatabaseRunnerImpl.this.getMaxAttempts(), LogMessageKeys.DELAY, this.delay.getNextDelayMillis()});
                    if (this.additionalLogMessageKeyValues != null) {
                        message.addKeysAndValues(this.additionalLogMessageKeyValues);
                    }
                    LOGGER.warn(message.toString(), e);
                }
                CompletableFuture<Void> future = this.delay.delay();
                if (FDBDatabaseRunnerImpl.this.getTimer() != null) {
                    future = FDBDatabaseRunnerImpl.this.getTimer().instrument(FDBStoreTimer.Events.RETRY_DELAY, future, FDBDatabaseRunnerImpl.this.executor);
                }
                FDBDatabaseRunnerImpl.this.futureManager.registerFuture(future);
                return future.thenApply(vignore -> {
                    ++this.currAttempt;
                    return true;
                });
            }
            this.exception = FDBDatabaseRunnerImpl.this.database.mapAsyncToSyncException(e);
            return AsyncUtil.READY_FALSE;
        }

        public CompletableFuture<T> runAsync(@Nonnull Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable, @Nonnull BiFunction<? super T, Throwable, Result<? extends T, ? extends Throwable>> handlePostTransaction) {
            CompletableFuture future = FDBDatabaseRunnerImpl.this.futureManager.newFuture();
            AsyncUtil.whileTrue(() -> {
                try {
                    return ((CompletableFuture)FDBDatabaseRunnerImpl.this.transactionalRunner.runAsync(this.currAttempt != 0, retriable).handle((result, ex) -> {
                        Result newResult = (Result)handlePostTransaction.apply((T)result, (Throwable)ex);
                        return this.handle((T)newResult.getValue(), (Throwable)newResult.getError());
                    })).thenCompose(Function.identity());
                }
                catch (Exception e) {
                    return this.handle(null, e);
                }
            }, FDBDatabaseRunnerImpl.this.getExecutor()).handle((vignore, e) -> {
                if (this.exception != null) {
                    future.completeExceptionally(this.exception);
                } else if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    future.complete(this.retVal);
                }
                return null;
            });
            return future;
        }

        public T run(@Nonnull Function<? super FDBRecordContext, ? extends T> retriable) {
            boolean again = true;
            while (again) {
                try {
                    T ret = FDBDatabaseRunnerImpl.this.transactionalRunner.run(this.currAttempt != 0, retriable);
                    again = FDBDatabaseRunnerImpl.this.asyncToSync(FDBStoreTimer.Waits.WAIT_RETRY_DELAY, this.handle(ret, null));
                }
                catch (Exception e) {
                    again = FDBDatabaseRunnerImpl.this.asyncToSync(FDBStoreTimer.Waits.WAIT_RETRY_DELAY, this.handle(null, e));
                }
            }
            if (this.exception == null) {
                return this.retVal;
            }
            throw this.exception;
        }
    }
}

