/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBError;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreInterruptedException;
import com.apple.foundationdb.record.RecordCoreRetriableTransactionException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.logging.CompletionExceptionLogHelper;
import com.apple.foundationdb.util.LoggableKeysAndValues;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBExceptions {
    private static final Object[] EMPTY_KEYS_AND_VALUES = new Object[0];

    private FDBExceptions() {
    }

    public static RuntimeException wrapException(@Nonnull Throwable ex) {
        Object[] logInfo = ex instanceof LoggableKeysAndValues ? ((LoggableKeysAndValues)((Object)ex)).exportLogInfo() : EMPTY_KEYS_AND_VALUES;
        if (ex instanceof CompletionException) {
            ex = CompletionExceptionLogHelper.asCause((CompletionException)ex);
        } else if (ex instanceof ExecutionException) {
            ex = CompletionExceptionLogHelper.asCause((ExecutionException)ex);
        }
        if (ex instanceof FDBException) {
            FDBException fdbex = (FDBException)ex;
            switch (FDBError.fromCode(fdbex.getCode())) {
                case TRANSACTION_TOO_OLD: {
                    return new FDBStoreTransactionIsTooOldException(fdbex).addLogInfo(logInfo);
                }
                case NOT_COMMITTED: {
                    return new FDBStoreTransactionConflictException(fdbex).addLogInfo(logInfo);
                }
                case TRANSACTION_TIMED_OUT: {
                    return new FDBStoreTransactionTimeoutException(fdbex).addLogInfo(logInfo);
                }
                case TRANSACTION_TOO_LARGE: {
                    return new FDBStoreTransactionSizeException(fdbex).addLogInfo(logInfo);
                }
                case KEY_TOO_LARGE: {
                    return new FDBStoreKeySizeException(fdbex).addLogInfo(logInfo);
                }
                case VALUE_TOO_LARGE: {
                    return new FDBStoreValueSizeException(fdbex).addLogInfo(logInfo);
                }
            }
            if (fdbex.isRetryable()) {
                return new FDBStoreRetriableException(fdbex).addLogInfo(logInfo);
            }
            return new FDBStoreException(fdbex).addLogInfo(logInfo);
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        if (ex instanceof InterruptedException) {
            return new RecordCoreInterruptedException(ex.getMessage(), (InterruptedException)ex).addLogInfo(logInfo);
        }
        return new RecordCoreException(ex.getMessage(), ex).addLogInfo(logInfo);
    }

    public static boolean isRetriable(@Nullable Throwable ex) {
        for (Throwable current = ex; current != null; current = current.getCause()) {
            if (current instanceof RecordCoreRetriableTransactionException) {
                return true;
            }
            if (!(current instanceof FDBException)) continue;
            return ((FDBException)current).isRetryable();
        }
        return false;
    }

    @Nullable
    public static FDBException getFDBCause(@Nullable Throwable ex) {
        for (Throwable current = ex; current != null; current = current.getCause()) {
            if (!(current instanceof FDBException)) continue;
            return (FDBException)current;
        }
        return null;
    }

    public static class FDBStoreTransactionIsTooOldException
    extends FDBStoreRetriableException {
        public FDBStoreTransactionIsTooOldException(FDBException cause) {
            super(cause);
        }

        public FDBStoreTransactionIsTooOldException(String message, FDBException cause) {
            super(message, cause);
        }
    }

    public static class FDBStoreTransactionConflictException
    extends FDBStoreRetriableException {
        public FDBStoreTransactionConflictException(FDBException cause) {
            super(cause);
        }
    }

    public static class FDBStoreTransactionTimeoutException
    extends FDBStoreException {
        public FDBStoreTransactionTimeoutException(FDBException cause) {
            super(cause);
        }
    }

    public static class FDBStoreTransactionSizeException
    extends FDBStoreException {
        public FDBStoreTransactionSizeException(FDBException cause) {
            super(cause);
        }
    }

    public static class FDBStoreKeySizeException
    extends FDBStoreException {
        public FDBStoreKeySizeException(String message, Object ... keyValues) {
            super(message, keyValues);
        }

        public FDBStoreKeySizeException(FDBException cause) {
            super(cause);
        }
    }

    public static class FDBStoreValueSizeException
    extends FDBStoreException {
        public FDBStoreValueSizeException(String message, Object ... keyValues) {
            super(message, keyValues);
        }

        public FDBStoreValueSizeException(FDBException cause) {
            super(cause);
        }
    }

    public static class FDBStoreRetriableException
    extends RecordCoreRetriableTransactionException {
        public FDBStoreRetriableException(FDBException cause) {
            super(cause.getMessage(), cause);
        }

        public FDBStoreRetriableException(String message, FDBException cause) {
            super(message, cause);
        }
    }

    public static class FDBStoreException
    extends RecordCoreStorageException {
        public FDBStoreException(String message) {
            super(message);
        }

        public FDBStoreException(String message, Object ... keyValues) {
            super(message, keyValues);
        }

        public FDBStoreException(FDBException cause) {
            super(cause.getMessage(), cause);
        }
    }

    public static class FDBStoreLockTakenException
    extends RecordCoreRetriableTransactionException {
        public FDBStoreLockTakenException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

