/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.metadata.Index;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class FDBIndexedRawRecord {
    @Nonnull
    private final IndexEntry indexEntry;
    @Nonnull
    private final MappedKeyValue rawRecord;

    @API(value=API.Status.INTERNAL)
    public FDBIndexedRawRecord(@Nonnull IndexEntry indexEntry, @Nonnull MappedKeyValue rawRecord) {
        this.indexEntry = indexEntry;
        this.rawRecord = rawRecord;
    }

    @Nonnull
    public Index getIndex() {
        return this.indexEntry.getIndex();
    }

    @Nonnull
    public IndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    @Nonnull
    public MappedKeyValue getRawRecord() {
        return this.rawRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDBIndexedRawRecord that = (FDBIndexedRawRecord)o;
        if (!this.indexEntry.equals(that.indexEntry)) {
            return false;
        }
        return Objects.equals(this.rawRecord, that.rawRecord);
    }

    public int hashCode() {
        int result = this.indexEntry.hashCode();
        result = 31 * result + Objects.hashCode(this.rawRecord);
        return result;
    }

    public String toString() {
        return String.valueOf(this.indexEntry) + " -> " + String.valueOf(this.rawRecord);
    }
}

