/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBIndexedRecord<M extends Message>
implements FDBRecord<M>,
FDBStoredSizes {
    @Nonnull
    private final IndexEntry indexEntry;
    @Nullable
    private final FDBStoredRecord<M> storedRecord;

    @API(value=API.Status.INTERNAL)
    public FDBIndexedRecord(@Nonnull IndexEntry indexEntry, @Nullable FDBStoredRecord<M> storedRecord) {
        this.indexEntry = indexEntry;
        this.storedRecord = storedRecord;
    }

    @Nonnull
    public Index getIndex() {
        return this.indexEntry.getIndex();
    }

    @Nonnull
    public IndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    public boolean hasStoredRecord() {
        return this.storedRecord != null;
    }

    @Nonnull
    public FDBStoredRecord<M> getStoredRecord() {
        if (this.storedRecord == null) {
            throw new RecordCoreException("No record associated with index entry", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, this.getIndex().getName(), LogMessageKeys.INDEX_KEY, this.indexEntry.getKey()});
        }
        return this.storedRecord;
    }

    @Override
    @Nonnull
    public Tuple getPrimaryKey() {
        return this.getStoredRecord().getPrimaryKey();
    }

    @Override
    @Nonnull
    public RecordType getRecordType() {
        return this.getStoredRecord().getRecordType();
    }

    @Override
    @Nonnull
    public M getRecord() {
        return this.getStoredRecord().getRecord();
    }

    @Override
    public boolean hasVersion() {
        return this.getStoredRecord().hasVersion();
    }

    @Override
    @Nullable
    public FDBRecordVersion getVersion() {
        return this.getStoredRecord().getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDBIndexedRecord that = (FDBIndexedRecord)o;
        if (!this.indexEntry.equals(that.indexEntry)) {
            return false;
        }
        return Objects.equals(this.storedRecord, that.storedRecord);
    }

    public int hashCode() {
        int result = this.indexEntry.hashCode();
        result = 31 * result + Objects.hashCode(this.storedRecord);
        return result;
    }

    public String toString() {
        return String.valueOf(this.indexEntry) + " -> " + String.valueOf(this.storedRecord);
    }

    @Override
    public int getKeyCount() {
        return this.getStoredRecord().getKeyCount();
    }

    @Override
    public int getKeySize() {
        return this.getStoredRecord().getKeySize();
    }

    @Override
    public int getValueSize() {
        return this.getStoredRecord().getValueSize();
    }

    @Override
    public boolean isSplit() {
        return this.getStoredRecord().isSplit();
    }

    @Override
    public boolean isVersionedInline() {
        return this.getStoredRecord().isVersionedInline();
    }
}

