/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataEvolutionValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.MetaDataCache;
import com.apple.foundationdb.record.provider.foundationdb.MetaDataProtoEditor;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class FDBMetaDataStore
extends FDBStoreBase
implements RecordMetaDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBMetaDataStore.class);
    private static final ExtensionRegistry DEFAULT_EXTENSION_REGISTRY;
    public static final Tuple CURRENT_KEY;
    public static final Tuple HISTORY_KEY_PREFIX;
    public static final Tuple OLD_FORMAT_KEY;
    @Nonnull
    private Descriptors.FileDescriptor[] dependencies = new Descriptors.FileDescriptor[0];
    @Nullable
    private Descriptors.FileDescriptor localFileDescriptor;
    @Nullable
    private ExtensionRegistry extensionRegistry = DEFAULT_EXTENSION_REGISTRY;
    @Nonnull
    private MetaDataEvolutionValidator evolutionValidator = MetaDataEvolutionValidator.getDefaultInstance();
    @Nullable
    private RecordMetaData recordMetaData;
    @Nullable
    private final MetaDataCache cache;
    @Nullable
    private PendingCacheUpdate pendingCacheUpdate;
    private boolean maintainHistory = true;

    @API(value=API.Status.UNSTABLE)
    public FDBMetaDataStore(@Nonnull FDBRecordContext context, @Nonnull Subspace subspace, @Nullable MetaDataCache cache) {
        super(context, subspace);
        this.cache = cache;
    }

    public FDBMetaDataStore(@Nonnull FDBRecordContext context, @Nonnull KeySpacePath path) {
        this(context, new Subspace(path.toTuple(context)), null);
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setDependencies(@Nonnull Descriptors.FileDescriptor[] dependencies) {
        this.dependencies = dependencies;
    }

    @Nullable
    public Descriptors.FileDescriptor getLocalFileDescriptor() {
        return this.localFileDescriptor;
    }

    public void setLocalFileDescriptor(@Nullable Descriptors.FileDescriptor localFileDescriptor) {
        this.localFileDescriptor = localFileDescriptor;
    }

    @Nonnull
    public MetaDataEvolutionValidator getEvolutionValidator() {
        return this.evolutionValidator;
    }

    public void setEvolutionValidator(@Nonnull MetaDataEvolutionValidator evolutionValidator) {
        this.evolutionValidator = evolutionValidator;
    }

    @Nullable
    protected ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public void setExtensionRegistry(@Nullable ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public void setMaintainHistory(boolean maintainHistory) {
        this.maintainHistory = maintainHistory;
    }

    public CompletableFuture<RecordMetaDataProto.MetaData> loadAndSetCurrent(boolean checkCache, int currentVersion) {
        int cachedSerializedVersion;
        if (checkCache && this.cache != null) {
            byte[] serialized2 = this.cache.getCachedSerialized();
            if (serialized2 != null) {
                RecordMetaDataProto.MetaData metaDataProto = this.parseMetaDataProto(serialized2);
                cachedSerializedVersion = metaDataProto.getVersion();
                if (currentVersion < 0 || currentVersion == cachedSerializedVersion) {
                    this.recordMetaData = this.buildMetaData(metaDataProto, false);
                    this.addPendingCacheUpdate(this.recordMetaData);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(KeyValueLogMessage.of("Using cached serialized meta-data", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.VERSION, currentVersion}));
                    }
                    return CompletableFuture.completedFuture(metaDataProto);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(KeyValueLogMessage.of("Cached serialized meta-data is out-of-date", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.VERSION, currentVersion, LogMessageKeys.CACHED_VERSION, cachedSerializedVersion}));
                }
            } else {
                cachedSerializedVersion = 0;
            }
        } else {
            cachedSerializedVersion = -1;
        }
        CompletionStage future = this.loadCurrentSerialized().thenApply(serialized -> {
            if (serialized == null) {
                return null;
            }
            RecordMetaDataProto.MetaData metaDataProto = this.parseMetaDataProto((byte[])serialized);
            this.recordMetaData = this.buildMetaData(metaDataProto, false);
            if (this.cache != null) {
                int serializedVersion = this.recordMetaData.getVersion();
                if (currentVersion != serializedVersion) {
                    this.cache.setCurrentVersion(this.context, serializedVersion);
                }
                this.addPendingCacheUpdate(this.recordMetaData);
                if (serializedVersion > cachedSerializedVersion) {
                    this.addPendingCacheUpdate((byte[])serialized);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Loaded meta-data", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.VERSION, metaDataProto.getVersion()}));
            }
            return metaDataProto;
        });
        return this.instrument(FDBStoreTimer.Events.LOAD_META_DATA, future);
    }

    protected CompletableFuture<byte[]> loadCurrentSerialized() {
        return SplitHelper.loadWithSplit(this.ensureContextActive(), this.context, this.getSubspace(), CURRENT_KEY, true, false, null).thenCompose(currentRawRecord -> {
            if (currentRawRecord != null) {
                return CompletableFuture.completedFuture(currentRawRecord.getRawRecord());
            }
            return SplitHelper.loadWithSplit(this.ensureContextActive(), this.context, this.getSubspace(), OLD_FORMAT_KEY, true, false, null).thenApply(oldRawRecord -> {
                if (oldRawRecord != null) {
                    byte[] oldBytes = oldRawRecord.getRawRecord();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(KeyValueLogMessage.of("Upgrading old-format meta-data store", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                    }
                    this.ensureContextActive().clear(this.getSubspace().range(OLD_FORMAT_KEY));
                    SplitHelper.saveWithSplit(this.context, this.getSubspace(), CURRENT_KEY, oldBytes, null);
                    return oldBytes;
                }
                return null;
            });
        });
    }

    @Nonnull
    protected RecordMetaDataProto.MetaData parseMetaDataProto(@Nonnull byte[] serialized) {
        try {
            return RecordMetaDataProto.MetaData.parseFrom(serialized, (ExtensionRegistryLite)this.getExtensionRegistry());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("Error parsing meta-data", ex);
        }
    }

    @Nonnull
    protected RecordMetaDataBuilder createMetaDataBuilder(@Nonnull RecordMetaDataProto.MetaData metaDataProto) {
        return this.createMetaDataBuilder(metaDataProto, true);
    }

    @Nonnull
    protected RecordMetaDataBuilder createMetaDataBuilder(@Nonnull RecordMetaDataProto.MetaData metaDataProto, boolean useLocalFileDescriptor) {
        RecordMetaDataBuilder builder = RecordMetaData.newBuilder().addDependencies(this.dependencies).setEvolutionValidator(this.evolutionValidator);
        if (useLocalFileDescriptor && this.localFileDescriptor != null) {
            builder.setLocalFileDescriptor(this.localFileDescriptor);
        }
        return builder.setRecords(metaDataProto);
    }

    @Nonnull
    protected RecordMetaData buildMetaData(@Nonnull RecordMetaDataProto.MetaData metaDataProto, boolean validate, boolean useLocalFileDescriptor) {
        return this.createMetaDataBuilder(metaDataProto, useLocalFileDescriptor).build(validate);
    }

    @Nonnull
    protected RecordMetaData buildMetaData(@Nonnull RecordMetaDataProto.MetaData metaDataProto, boolean validate) {
        return this.buildMetaData(metaDataProto, validate, true);
    }

    public CompletableFuture<RecordMetaData> loadVersion(int version) {
        if (!this.maintainHistory) {
            throw new RecordCoreException("This store does not maintain a history of older versions", new Object[0]);
        }
        return SplitHelper.loadWithSplit(this.ensureContextActive(), this.context, this.getSubspace(), HISTORY_KEY_PREFIX.add(version), true, false, null).thenApply(rawRecord -> rawRecord == null ? null : this.buildMetaData(this.parseMetaDataProto(rawRecord.getRawRecord()), false));
    }

    @Nonnull
    public CompletableFuture<Void> saveAndSetCurrent(@Nonnull RecordMetaDataProto.MetaData metaDataProto) {
        RecordMetaData validatedMetaData = this.buildMetaData(metaDataProto, true);
        CompletionStage future = this.loadCurrentSerialized().thenApply(oldSerialized -> {
            if (oldSerialized != null) {
                RecordMetaDataProto.MetaData oldProto = this.parseMetaDataProto((byte[])oldSerialized);
                int oldVersion = oldProto.getVersion();
                if (metaDataProto.getVersion() <= oldVersion) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(KeyValueLogMessage.of("Meta-data version did not increase", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.OLD, oldVersion, LogMessageKeys.NEW, metaDataProto.getVersion()}));
                    }
                    throw new MetaDataException("meta-data version must increase", new Object[0]);
                }
                RecordMetaData oldMetaData = this.buildMetaData(oldProto, true, false);
                RecordMetaData newMetaData = this.buildMetaData(metaDataProto, true, false);
                this.evolutionValidator.validate(oldMetaData, newMetaData);
                if (this.maintainHistory) {
                    SplitHelper.saveWithSplit(this.context, this.getSubspace(), HISTORY_KEY_PREFIX.add(oldVersion), oldSerialized, null);
                }
            }
            return null;
        });
        future = ((CompletableFuture)future).thenApply(vignore -> {
            this.recordMetaData = validatedMetaData;
            byte[] serialized = metaDataProto.toByteArray();
            SplitHelper.saveWithSplit(this.context, this.getSubspace(), CURRENT_KEY, serialized, null);
            if (this.cache != null) {
                this.cache.setCurrentVersion(this.context, this.recordMetaData.getVersion());
                this.addPendingCacheUpdate(this.recordMetaData);
                this.addPendingCacheUpdate(serialized);
            }
            return null;
        });
        return this.instrument(FDBStoreTimer.Events.SAVE_META_DATA, future);
    }

    public CompletableFuture<RecordMetaData> getRecordMetaDataAsync(boolean errorIfMissing) {
        if (this.recordMetaData != null) {
            return CompletableFuture.completedFuture(this.recordMetaData);
        }
        CompletableFuture<Integer> currentVersionFuture = this.cache == null ? CompletableFuture.completedFuture(-1) : this.cache.getCurrentVersionAsync(this.context);
        return this.instrument(FDBStoreTimer.Events.GET_META_DATA_CACHE_VERSION, currentVersionFuture).thenCompose(currentVersion -> {
            if (this.cache != null) {
                long startTime = System.nanoTime();
                this.recordMetaData = this.cache.getCachedMetaData();
                long endTime = System.nanoTime();
                if (this.getTimer() != null) {
                    this.getTimer().record(FDBStoreTimer.Events.GET_META_DATA_CACHE_ENTRY, endTime - startTime);
                }
                if (this.recordMetaData != null && currentVersion >= 0) {
                    if (currentVersion.intValue() == this.recordMetaData.getVersion()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(KeyValueLogMessage.of("Using cached meta-data", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.VERSION, currentVersion}));
                        }
                        return CompletableFuture.completedFuture(this.recordMetaData);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(KeyValueLogMessage.of("Cached meta-data is out-of-date", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.VERSION, currentVersion, LogMessageKeys.CACHED_VERSION, this.recordMetaData.getVersion()}));
                    }
                    this.recordMetaData = null;
                }
            }
            return this.loadAndSetCurrent(true, (int)currentVersion).thenApply(ignore -> {
                if (errorIfMissing && this.recordMetaData == null) {
                    throw new MissingMetaDataException("Metadata could not be loaded");
                }
                return this.recordMetaData;
            });
        });
    }

    @Nonnull
    public CompletableFuture<Void> preloadMetaData(@Nullable RecordMetaDataProvider metaDataProvider) {
        return this.getRecordMetaDataAsync(metaDataProvider == null).thenCompose(metaData -> {
            if (metaData == null) {
                RecordMetaData seedMetaData = metaDataProvider.getRecordMetaData();
                RecordMetaDataProto.MetaData metaDataProto = seedMetaData.toProto();
                return this.saveAndSetCurrent(metaDataProto);
            }
            return AsyncUtil.DONE;
        });
    }

    private PendingCacheUpdate pendingCacheUpdate() {
        if (this.pendingCacheUpdate == null) {
            this.pendingCacheUpdate = new PendingCacheUpdate();
        }
        return this.pendingCacheUpdate;
    }

    private void addPendingCacheUpdate(@Nonnull RecordMetaData metaData) {
        this.pendingCacheUpdate().metaData = metaData;
    }

    private void addPendingCacheUpdate(@Nonnull byte[] serialized) {
        this.pendingCacheUpdate().serialized = serialized;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_META_DATA, this.getRecordMetaDataAsync(true));
    }

    @API(value=API.Status.UNSTABLE)
    public void saveRecordMetaData(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_SAVE_META_DATA, this.saveRecordMetaDataAsync(fileDescriptor));
    }

    public void saveRecordMetaData(@Nonnull RecordMetaDataProvider metaDataProvider) {
        this.saveRecordMetaData(metaDataProvider.getRecordMetaData().toProto());
    }

    public void saveRecordMetaData(@Nonnull RecordMetaDataProto.MetaData metaDataProto) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_SAVE_META_DATA, this.saveAndSetCurrent(metaDataProto));
    }

    @API(value=API.Status.UNSTABLE)
    public CompletableFuture<Void> saveRecordMetaDataAsync(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        return this.getRecordMetaDataAsync(false).thenCompose(metaData -> {
            if (metaData == null) {
                return this.saveAndSetCurrent(RecordMetaData.build(MetaDataProtoEditor.addDefaultUnionIfMissing(fileDescriptor)).toProto());
            }
            return this.updateRecordsAsync(fileDescriptor);
        });
    }

    @Nonnull
    private CompletableFuture<RecordMetaDataProto.MetaData> loadCurrentProto() {
        return this.loadCurrentSerialized().thenApply(serialized -> {
            if (serialized == null) {
                return null;
            }
            return this.parseMetaDataProto((byte[])serialized);
        });
    }

    public void addIndex(@Nonnull String recordType, @Nonnull String indexName, @Nonnull String fieldName) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADD_INDEX, this.addIndexAsync(recordType, indexName, fieldName));
    }

    public void addIndex(@Nonnull String recordType, @Nonnull String indexName, @Nonnull KeyExpression indexExpression) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADD_INDEX, this.addIndexAsync(recordType, indexName, indexExpression));
    }

    public void addIndex(@Nonnull String recordType, @Nonnull Index index) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADD_INDEX, this.addIndexAsync(recordType, index));
    }

    @Nonnull
    public CompletableFuture<Void> addIndexAsync(@Nonnull String recordType, @Nonnull String indexName, @Nonnull String fieldName) {
        return this.addIndexAsync(recordType, new Index(indexName, fieldName));
    }

    @Nonnull
    public CompletableFuture<Void> addIndexAsync(@Nonnull String recordType, @Nonnull String indexName, @Nonnull KeyExpression indexExpression) {
        return this.addIndexAsync(recordType, new Index(indexName, indexExpression));
    }

    @Nonnull
    public CompletableFuture<Void> addIndexAsync(@Nonnull String recordType, @Nonnull Index index) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            recordMetaDataBuilder.addIndex(recordType, index);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void addMultiTypeIndex(@Nullable List<String> recordTypes, @Nonnull Index index) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADD_INDEX, this.addMultiTypeIndexAsync(recordTypes, index));
    }

    @Nonnull
    public CompletableFuture<Void> addMultiTypeIndexAsync(@Nullable List<String> recordTypes, @Nonnull Index index) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            ArrayList<RecordTypeBuilder> recordTypeBuilders = new ArrayList<RecordTypeBuilder>();
            if (recordTypes != null) {
                for (String type : recordTypes) {
                    recordTypeBuilders.add(recordMetaDataBuilder.getRecordType(type));
                }
            }
            recordMetaDataBuilder.addMultiTypeIndex(recordTypeBuilders, index);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void addUniversalIndex(@Nonnull Index index) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADD_INDEX, this.addUniversalIndexAsync(index));
    }

    @Nonnull
    public CompletableFuture<Void> addUniversalIndexAsync(@Nonnull Index index) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            recordMetaDataBuilder.addUniversalIndex(index);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void dropIndex(@Nonnull String indexName) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_DROP_INDEX, this.dropIndexAsync(indexName));
    }

    @Nonnull
    public CompletableFuture<Void> dropIndexAsync(@Nonnull String indexName) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            recordMetaDataBuilder.removeIndex(indexName);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    @API(value=API.Status.UNSTABLE)
    public void updateRecords(@Nonnull Descriptors.FileDescriptor recordsDescriptor) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_UPDATE_RECORDS_DESCRIPTOR, this.updateRecordsAsync(recordsDescriptor));
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public CompletableFuture<Void> updateRecordsAsync(@Nonnull Descriptors.FileDescriptor recordsDescriptor) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto, false);
            recordMetaDataBuilder.updateRecords(MetaDataProtoEditor.addDefaultUnionIfMissing(recordsDescriptor, recordMetaDataBuilder.getUnionDescriptor()));
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void mutateMetaData(@Nonnull Consumer<RecordMetaDataProto.MetaData.Builder> mutateMetaDataProto) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_MUTATE_METADATA, this.mutateMetaDataAsync(mutateMetaDataProto));
    }

    public void mutateMetaData(@Nonnull Consumer<RecordMetaDataProto.MetaData.Builder> mutateMetaDataProto, @Nullable Consumer<RecordMetaDataBuilder> mutateRecordMetaDataBuilder) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_MUTATE_METADATA, this.mutateMetaDataAsync(mutateMetaDataProto, mutateRecordMetaDataBuilder));
    }

    @Nonnull
    public CompletableFuture<Void> mutateMetaDataAsync(@Nonnull Consumer<RecordMetaDataProto.MetaData.Builder> mutateMetaDataProto) {
        return this.mutateMetaDataAsync(mutateMetaDataProto, null);
    }

    @Nonnull
    public CompletableFuture<Void> mutateMetaDataAsync(@Nonnull Consumer<RecordMetaDataProto.MetaData.Builder> mutateMetaDataProto, @Nullable Consumer<RecordMetaDataBuilder> mutateRecordMetaDataBuilder) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataProto.MetaData.Builder metaDataBuilder = metaDataProto.toBuilder();
            mutateMetaDataProto.accept(metaDataBuilder);
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder(metaDataBuilder.build());
            recordMetaDataBuilder.setVersion(metaDataProto.getVersion() + 1);
            if (mutateRecordMetaDataBuilder != null) {
                mutateRecordMetaDataBuilder.accept(recordMetaDataBuilder);
            }
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void updateStoreRecordVersions(boolean storeRecordVersions) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_UPDATE_STORE_RECORD_VERSIONS, this.updateStoreRecordVersionsAsync(storeRecordVersions));
    }

    @Nonnull
    public CompletableFuture<Void> updateStoreRecordVersionsAsync(boolean storeRecordVersions) {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            recordMetaDataBuilder.setStoreRecordVersions(storeRecordVersions);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    public void enableSplitLongRecords() {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ENABLE_SPLIT_LONG_RECORDS, this.enableSplitLongRecordsAsync());
    }

    @Nonnull
    public CompletableFuture<Void> enableSplitLongRecordsAsync() {
        return this.loadCurrentProto().thenCompose(metaDataProto -> {
            RecordMetaDataBuilder recordMetaDataBuilder = this.createMetaDataBuilder((RecordMetaDataProto.MetaData)metaDataProto);
            recordMetaDataBuilder.setSplitLongRecords(true);
            return this.saveAndSetCurrent(recordMetaDataBuilder.getRecordMetaData().toProto());
        });
    }

    @Nullable
    @VisibleForTesting
    public MetaDataCache getCache() {
        return this.cache;
    }

    static {
        ExtensionRegistry defaultExtensionRegistry = ExtensionRegistry.newInstance();
        RecordMetaDataOptionsProto.registerAllExtensions(defaultExtensionRegistry);
        DEFAULT_EXTENSION_REGISTRY = defaultExtensionRegistry.getUnmodifiable();
        CURRENT_KEY = Tuple.from(new Object[]{null});
        HISTORY_KEY_PREFIX = Tuple.from("H");
        OLD_FORMAT_KEY = TupleHelpers.EMPTY;
    }

    class PendingCacheUpdate
    implements FDBRecordContext.AfterCommit {
        RecordMetaData metaData;
        byte[] serialized;

        PendingCacheUpdate() {
        }

        @Override
        public void run() {
            if (this.metaData != null) {
                FDBMetaDataStore.this.cache.setCachedMetaData(this.metaData);
            }
            if (this.serialized != null) {
                FDBMetaDataStore.this.cache.setCachedSerialized(this.serialized);
            }
        }
    }

    public static class MissingMetaDataException
    extends RecordCoreException {
        public MissingMetaDataException(@Nonnull String msg) {
            super(msg, new Object[0]);
        }
    }
}

