/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.FDBRawRecord;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
class FDBPreloadRecordCache {
    @Nonnull
    private final Cache<Tuple, EntryImpl> cache;

    public FDBPreloadRecordCache(int maximumSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize(maximumSize).build();
    }

    @Nonnull
    public Future beginPrefetch(@Nonnull Tuple tuple) {
        EntryImpl entry = new EntryImpl(tuple);
        this.cache.put(tuple, entry);
        return entry;
    }

    public void invalidate(@Nonnull Tuple tuple) {
        this.cache.invalidate(tuple);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Nullable
    public Entry get(@Nonnull Tuple tuple) {
        EntryImpl entry = this.cache.getIfPresent(tuple);
        if (entry != null && entry.isComplete()) {
            return entry;
        }
        return null;
    }

    private class EntryImpl
    implements Entry,
    Future {
        private boolean isComplete;
        @Nullable
        private FDBRawRecord rawRecord;
        @Nonnull
        private final Tuple primaryKey;

        public EntryImpl(Tuple primaryKey) {
            this.primaryKey = primaryKey;
        }

        @Override
        public void cancel() {
            FDBPreloadRecordCache.this.cache.invalidate(this.primaryKey);
        }

        @Override
        public synchronized void complete(@Nullable FDBRawRecord rawRecord) {
            this.isComplete = true;
            this.rawRecord = rawRecord;
        }

        private synchronized boolean isComplete() {
            return this.isComplete;
        }

        @Override
        public boolean isPresent() {
            return this.rawRecord != null;
        }

        @Override
        public FDBRawRecord get() {
            if (this.rawRecord == null) {
                throw new IllegalStateException("record is null");
            }
            return this.rawRecord;
        }

        @Override
        @Nullable
        public FDBRawRecord orElse(@Nullable FDBRawRecord other) {
            return this.rawRecord != null ? this.rawRecord : other;
        }
    }

    public static interface Future {
        public void complete(@Nullable FDBRawRecord var1);

        public void cancel();
    }

    public static interface Entry {
        public boolean isPresent();

        public FDBRawRecord get();

        @Nullable
        public FDBRawRecord orElse(@Nullable FDBRawRecord var1);
    }
}

