/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class FDBQueriedRecord<M extends Message>
implements FDBRecord<M> {
    @Nullable
    public abstract FDBStoredRecord<M> getStoredRecord();

    @Nullable
    public abstract Index getIndex();

    @Nullable
    public abstract IndexEntry getIndexEntry();

    @Nullable
    public abstract FDBSyntheticRecord getSyntheticRecord();

    @Nullable
    public abstract FDBQueriedRecord<M> getConstituent(@Nonnull String var1);

    @Nullable
    public abstract String getConstituentName();

    public static <M extends Message> FDBQueriedRecord<M> indexed(@Nonnull FDBIndexedRecord<M> indexed) {
        return new Indexed<M>(indexed);
    }

    public static <M extends Message> FDBQueriedRecord<M> stored(@Nonnull FDBStoredRecord<M> stored) {
        return new Stored<M>(stored);
    }

    public static <M extends Message> FDBQueriedRecord<M> covered(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull Tuple primaryKey, @Nonnull RecordType recordType, @Nonnull M protoRecord) {
        return new Covered<M>(index, indexEntry, primaryKey, recordType, protoRecord);
    }

    public static <M extends Message> FDBQueriedRecord<M> synthetic(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull FDBSyntheticRecord syntheticRecord) {
        return new Synthetic(index, indexEntry, syntheticRecord);
    }

    static class Indexed<M extends Message>
    extends FDBQueriedRecord<M> {
        private final FDBIndexedRecord<M> indexed;

        Indexed(FDBIndexedRecord<M> indexed) {
            this.indexed = indexed;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.indexed.getPrimaryKey();
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.indexed.getRecordType();
        }

        @Override
        @Nonnull
        public M getRecord() {
            return this.indexed.getRecord();
        }

        @Override
        public boolean hasVersion() {
            return this.indexed.hasVersion();
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return this.indexed.getVersion();
        }

        @Override
        @Nonnull
        public FDBStoredRecord<M> getStoredRecord() {
            return this.indexed.getStoredRecord();
        }

        @Override
        @Nonnull
        public Index getIndex() {
            return this.indexed.getIndex();
        }

        @Override
        @Nonnull
        public IndexEntry getIndexEntry() {
            return this.indexed.getIndexEntry();
        }

        @Override
        @Nullable
        public FDBSyntheticRecord getSyntheticRecord() {
            return null;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(@Nonnull String constituentName) {
            return null;
        }

        @Override
        @Nullable
        public String getConstituentName() {
            return null;
        }
    }

    static class Stored<M extends Message>
    extends FDBQueriedRecord<M> {
        private final FDBStoredRecord<M> stored;

        Stored(@Nonnull FDBStoredRecord<M> stored) {
            this.stored = stored;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.stored.getPrimaryKey();
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.stored.getRecordType();
        }

        @Override
        @Nonnull
        public M getRecord() {
            return this.stored.getRecord();
        }

        @Override
        public boolean hasVersion() {
            return this.stored.hasVersion();
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return this.stored.getVersion();
        }

        @Override
        @Nullable
        public FDBStoredRecord<M> getStoredRecord() {
            return this.stored;
        }

        @Override
        @Nullable
        public Index getIndex() {
            return null;
        }

        @Override
        @Nullable
        public IndexEntry getIndexEntry() {
            return null;
        }

        @Override
        @Nullable
        public FDBSyntheticRecord getSyntheticRecord() {
            return null;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(@Nonnull String constituentName) {
            return null;
        }

        @Override
        @Nullable
        public String getConstituentName() {
            return null;
        }
    }

    static class Covered<M extends Message>
    extends FDBQueriedRecord<M> {
        @Nonnull
        private final Index index;
        @Nonnull
        private final IndexEntry indexEntry;
        @Nonnull
        private final Tuple primaryKey;
        @Nonnull
        private final RecordType recordType;
        @Nonnull
        private final M protoRecord;

        public Covered(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull Tuple primaryKey, @Nonnull RecordType recordType, @Nonnull M protoRecord) {
            this.index = index;
            this.indexEntry = indexEntry;
            this.primaryKey = primaryKey;
            this.recordType = recordType;
            this.protoRecord = protoRecord;
        }

        @Override
        @Nonnull
        public Index getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public IndexEntry getIndexEntry() {
            return this.indexEntry;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.recordType;
        }

        @Override
        @Nonnull
        public M getRecord() {
            return this.protoRecord;
        }

        @Override
        public boolean hasVersion() {
            return false;
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return null;
        }

        @Override
        @Nullable
        public FDBStoredRecord<M> getStoredRecord() {
            return null;
        }

        @Override
        @Nullable
        public FDBSyntheticRecord getSyntheticRecord() {
            return null;
        }

        @Override
        @Nullable
        public String getConstituentName() {
            return null;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(final @Nonnull String constituentName) {
            if (this.recordType instanceof SyntheticRecordType) {
                int position;
                RecordType constituentRecordType = null;
                List constituentsTypes = ((SyntheticRecordType)this.recordType).getConstituents();
                for (position = 0; position < constituentsTypes.size(); ++position) {
                    SyntheticRecordType.Constituent constituentType = (SyntheticRecordType.Constituent)constituentsTypes.get(position);
                    if (!constituentType.getName().equals(constituentName)) continue;
                    constituentRecordType = constituentType.getRecordType();
                    break;
                }
                if (constituentRecordType == null) {
                    return null;
                }
                Tuple constituentPrimaryKey = this.primaryKey.isEmpty() ? TupleHelpers.EMPTY : this.primaryKey.getNestedTuple(position + 1);
                Message constituent = (Message)this.protoRecord.getField(this.recordType.getDescriptor().findFieldByName(constituentName));
                return new Covered<M>(this.index, this.indexEntry, constituentPrimaryKey, constituentRecordType, constituent){

                    @Override
                    @Nonnull
                    public String getConstituentName() {
                        return constituentName;
                    }
                };
            }
            return null;
        }
    }

    static class Synthetic<M extends Message>
    extends FDBQueriedRecord<M> {
        @Nonnull
        private final Index index;
        @Nonnull
        private final IndexEntry indexEntry;
        @Nonnull
        private final FDBSyntheticRecord syntheticRecord;

        public Synthetic(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull FDBSyntheticRecord syntheticRecord) {
            this.index = index;
            this.indexEntry = indexEntry;
            this.syntheticRecord = syntheticRecord;
        }

        @Override
        @Nonnull
        public Index getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public IndexEntry getIndexEntry() {
            return this.indexEntry;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.syntheticRecord.getPrimaryKey();
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.syntheticRecord.getRecordType();
        }

        @Override
        @Nonnull
        public M getRecord() {
            return (M)this.syntheticRecord.getRecord();
        }

        @Override
        public boolean hasVersion() {
            return false;
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return null;
        }

        @Override
        @Nullable
        public FDBStoredRecord<M> getStoredRecord() {
            return null;
        }

        @Override
        @Nonnull
        public FDBSyntheticRecord getSyntheticRecord() {
            return this.syntheticRecord;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(@Nonnull String constituentName) {
            if (this.syntheticRecord.getConstituent(constituentName) == null) {
                return null;
            }
            return new Constituent(this.index, this.indexEntry, this.syntheticRecord, constituentName);
        }

        @Override
        @Nullable
        public String getConstituentName() {
            return null;
        }
    }

    static class Constituent<M extends Message>
    extends FDBQueriedRecord<M> {
        @Nonnull
        private final Index index;
        @Nonnull
        private final IndexEntry indexEntry;
        @Nonnull
        private final FDBSyntheticRecord syntheticRecord;
        @Nonnull
        private final String constituentName;

        public Constituent(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull FDBSyntheticRecord syntheticRecord, @Nonnull String constituentName) {
            this.index = index;
            this.indexEntry = indexEntry;
            this.syntheticRecord = syntheticRecord;
            this.constituentName = constituentName;
        }

        @Override
        @Nonnull
        public Index getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public IndexEntry getIndexEntry() {
            return this.indexEntry;
        }

        @Override
        @Nonnull
        public Tuple getPrimaryKey() {
            return this.getStoredRecord().getPrimaryKey();
        }

        @Override
        @Nonnull
        public RecordType getRecordType() {
            return this.getStoredRecord().getRecordType();
        }

        @Override
        @Nonnull
        public M getRecord() {
            return this.getStoredRecord().getRecord();
        }

        @Override
        public boolean hasVersion() {
            return this.getStoredRecord().hasVersion();
        }

        @Override
        @Nullable
        public FDBRecordVersion getVersion() {
            return this.getStoredRecord().getVersion();
        }

        @Override
        @Nonnull
        public FDBStoredRecord<M> getStoredRecord() {
            return Objects.requireNonNull(this.syntheticRecord.getConstituent(this.constituentName));
        }

        @Override
        @Nonnull
        public FDBSyntheticRecord getSyntheticRecord() {
            return this.syntheticRecord;
        }

        @Override
        @Nullable
        public FDBQueriedRecord<M> getConstituent(@Nonnull String constituentName) {
            return null;
        }

        @Override
        @Nonnull
        public String getConstituentName() {
            return this.constituentName;
        }
    }
}

