/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class FDBRawRecord
implements FDBStoredSizes {
    @Nonnull
    private final Tuple primaryKey;
    @Nonnull
    private final byte[] rawRecord;
    @Nullable
    private final FDBRecordVersion version;
    private final int keyCount;
    private final int keySize;
    private final int valueSize;
    private final boolean split;
    private final boolean versionedInline;

    public FDBRawRecord(@Nonnull Tuple primaryKey, @Nonnull byte[] rawRecord, @Nullable FDBRecordVersion version, @Nonnull FDBStoredSizes size) {
        this(primaryKey, rawRecord, version, size.getKeyCount(), size.getKeySize(), size.getValueSize(), size.isSplit(), size.isVersionedInline());
    }

    public FDBRawRecord(@Nonnull Tuple primaryKey, @Nonnull byte[] rawRecord, @Nullable FDBRecordVersion version, int keyCount, int keySize, int valueSize, boolean split, boolean versionedInline) {
        this.primaryKey = primaryKey;
        this.rawRecord = rawRecord;
        this.version = version;
        this.keyCount = keyCount;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.split = split;
        this.versionedInline = versionedInline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDBRawRecord that = (FDBRawRecord)o;
        if (!this.primaryKey.equals(that.getPrimaryKey())) {
            return false;
        }
        if (!Arrays.equals(this.rawRecord, that.getRawRecord())) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return this.keyCount == that.keyCount && this.keySize == that.keySize && this.valueSize == that.valueSize && this.split == that.split && this.versionedInline == that.versionedInline;
    }

    public int hashCode() {
        return 31 * this.primaryKey.hashCode() + Arrays.hashCode(this.rawRecord) + (this.version != null ? 961 * this.version.hashCode() : 0);
    }

    @Nonnull
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    @Nonnull
    public byte[] getRawRecord() {
        return this.rawRecord;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    @Nullable
    public FDBRecordVersion getVersion() {
        return this.version;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    @Override
    public boolean isVersionedInline() {
        return this.versionedInline;
    }
}

