/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBError;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.locking.AsyncLock;
import com.apple.foundationdb.record.locking.LockIdentifier;
import com.apple.foundationdb.record.locking.LockRegistry;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBLatencySource;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.RecordContextNotActiveException;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.plan.cascades.TempTable;
import com.apple.foundationdb.record.util.MapUtils;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.system.SystemKeyspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Utf8;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class FDBRecordContext
extends FDBTransactionContext
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBRecordContext.class);
    private static final byte[] META_DATA_VERSION_STAMP_VALUE = new byte[14];
    private static final long UNSET_VERSION = 0L;
    private static final String INTERNAL_COMMIT_HOOK_PREFIX = "@__";
    private static final String AFTER_COMMIT_HOOK_NAME = "@__afterCommit";
    public static final int MAX_TR_ID_SIZE = 100;
    @Nullable
    private CompletableFuture<Long> readVersionFuture;
    private long readVersion = 0L;
    private long committedVersion = 0L;
    private long transactionCreateTime;
    @Nullable
    private final String transactionId;
    @Nullable
    private final Throwable openStackTrace;
    private boolean logged;
    @Nullable
    private byte[] versionStamp;
    @Nonnull
    private AtomicInteger localVersion;
    @Nonnull
    private ConcurrentNavigableMap<byte[], Integer> localVersionCache;
    @Nonnull
    private ConcurrentNavigableMap<byte[], NonnullPair<MutationType, byte[]>> versionMutationCache;
    @Nonnull
    private final FDBRecordContextConfig config;
    private final long timeoutMillis;
    @Nullable
    private Consumer<StoreTimer.Wait> hookForAsyncToSync = null;
    @Nonnull
    private final Map<String, CommitCheckAsync> commitChecks = new LinkedHashMap<String, CommitCheckAsync>();
    @Nonnull
    private final Map<String, PostCommit> postCommits = new LinkedHashMap<String, PostCommit>();
    private boolean dirtyStoreState;
    private boolean dirtyMetaDataVersionStamp;
    private long trackOpenTimeNanos;
    @Nonnull
    private final Map<Object, Object> session = new LinkedHashMap<Object, Object>();
    @Nullable
    private List<Range> notCommittedConflictingKeys = null;
    @Nonnull
    private final LockRegistry lockRegistry = new LockRegistry(this.getTimer());
    @Nonnull
    private final TempTable.Factory tempTableFactory = TempTable.Factory.instance();

    protected FDBRecordContext(@Nonnull FDBDatabase fdb, @Nonnull Transaction transaction, @Nonnull FDBRecordContextConfig config, @Nullable FDBStoreTimer delayedTimer) {
        super(fdb, transaction, config.getTimer(), delayedTimer);
        this.transactionCreateTime = System.currentTimeMillis();
        this.localVersion = new AtomicInteger(0);
        this.localVersionCache = new ConcurrentSkipListMap<byte[], Integer>(ByteArrayUtil::compareUnsigned);
        this.versionMutationCache = new ConcurrentSkipListMap<byte[], NonnullPair<MutationType, byte[]>>(ByteArrayUtil::compareUnsigned);
        this.transactionId = FDBRecordContext.getSanitizedId(config);
        this.openStackTrace = config.isSaveOpenStackTrace() ? new Throwable("Not really thrown") : null;
        Transaction tr = this.ensureActive();
        if (this.transactionId != null) {
            tr.options().setDebugTransactionIdentifier(this.transactionId);
            if (config.isLogTransaction()) {
                this.logTransaction();
            }
        }
        if (config.isServerRequestTracing()) {
            tr.options().setServerRequestTracing();
        }
        if (!config.getTags().isEmpty()) {
            for (String tag : config.getTags()) {
                tr.options().setTag(tag);
            }
        }
        if (config.isReportConflictingKeys()) {
            tr.options().setReportConflictingKeys();
        }
        this.config = config;
        if (config.getWeakReadSemantics() != null && config.getWeakReadSemantics().isCausalReadRisky()) {
            tr.options().setCausalReadRisky();
        }
        switch (config.getPriority()) {
            case BATCH: {
                tr.options().setPriorityBatch();
                break;
            }
            case DEFAULT: {
                break;
            }
            case SYSTEM_IMMEDIATE: {
                tr.options().setPrioritySystemImmediate();
                break;
            }
            default: {
                throw new RecordCoreArgumentException("unknown priority level " + String.valueOf((Object)config.getPriority()), new Object[0]);
            }
        }
        this.timeoutMillis = FDBRecordContext.getTimeoutMillisToSet(fdb, config);
        if (this.timeoutMillis != -1L) {
            tr.options().setTimeout(this.timeoutMillis);
        }
        this.dirtyStoreState = false;
    }

    @Nonnull
    public FDBRecordContextConfig getConfig() {
        return this.config;
    }

    @Nullable
    private static String getSanitizedId(@Nonnull FDBRecordContextConfig config) {
        if (config.getTransactionId() != null) {
            return FDBRecordContext.getSanitizedId(config.getTransactionId());
        }
        if (config.getMdcContext() != null) {
            String mdcId = config.getMdcContext().get("uuid");
            return mdcId == null ? null : FDBRecordContext.getSanitizedId(mdcId);
        }
        return null;
    }

    @Nullable
    private static String getSanitizedId(@Nonnull String id) {
        try {
            if (Utf8.encodedLength(id) > 100) {
                if (CharMatcher.ascii().matchesAllOf(id)) {
                    return id.substring(0, 97) + "...";
                }
                return null;
            }
            return id;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static long getTimeoutMillisToSet(@Nonnull FDBDatabase fdb, @Nonnull FDBRecordContextConfig config) {
        if (config.getTransactionTimeoutMillis() != -1L) {
            return config.getTransactionTimeoutMillis();
        }
        return fdb.getFactory().getTransactionTimeoutMillis();
    }

    @Nullable
    public String getTransactionId() {
        return this.transactionId;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public final void logTransaction() {
        if (this.transactionId == null) {
            throw new RecordCoreException("Cannot log transaction as ID is not set", new Object[0]);
        }
        this.ensureActive().options().setLogTransaction();
        this.logged = true;
    }

    public boolean isLogged() {
        return this.logged;
    }

    @API(value=API.Status.INTERNAL)
    @VisibleForTesting
    public long getTrackOpenTimeNanos() {
        return this.trackOpenTimeNanos;
    }

    void setTrackOpenTimeNanos(long trackOpenTimeNanos) {
        this.trackOpenTimeNanos = trackOpenTimeNanos;
    }

    @Nullable
    Throwable getOpenStackTrace() {
        return this.openStackTrace;
    }

    public boolean isClosed() {
        return this.transaction == null;
    }

    @Override
    public void close() {
        this.closeTransaction(false);
    }

    synchronized void closeTransaction(boolean openTooLong) {
        if (this.transaction != null) {
            try {
                this.transaction.close();
            }
            finally {
                this.transaction = null;
                if (this.trackOpenTimeNanos != 0L) {
                    this.database.untrackOpenContext(this);
                }
                if (this.timer != null) {
                    this.timer.increment(FDBStoreTimer.Counts.CLOSE_CONTEXT);
                    if (openTooLong) {
                        this.timer.increment(FDBStoreTimer.Counts.CLOSE_CONTEXT_OPEN_TOO_LONG);
                    }
                }
            }
        }
    }

    @Nonnull
    private CompletableFuture<Void> injectLatency(@Nonnull FDBLatencySource latencySource) {
        long latencyMillis = this.database.getLatencyToInject(latencySource);
        if (latencyMillis <= 0L) {
            return AsyncUtil.DONE;
        }
        return this.instrument(latencySource.getTimerEvent(), MoreAsyncUtil.delayedFuture(latencyMillis, TimeUnit.MILLISECONDS, this.getScheduledExecutor()));
    }

    public void commit() {
        this.asyncToSync(FDBStoreTimer.Waits.WAIT_COMMIT, this.commitAsync());
    }

    public CompletableFuture<Void> commitAsync() {
        long startTimeNanos = System.nanoTime();
        this.ensureActive();
        CompletableFuture<Void> checks = this.runCommitChecks();
        this.versionMutationCache.forEach((key, valuePair) -> this.transaction.mutate((MutationType)((Object)((Object)valuePair.getLeft())), (byte[])key, (byte[])valuePair.getRight()));
        CompletableFuture<byte[]> versionFuture = this.transaction.getVersionstamp();
        long beforeCommitTimeMillis = System.currentTimeMillis();
        CompletionStage<Void> commit = MoreAsyncUtil.isCompletedNormally(checks) ? this.delayedCommit() : checks.thenCompose(vignore -> this.delayedCommit());
        commit = commit.thenCompose(vignore -> {
            this.committedVersion = this.transaction.getCommittedVersion();
            if (this.committedVersion > 0L) {
                return versionFuture.thenAccept(vs -> {
                    this.versionStamp = vs;
                });
            }
            return AsyncUtil.DONE;
        });
        if (this.config.isReportConflictingKeys()) {
            commit = MoreAsyncUtil.composeWhenCompleteAndHandle(commit, (v, ex) -> {
                FDBException fdbException = FDBExceptions.getFDBCause(ex);
                if (fdbException != null && FDBError.fromCode(fdbException.getCode()) == FDBError.NOT_COMMITTED) {
                    return FDBRecordContext.readConflictingKeys(this.ensureActive(), this.getExecutor()).thenApply(keys -> {
                        this.notCommittedConflictingKeys = keys;
                        return null;
                    });
                }
                return AsyncUtil.DONE;
            }, ex -> ex instanceof RuntimeException ? (RuntimeException)ex : new RecordCoreException((Throwable)ex));
        }
        return ((CompletableFuture)commit.whenComplete((v, ex) -> {
            FDBStoreTimer.Events event = FDBStoreTimer.Events.COMMIT;
            try {
                if (ex != null) {
                    event = FDBStoreTimer.Events.COMMIT_FAILURE;
                } else if (this.committedVersion > 0L) {
                    if (this.database.isTrackLastSeenVersionOnCommit()) {
                        this.database.updateLastSeenFDBVersion(beforeCommitTimeMillis, this.committedVersion);
                    }
                } else {
                    event = FDBStoreTimer.Events.COMMIT_READ_ONLY;
                }
            }
            finally {
                this.close();
                if (this.timer != null) {
                    this.timer.recordSinceNanoTime(event, startTimeNanos);
                }
            }
        })).thenCompose(vignore -> this.runPostCommits());
    }

    private CompletableFuture<Void> delayedCommit() {
        return this.injectLatency(FDBLatencySource.COMMIT_ASYNC).thenCompose(vignore -> this.transaction.commit());
    }

    @Override
    @Nonnull
    public Transaction ensureActive() {
        if (this.transaction == null) {
            throw new RecordContextNotActiveException("Transaction is no longer active.");
        }
        return this.transaction;
    }

    public synchronized long setReadVersion(long readVersion) {
        if (this.hasReadVersion()) {
            return this.readVersion;
        }
        if (this.readVersionFuture != null) {
            if (MoreAsyncUtil.isCompletedNormally(this.readVersionFuture)) {
                return this.joinNow(this.readVersionFuture);
            }
            throw new RecordCoreException("Cannot set read version as read version request is outstanding", new Object[0]);
        }
        this.ensureActive().setReadVersion(readVersion);
        this.readVersion = readVersion;
        this.readVersionFuture = CompletableFuture.completedFuture(readVersion);
        return readVersion;
    }

    @Nonnull
    public synchronized CompletableFuture<Long> getReadVersionAsync() {
        if (this.readVersionFuture != null) {
            return this.readVersionFuture;
        }
        this.ensureActive();
        long startTimeMillis = System.currentTimeMillis();
        long startTimeNanos = System.nanoTime();
        CompletableFuture<Long> localReadVersionFuture = ((CompletableFuture)this.injectLatency(FDBLatencySource.GET_READ_VERSION).thenCompose(ignore -> this.ensureActive().getReadVersion())).thenApply(newReadVersion -> {
            this.readVersion = newReadVersion;
            if (this.database.isTrackLastSeenVersionOnRead()) {
                this.database.updateLastSeenFDBVersion(startTimeMillis, (long)newReadVersion);
            }
            return newReadVersion;
        });
        FDBStoreTimer.Events grvEvent = FDBTransactionPriority.BATCH.equals((Object)this.config.getPriority()) ? FDBStoreTimer.Events.BATCH_GET_READ_VERSION : FDBStoreTimer.Events.GET_READ_VERSION;
        localReadVersionFuture = this.instrument(grvEvent, localReadVersionFuture, startTimeNanos);
        this.readVersionFuture = localReadVersionFuture;
        return localReadVersionFuture;
    }

    @SpotBugsSuppressWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="read only one field and avoid blocking in setReadVersion")
    public long getReadVersion() {
        if (this.hasReadVersion()) {
            return this.readVersion;
        }
        return this.asyncToSync(FDBStoreTimer.Waits.WAIT_GET_READ_VERSION, this.getReadVersionAsync());
    }

    public boolean hasReadVersion() {
        return this.readVersion != 0L;
    }

    @Nonnull
    public ReadTransaction readTransaction(boolean snapshot) {
        if (snapshot) {
            return this.ensureActive().snapshot();
        }
        return this.ensureActive();
    }

    public long getTransactionAge() {
        return System.currentTimeMillis() - this.transactionCreateTime;
    }

    public long getTransactionCreateTime() {
        return this.transactionCreateTime;
    }

    @API(value=API.Status.INTERNAL)
    public void setDirtyStoreState(boolean dirtyStoreState) {
        this.dirtyStoreState = dirtyStoreState;
    }

    @API(value=API.Status.INTERNAL)
    public boolean hasDirtyStoreState() {
        return this.dirtyStoreState;
    }

    @API(value=API.Status.INTERNAL)
    public synchronized List<CommitCheckAsync> getCommitChecks(@Nonnull Predicate<CommitCheckAsync> filter) {
        return this.commitChecks.values().stream().filter(filter).collect(Collectors.toList());
    }

    @API(value=API.Status.INTERNAL)
    public synchronized List<CompletableFuture<Void>> removeCommitChecks(@Nonnull Function<CommitCheckAsync, Boolean> filter, @Nonnull Predicate<Throwable> shouldSwallow) {
        List toRemove = this.commitChecks.entrySet().stream().filter(entry -> (Boolean)filter.apply((CommitCheckAsync)entry.getValue())).collect(Collectors.toList());
        return toRemove.stream().map(entry -> MoreAsyncUtil.swallowException(((CommitCheckAsync)entry.getValue()).checkAsync(), shouldSwallow).whenComplete((result, err) -> this.removeCommitCheck((String)entry.getKey()))).collect(Collectors.toList());
    }

    private synchronized void removeCommitCheck(String key) {
        this.commitChecks.remove(key);
    }

    public synchronized void addCommitCheck(@Nonnull CompletableFuture<Void> check) {
        this.addCommitCheck(CommitCheckAsync.fromFuture(check));
    }

    public void addCommitCheck(@Nonnull CommitCheckAsync check) {
        this.addAnonymousCommitHookToMap(this.commitChecks, check);
    }

    public void addCommitCheck(@Nonnull String name, @Nonnull CommitCheckAsync check) {
        this.addCommitHook(this.commitChecks, name, check);
    }

    @Nonnull
    public CommitCheckAsync getOrCreateCommitCheck(@Nonnull String name, @Nonnull Function<String, CommitCheckAsync> ifNotExists) {
        return this.getOrCreateCommitHook(this.commitChecks, name, ifNotExists);
    }

    @Nullable
    public CommitCheckAsync getCommitCheck(@Nonnull String name) {
        return this.getCommitHook(this.commitChecks, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompletableFuture<Void> runCommitChecks() {
        List futures;
        Map<String, CommitCheckAsync> map = this.commitChecks;
        synchronized (map) {
            if (this.commitChecks.isEmpty()) {
                return AsyncUtil.DONE;
            }
            futures = this.commitChecks.values().stream().map(CommitCheckAsync::checkAsync).collect(Collectors.toList());
        }
        return AsyncUtil.whenAll(futures);
    }

    @Nonnull
    public PostCommit getOrCreatePostCommit(@Nonnull String name, @Nonnull Function<String, PostCommit> ifNotExists) {
        return this.getOrCreateCommitHook(this.postCommits, name, ifNotExists);
    }

    @Nullable
    public PostCommit getPostCommit(@Nonnull String name) {
        return this.getCommitHook(this.postCommits, name);
    }

    public void addPostCommit(@Nonnull String name, @Nonnull PostCommit postCommit) {
        this.addCommitHook(this.postCommits, name, postCommit);
    }

    public void addPostCommit(@Nonnull PostCommit postCommit) {
        this.addAnonymousCommitHookToMap(this.postCommits, postCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addAnonymousCommitHookToMap(@Nonnull Map<String, T> map, @Nonnull T item) {
        Map<String, T> map2 = map;
        synchronized (map2) {
            String name;
            while (map.containsKey(name = "@__anon-" + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE))) {
            }
            map.put(name, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addCommitHook(@Nonnull Map<String, T> map, @Nonnull String name, @Nonnull T item) {
        this.checkCommitHookName(name);
        Map<String, T> map2 = map;
        synchronized (map2) {
            if (map.containsKey(name)) {
                throw new RecordCoreArgumentException("Commit hook already exists", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMMIT_NAME, name});
            }
            map.put(name, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreateCommitHook(@Nonnull Map<String, T> map, @Nonnull String name, @Nonnull Function<String, T> ifNotExists) {
        this.checkCommitHookName(name);
        Map<String, T> map2 = map;
        synchronized (map2) {
            return MapUtils.computeIfAbsent(map, name, ifNotExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T getCommitHook(@Nonnull Map<String, T> map, @Nonnull String name) {
        if (this.isInternalCommitHookName(name)) {
            return null;
        }
        Map<String, T> map2 = map;
        synchronized (map2) {
            return map.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PostCommit removePostCommit(@Nonnull String name) {
        this.checkCommitHookName(name);
        Map<String, PostCommit> map = this.postCommits;
        synchronized (map) {
            return this.postCommits.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Void> runPostCommits() {
        Map<String, PostCommit> map = this.postCommits;
        synchronized (map) {
            if (this.postCommits.isEmpty()) {
                return AsyncUtil.DONE;
            }
            List work = this.postCommits.values().stream().map(PostCommit::get).collect(Collectors.toList());
            this.postCommits.clear();
            return AsyncUtil.whenAll(work);
        }
    }

    private void checkCommitHookName(@Nonnull String name) {
        if (this.isInternalCommitHookName(name)) {
            throw new RecordCoreArgumentException("Invalid commit hook name", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMMIT_NAME, name});
        }
    }

    private boolean isInternalCommitHookName(@Nonnull String name) {
        return name.startsWith(INTERNAL_COMMIT_HOOK_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfterCommit(@Nonnull AfterCommit afterCommit) {
        Map<String, PostCommit> map = this.postCommits;
        synchronized (map) {
            AfterCommitPostCommit adapter = (AfterCommitPostCommit)this.postCommits.get(AFTER_COMMIT_HOOK_NAME);
            if (adapter == null) {
                adapter = new AfterCommitPostCommit();
                this.postCommits.put(AFTER_COMMIT_HOOK_NAME, adapter);
            }
            adapter.addAfterCommit(afterCommit);
        }
    }

    public long getCommittedVersion() {
        if (this.committedVersion == 0L) {
            throw new RecordCoreStorageException("Transaction has not been committed yet.");
        }
        return this.committedVersion;
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"EI"}, justification="avoids copy")
    public byte[] getVersionStamp() {
        if (this.committedVersion == 0L) {
            throw new RecordCoreStorageException("Transaction has not been committed yet.");
        }
        return this.versionStamp;
    }

    @Nonnull
    public CompletableFuture<byte[]> getMetaDataVersionStampAsync(@Nonnull IsolationLevel isolationLevel) {
        if (this.dirtyMetaDataVersionStamp) {
            this.ensureActive();
            return CompletableFuture.completedFuture(null);
        }
        return this.readTransaction(isolationLevel.isSnapshot()).get(SystemKeyspace.METADATA_VERSION_KEY).handle((val, err) -> {
            if (err == null) {
                return val;
            }
            FDBException fdbCause = FDBExceptions.getFDBCause(err);
            if (fdbCause != null && fdbCause.getCode() == FDBError.ACCESSED_UNREADABLE.code()) {
                this.dirtyMetaDataVersionStamp = true;
                return null;
            }
            throw this.database.mapAsyncToSyncException((Throwable)err);
        });
    }

    @Nullable
    public byte[] getMetaDataVersionStamp(@Nonnull IsolationLevel isolationLevel) {
        return this.asyncToSync(FDBStoreTimer.Waits.WAIT_META_DATA_VERSION_STAMP, this.getMetaDataVersionStampAsync(isolationLevel));
    }

    public void setMetaDataVersionStamp() {
        this.ensureActive();
        this.dirtyMetaDataVersionStamp = true;
        this.transaction.mutate(MutationType.SET_VERSIONSTAMPED_VALUE, SystemKeyspace.METADATA_VERSION_KEY, META_DATA_VERSION_STAMP_VALUE);
    }

    @Nullable
    public <T> T asyncToSync(StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        if (this.hookForAsyncToSync != null && !MoreAsyncUtil.isCompletedNormally(async)) {
            this.hookForAsyncToSync.accept(event);
        }
        return this.database.asyncToSync(this.timer, event, async);
    }

    public <T> T join(CompletableFuture<T> future) {
        return this.database.join(future);
    }

    public <T> T joinNow(CompletableFuture<T> future) {
        return this.database.joinNow(future);
    }

    public <T> T get(CompletableFuture<T> future) throws InterruptedException, ExecutionException {
        return this.database.get(future);
    }

    public void timeReadSampleKey(byte[] key) {
        if (this.timer != null) {
            CompletionStage future = this.instrument((StoreTimer.Event)FDBStoreTimer.Events.READ_SAMPLE_KEY, this.ensureActive().get(key)).handle((bytes, ex) -> {
                if (ex != null && (!(ex instanceof FDBException) || ((FDBException)ex).getCode() != FDBError.TRANSACTION_CANCELLED.code()) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.of("error reading sample key", new Object[]{LogMessageKeys.KEY, ByteArrayUtil2.loggable(key)}), (Throwable)ex);
                }
                return null;
            });
            this.addCommitCheck((CompletableFuture<Void>)future);
        }
    }

    @Nullable
    public Map<String, String> getMdcContext() {
        return this.config.getMdcContext();
    }

    @Nonnull
    public FDBDatabaseRunner newRunner() {
        return this.database.newRunner(this.config.toBuilder());
    }

    public int claimLocalVersion() {
        return this.localVersion.getAndIncrement();
    }

    void addToLocalVersionCache(@Nonnull byte[] recordVersionKey, int version) {
        this.localVersionCache.put(recordVersionKey, version);
    }

    boolean removeLocalVersion(@Nonnull byte[] recordVersionKey) {
        return this.localVersionCache.remove(recordVersionKey) != null;
    }

    @API(value=API.Status.INTERNAL)
    void removeLocalVersionRange(Range range) {
        this.localVersionCache.subMap((Object)range.begin, (Object)range.end).clear();
    }

    @Nonnull
    Optional<Integer> getLocalVersion(@Nonnull byte[] recordVersionKey) {
        return Optional.ofNullable((Integer)this.localVersionCache.get(recordVersionKey));
    }

    @Nullable
    public byte[] addVersionMutation(@Nonnull MutationType mutationType, @Nonnull byte[] key, @Nonnull byte[] value) {
        NonnullPair<MutationType, byte[]> valuePair = NonnullPair.of(mutationType, value);
        NonnullPair<MutationType, byte[]> existingPair = this.versionMutationCache.put(key, valuePair);
        return existingPair != null ? existingPair.getRight() : null;
    }

    @Nullable
    public byte[] removeVersionMutation(@Nonnull byte[] key) {
        NonnullPair existingValue = (NonnullPair)this.versionMutationCache.remove(key);
        return existingValue != null ? (byte[])existingValue.getRight() : null;
    }

    @API(value=API.Status.INTERNAL)
    public void removeVersionMutationRange(@Nonnull Range range) {
        this.versionMutationCache.subMap((Object)range.begin, (Object)range.end).clear();
    }

    @API(value=API.Status.INTERNAL)
    public void clear(@Nonnull byte[] key) {
        this.ensureActive().clear(key);
        this.removeVersionMutation(key);
        this.removeLocalVersion(key);
    }

    @API(value=API.Status.INTERNAL)
    public void clear(@Nonnull Range range) {
        this.ensureActive().clear(range);
        this.removeVersionMutationRange(range);
        this.removeLocalVersionRange(range);
    }

    @Nullable
    public byte[] updateVersionMutation(@Nonnull MutationType mutationType, @Nonnull byte[] key, @Nonnull byte[] value, @Nonnull BiFunction<byte[], byte[], byte[]> remappingFunction) {
        NonnullPair<MutationType, byte[]> valuePair = NonnullPair.of(mutationType, value);
        return (byte[])this.versionMutationCache.merge(key, valuePair, (origPair, newPair) -> {
            if (((MutationType)((Object)((Object)origPair.getLeft()))).equals(newPair.getLeft())) {
                byte[] newValue = (byte[])remappingFunction.apply((byte[])origPair.getRight(), (byte[])newPair.getRight());
                return newValue == null ? null : NonnullPair.of((MutationType)((Object)((Object)origPair.getLeft())), newValue);
            }
            throw new RecordCoreArgumentException("cannot update mutation type for versionstamp operation", new Object[0]);
        }).getRight();
    }

    @Nullable
    public FDBDatabase.WeakReadSemantics getWeakReadSemantics() {
        return this.config.getWeakReadSemantics();
    }

    @Nonnull
    public FDBTransactionPriority getPriority() {
        return this.config.getPriority();
    }

    public void setHookForAsyncToSync(@Nonnull Consumer<StoreTimer.Wait> hook) {
        this.hookForAsyncToSync = hook;
    }

    @Nullable
    public Consumer<StoreTimer.Wait> getHookForAsyncToSync() {
        return this.hookForAsyncToSync;
    }

    public boolean hasHookForAsyncToSync() {
        return this.hookForAsyncToSync != null;
    }

    @Nullable
    @API(value=API.Status.EXPERIMENTAL)
    public synchronized <T> T getInSession(@Nonnull Object key, @Nonnull Class<T> clazz) {
        return (T)this.session.get(key);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public synchronized <T> void putInSessionIfAbsent(@Nonnull Object key, @Nonnull T value) {
        this.session.put(key, value);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public synchronized <T> T removeFromSession(@Nonnull String key, @Nonnull Class<T> clazz) {
        return (T)this.session.remove(key);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public RecordLayerPropertyStorage getPropertyStorage() {
        return this.config.getPropertyStorage();
    }

    @Nullable
    public List<Range> getNotCommittedConflictingKeys() {
        return this.notCommittedConflictingKeys;
    }

    private static CompletableFuture<List<Range>> readConflictingKeys(@Nonnull Transaction tr, @Nonnull Executor executor) {
        ArrayList result = new ArrayList();
        return AsyncUtil.forEach(tr.getRange(Range.startsWith(SystemKeyspace.TRANSACTION_CONFLICTING_KEYS_PREFIX)), kv -> {
            boolean state = kv.getValue()[0] == 49;
            byte[] key = Arrays.copyOfRange(kv.getKey(), SystemKeyspace.TRANSACTION_CONFLICTING_KEYS_PREFIX.length, kv.getKey().length);
            if (state) {
                result.add(Range.startsWith(key));
            } else if (!result.isEmpty()) {
                int pos = result.size() - 1;
                Range started = (Range)result.get(pos);
                result.set(pos, new Range(started.begin, key));
            }
        }, executor).thenApply(vignore -> result);
    }

    @API(value=API.Status.INTERNAL)
    public CompletableFuture<AsyncLock> acquireReadLock(@Nonnull LockIdentifier id) {
        return this.lockRegistry.acquireReadLock(id);
    }

    @API(value=API.Status.INTERNAL)
    public CompletableFuture<AsyncLock> acquireWriteLock(@Nonnull LockIdentifier id) {
        return this.lockRegistry.acquireWriteLock(id);
    }

    @API(value=API.Status.INTERNAL)
    public <T> CompletableFuture<T> doWithReadLock(@Nonnull LockIdentifier identifier, @Nonnull Supplier<CompletableFuture<T>> operation) {
        return this.lockRegistry.doWithReadLock(identifier, operation);
    }

    @API(value=API.Status.INTERNAL)
    public <T> CompletableFuture<T> doWithWriteLock(@Nonnull LockIdentifier identifier, @Nonnull Supplier<CompletableFuture<T>> operation) {
        return this.lockRegistry.doWithWriteLock(identifier, operation);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public TempTable.Factory getTempTableFactory() {
        return this.tempTableFactory;
    }

    static {
        Arrays.fill(META_DATA_VERSION_STAMP_VALUE, (byte)0);
    }

    public static interface CommitCheckAsync {
        default public boolean isReady() {
            return false;
        }

        @Nonnull
        public CompletableFuture<Void> checkAsync();

        public static CommitCheckAsync fromFuture(final @Nonnull CompletableFuture<Void> check) {
            return new CommitCheckAsync(){

                @Override
                public boolean isReady() {
                    return check.isDone();
                }

                @Override
                @Nonnull
                public CompletableFuture<Void> checkAsync() {
                    return check;
                }
            };
        }
    }

    public static interface PostCommit {
        public CompletableFuture<Void> get();
    }

    private static class AfterCommitPostCommit
    implements PostCommit {
        @Nonnull
        private final Queue<AfterCommit> afterCommits = new ArrayDeque<AfterCommit>();

        private AfterCommitPostCommit() {
        }

        public synchronized void addAfterCommit(@Nonnull AfterCommit afterCommit) {
            this.afterCommits.add(afterCommit);
        }

        @Override
        public CompletableFuture<Void> get() {
            return CompletableFuture.runAsync(this::run);
        }

        public synchronized void run() {
            while (!this.afterCommits.isEmpty()) {
                this.afterCommits.remove().run();
            }
        }
    }

    public static interface AfterCommit {
        public void run();
    }

    public static interface CommitCheck
    extends CommitCheckAsync {
        @Override
        @Nonnull
        default public CompletableFuture<Void> checkAsync() {
            this.check();
            return AsyncUtil.DONE;
        }

        public void check();
    }
}

