/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.KeyChecker;
import com.apple.foundationdb.record.provider.foundationdb.TransactionListener;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FDBRecordContextConfig {
    @Nullable
    private final Map<String, String> mdcContext;
    @Nullable
    private final FDBStoreTimer timer;
    @Nullable
    private final FDBDatabase.WeakReadSemantics weakReadSemantics;
    @Nonnull
    private final FDBTransactionPriority priority;
    @Nullable
    private final String transactionId;
    private final long transactionTimeoutMillis;
    private final boolean enableAssertions;
    private final boolean logTransaction;
    private final boolean serverRequestTracing;
    private final boolean trackOpen;
    private final boolean saveOpenStackTrace;
    @Nullable
    private final TransactionListener listener;
    @Nonnull
    private final RecordLayerPropertyStorage propertyStorage;
    @Nonnull
    private final Set<String> tags;
    private final boolean reportConflictingKeys;
    @Nullable
    private final KeyChecker keyChecker;

    private FDBRecordContextConfig(@Nonnull Builder builder) {
        this.mdcContext = builder.mdcContext;
        this.timer = builder.timer;
        this.weakReadSemantics = builder.weakReadSemantics;
        this.priority = builder.priority;
        this.transactionId = builder.transactionId;
        this.transactionTimeoutMillis = builder.transactionTimeoutMillis;
        this.enableAssertions = builder.enableAssertions;
        this.logTransaction = builder.logTransaction;
        this.serverRequestTracing = builder.serverRequestTracing;
        this.trackOpen = builder.trackOpen;
        this.saveOpenStackTrace = builder.saveOpenStackTrace;
        this.listener = builder.listener;
        this.propertyStorage = builder.recordContextProperties;
        this.tags = builder.tags;
        this.reportConflictingKeys = builder.reportConflictingKeys;
        this.keyChecker = builder.keyChecker;
    }

    @Nullable
    public Map<String, String> getMdcContext() {
        return this.mdcContext;
    }

    @Nullable
    public FDBStoreTimer getTimer() {
        return this.timer;
    }

    @Nullable
    public FDBDatabase.WeakReadSemantics getWeakReadSemantics() {
        return this.weakReadSemantics;
    }

    @Nonnull
    public FDBTransactionPriority getPriority() {
        return this.priority;
    }

    @Nullable
    public String getTransactionId() {
        return this.transactionId;
    }

    public long getTransactionTimeoutMillis() {
        return this.transactionTimeoutMillis;
    }

    public boolean areAssertionsEnabled() {
        return this.enableAssertions;
    }

    public boolean isLogTransaction() {
        return this.logTransaction;
    }

    public boolean isServerRequestTracing() {
        return this.serverRequestTracing;
    }

    public boolean isTrackOpen() {
        return this.trackOpen;
    }

    public boolean isSaveOpenStackTrace() {
        return this.saveOpenStackTrace;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public TransactionListener getTransactionListener() {
        return this.listener;
    }

    @Nonnull
    public RecordLayerPropertyStorage getPropertyStorage() {
        return this.propertyStorage;
    }

    @Nonnull
    public Set<String> getTags() {
        return this.tags;
    }

    public boolean isReportConflictingKeys() {
        return this.reportConflictingKeys;
    }

    @Nullable
    public KeyChecker getKeyChecker() {
        return this.keyChecker;
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        @Nullable
        private Map<String, String> mdcContext = null;
        @Nullable
        private FDBStoreTimer timer = null;
        @Nullable
        private FDBDatabase.WeakReadSemantics weakReadSemantics = null;
        @Nonnull
        private FDBTransactionPriority priority = FDBTransactionPriority.DEFAULT;
        @Nullable
        private String transactionId = null;
        private long transactionTimeoutMillis = -1L;
        private boolean enableAssertions = false;
        private boolean logTransaction = false;
        private boolean serverRequestTracing = false;
        private boolean trackOpen = false;
        private boolean saveOpenStackTrace = false;
        private TransactionListener listener = null;
        private RecordLayerPropertyStorage recordContextProperties = RecordLayerPropertyStorage.getEmptyInstance();
        @Nonnull
        private Set<String> tags = Collections.emptySet();
        private boolean reportConflictingKeys = false;
        @Nullable
        private KeyChecker keyChecker;

        private Builder() {
        }

        private Builder(@Nonnull FDBRecordContextConfig config) {
            this.mdcContext = config.mdcContext;
            this.timer = config.timer;
            this.weakReadSemantics = config.weakReadSemantics;
            this.priority = config.priority;
            this.transactionId = config.transactionId;
            this.transactionTimeoutMillis = config.transactionTimeoutMillis;
            this.enableAssertions = config.enableAssertions;
            this.logTransaction = config.logTransaction;
            this.serverRequestTracing = config.serverRequestTracing;
            this.trackOpen = config.trackOpen;
            this.saveOpenStackTrace = config.saveOpenStackTrace;
            this.listener = config.listener;
            this.recordContextProperties = config.propertyStorage;
            this.tags = config.tags;
            this.reportConflictingKeys = config.reportConflictingKeys;
            this.keyChecker = config.keyChecker;
        }

        private Builder(@Nonnull Builder config) {
            this.mdcContext = config.mdcContext;
            this.timer = config.timer;
            this.weakReadSemantics = config.weakReadSemantics;
            this.priority = config.priority;
            this.transactionId = config.transactionId;
            this.transactionTimeoutMillis = config.transactionTimeoutMillis;
            this.enableAssertions = config.enableAssertions;
            this.logTransaction = config.logTransaction;
            this.serverRequestTracing = config.serverRequestTracing;
            this.trackOpen = config.trackOpen;
            this.saveOpenStackTrace = config.saveOpenStackTrace;
            this.listener = config.listener;
            this.recordContextProperties = config.recordContextProperties;
            this.tags = config.tags;
            this.reportConflictingKeys = config.reportConflictingKeys;
            this.keyChecker = config.keyChecker;
        }

        @Nonnull
        public Builder setMdcContext(@Nullable Map<String, String> mdcContext) {
            this.mdcContext = mdcContext;
            return this;
        }

        @Nullable
        public Map<String, String> getMdcContext() {
            return this.mdcContext;
        }

        @Nonnull
        public Builder setTimer(@Nullable FDBStoreTimer timer) {
            this.timer = timer;
            return this;
        }

        @Nullable
        public FDBStoreTimer getTimer() {
            return this.timer;
        }

        @Nonnull
        public Builder setWeakReadSemantics(@Nullable FDBDatabase.WeakReadSemantics weakReadSemantics) {
            this.weakReadSemantics = weakReadSemantics;
            return this;
        }

        @Nullable
        public FDBDatabase.WeakReadSemantics getWeakReadSemantics() {
            return this.weakReadSemantics;
        }

        @Nonnull
        public Builder setPriority(@Nonnull FDBTransactionPriority priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public FDBTransactionPriority getPriority() {
            return this.priority;
        }

        @Nonnull
        public Builder setTransactionId(@Nullable String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Nullable
        public String getTransactionId() {
            return this.transactionId;
        }

        @Nonnull
        public Builder setTransactionTimeoutMillis(long transactionTimeoutMillis) {
            if (transactionTimeoutMillis < -1L) {
                throw new RecordCoreArgumentException("cannot set transaction timeout to " + transactionTimeoutMillis, new Object[0]);
            }
            this.transactionTimeoutMillis = transactionTimeoutMillis;
            return this;
        }

        public long getTransactionTimeoutMillis() {
            return this.transactionTimeoutMillis;
        }

        public Builder setEnableAssertions(boolean enableAssertions) {
            this.enableAssertions = enableAssertions;
            return this;
        }

        public boolean areAssertionsEnabled() {
            return this.enableAssertions;
        }

        public boolean isLogTransaction() {
            return this.logTransaction;
        }

        public Builder setLogTransaction(boolean logTransaction) {
            this.logTransaction = logTransaction;
            return this;
        }

        public boolean isServerRequestTracing() {
            return this.serverRequestTracing;
        }

        public Builder setServerRequestTracing(boolean serverRequestTracing) {
            this.serverRequestTracing = serverRequestTracing;
            return this;
        }

        public boolean isTrackOpen() {
            return this.trackOpen;
        }

        public Builder setTrackOpen(boolean trackOpen) {
            this.trackOpen = trackOpen;
            return this;
        }

        public boolean isSaveOpenStackTrace() {
            return this.saveOpenStackTrace;
        }

        public Builder setSaveOpenStackTrace(boolean saveOpenStackTrace) {
            this.saveOpenStackTrace = saveOpenStackTrace;
            return this;
        }

        public Builder setListener(TransactionListener listener) {
            this.listener = listener;
            return this;
        }

        public TransactionListener getListener() {
            return this.listener;
        }

        public RecordLayerPropertyStorage getRecordContextProperties() {
            return this.recordContextProperties;
        }

        public Builder setRecordContextProperties(@Nonnull RecordLayerPropertyStorage recordContextProperties) {
            this.recordContextProperties = recordContextProperties;
            return this;
        }

        @Nonnull
        public Set<String> getTags() {
            return this.tags;
        }

        public Builder setTags(@Nonnull Set<String> tags) {
            if (tags.size() > 5) {
                throw new IllegalArgumentException("At most 5 tags allowed");
            }
            for (String tag : tags) {
                if (tag.length() <= 16) continue;
                throw new IllegalArgumentException("Tag must be 16 characters or shorter");
            }
            this.tags = tags;
            return this;
        }

        public boolean isReportConflictingKeys() {
            return this.reportConflictingKeys;
        }

        public Builder setReportConflictingKeys(boolean reportConflictingKeys) {
            this.reportConflictingKeys = reportConflictingKeys;
            return this;
        }

        @Nullable
        public KeyChecker getKeyChecker() {
            return this.keyChecker;
        }

        public void setKeyChecker(@Nullable KeyChecker keyChecker) {
            this.keyChecker = keyChecker;
        }

        @Nonnull
        public FDBRecordContextConfig build() {
            return new FDBRecordContextConfig(this);
        }

        public Builder copyBuilder() {
            return new Builder(this);
        }
    }
}

