/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.AggregateFunctionNotSupportedException;
import com.apple.foundationdb.record.ByteScanLimiter;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ExecuteState;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.MutableRecordStoreState;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordIndexUniquenessViolation;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.StoreIsLockedForRecordUpdates;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.cursors.DedupCursor;
import com.apple.foundationdb.record.cursors.ListCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.FormerIndex;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.JoinedRecordType;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.RecordTypeOrBuilder;
import com.apple.foundationdb.record.metadata.StoreRecordFunction;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.DynamicMessageRecordSerializer;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBMetaDataStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBPreloadRecordCache;
import com.apple.foundationdb.record.provider.foundationdb.FDBRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreKeyspace;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecordBuilder;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexBuildState;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistryImpl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintenanceFilter;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexUniquenessCommitCheck;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.RecordAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.RecordDeserializationException;
import com.apple.foundationdb.record.provider.foundationdb.RecordDoesNotExistException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreAlreadyExistsException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreDoesNotExistException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreNoInfoAndNotEmptyException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreStaleMetaDataVersionException;
import com.apple.foundationdb.record.provider.foundationdb.RecordStoreStaleUserVersionException;
import com.apple.foundationdb.record.provider.foundationdb.RecordTypeChangedException;
import com.apple.foundationdb.record.provider.foundationdb.ScanNonReadableIndexException;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProviderByKeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProviderBySubspace;
import com.apple.foundationdb.record.provider.foundationdb.UninitializedRecordStoreException;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedFormatVersionException;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedMethodException;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingHeartbeat;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.RecordTypeKeyComparison;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerializationRegistry;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.apple.foundationdb.util.LoggableException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class FDBRecordStore
extends FDBStoreBase
implements FDBRecordStoreBase<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBRecordStore.class);
    public static final int DEFAULT_PIPELINE_SIZE = 10;
    public static final FDBRecordStoreBase.PipelineSizer DEFAULT_PIPELINE_SIZER = pipelineOperation -> {
        if (pipelineOperation == PipelineOperation.UPDATE || pipelineOperation == PipelineOperation.INSERT || pipelineOperation == PipelineOperation.DELETE) {
            return 1;
        }
        return 10;
    };
    public static final int MAX_RECORDS_FOR_REBUILD = 200;
    public static final int MAX_PARALLEL_INDEX_REBUILD = 10;
    @Deprecated(forRemoval=true)
    private static final int MIN_FORMAT_VERSION = FormatVersion.getMinimumVersion().getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int INFO_ADDED_FORMAT_VERSION = FormatVersion.INFO_ADDED.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int RECORD_COUNT_ADDED_FORMAT_VERSION = FormatVersion.RECORD_COUNT_ADDED.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int RECORD_COUNT_KEY_ADDED_FORMAT_VERSION = FormatVersion.RECORD_COUNT_KEY_ADDED.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int FORMAT_CONTROL_FORMAT_VERSION = FormatVersion.FORMAT_CONTROL.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int SAVE_UNSPLIT_WITH_SUFFIX_FORMAT_VERSION = FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int SAVE_VERSION_WITH_RECORD_FORMAT_VERSION = FormatVersion.SAVE_VERSION_WITH_RECORD.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int CACHEABLE_STATE_FORMAT_VERSION = FormatVersion.CACHEABLE_STATE.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int HEADER_USER_FIELDS_FORMAT_VERSION = FormatVersion.HEADER_USER_FIELDS.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int READABLE_UNIQUE_PENDING_FORMAT_VERSION = FormatVersion.READABLE_UNIQUE_PENDING.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int CHECK_INDEX_BUILD_TYPE_DURING_UPDATE_FORMAT_VERSION = FormatVersion.CHECK_INDEX_BUILD_TYPE_DURING_UPDATE.getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int MAX_SUPPORTED_FORMAT_VERSION = FormatVersion.getMaximumSupportedVersion().getValueForSerialization();
    @Deprecated(forRemoval=true)
    public static final int DEFAULT_FORMAT_VERSION = FormatVersion.getDefaultFormatVersion().getValueForSerialization();
    public static final int KEY_SIZE_LIMIT = 10000;
    public static final int VALUE_SIZE_LIMIT = 100000;
    private static final int PRELOAD_CACHE_SIZE = 100;
    @Nonnull
    private static final CompletableFuture<IndexState> READY_READABLE = CompletableFuture.completedFuture(IndexState.READABLE);
    protected static final Object STORE_INFO_KEY = FDBRecordStoreKeyspace.STORE_INFO.key();
    protected static final Object RECORD_KEY = FDBRecordStoreKeyspace.RECORD.key();
    protected static final Object INDEX_KEY = FDBRecordStoreKeyspace.INDEX.key();
    protected static final Object INDEX_SECONDARY_SPACE_KEY = FDBRecordStoreKeyspace.INDEX_SECONDARY_SPACE.key();
    protected static final Object RECORD_COUNT_KEY = FDBRecordStoreKeyspace.RECORD_COUNT.key();
    protected static final Object INDEX_STATE_SPACE_KEY = FDBRecordStoreKeyspace.INDEX_STATE_SPACE.key();
    protected static final Object INDEX_RANGE_SPACE_KEY = FDBRecordStoreKeyspace.INDEX_RANGE_SPACE.key();
    protected static final Object INDEX_UNIQUENESS_VIOLATIONS_KEY = FDBRecordStoreKeyspace.INDEX_UNIQUENESS_VIOLATIONS_SPACE.key();
    protected static final Object RECORD_VERSION_KEY = FDBRecordStoreKeyspace.RECORD_VERSION_SPACE.key();
    protected static final Object INDEX_BUILD_SPACE_KEY = FDBRecordStoreKeyspace.INDEX_BUILD_SPACE.key();
    @SpotBugsSuppressWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final byte[] LITTLE_ENDIAN_INT64_ONE = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    @SpotBugsSuppressWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final byte[] LITTLE_ENDIAN_INT64_MINUS_ONE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    @SpotBugsSuppressWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final byte[] INT64_ZERO = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected FormatVersion formatVersion;
    protected int userVersion;
    private boolean omitUnsplitRecordSuffix;
    @Nonnull
    protected final RecordMetaDataProvider metaDataProvider;
    private volatile boolean versionChanged;
    @Nonnull
    protected final AtomicReference<MutableRecordStoreState> recordStoreStateRef = new AtomicReference();
    @Nonnull
    protected final RecordSerializer<Message> serializer;
    @Nonnull
    protected final IndexMaintainerFactoryRegistry indexMaintainerRegistry;
    @Nonnull
    protected final IndexMaintenanceFilter indexMaintenanceFilter;
    @Nonnull
    protected final FDBRecordStoreBase.PipelineSizer pipelineSizer;
    @Nullable
    protected final FDBRecordStoreStateCache storeStateCache;
    @Nonnull
    protected final StateCacheabilityOnOpen stateCacheabilityOnOpen;
    @Nullable
    private final FDBRecordStoreBase.UserVersionChecker userVersionChecker;
    @Nullable
    private Subspace cachedRecordsSubspace;
    @Nonnull
    private final FDBPreloadRecordCache preloadCache;
    private boolean recordsReadConflict;
    private boolean storeStateReadConflict;
    private IndexDeferredMaintenanceControl indexDeferredMaintenanceControl;
    @Nonnull
    private final Set<String> indexStateReadConflicts = ConcurrentHashMap.newKeySet(8);
    @Nonnull
    private final PlanSerializationRegistry planSerializationRegistry;

    @API(value=API.Status.INTERNAL)
    protected FDBRecordStore(@Nonnull FDBRecordContext context, @Nonnull SubspaceProvider subspaceProvider, @Nonnull FormatVersion formatVersion, @Nonnull RecordMetaDataProvider metaDataProvider, @Nonnull RecordSerializer<Message> serializer, @Nonnull IndexMaintainerFactoryRegistry indexMaintainerRegistry, @Nonnull IndexMaintenanceFilter indexMaintenanceFilter, @Nonnull FDBRecordStoreBase.PipelineSizer pipelineSizer, @Nullable FDBRecordStoreStateCache storeStateCache, @Nonnull StateCacheabilityOnOpen stateCacheabilityOnOpen, @Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull PlanSerializationRegistry planSerializationRegistry) {
        super(context, subspaceProvider);
        this.formatVersion = formatVersion;
        this.metaDataProvider = metaDataProvider;
        this.serializer = serializer;
        this.indexMaintainerRegistry = indexMaintainerRegistry;
        this.indexMaintenanceFilter = indexMaintenanceFilter;
        this.pipelineSizer = pipelineSizer;
        this.storeStateCache = storeStateCache;
        this.stateCacheabilityOnOpen = stateCacheabilityOnOpen;
        this.userVersionChecker = userVersionChecker;
        this.omitUnsplitRecordSuffix = !formatVersion.isAtLeast(FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX);
        this.preloadCache = new FDBPreloadRecordCache(100);
        this.planSerializationRegistry = planSerializationRegistry;
    }

    @Override
    public FDBRecordStore getUntypedRecordStore() {
        return this;
    }

    @Override
    @Nonnull
    public FDBRecordContext getContext() {
        return this.context;
    }

    @Deprecated(forRemoval=true)
    public int getFormatVersion() {
        return this.formatVersion.getValueForSerialization();
    }

    @API(value=API.Status.INTERNAL)
    public FormatVersion getFormatVersionEnum() {
        return this.formatVersion;
    }

    public int getUserVersion() {
        return this.userVersion;
    }

    private boolean useOldVersionFormat() {
        return FDBRecordStore.useOldVersionFormat(this.getFormatVersion(), this.omitUnsplitRecordSuffix);
    }

    private static boolean useOldVersionFormat(int formatVersion, boolean omitUnsplitRecordSuffix) {
        return formatVersion < SAVE_VERSION_WITH_RECORD_FORMAT_VERSION || omitUnsplitRecordSuffix;
    }

    @Nullable
    public RecordMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    public boolean isVersionChanged() {
        return this.versionChanged;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaDataProvider.getRecordMetaData();
    }

    @Override
    @Nonnull
    public RecordStoreState getRecordStoreState() {
        if (this.recordStoreStateRef.get() == null) {
            this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD_STORE_STATE, this.preloadRecordStoreStateAsync(FDBRecordStoreBase.StoreExistenceCheck.NONE, IsolationLevel.SERIALIZABLE, IsolationLevel.SNAPSHOT));
        }
        return this.recordStoreStateRef.get();
    }

    private CompletableFuture<RecordStoreState> getRecordStoreStateAsync() {
        MutableRecordStoreState localStoreState = this.recordStoreStateRef.get();
        if (localStoreState != null) {
            return CompletableFuture.completedFuture(localStoreState);
        }
        return this.preloadRecordStoreStateAsync().thenApply(ignore -> Objects.requireNonNull(this.recordStoreStateRef.get()));
    }

    @Override
    @Nonnull
    public RecordSerializer<Message> getSerializer() {
        return this.serializer;
    }

    @Override
    @Nonnull
    public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry() {
        return this.indexMaintainerRegistry;
    }

    @Nonnull
    public IndexMaintenanceFilter getIndexMaintenanceFilter() {
        return this.indexMaintenanceFilter;
    }

    @Nonnull
    public PlanSerializationRegistry getPlanSerializationRegistry() {
        return this.planSerializationRegistry;
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<Message>> saveRecordAsync(@Nonnull Message rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.saveTypedRecord(this.serializer, rec, existenceCheck, version, behavior);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<Message>> dryRunSaveRecordAsync(@Nonnull Message rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.saveTypedRecord(this.serializer, rec, existenceCheck, null, FDBRecordStoreBase.VersionstampSaveBehavior.DEFAULT, true, false);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBStoredRecord<Message>> overrideLockSaveRecordAsync(@Nonnull Message rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.saveTypedRecord(this.serializer, rec, existenceCheck, version, behavior, false, true);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    protected <M extends Message> CompletableFuture<FDBStoredRecord<M>> saveTypedRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull M rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.saveTypedRecord(typedSerializer, rec, existenceCheck, version, behavior, false, false);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    protected <M extends Message> CompletableFuture<FDBStoredRecord<M>> saveTypedRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull M rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior, boolean isDryRun, boolean overrideLock) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Descriptors.Descriptor recordDescriptor = rec.getDescriptorForType();
        RecordType recordType = metaData.getRecordTypeForDescriptor(recordDescriptor);
        KeyExpression primaryKeyExpression = recordType.getPrimaryKey();
        FDBStoredRecordBuilder recordBuilder = FDBStoredRecord.newBuilder(rec).setRecordType(recordType);
        FDBRecordVersion recordVersion = this.recordVersionForSave(metaData, version, behavior);
        recordBuilder.setVersion(recordVersion);
        Tuple primaryKey = primaryKeyExpression.evaluateSingleton(recordBuilder).toTuple();
        recordBuilder.setPrimaryKey(primaryKey);
        CompletionStage result = this.loadExistingRecord(typedSerializer, primaryKey).thenCompose(oldRecord -> {
            if (oldRecord == null) {
                if (existenceCheck.errorIfNotExists()) {
                    throw new RecordDoesNotExistException("record does not exist", new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
                }
            } else {
                if (existenceCheck.errorIfExists()) {
                    throw new RecordAlreadyExistsException("record already exists", new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
                }
                if (existenceCheck.errorIfTypeChanged() && oldRecord.getRecordType() != recordType) {
                    throw new RecordTypeChangedException("record type changed", new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey, LogMessageKeys.ACTUAL_TYPE, oldRecord.getRecordType().getName(), LogMessageKeys.EXPECTED_TYPE, recordType.getName()});
                }
            }
            if (isDryRun) {
                FDBStoredRecord newRecord = this.dryRunSetSizeInfo(typedSerializer, recordBuilder, metaData);
                return CompletableFuture.completedFuture(newRecord);
            }
            return this.getRecordStoreStateAsync().thenCompose(recordStoreState -> {
                if (!overrideLock) {
                    FDBRecordStore.validateRecordUpdateAllowed(recordStoreState);
                }
                FDBStoredRecord newRecord = this.serializeAndSaveRecord(typedSerializer, recordBuilder, metaData, (FDBStoredSizes)oldRecord);
                if (oldRecord == null) {
                    this.addRecordCount(metaData, newRecord, LITTLE_ENDIAN_INT64_ONE);
                } else if (this.getTimer() != null) {
                    this.getTimer().increment(FDBStoreTimer.Counts.REPLACE_RECORD_VALUE_BYTES, oldRecord.getValueSize());
                }
                return this.updateSecondaryIndexes((FDBStoredRecord)oldRecord, newRecord).thenApply(v -> newRecord);
            });
        });
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SAVE_RECORD, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Message> void addRecordCount(@Nonnull RecordMetaData metaData, @Nonnull FDBStoredRecord<M> rec, @Nonnull byte[] increment) {
        if (metaData.getRecordCountKey() != null) {
            this.beginRecordStoreStateRead();
            try {
                RecordMetaDataProto.DataStoreInfo header = this.recordStoreStateRef.get().getStoreHeader();
                if (header.getRecordCountState() != RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
                    Key.Evaluated subkey = metaData.getRecordCountKey().evaluateSingleton(rec);
                    byte[] keyBytes = this.getSubspace().pack(Tuple.from(RECORD_COUNT_KEY).addAll(subkey.toTupleAppropriateList()));
                    this.ensureContextActive().mutate(MutationType.ADD, keyBytes, increment);
                }
            }
            finally {
                this.endRecordStoreStateRead();
            }
        }
    }

    @Nullable
    private FDBRecordVersion recordVersionForSave(@Nonnull RecordMetaData metaData, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        if (behavior.equals((Object)FDBRecordStoreBase.VersionstampSaveBehavior.NO_VERSION)) {
            if (version != null) {
                throw this.recordCoreException("Nonnull version supplied with a NO_VERSION behavior: " + String.valueOf(version));
            }
            return null;
        }
        if (behavior.equals((Object)FDBRecordStoreBase.VersionstampSaveBehavior.IF_PRESENT)) {
            return version;
        }
        if (version == null && (behavior.equals((Object)FDBRecordStoreBase.VersionstampSaveBehavior.WITH_VERSION) || metaData.isStoreRecordVersions())) {
            return FDBRecordVersion.incomplete(this.context.claimLocalVersion());
        }
        return version;
    }

    @Nonnull
    private <M extends Message> CompletableFuture<FDBStoredRecord<M>> loadExistingRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull Tuple primaryKey) {
        return this.loadTypedRecord(typedSerializer, primaryKey, false);
    }

    @Nonnull
    private <M extends Message> FDBStoredRecord<M> dryRunSetSizeInfo(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull FDBStoredRecordBuilder<M> recordBuilder, @Nonnull RecordMetaData metaData) {
        FDBRecordVersion version = recordBuilder.getVersion();
        byte[] serialized = typedSerializer.serialize(metaData, recordBuilder.getRecordType(), recordBuilder.getRecord(), this.getTimer());
        FDBRecordVersion splitVersion = this.useOldVersionFormat() ? null : version;
        SplitHelper.SizeInfo sizeInfo = new SplitHelper.SizeInfo();
        SplitHelper.dryRunSaveWithSplitOnlySetSizeInfo(this.recordsSubspace(), recordBuilder.getPrimaryKey(), serialized, splitVersion, metaData.isSplitLongRecords(), this.omitUnsplitRecordSuffix, sizeInfo);
        recordBuilder.setSize(sizeInfo);
        return recordBuilder.build();
    }

    @Nonnull
    private <M extends Message> FDBStoredRecord<M> serializeAndSaveRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull FDBStoredRecordBuilder<M> recordBuilder, @Nonnull RecordMetaData metaData, @Nullable FDBStoredSizes oldSizeInfo) {
        Tuple primaryKey = recordBuilder.getPrimaryKey();
        FDBRecordVersion version = recordBuilder.getVersion();
        byte[] serialized = typedSerializer.serialize(metaData, recordBuilder.getRecordType(), recordBuilder.getRecord(), this.getTimer());
        FDBRecordVersion splitVersion = this.useOldVersionFormat() ? null : version;
        SplitHelper.SizeInfo sizeInfo = new SplitHelper.SizeInfo();
        this.preloadCache.invalidate(primaryKey);
        SplitHelper.saveWithSplit(this.context, this.recordsSubspace(), recordBuilder.getPrimaryKey(), serialized, splitVersion, metaData.isSplitLongRecords(), this.omitUnsplitRecordSuffix, true, oldSizeInfo, sizeInfo);
        this.countKeysAndValues(FDBStoreTimer.Counts.SAVE_RECORD_KEY, FDBStoreTimer.Counts.SAVE_RECORD_KEY_BYTES, FDBStoreTimer.Counts.SAVE_RECORD_VALUE_BYTES, sizeInfo);
        recordBuilder.setSize(sizeInfo);
        if (version != null && this.useOldVersionFormat()) {
            this.saveVersionWithOldFormat(primaryKey, version);
        }
        return recordBuilder.build();
    }

    private void saveVersionWithOldFormat(@Nonnull Tuple primaryKey, @Nonnull FDBRecordVersion version) {
        byte[] versionKey = this.getSubspace().pack(this.recordVersionKey(primaryKey));
        if (version.isComplete()) {
            this.context.ensureActive().set(versionKey, version.toBytes());
        } else {
            this.context.addToLocalVersionCache(versionKey, version.getLocalVersion());
            byte[] valueBytes = version.writeTo(ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN)).putInt(0).array();
            this.context.addVersionMutation(MutationType.SET_VERSIONSTAMPED_VALUE, versionKey, valueBytes);
        }
    }

    @Nonnull
    private Tuple recordVersionKey(@Nonnull Tuple primaryKey) {
        if (this.useOldVersionFormat()) {
            return Tuple.from(RECORD_VERSION_KEY).addAll(primaryKey);
        }
        return Tuple.from(RECORD_KEY).addAll(primaryKey).add(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private <M extends Message> CompletableFuture<Void> updateSecondaryIndexes(@Nullable FDBStoredRecord<M> oldRecord, @Nullable FDBStoredRecord<M> newRecord) {
        if (oldRecord == null && newRecord == null) {
            return AsyncUtil.DONE;
        }
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.updateSecondaryIndexes(oldRecord, newRecord));
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        RecordType sameRecordType = oldRecord == null ? newRecord.getRecordType() : (newRecord == null ? oldRecord.getRecordType() : (oldRecord.getRecordType() == newRecord.getRecordType() ? newRecord.getRecordType() : null));
        this.beginRecordStoreStateRead();
        boolean haveFuture = false;
        try {
            if (sameRecordType != null) {
                this.updateSecondaryIndexes(oldRecord, newRecord, futures, this.getEnabledIndexes(sameRecordType));
                this.updateSecondaryIndexes(oldRecord, newRecord, futures, this.getEnabledUniversalIndexes());
                this.updateSecondaryIndexes(oldRecord, newRecord, futures, this.getEnabledMultiTypeIndexes(sameRecordType));
            } else {
                ArrayList<Index> oldIndexes = new ArrayList<Index>();
                if (oldRecord != null) {
                    RecordType oldRecordType = oldRecord.getRecordType();
                    oldIndexes.addAll(this.getEnabledIndexes(oldRecordType));
                    oldIndexes.addAll(this.getEnabledUniversalIndexes());
                    oldIndexes.addAll(this.getEnabledMultiTypeIndexes(oldRecordType));
                }
                ArrayList<Index> newIndexes = new ArrayList<Index>();
                if (newRecord != null) {
                    RecordType newRecordType = newRecord.getRecordType();
                    newIndexes.addAll(this.getEnabledIndexes(newRecordType));
                    newIndexes.addAll(this.getEnabledUniversalIndexes());
                    newIndexes.addAll(this.getEnabledMultiTypeIndexes(newRecordType));
                }
                ArrayList<Index> commonIndexes = new ArrayList<Index>(oldIndexes);
                commonIndexes.retainAll(newIndexes);
                oldIndexes.removeAll(commonIndexes);
                newIndexes.removeAll(commonIndexes);
                this.updateSecondaryIndexes(oldRecord, null, futures, oldIndexes);
                this.updateSecondaryIndexes(null, newRecord, futures, newIndexes);
                this.updateSecondaryIndexes(oldRecord, newRecord, futures, commonIndexes);
            }
            if (!this.getRecordMetaData().getSyntheticRecordTypes().isEmpty()) {
                this.updateSyntheticIndexes(oldRecord, newRecord, futures);
            }
            haveFuture = true;
        }
        finally {
            if (!haveFuture) {
                this.endRecordStoreStateRead();
            }
        }
        if (futures.isEmpty()) {
            this.endRecordStoreStateRead();
            return AsyncUtil.DONE;
        }
        if (futures.size() == 1) {
            return ((CompletableFuture)futures.get(0)).whenComplete((v, t2) -> this.endRecordStoreStateRead());
        }
        return AsyncUtil.whenAll(futures).whenComplete((v, t2) -> this.endRecordStoreStateRead());
    }

    private <M extends Message> void updateSecondaryIndexes(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord, @Nonnull List<CompletableFuture<Void>> futures, @Nonnull List<Index> indexes) {
        if (oldRecord == null && newRecord == null) {
            return;
        }
        for (Index index : indexes) {
            IndexMaintainer maintainer = this.getIndexMaintainer(index);
            CompletableFuture<Void> future = this.isIndexWriteOnly(index) ? maintainer.updateWhileWriteOnly(oldRecord, newRecord) : maintainer.update(oldRecord, newRecord);
            if (MoreAsyncUtil.isCompletedNormally(future)) continue;
            futures.add(future);
        }
    }

    @API(value=API.Status.EXPERIMENTAL)
    private <M extends Message> void updateSyntheticIndexes(@Nullable FDBStoredRecord<M> oldRecord, @Nullable FDBStoredRecord<M> newRecord, @Nonnull List<CompletableFuture<Void>> futures) {
        SyntheticRecordPlanner planner = new SyntheticRecordPlanner(this);
        boolean pipelineSize = true;
        if (oldRecord != null && newRecord != null && oldRecord.getRecordType() == newRecord.getRecordType()) {
            SyntheticRecordFromStoredRecordPlan plan = planner.fromStoredType(newRecord.getRecordType(), true);
            if (plan == null) {
                return;
            }
            Map<RecordType, Collection<IndexMaintainer>> maintainers = this.getSyntheticMaintainers(plan.getSyntheticRecordTypes());
            ConcurrentHashMap oldRecords = new ConcurrentHashMap();
            CompletionStage<Void> future = plan.execute(this, oldRecord).forEach(syntheticRecord -> oldRecords.put(syntheticRecord.getPrimaryKey(), syntheticRecord));
            FDBStoredRecord theNewRecord = newRecord;
            future = ((CompletableFuture)future).thenCompose(v -> plan.execute(this, theNewRecord).forEachAsync(syntheticRecord -> this.runSyntheticMaintainers(maintainers, (FDBSyntheticRecord)oldRecords.remove(syntheticRecord.getPrimaryKey()), (FDBSyntheticRecord)syntheticRecord), 1));
            future = ((CompletableFuture)future).thenCompose(v -> {
                ArrayList<CompletableFuture<Void>> subFutures = new ArrayList<CompletableFuture<Void>>();
                for (FDBSyntheticRecord oldSyntheticRecord : oldRecords.values()) {
                    CompletableFuture<Void> subFuture = this.runSyntheticMaintainers(maintainers, oldSyntheticRecord, null);
                    if (MoreAsyncUtil.isCompletedNormally(subFuture)) continue;
                    subFutures.add(subFuture);
                }
                if (subFutures.isEmpty()) {
                    return AsyncUtil.DONE;
                }
                if (subFutures.size() == 1) {
                    return (CompletionStage)subFutures.get(0);
                }
                return AsyncUtil.whenAll(subFutures);
            });
            futures.add((CompletableFuture<Void>)future);
        } else {
            Map<RecordType, Collection<IndexMaintainer>> maintainers;
            SyntheticRecordFromStoredRecordPlan plan;
            if (oldRecord != null && (plan = planner.fromStoredType(oldRecord.getRecordType(), true)) != null && !(maintainers = this.getSyntheticMaintainers(plan.getSyntheticRecordTypes())).isEmpty()) {
                futures.add(plan.execute(this, oldRecord).forEachAsync(syntheticRecord -> this.runSyntheticMaintainers(maintainers, (FDBSyntheticRecord)syntheticRecord, null), 1));
            }
            if (newRecord != null && (plan = planner.fromStoredType(newRecord.getRecordType(), true)) != null && !(maintainers = this.getSyntheticMaintainers(plan.getSyntheticRecordTypes())).isEmpty()) {
                futures.add(plan.execute(this, newRecord).forEachAsync(syntheticRecord -> this.runSyntheticMaintainers(maintainers, null, (FDBSyntheticRecord)syntheticRecord), 1));
            }
        }
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    private Map<RecordType, Collection<IndexMaintainer>> getSyntheticMaintainers(@Nonnull Set<String> syntheticRecordTypes) {
        RecordMetaData metaData = this.getRecordMetaData();
        return syntheticRecordTypes.stream().map(metaData::getSyntheticRecordType).collect(Collectors.toMap(Function.identity(), syntheticRecordType -> {
            ArrayList indexMaintainers = new ArrayList();
            syntheticRecordType.getIndexes().stream().filter(index -> !this.isIndexDisabled((Index)index)).map(this::getIndexMaintainer).forEach(indexMaintainers::add);
            syntheticRecordType.getMultiTypeIndexes().stream().filter(index -> !this.isIndexDisabled((Index)index)).map(this::getIndexMaintainer).forEach(indexMaintainers::add);
            return indexMaintainers;
        }));
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    private CompletableFuture<Void> runSyntheticMaintainers(@Nonnull Map<RecordType, Collection<IndexMaintainer>> maintainers, @Nullable FDBSyntheticRecord oldRecord, @Nullable FDBSyntheticRecord newRecord) {
        if (oldRecord == null && newRecord == null) {
            return AsyncUtil.DONE;
        }
        RecordType recordType = oldRecord != null ? oldRecord.getRecordType() : newRecord.getRecordType();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (IndexMaintainer indexMaintainer : maintainers.get(recordType)) {
            CompletableFuture<Void> future = indexMaintainer.update(oldRecord, newRecord);
            if (MoreAsyncUtil.isCompletedNormally(future)) continue;
            futures.add(future);
        }
        if (futures.isEmpty()) {
            return AsyncUtil.DONE;
        }
        if (futures.size() == 1) {
            return (CompletableFuture)futures.get(0);
        }
        return AsyncUtil.whenAll(futures);
    }

    @Override
    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<FDBSyntheticRecord> loadSyntheticRecord(@Nonnull Tuple primaryKey, IndexOrphanBehavior orphanBehavior) {
        SyntheticRecordType<?> syntheticRecordType = this.getRecordMetaData().getSyntheticRecordTypeFromRecordTypeKey(primaryKey.get(0));
        if (syntheticRecordType.getConstituents().size() != primaryKey.size() - 1) {
            throw this.recordCoreException("Primary key does not have correct number of nested keys: " + String.valueOf(primaryKey));
        }
        return syntheticRecordType.loadByPrimaryKeyAsync(this, primaryKey, orphanBehavior);
    }

    @Nonnull
    public Subspace recordsSubspace() {
        if (this.cachedRecordsSubspace == null) {
            this.cachedRecordsSubspace = this.getSubspace().subspace(Tuple.from(RECORD_KEY));
        }
        return this.cachedRecordsSubspace;
    }

    @Nonnull
    public Subspace indexSubspace(@Nonnull Index index) {
        return this.getSubspace().subspace(Tuple.from(INDEX_KEY, index.getSubspaceTupleKey()));
    }

    @Nonnull
    public Subspace indexSubspaceFromMaintainer(@Nonnull Index index) {
        return this.getIndexMaintainer(index).getIndexSubspace();
    }

    @Nonnull
    public Subspace indexStateSubspace() {
        return this.getSubspace().subspace(Tuple.from(INDEX_STATE_SPACE_KEY));
    }

    @Nonnull
    public Subspace indexSecondarySubspace(@Nonnull Index index) {
        return this.getSubspace().subspace(Tuple.from(INDEX_SECONDARY_SPACE_KEY, index.getSubspaceTupleKey()));
    }

    @Nonnull
    public Subspace indexRangeSubspace(@Nonnull Index index) {
        return this.getSubspace().subspace(Tuple.from(INDEX_RANGE_SPACE_KEY, index.getSubspaceTupleKey()));
    }

    @Nonnull
    public Subspace indexUniquenessViolationsSubspace(@Nonnull Index index) {
        return this.getSubspace().subspace(Tuple.from(INDEX_UNIQUENESS_VIOLATIONS_KEY, index.getSubspaceTupleKey()));
    }

    @Nonnull
    Subspace indexBuildSubspace(@Nonnull Index index) {
        return this.getSubspace().subspace(Tuple.from(INDEX_BUILD_SPACE_KEY, index.getSubspaceTupleKey()));
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull Index index) {
        return this.indexMaintainerRegistry.getIndexMaintainer(new IndexMaintainerState(this, index, this.indexMaintenanceFilter));
    }

    @Nonnull
    public PlanSerializationContext newPlanSerializationContext(@Nonnull PlanHashable.PlanHashMode mode) {
        return new PlanSerializationContext(this.planSerializationRegistry, mode);
    }

    public int getKeySizeLimit() {
        return 10000;
    }

    public int getValueSizeLimit() {
        return 100000;
    }

    public CompletableFuture<IndexOperationResult> performIndexOperationAsync(@Nonnull String indexName, @Nonnull IndexOperation operation) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Index index = metaData.getIndex(indexName);
        return this.getIndexMaintainer(index).performOperation(operation);
    }

    public IndexOperationResult performIndexOperation(@Nonnull String indexName, @Nonnull IndexOperation operation) {
        return this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_INDEX_OPERATION, this.performIndexOperationAsync(indexName, operation));
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<Message>> loadRecordInternal(@Nonnull Tuple primaryKey, @Nonnull ExecuteState executeState, boolean snapshot) {
        return this.loadTypedRecord(this.serializer, primaryKey, executeState, snapshot);
    }

    @Nonnull
    protected <M extends Message> CompletableFuture<FDBStoredRecord<M>> loadTypedRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull Tuple primaryKey, boolean snapshot) {
        return this.loadTypedRecord(typedSerializer, primaryKey, ExecuteState.NO_LIMITS, snapshot);
    }

    @Nonnull
    protected <M extends Message> CompletableFuture<FDBStoredRecord<M>> loadTypedRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull Tuple primaryKey, @Nonnull ExecuteState executeState, boolean snapshot) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Optional<Object> versionFutureOptional = this.useOldVersionFormat() ? this.loadRecordVersionAsync(primaryKey) : Optional.empty();
        SplitHelper.SizeInfo sizeInfo = new SplitHelper.SizeInfo();
        CompletionStage result = this.loadRawRecordAsync(primaryKey, sizeInfo, snapshot).thenCompose(rawRecord -> {
            ByteScanLimiter byteScanLimiter = executeState.getByteScanLimiter();
            if (byteScanLimiter != null) {
                byteScanLimiter.registerScannedBytes(sizeInfo.getKeySize() + sizeInfo.getValueSize());
            }
            return rawRecord == null ? CompletableFuture.completedFuture(null) : this.deserializeRecord(typedSerializer, (FDBRawRecord)rawRecord, metaData, (Optional<CompletableFuture<FDBRecordVersion>>)versionFutureOptional);
        });
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.LOAD_RECORD, result);
    }

    @Nonnull
    public Optional<CompletableFuture<FDBRecordVersion>> loadRecordVersionAsync(@Nonnull Tuple primaryKey) {
        return this.loadRecordVersionAsync(primaryKey, false);
    }

    @Nonnull
    public Optional<CompletableFuture<FDBRecordVersion>> loadRecordVersionAsync(@Nonnull Tuple primaryKey, boolean snapshot) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        if (this.useOldVersionFormat() && !metaData.isStoreRecordVersions()) {
            return Optional.empty();
        }
        byte[] versionKey = this.getSubspace().pack(this.recordVersionKey(primaryKey));
        Optional<CompletableFuture<FDBRecordVersion>> cachedOptional = this.context.getLocalVersion(versionKey).map(localVersion -> CompletableFuture.completedFuture(FDBRecordVersion.incomplete(localVersion)));
        if (cachedOptional.isPresent()) {
            return cachedOptional;
        }
        ReadTransaction tr = snapshot ? this.ensureContextActive().snapshot() : this.ensureContextActive();
        return Optional.of(tr.get(versionKey).thenApply(valueBytes -> {
            if (valueBytes == null) {
                return null;
            }
            if (this.useOldVersionFormat()) {
                return FDBRecordVersion.complete(valueBytes, false);
            }
            return SplitHelper.unpackVersion(valueBytes);
        }));
    }

    @Nonnull
    public Optional<FDBRecordVersion> loadRecordVersion(@Nonnull Tuple primaryKey) {
        return this.loadRecordVersionAsync(primaryKey).map(future -> (FDBRecordVersion)this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD_VERSION, future));
    }

    @Nonnull
    public Optional<FDBRecordVersion> loadRecordVersion(@Nonnull Tuple primaryKey, boolean snapshot) {
        return this.loadRecordVersionAsync(primaryKey, snapshot).map(future -> (FDBRecordVersion)this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD_VERSION, future));
    }

    private <M extends Message> CompletableFuture<FDBStoredRecord<M>> deserializeRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull FDBRawRecord rawRecord, @Nonnull RecordMetaData metaData, @Nonnull Optional<CompletableFuture<FDBRecordVersion>> versionFutureOptional) {
        Tuple primaryKey = rawRecord.getPrimaryKey();
        byte[] serialized = rawRecord.getRawRecord();
        try {
            M protoRecord = typedSerializer.deserialize(metaData, primaryKey, rawRecord.getRawRecord(), this.getTimer());
            RecordType recordType = metaData.getRecordTypeForDescriptor(protoRecord.getDescriptorForType());
            this.countKeysAndValues(FDBStoreTimer.Counts.LOAD_RECORD_KEY, FDBStoreTimer.Counts.LOAD_RECORD_KEY_BYTES, FDBStoreTimer.Counts.LOAD_RECORD_VALUE_BYTES, rawRecord);
            FDBStoredRecordBuilder recordBuilder = FDBStoredRecord.newBuilder(protoRecord).setPrimaryKey(primaryKey).setRecordType(recordType).setSize(rawRecord);
            if (rawRecord.hasVersion()) {
                recordBuilder.setVersion(rawRecord.getVersion());
                return CompletableFuture.completedFuture(recordBuilder.build());
            }
            if (versionFutureOptional.isPresent()) {
                return versionFutureOptional.get().thenApply(version -> {
                    recordBuilder.setVersion((FDBRecordVersion)version);
                    return recordBuilder.build();
                });
            }
            return CompletableFuture.completedFuture(recordBuilder.build());
        }
        catch (Exception ex) {
            RecordDeserializationException ex2 = new RecordDeserializationException("Failed to deserialize record", ex);
            ((LoggableException)ex2).addLogInfo(new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.PRIMARY_KEY, primaryKey, LogMessageKeys.META_DATA_VERSION, metaData.getVersion()});
            if (LOGGER.isDebugEnabled()) {
                ((LoggableException)ex2).addLogInfo("serialized", (Object)ByteArrayUtil2.loggable(serialized));
            }
            if (LOGGER.isTraceEnabled()) {
                ((LoggableException)ex2).addLogInfo("descriptor", (Object)metaData.getUnionDescriptor().getFile().toProto());
            }
            throw ex2;
        }
    }

    protected void countKeysAndValues(@Nonnull StoreTimer.Count key, @Nonnull StoreTimer.Count keyBytes, @Nonnull StoreTimer.Count valueBytes, @Nonnull FDBStoredSizes sizeInfo) {
        FDBStoreTimer timer = this.getTimer();
        if (timer != null) {
            timer.increment(key, sizeInfo.getKeyCount());
            timer.increment(keyBytes, sizeInfo.getKeySize());
            timer.increment(valueBytes, sizeInfo.getValueSize());
        }
    }

    public void countKeyValue(@Nonnull StoreTimer.Count key, @Nonnull StoreTimer.Count keyBytes, @Nonnull StoreTimer.Count valueBytes, @Nonnull KeyValue keyValue) {
        this.countKeyValue(key, keyBytes, valueBytes, keyValue.getKey(), keyValue.getValue());
    }

    public void countKeyValue(@Nonnull StoreTimer.Count key, @Nonnull StoreTimer.Count keyBytes, @Nonnull StoreTimer.Count valueBytes, @Nonnull byte[] k, @Nonnull byte[] v) {
        FDBStoreTimer timer = this.getTimer();
        if (timer != null) {
            timer.increment(key);
            timer.increment(keyBytes, k.length);
            timer.increment(valueBytes, v.length);
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> preloadRecordAsync(@Nonnull Tuple primaryKey) {
        FDBPreloadRecordCache.Future futureRecord = this.preloadCache.beginPrefetch(primaryKey);
        return ((CompletableFuture)this.loadRawRecordAsync(primaryKey, null, false).whenComplete((rawRecord, ex) -> {
            if (ex != null) {
                futureRecord.cancel();
            } else {
                futureRecord.complete((FDBRawRecord)rawRecord);
            }
        })).thenApply(rawRecord -> null);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> recordExistsAsync(@Nonnull Tuple primaryKey, @Nonnull IsolationLevel isolationLevel) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        ReadTransaction tr = isolationLevel.isSnapshot() ? this.ensureContextActive().snapshot() : this.ensureContextActive();
        return SplitHelper.keyExists(tr, this.context, this.recordsSubspace(), primaryKey, metaData.isSplitLongRecords(), this.omitUnsplitRecordSuffix);
    }

    @Nonnull
    private Range getRangeForRecord(@Nonnull Tuple primaryKey) {
        return TupleRange.allOf(primaryKey).toRange(this.recordsSubspace());
    }

    @Override
    public void addRecordReadConflict(@Nonnull Tuple primaryKey) {
        Range recordRange = this.getRangeForRecord(primaryKey);
        this.ensureContextActive().addReadConflictRange(recordRange.begin, recordRange.end);
    }

    @Override
    public void addRecordWriteConflict(@Nonnull Tuple primaryKey) {
        Range recordRange = this.getRangeForRecord(primaryKey);
        this.ensureContextActive().addWriteConflictRange(recordRange.begin, recordRange.end);
    }

    @Nonnull
    private CompletableFuture<FDBRawRecord> loadRawRecordAsync(@Nonnull Tuple primaryKey, @Nullable SplitHelper.SizeInfo sizeInfo, boolean snapshot) {
        FDBPreloadRecordCache.Entry entry = this.preloadCache.get(primaryKey);
        if (entry != null) {
            return CompletableFuture.completedFuture(entry.orElse(null));
        }
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        ReadTransaction tr = snapshot ? this.ensureContextActive().snapshot() : this.ensureContextActive();
        return SplitHelper.loadWithSplit(tr, this.context, this.recordsSubspace(), primaryKey, metaData.isSplitLongRecords(), this.omitUnsplitRecordSuffix, sizeInfo);
    }

    @Override
    @Nonnull
    public RecordCursor<FDBStoredRecord<Message>> scanRecords(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanTypedRecords(this.serializer, low, high, lowEndpoint, highEndpoint, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<Tuple> scanRecordKeys(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!this.getFormatVersionEnum().isAtLeast(FormatVersion.RECORD_COUNT_KEY_ADDED)) {
            throw new UnsupportedFormatVersionException("scanRecordKeys does not support this format version", new Object[0]);
        }
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Subspace recordsSubspace = this.recordsSubspace();
        if (!metaData.isSplitLongRecords() && this.omitUnsplitRecordSuffix) {
            KeyValueCursor keyValuesCursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordsSubspace).setContext(this.context)).setContinuation(continuation)).setRange(TupleRange.ALL)).setScanProperties(scanProperties)).build();
            return keyValuesCursor.map(kv -> SplitHelper.unpackKey(recordsSubspace, kv));
        }
        Function innerFunction = cont -> {
            KeyValueCursor cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordsSubspace).setContext(this.context)).setContinuation((byte[])cont)).setRange(TupleRange.ALL)).setScanProperties(scanProperties.with(ExecuteProperties::clearReturnedRowLimit))).build();
            return cursor.map(kv -> {
                Tuple keyTuple = recordsSubspace.unpack(kv.getKey());
                Tuple nextKey = keyTuple.popBack();
                SplitHelper.validatePrimaryKeySuffixNumber(keyTuple);
                return nextKey;
            });
        };
        return new DedupCursor<Tuple>(innerFunction, Tuple::fromBytes, Tuple::pack, continuation).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
    }

    @Nonnull
    public <M extends Message> RecordCursor<FDBStoredRecord<M>> scanTypedRecords(@Nonnull RecordSerializer<M> typedSerializer, @Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        RecordCursor<FDBRawRecord> rawRecords;
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Subspace recordsSubspace = this.recordsSubspace();
        SplitHelper.SizeInfo sizeInfo = new SplitHelper.SizeInfo();
        if (metaData.isSplitLongRecords()) {
            KeyValueCursor keyValues = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordsSubspace).setContext(this.context)).setContinuation(continuation)).setLow(low, lowEndpoint)).setHigh(high, highEndpoint)).setScanProperties(scanProperties.with(ExecuteProperties::clearRowAndTimeLimits).with(ExecuteProperties::clearSkipAndLimit).with(ExecuteProperties::clearState))).build();
            rawRecords = new SplitHelper.KeyValueUnsplitter(this.context, recordsSubspace, keyValues, this.useOldVersionFormat(), sizeInfo, scanProperties.isReverse(), new CursorLimitManager(this.context, scanProperties.with(ExecuteProperties::clearReturnedRowLimit))).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
        } else {
            KeyValueCursor.Builder keyValuesBuilder = (KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordsSubspace).setContext(this.context)).setContinuation(continuation)).setLow(low, lowEndpoint)).setHigh(high, highEndpoint);
            if (this.omitUnsplitRecordSuffix) {
                rawRecords = ((KeyValueCursor.Builder)keyValuesBuilder.setScanProperties(scanProperties)).build().map(kv -> {
                    sizeInfo.set((KeyValue)kv);
                    Tuple primaryKey = SplitHelper.unpackKey(recordsSubspace, kv);
                    return new FDBRawRecord(primaryKey, kv.getValue(), null, sizeInfo);
                });
            } else {
                ScanProperties finalScanProperties = scanProperties.with(executeProperties -> {
                    ExecuteProperties.Builder builder = executeProperties.toBuilder().clearTimeLimit().clearSkipAndAdjustLimit().clearState();
                    int returnedRowLimit = builder.getReturnedRowLimitOrMax();
                    if (returnedRowLimit != Integer.MAX_VALUE) {
                        builder.setReturnedRowLimit(2 * returnedRowLimit);
                    }
                    return builder.build();
                });
                rawRecords = new SplitHelper.KeyValueUnsplitter(this.context, recordsSubspace, ((KeyValueCursor.Builder)keyValuesBuilder.setScanProperties(finalScanProperties)).build(), this.useOldVersionFormat(), sizeInfo, scanProperties.isReverse(), new CursorLimitManager(this.context, scanProperties.with(ExecuteProperties::clearReturnedRowLimit))).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
            }
        }
        RecordCursor result = rawRecords.mapPipelined(rawRecord -> {
            Optional<CompletableFuture<FDBRecordVersion>> versionFutureOptional = this.useOldVersionFormat() ? this.loadRecordVersionAsync(rawRecord.getPrimaryKey(), scanProperties.getExecuteProperties().getIsolationLevel().isSnapshot()) : Optional.empty();
            return this.deserializeRecord(typedSerializer, (FDBRawRecord)rawRecord, metaData, versionFutureOptional);
        }, this.pipelineSizer.getPipelineSize(PipelineOperation.KEY_TO_RECORD));
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SCAN_RECORDS, result);
    }

    @Override
    @Nonnull
    public CompletableFuture<Integer> countRecords(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        Subspace recordsSubspace = this.recordsSubspace();
        KeyValueCursor keyValues = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordsSubspace).setContext(this.context)).setLow(low, lowEndpoint)).setHigh(high, highEndpoint)).setContinuation(continuation)).setScanProperties(scanProperties.with(ExecuteProperties::clearRowAndTimeLimits).with(ExecuteProperties::clearState))).build();
        if (this.getRecordMetaData().isSplitLongRecords()) {
            return new SplitHelper.KeyValueUnsplitter(this.context, recordsSubspace, keyValues, this.useOldVersionFormat(), null, scanProperties.isReverse(), new CursorLimitManager(this.context, scanProperties.with(ExecuteProperties::clearRowAndTimeLimits))).getCount();
        }
        return keyValues.getCount();
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scanIndex(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!this.isIndexScannable(index)) {
            throw new ScanNonReadableIndexException("Cannot scan non-readable index", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
        }
        RecordCursor<IndexEntry> result = this.getIndexMaintainer(index).scan(scanBounds, continuation, scanProperties);
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SCAN_INDEX_KEYS, result);
    }

    @Override
    @Nonnull
    public RecordCursor<FDBIndexedRecord<Message>> scanIndexRemoteFetch(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, int commonPrimaryKeyLength, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior) {
        return this.scanIndexRemoteFetchInternal(index, scanBounds, commonPrimaryKeyLength, continuation, this.serializer, scanProperties, orphanBehavior);
    }

    @Nonnull
    protected <M extends Message> RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetchInternal(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, int commonPrimaryKeyLength, @Nullable byte[] continuation, @Nonnull RecordSerializer<M> typedSerializer, @Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior) {
        if (commonPrimaryKeyLength <= 0) {
            throw new RecordCoreArgumentException("commonPrimaryKeyLength has to be a positive number", new Object[]{LogMessageKeys.INDEX_NAME, index.getName()});
        }
        if (!this.isIndexScannable(index)) {
            throw new ScanNonReadableIndexException("Cannot scan non-readable index", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
        }
        if (!scanBounds.getScanType().equals(IndexScanType.BY_VALUE)) {
            throw new RecordCoreArgumentException("Index remote fetch can only be used with VALUE index scan.", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
        }
        if (!this.getContext().getAPIVersion().isAtLeast(APIVersion.API_VERSION_7_1)) {
            throw new UnsupportedMethodException("Index Remote Fetch can only be used with API_VERSION of at least 7.1.", new Object[0]);
        }
        IndexMaintainer indexMaintainer = this.getIndexMaintainer(index);
        RecordCursor<FDBIndexedRawRecord> indexEntries = indexMaintainer.scanRemoteFetch(scanBounds, continuation, scanProperties, commonPrimaryKeyLength);
        RecordCursor<FDBIndexedRecord<M>> indexedRecordCursor = this.indexEntriesToIndexRecords(scanProperties, orphanBehavior, indexEntries, typedSerializer);
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.SCAN_REMOTE_FETCH_ENTRY, indexedRecordCursor);
    }

    @Nonnull
    @VisibleForTesting
    <M extends Message> RecordCursor<FDBIndexedRecord<M>> indexEntriesToIndexRecords(@Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull RecordCursor<FDBIndexedRawRecord> indexEntries, @Nonnull RecordSerializer<M> typedSerializer) {
        ByteScanLimiter byteScanLimiter = scanProperties.getExecuteProperties().getState().getByteScanLimiter();
        RecordCursor<FDBIndexedRecord<M>> indexedRecordCursor = indexEntries.mapPipelined(indexedRawRecord -> {
            CompletableFuture indexedRecordFuture = this.buildSingleRecordInternal((FDBIndexedRawRecord)indexedRawRecord, typedSerializer, byteScanLimiter);
            return indexedRecordFuture.thenApply(record -> {
                if (record == null) {
                    return this.handleOrphanEntry(indexedRawRecord.getIndexEntry(), orphanBehavior);
                }
                return record;
            });
        }, 1);
        if (orphanBehavior == IndexOrphanBehavior.SKIP) {
            indexedRecordCursor = indexedRecordCursor.filter(Objects::nonNull);
        }
        return indexedRecordCursor;
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBIndexedRecord<Message>> buildSingleRecord(@Nonnull FDBIndexedRawRecord indexedRawRecord) {
        return this.buildSingleRecordInternal(indexedRawRecord, this.serializer, null);
    }

    protected <M extends Message> CompletableFuture<FDBIndexedRecord<M>> buildSingleRecordInternal(@Nonnull FDBIndexedRawRecord indexedRawRecord, @Nonnull RecordSerializer<M> typedSerializer, @Nullable ByteScanLimiter byteScanLimiter) {
        SplitHelper.SizeInfo sizeInfo = new SplitHelper.SizeInfo();
        FDBRawRecord fdbRawRecord = this.reconstructSingleRecord(this.recordsSubspace(), sizeInfo, indexedRawRecord.getRawRecord(), this.useOldVersionFormat());
        if (fdbRawRecord == null) {
            return CompletableFuture.completedFuture(null);
        }
        Optional<CompletableFuture<FDBRecordVersion>> versionFutureOptional = Optional.empty();
        if (this.useOldVersionFormat() && !fdbRawRecord.hasVersion()) {
            versionFutureOptional = this.loadRecordVersionAsync(indexedRawRecord.getIndexEntry().getPrimaryKey());
        }
        if (byteScanLimiter != null) {
            byteScanLimiter.registerScannedBytes((long)sizeInfo.getKeySize() + (long)sizeInfo.getValueSize());
        }
        CompletableFuture<FDBStoredRecord<M>> storedRecord = this.deserializeRecord(typedSerializer, fdbRawRecord, this.metaDataProvider.getRecordMetaData(), versionFutureOptional);
        return storedRecord.thenApply(rec -> new FDBIndexedRecord(indexedRawRecord.getIndexEntry(), rec));
    }

    private <M extends Message> FDBIndexedRecord<M> handleOrphanEntry(IndexEntry indexEntry, IndexOrphanBehavior orphanBehavior) {
        switch (orphanBehavior) {
            case SKIP: {
                return null;
            }
            case RETURN: {
                return new FDBIndexedRecord(indexEntry, null);
            }
            case ERROR: {
                if (this.getTimer() != null) {
                    this.getTimer().increment(FDBStoreTimer.Counts.BAD_INDEX_ENTRY);
                }
                throw new RecordCoreStorageException("record not found for prefetched index entry").addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, indexEntry.getIndex().getName(), LogMessageKeys.PRIMARY_KEY, indexEntry.getPrimaryKey(), LogMessageKeys.INDEX_KEY, indexEntry.getKey(), this.getSubspaceProvider().logKey(), this.getSubspaceProvider().toString(this.getContext())});
            }
        }
        throw new RecordCoreException("Unexpected index orphan behavior: " + String.valueOf((Object)orphanBehavior), new Object[0]);
    }

    @Nullable
    private FDBRawRecord reconstructSingleRecord(Subspace recordSubspace, SplitHelper.SizeInfo sizeInfo, MappedKeyValue mappedResult, boolean oldVersionFormat) {
        List<KeyValue> scannedRange = mappedResult.getRangeResult();
        if (scannedRange == null || scannedRange.isEmpty()) {
            return null;
        }
        ListCursor<KeyValue> rangeCursor = new ListCursor<KeyValue>(scannedRange, null);
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        SplitHelper.KeyValueUnsplitter rawRecords = metaData.isSplitLongRecords() ? new SplitHelper.KeyValueUnsplitter(this.context, recordSubspace, rangeCursor, oldVersionFormat, sizeInfo, false, CursorLimitManager.UNTRACKED) : (this.omitUnsplitRecordSuffix ? rangeCursor.map(kv -> {
            sizeInfo.set((KeyValue)kv);
            Tuple primaryKey = SplitHelper.unpackKey(recordSubspace, kv);
            return new FDBRawRecord(primaryKey, kv.getValue(), null, sizeInfo);
        }) : new SplitHelper.KeyValueUnsplitter(this.context, recordSubspace, rangeCursor, oldVersionFormat, sizeInfo, false, CursorLimitManager.UNTRACKED));
        return (FDBRawRecord)rawRecords.getNext().get();
    }

    @Override
    @Nonnull
    public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        if (!index.isUnique()) {
            return RecordCursor.empty(this.getExecutor());
        }
        RecordCursor<IndexEntry> tupleCursor = this.getIndexMaintainer(index).scanUniquenessViolations(range, continuation, scanProperties);
        return tupleCursor.map(entry -> {
            int indexColumns = index.getColumnSize();
            Tuple valueKey = TupleHelpers.subTuple(entry.getKey(), 0, indexColumns);
            Tuple primaryKey = TupleHelpers.subTuple(entry.getKey(), indexColumns, entry.getKey().size());
            Tuple existingKey = entry.getValue();
            return new RecordIndexUniquenessViolation(index, new IndexEntry(index, valueKey, entry.getValue()), primaryKey, existingKey);
        });
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> resolveUniquenessViolation(@Nonnull Index index, @Nonnull Tuple valueKey, @Nullable Tuple remainPrimaryKey) {
        return this.scanUniquenessViolations(index, valueKey).forEachAsync(uniquenessViolation -> {
            if (remainPrimaryKey == null || !remainPrimaryKey.equals(uniquenessViolation.getPrimaryKey())) {
                return this.deleteRecordAsync(uniquenessViolation.getPrimaryKey()).thenApply(ignore -> null);
            }
            return AsyncUtil.DONE;
        }, this.getPipelineSize(PipelineOperation.RESOLVE_UNIQUENESS));
    }

    @API(value=API.Status.INTERNAL)
    public void addIndexUniquenessCommitCheck(@Nonnull Index index, @Nonnull Subspace indexSubspace, @Nonnull CompletableFuture<Void> check) {
        IndexUniquenessCommitCheck commitCheck = new IndexUniquenessCommitCheck(index, indexSubspace, check);
        this.getRecordContext().addCommitCheck(commitCheck);
    }

    @Nonnull
    @VisibleForTesting
    CompletableFuture<Void> whenAllIndexUniquenessCommitChecks(@Nonnull Index index) {
        Subspace indexSubspace = this.indexSubspace(index);
        List<FDBRecordContext.CommitCheckAsync> indexUniquenessChecks = this.getRecordContext().getCommitChecks(commitCheck -> {
            if (commitCheck instanceof IndexUniquenessCommitCheck) {
                return ((IndexUniquenessCommitCheck)commitCheck).getIndexSubspace().equals(indexSubspace);
            }
            return false;
        });
        return AsyncUtil.whenAll(indexUniquenessChecks.stream().map(FDBRecordContext.CommitCheckAsync::checkAsync).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> dryRunDeleteRecordAsync(@Nonnull Tuple primaryKey) {
        return this.deleteTypedRecord(this.serializer, primaryKey, true);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> deleteRecordAsync(@Nonnull Tuple primaryKey) {
        return this.deleteTypedRecord(this.serializer, primaryKey, false);
    }

    @Nonnull
    protected <M extends Message> CompletableFuture<Boolean> deleteTypedRecord(@Nonnull RecordSerializer<M> typedSerializer, @Nonnull Tuple primaryKey, boolean isDryRun) {
        if (isDryRun) {
            return this.loadTypedRecord(typedSerializer, primaryKey, false).thenCompose(oldRecord -> oldRecord == null ? AsyncUtil.READY_FALSE : AsyncUtil.READY_TRUE);
        }
        this.preloadCache.invalidate(primaryKey);
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        CompletionStage result = this.loadTypedRecord(typedSerializer, primaryKey, false).thenCompose(oldRecord -> {
            if (oldRecord == null) {
                return AsyncUtil.READY_FALSE;
            }
            return this.getRecordStoreStateAsync().thenCompose(recordStoreState -> {
                boolean oldHasIncompleteVersion;
                FDBRecordStore.validateRecordUpdateAllowed(recordStoreState);
                this.deleteRecordSplits(primaryKey, true, (FDBStoredRecord)oldRecord, metaData);
                this.countKeysAndValues(FDBStoreTimer.Counts.DELETE_RECORD_KEY, FDBStoreTimer.Counts.DELETE_RECORD_KEY_BYTES, FDBStoreTimer.Counts.DELETE_RECORD_VALUE_BYTES, (FDBStoredSizes)oldRecord);
                this.addRecordCount(metaData, (FDBStoredRecord)oldRecord, LITTLE_ENDIAN_INT64_MINUS_ONE);
                boolean bl = oldHasIncompleteVersion = oldRecord.hasVersion() && !oldRecord.getVersion().isComplete();
                if (this.useOldVersionFormat()) {
                    byte[] versionKey = this.getSubspace().pack(this.recordVersionKey(primaryKey));
                    if (oldHasIncompleteVersion) {
                        this.context.removeVersionMutation(versionKey);
                    } else if (metaData.isStoreRecordVersions()) {
                        this.ensureContextActive().clear(versionKey);
                    }
                }
                CompletableFuture<Void> updateIndexesFuture = this.updateSecondaryIndexes((FDBStoredRecord)oldRecord, null);
                if (oldHasIncompleteVersion) {
                    return updateIndexesFuture.thenApply(vignore -> {
                        byte[] versionKey = this.getSubspace().pack(this.recordVersionKey(primaryKey));
                        this.context.removeLocalVersion(versionKey);
                        return true;
                    });
                }
                return updateIndexesFuture.thenApply(vignore -> true);
            });
        });
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.DELETE_RECORD, result);
    }

    @API(value=API.Status.INTERNAL)
    public <M extends Message> void deleteRecordSplits(@Nonnull Tuple primaryKey, boolean clearBasedOnPreviousSizeInfo, @Nullable FDBStoredRecord<M> oldRecord, @Nonnull RecordMetaData metaData) {
        SplitHelper.deleteSplit(this.getRecordContext(), this.recordsSubspace(), primaryKey, metaData.isSplitLongRecords(), this.omitUnsplitRecordSuffix, clearBasedOnPreviousSizeInfo, oldRecord);
    }

    public static void deleteStore(FDBRecordContext context, KeySpacePath path) {
        Subspace subspace = path.toSubspace(context);
        FDBRecordStore.deleteStore(context, subspace);
    }

    public static void deleteStore(FDBRecordContext context, Subspace subspace) {
        context.setMetaDataVersionStamp();
        context.setDirtyStoreState(true);
        context.clear(subspace.range());
    }

    @Override
    public void deleteAllRecords() {
        this.preloadCache.invalidateAll();
        RecordStoreState localRecordStoreState = this.recordStoreStateRef.get();
        if (localRecordStoreState == null) {
            throw new RecordCoreException("checkVersion must be called before calling deleteAllRecords", new Object[0]);
        }
        FDBRecordStore.validateRecordUpdateAllowed(localRecordStoreState);
        Range indexStateRange = this.indexStateSubspace().range();
        this.context.clear(new Range(this.recordsSubspace().getKey(), indexStateRange.begin));
        this.context.clear(new Range(indexStateRange.end, this.getSubspace().range().end));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteRecordsWhereAsync(@Nonnull QueryComponent component) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(ignore -> this.deleteRecordsWhereAsync(component));
        }
        FDBRecordStore.validateRecordUpdateAllowed(this.recordStoreStateRef.get());
        this.preloadCache.invalidateAll();
        this.recordStoreStateRef.get().beginRead();
        boolean async = false;
        try {
            CompletableFuture<Void> future = new RecordsWhereDeleter(component).run();
            async = true;
            CompletionStage completionStage = future.whenComplete((ignore, err) -> this.recordStoreStateRef.get().endRead());
            return completionStage;
        }
        finally {
            if (!async) {
                this.recordStoreStateRef.get().endRead();
            }
        }
    }

    private static void validateRecordUpdateAllowed(@Nonnull RecordStoreState state) {
        if (!state.isRecordUpdateAllowed()) {
            throw new StoreIsLockedForRecordUpdates(state);
        }
    }

    private boolean hasSplitRecordSuffix() {
        return this.getRecordMetaData().isSplitLongRecords() || !this.omitUnsplitRecordSuffix;
    }

    @Nonnull
    protected static QueryComponent mergeRecordTypeAndComponent(@Nonnull String recordType, @Nullable QueryComponent component) {
        if (component == null) {
            return new RecordTypeKeyComparison(recordType);
        }
        ArrayList<QueryComponent> components = new ArrayList<QueryComponent>();
        components.add(new RecordTypeKeyComparison(recordType));
        if (component instanceof AndComponent) {
            components.addAll(((AndComponent)component).getChildren());
        } else {
            components.add(component);
        }
        return Query.and(components);
    }

    @Override
    public FDBRecordStoreBase.PipelineSizer getPipelineSizer() {
        return this.pipelineSizer;
    }

    @Nonnull
    private FDBRecordStoreStateCache getStoreStateCache() {
        return this.storeStateCache == null ? this.context.getDatabase().getStoreStateCache() : this.storeStateCache;
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> estimateStoreSizeAsync() {
        long startTime = System.nanoTime();
        return this.getSubspaceAsync().thenCompose(subspace -> this.estimateSize(subspace.range(), startTime));
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> estimateRecordsSizeAsync(@Nonnull TupleRange range) {
        long startTime = System.nanoTime();
        return this.getSubspaceAsync().thenCompose(ignore -> this.estimateSize(range.toRange(this.recordsSubspace()), startTime));
    }

    private CompletableFuture<Long> estimateSize(@Nonnull Range range, long startTimeNanos) {
        CompletableFuture<Long> sizeFuture = this.ensureContextActive().getEstimatedRangeSizeBytes(range);
        return this.instrument(FDBStoreTimer.Events.ESTIMATE_SIZE, sizeFuture, startTimeNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Long> getSnapshotRecordCount(@Nonnull KeyExpression key, @Nonnull Key.Evaluated value, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        RecordMetaData recordMetaData = this.getRecordMetaData();
        if (recordMetaData.getRecordCountKey() != null) {
            this.beginRecordStoreStateRead();
            boolean futureCreated = false;
            try {
                RecordMetaDataProto.DataStoreInfo header = this.recordStoreStateRef.get().getStoreHeader();
                if (header.getRecordCountState() == RecordMetaDataProto.DataStoreInfo.RecordCountState.READABLE) {
                    if (key.getColumnSize() != value.size()) {
                        throw this.recordCoreException("key and value are not the same size");
                    }
                    ReadTransaction tr = this.context.readTransaction(true);
                    Tuple subkey = Tuple.from(RECORD_COUNT_KEY).addAll(value.toTupleAppropriateList());
                    if (recordMetaData.getRecordCountKey().equals(key)) {
                        CompletionStage result = ((CompletableFuture)tr.get(this.getSubspace().pack(subkey)).thenApply(FDBRecordStore::decodeRecordCount)).whenComplete((ignored, error) -> this.endRecordStoreStateRead());
                        futureCreated = true;
                        CompletionStage completionStage = result;
                        return completionStage;
                    }
                    if (key.isPrefixKey(recordMetaData.getRecordCountKey())) {
                        AsyncIterable<KeyValue> kvs = tr.getRange(this.getSubspace().range(Tuple.from(RECORD_COUNT_KEY)));
                        CompletionStage result = MoreAsyncUtil.reduce(this.getExecutor(), kvs.iterator(), 0L, (count, kv) -> count + FDBRecordStore.decodeRecordCount(kv.getValue())).whenComplete((ignored, error) -> this.endRecordStoreStateRead());
                        futureCreated = true;
                        CompletionStage completionStage = result;
                        return completionStage;
                    }
                }
            }
            finally {
                if (!futureCreated) {
                    this.endRecordStoreStateRead();
                }
            }
        }
        return this.evaluateAggregateFunction(Collections.emptyList(), IndexFunctionHelper.count(key), TupleRange.allOf(value.toTuple()), IsolationLevel.SNAPSHOT, indexQueryabilityFilter).thenApply(tuple -> tuple.getLong(0));
    }

    @Override
    public CompletableFuture<Long> getSnapshotRecordCountForRecordType(@Nonnull String recordTypeName, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        IndexAggregateFunction aggregateFunction = IndexFunctionHelper.count(EmptyKeyExpression.EMPTY);
        Optional<IndexMaintainer> indexMaintainer = IndexFunctionHelper.indexMaintainerForAggregateFunction(this, aggregateFunction, Collections.singletonList(recordTypeName), indexQueryabilityFilter);
        if (indexMaintainer.isPresent()) {
            return indexMaintainer.get().evaluateAggregateFunction(aggregateFunction, TupleRange.ALL, IsolationLevel.SNAPSHOT).thenApply(tuple -> tuple.getLong(0));
        }
        aggregateFunction = IndexFunctionHelper.count(Key.Expressions.recordType());
        indexMaintainer = IndexFunctionHelper.indexMaintainerForAggregateFunction(this, aggregateFunction, Collections.emptyList(), indexQueryabilityFilter);
        if (indexMaintainer.isPresent()) {
            RecordType recordType = this.getRecordMetaData().getRecordType(recordTypeName);
            return indexMaintainer.get().evaluateAggregateFunction(aggregateFunction, TupleRange.allOf(recordType.getRecordTypeKeyTuple()), IsolationLevel.SNAPSHOT).thenApply(tuple -> tuple.getLong(0));
        }
        throw this.recordCoreException("Require a COUNT index on " + recordTypeName);
    }

    static byte[] encodeRecordCount(long count) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(count).array();
    }

    public static long decodeRecordCount(@Nullable byte[] bytes) {
        return bytes == null ? 0L : ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    @Override
    @Nonnull
    public <T> CompletableFuture<T> evaluateIndexRecordFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<Message> rec) {
        return this.evaluateTypedIndexRecordFunction(evaluationContext, function, rec);
    }

    @Nonnull
    protected <T, M extends Message> CompletableFuture<T> evaluateTypedIndexRecordFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull IndexRecordFunction<T> indexRecordFunction, @Nonnull FDBRecord<M> rec) {
        return IndexFunctionHelper.indexMaintainerForRecordFunction(this, indexRecordFunction, rec).orElseThrow(() -> this.recordCoreException("Record function " + String.valueOf(indexRecordFunction) + " requires appropriate index on " + rec.getRecordType().getName())).evaluateRecordFunction(evaluationContext, indexRecordFunction, rec);
    }

    @Override
    @Nonnull
    public <T> CompletableFuture<T> evaluateStoreFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull StoreRecordFunction<T> function, @Nonnull FDBRecord<Message> rec) {
        return this.evaluateTypedStoreFunction(evaluationContext, function, rec);
    }

    @Nonnull
    public <T, M extends Message> CompletableFuture<T> evaluateTypedStoreFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull StoreRecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        if ("version".equals(function.getName())) {
            if (rec.hasVersion() && rec.getVersion().isComplete()) {
                return CompletableFuture.completedFuture(rec.getVersion());
            }
            return this.loadRecordVersionAsync(rec.getPrimaryKey()).orElse(CompletableFuture.completedFuture(null));
        }
        throw this.recordCoreException("Unknown store function " + function.getName());
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull List<String> recordTypeNames, @Nonnull IndexAggregateFunction aggregateFunction, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        return IndexFunctionHelper.indexMaintainerForAggregateFunction(this, aggregateFunction, recordTypeNames, indexQueryabilityFilter).orElseThrow(() -> new AggregateFunctionNotSupportedException("Aggregate function requires appropriate index", new Object[]{LogMessageKeys.FUNCTION, aggregateFunction, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)})).evaluateAggregateFunction(aggregateFunction, range, isolationLevel);
    }

    @Override
    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        RecordQueryPlanner planner = new RecordQueryPlanner(this.getRecordMetaData(), this.getRecordStoreState());
        return planner.plan(query, parameterRelationshipGraph);
    }

    @Override
    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph, @Nonnull RecordQueryPlannerConfiguration plannerConfiguration) {
        RecordQueryPlanner planner = new RecordQueryPlanner(this.getRecordMetaData(), this.getRecordStoreState());
        planner.setConfiguration(plannerConfiguration);
        return planner.plan(query, parameterRelationshipGraph);
    }

    @Nonnull
    public static IndexState writeOnlyIfTooManyRecordsForRebuild(long recordCount, boolean indexOnNewRecordTypes) {
        return FDBRecordStore.readableIfNewTypeOrFewRecordsForRebuild(recordCount, indexOnNewRecordTypes, IndexState.WRITE_ONLY);
    }

    @Nonnull
    public static IndexState disabledIfTooManyRecordsForRebuild(long recordCount, boolean indexOnNewRecordTypes) {
        return FDBRecordStore.readableIfNewTypeOrFewRecordsForRebuild(recordCount, indexOnNewRecordTypes, IndexState.DISABLED);
    }

    @Nonnull
    private static IndexState readableIfNewTypeOrFewRecordsForRebuild(long recordCount, boolean indexOnNewRecordTypes, @Nonnull IndexState defaultState) {
        if (indexOnNewRecordTypes || recordCount <= 200L) {
            return IndexState.READABLE;
        }
        return defaultState;
    }

    @Nonnull
    public CompletableFuture<Boolean> checkVersion(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        return this.checkVersion(userVersionChecker, existenceCheck, AsyncUtil.DONE);
    }

    @Nonnull
    private CompletableFuture<Boolean> checkVersion(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck, @Nonnull CompletableFuture<Void> metaDataPreloadFuture) {
        CompletableFuture<Void> subspacePreloadFuture = this.preloadSubspaceAsync();
        CompletionStage storeHeaderFuture = this.getStoreStateCache().get(this, existenceCheck).thenApply(storeInfo -> {
            if (this.recordStoreStateRef.get() == null) {
                this.recordStoreStateRef.compareAndSet(null, storeInfo.getRecordStoreState().toMutable());
            }
            return this.recordStoreStateRef.get().getStoreHeader();
        });
        if (!MoreAsyncUtil.isCompletedNormally(metaDataPreloadFuture)) {
            storeHeaderFuture = metaDataPreloadFuture.thenCombine(storeHeaderFuture, (vignore, storeHeader) -> storeHeader);
        }
        if (!MoreAsyncUtil.isCompletedNormally(subspacePreloadFuture)) {
            storeHeaderFuture = subspacePreloadFuture.thenCombine(storeHeaderFuture, (vignore, storeHeader) -> storeHeader);
        }
        CompletionStage result = ((CompletableFuture)storeHeaderFuture).thenCompose(storeHeader -> this.checkVersion((RecordMetaDataProto.DataStoreInfo)storeHeader, userVersionChecker));
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.CHECK_VERSION, result).thenApply(versionChanged -> {
            if (versionChanged.booleanValue()) {
                this.versionChanged = true;
            }
            return versionChanged;
        });
    }

    @Nonnull
    private CompletableFuture<Boolean> checkVersion(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader, @Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker) {
        RecordMetaDataProto.DataStoreInfo.Builder info = storeHeader.toBuilder();
        if (info.hasFormatVersion() && info.getFormatVersion() >= SAVE_UNSPLIT_WITH_SUFFIX_FORMAT_VERSION) {
            this.omitUnsplitRecordSuffix = info.getOmitUnsplitRecordSuffix();
        }
        boolean[] dirty = new boolean[1];
        boolean newStore = FDBRecordStore.isNewStoreHeader(storeHeader);
        if (Math.max(storeHeader.getFormatVersion(), this.formatVersion.getValueForSerialization()) >= CACHEABLE_STATE_FORMAT_VERSION && (this.stateCacheabilityOnOpen.isUpdateExistingStores() || newStore)) {
            boolean cacheable = this.stateCacheabilityOnOpen.isCacheable();
            if (info.getCacheable() != cacheable) {
                if (newStore) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(KeyValueLogMessage.of("setting initial store state cacheability", new Object[]{LogMessageKeys.OLD, info.getCacheable(), LogMessageKeys.NEW, cacheable, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                    }
                } else if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of("updating store state cacheability", new Object[]{LogMessageKeys.OLD, info.getCacheable(), LogMessageKeys.NEW, cacheable, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
                info.setCacheable(cacheable);
                dirty[0] = true;
            }
        }
        CompletableFuture<Void> checkedUserVersion = this.checkUserVersion(userVersionChecker, storeHeader, info, dirty);
        CompletionStage checkedRebuild = checkedUserVersion.thenCompose(vignore -> this.checkPossiblyRebuild(userVersionChecker, info, dirty));
        return ((CompletableFuture)((CompletableFuture)checkedRebuild).thenCompose(vignore -> {
            if (dirty[0]) {
                return this.updateStoreHeaderAsync(ignore -> info).thenApply(vignore2 -> true);
            }
            return AsyncUtil.READY_FALSE;
        })).thenCompose(this::removeReplacedIndexesIfChanged);
    }

    private CompletableFuture<Void> checkUserVersion(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull RecordMetaDataProto.DataStoreInfo storeHeader, @Nonnull RecordMetaDataProto.DataStoreInfo.Builder info, @Nonnull boolean[] dirty) {
        if (userVersionChecker == null) {
            return AsyncUtil.DONE;
        }
        boolean newStore = FDBRecordStore.isNewStoreHeader(storeHeader);
        int oldUserVersion = newStore ? -1 : info.getUserVersion();
        return userVersionChecker.checkUserVersion(storeHeader, this.metaDataProvider).thenApply(newUserVersion -> {
            this.userVersion = newUserVersion;
            if (newUserVersion != oldUserVersion) {
                if (oldUserVersion > newUserVersion) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error(KeyValueLogMessage.of("stale user version", new Object[]{LogMessageKeys.STORED_VERSION, oldUserVersion, LogMessageKeys.LOCAL_VERSION, newUserVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                    }
                    throw new RecordStoreStaleUserVersionException("Stale user version with local version " + newUserVersion + " and stored version " + oldUserVersion, new Object[0]);
                }
                info.setUserVersion((int)newUserVersion);
                dirty[0] = true;
                if (oldUserVersion < 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(KeyValueLogMessage.of("setting initial user version", new Object[]{LogMessageKeys.NEW_VERSION, newUserVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                    }
                } else if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of("changing user version", new Object[]{LogMessageKeys.OLD_VERSION, oldUserVersion, LogMessageKeys.NEW_VERSION, newUserVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
            }
            return null;
        });
    }

    private static boolean isNewStoreHeader(@Nonnull RecordMetaDataProto.DataStoreInfoOrBuilder storeInfo) {
        return storeInfo.getFormatVersion() == 0;
    }

    @Nonnull
    private RecordMetaDataProto.DataStoreInfo checkAndParseStoreHeader(@Nullable KeyValue firstKeyValue, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        RecordMetaDataProto.DataStoreInfo info;
        if (firstKeyValue == null) {
            info = RecordMetaDataProto.DataStoreInfo.getDefaultInstance();
        } else if (!FDBRecordStore.checkFirstKeyIsHeader(firstKeyValue, this.getContext(), this.getSubspaceProvider(), this.getSubspace(), existenceCheck)) {
            info = RecordMetaDataProto.DataStoreInfo.getDefaultInstance();
        } else {
            try {
                info = RecordMetaDataProto.DataStoreInfo.parseFrom(firstKeyValue.getValue());
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreStorageException("Error reading version", ex).addLogInfo(new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
            }
        }
        FDBRecordStore.checkStoreHeaderInternal(info, this.getContext(), this.getSubspaceProvider(), existenceCheck);
        return info;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public static CompletableFuture<Void> checkStoreHeader(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader, @Nonnull FDBRecordContext context, @Nonnull SubspaceProvider subspaceProvider, @Nonnull Subspace subspace, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        if (storeHeader == RecordMetaDataProto.DataStoreInfo.getDefaultInstance()) {
            return FDBRecordStore.readStoreFirstKey(context, subspace, IsolationLevel.SNAPSHOT).thenAccept(firstKeyValue -> {
                if (firstKeyValue != null && FDBRecordStore.checkFirstKeyIsHeader(firstKeyValue, context, subspaceProvider, subspace, existenceCheck)) {
                    throw new RecordCoreException("Record store with no header had header in database", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context)});
                }
                context.ensureActive().addReadConflictKey(subspace.pack(STORE_INFO_KEY));
                FDBRecordStore.checkStoreHeaderInternal(storeHeader, context, subspaceProvider, existenceCheck);
            });
        }
        try {
            FDBRecordStore.checkStoreHeaderInternal(storeHeader, context, subspaceProvider, existenceCheck);
            return AsyncUtil.DONE;
        }
        catch (RecordCoreException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    private static boolean checkFirstKeyIsHeader(@Nonnull KeyValue firstKeyValue, @Nonnull FDBRecordContext context, @Nonnull SubspaceProvider subspaceProvider, @Nonnull Subspace subspace, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        Tuple firstKey = subspace.unpack(firstKeyValue.getKey());
        if (TupleHelpers.equals(firstKey, Tuple.from(STORE_INFO_KEY))) {
            return true;
        }
        if (existenceCheck == FDBRecordStoreBase.StoreExistenceCheck.NONE) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(KeyValueLogMessage.of("Record store has no info but is not empty", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context), LogMessageKeys.KEY, firstKey}));
            }
            return false;
        }
        FDBRecordStoreKeyspace keyspace = FDBRecordStore.determineRecordStoreKeyspace(firstKey, subspaceProvider, context);
        if (FDBRecordStoreKeyspace.INDEX_STATE_SPACE.equals((Object)keyspace) || FDBRecordStoreKeyspace.INDEX_RANGE_SPACE.equals((Object)keyspace) || FDBRecordStoreKeyspace.INDEX_BUILD_SPACE.equals((Object)keyspace)) {
            if (existenceCheck == FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_NO_INFO_AND_HAS_RECORDS_OR_INDEXES) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.of("Record store has no info or records but is not empty", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context), LogMessageKeys.KEY, firstKey}));
                }
                return false;
            }
            throw FDBRecordStore.noInfoAndNotEmptyException("Record store has no info or records but is not empty", firstKey, subspaceProvider, context);
        }
        throw FDBRecordStore.noInfoAndNotEmptyException("Record store has no info but is not empty", firstKey, subspaceProvider, context);
    }

    @Nonnull
    private static FDBRecordStoreKeyspace determineRecordStoreKeyspace(@Nonnull Tuple firstKey, @Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordContext context) {
        if (firstKey.isEmpty()) {
            throw new RecordCoreException("First key in record store is empty", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context), LogMessageKeys.KEY, firstKey});
        }
        try {
            return FDBRecordStoreKeyspace.fromKey(firstKey.get(0));
        }
        catch (RecordCoreException e) {
            throw new RecordStoreNoInfoAndNotEmptyException("Record store has no info but is not empty with an unknown keyspace", e).addLogInfo(new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context)}).addLogInfo(new Object[]{LogMessageKeys.KEY, firstKey});
        }
    }

    @Nonnull
    private static RecordStoreNoInfoAndNotEmptyException noInfoAndNotEmptyException(@Nonnull String staticMessage, @Nonnull Tuple firstKey, @Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordContext context) {
        return new RecordStoreNoInfoAndNotEmptyException(staticMessage, new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context), LogMessageKeys.KEY, firstKey});
    }

    private static void checkStoreHeaderInternal(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader, @Nonnull FDBRecordContext context, @Nonnull SubspaceProvider subspaceProvider, @Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        if (storeHeader == RecordMetaDataProto.DataStoreInfo.getDefaultInstance()) {
            if (existenceCheck == FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_NOT_EXISTS) {
                throw new RecordStoreDoesNotExistException("Record store does not exist", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context)});
            }
            context.increment(FDBStoreTimer.Counts.CREATE_RECORD_STORE);
        } else {
            if (existenceCheck == FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_EXISTS) {
                throw new RecordStoreAlreadyExistsException("Record store already exists", new Object[]{subspaceProvider.logKey(), subspaceProvider.toString(context)});
            }
            FormatVersion.validateFormatVersion(storeHeader.getFormatVersion(), subspaceProvider);
        }
    }

    private boolean addRemoveReplacedIndexesCommitCheckIfChanged(boolean changed) {
        if (changed) {
            String commitCheckName = "removeReplacedIndexes_" + ByteArrayUtil2.toHexString(this.getSubspace().pack());
            this.getRecordContext().getOrCreateCommitCheck(commitCheckName, name -> this::removeReplacedIndexes);
        }
        return changed;
    }

    @Nonnull
    private CompletableFuture<Boolean> removeReplacedIndexesIfChanged(boolean changed) {
        if (changed) {
            return this.removeReplacedIndexes().thenApply(vignore -> true);
        }
        return AsyncUtil.READY_FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Void> removeReplacedIndexes() {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.removeReplacedIndexes());
        }
        this.beginRecordStoreStateRead();
        RecordMetaData metaData = this.getRecordMetaData();
        ArrayList<Index> indexesToRemove = new ArrayList<Index>();
        try {
            for (Index index : metaData.getAllIndexes()) {
                List<String> replacedByNames = index.getReplacedByIndexNames();
                if (replacedByNames.isEmpty() || !replacedByNames.stream().allMatch(replacedByName -> metaData.hasIndex((String)replacedByName) && this.isIndexReadable((String)replacedByName))) continue;
                indexesToRemove.add(index);
            }
        }
        finally {
            this.endRecordStoreStateRead();
        }
        if (indexesToRemove.isEmpty()) {
            return AsyncUtil.DONE;
        }
        this.beginRecordStoreStateWrite();
        boolean haveFuture = false;
        try {
            ArrayList<CompletableFuture<Boolean>> indexRemoveFutures = new ArrayList<CompletableFuture<Boolean>>(indexesToRemove.size());
            for (Index index : indexesToRemove) {
                indexRemoveFutures.add(this.markIndexDisabled(index));
            }
            CompletionStage future = AsyncUtil.whenAll(indexRemoveFutures).whenComplete((vignore, errIgnore) -> this.endRecordStoreStateWrite());
            haveFuture = true;
            CompletionStage completionStage = future;
            return completionStage;
        }
        finally {
            if (!haveFuture) {
                this.endRecordStoreStateWrite();
            }
        }
    }

    private void beginRecordStoreStateRead() {
        this.recordStoreStateRef.updateAndGet(state -> {
            state.beginRead();
            return state;
        });
    }

    private void endRecordStoreStateRead() {
        this.recordStoreStateRef.updateAndGet(state -> {
            state.endRead();
            return state;
        });
    }

    private void beginRecordStoreStateWrite() {
        this.recordStoreStateRef.updateAndGet(state -> {
            state.beginWrite();
            return state;
        });
    }

    private void endRecordStoreStateWrite() {
        this.recordStoreStateRef.updateAndGet(state -> {
            state.endWrite();
            return state;
        });
    }

    @Nonnull
    private CompletableFuture<RecordMetaDataProto.DataStoreInfo> loadStoreHeaderAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck, @Nonnull IsolationLevel isolationLevel) {
        return FDBRecordStore.readStoreFirstKey(this.context, this.getSubspace(), isolationLevel).thenApply(keyValue -> this.checkAndParseStoreHeader((KeyValue)keyValue, existenceCheck));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void saveStoreHeader(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader) {
        if (this.recordStoreStateRef.get() == null) {
            throw this.uninitializedStoreException("cannot update store header on an uninitialized store");
        }
        this.beginRecordStoreStateWrite();
        try {
            this.context.setDirtyStoreState(true);
            FDBRecordStore fDBRecordStore = this;
            synchronized (fDBRecordStore) {
                this.recordStoreStateRef.updateAndGet(state -> {
                    state.setStoreHeader(storeHeader);
                    return state;
                });
                this.ensureContextActive().set(this.getSubspace().pack(STORE_INFO_KEY), storeHeader.toByteArray());
            }
        }
        finally {
            this.endRecordStoreStateWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Void> updateStoreHeaderAsync(@Nonnull UnaryOperator<RecordMetaDataProto.DataStoreInfo.Builder> storeHeaderMutator) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.updateStoreHeaderAsync(storeHeaderMutator));
        }
        AtomicReference oldStoreHeaderRef = new AtomicReference();
        AtomicReference newStoreHeaderRef = new AtomicReference();
        this.beginRecordStoreStateWrite();
        try {
            this.context.setDirtyStoreState(true);
            FDBRecordStore fDBRecordStore = this;
            synchronized (fDBRecordStore) {
                this.recordStoreStateRef.updateAndGet(state -> {
                    RecordMetaDataProto.DataStoreInfo oldStoreHeader = state.getStoreHeader();
                    oldStoreHeaderRef.set(oldStoreHeader);
                    RecordMetaDataProto.DataStoreInfo.Builder storeHeaderBuilder = oldStoreHeader.toBuilder();
                    storeHeaderBuilder = (RecordMetaDataProto.DataStoreInfo.Builder)storeHeaderMutator.apply(storeHeaderBuilder);
                    storeHeaderBuilder.setLastUpdateTime(System.currentTimeMillis());
                    RecordMetaDataProto.DataStoreInfo newStoreHeader = storeHeaderBuilder.build();
                    newStoreHeaderRef.set(newStoreHeader);
                    state.setStoreHeader(newStoreHeader);
                    return state;
                });
                this.ensureContextActive().set(this.getSubspace().pack(STORE_INFO_KEY), ((RecordMetaDataProto.DataStoreInfo)newStoreHeaderRef.get()).toByteArray());
            }
        }
        finally {
            this.endRecordStoreStateWrite();
        }
        RecordMetaDataProto.DataStoreInfo oldStoreHeader = (RecordMetaDataProto.DataStoreInfo)oldStoreHeaderRef.get();
        RecordMetaDataProto.DataStoreInfo newStoreHeader = (RecordMetaDataProto.DataStoreInfo)newStoreHeaderRef.get();
        if (oldStoreHeader.getCacheable()) {
            this.context.setMetaDataVersionStamp();
            return AsyncUtil.DONE;
        }
        if (newStoreHeader.getCacheable()) {
            return this.context.getMetaDataVersionStampAsync(IsolationLevel.SNAPSHOT).thenAccept(metaDataVersionStamp -> {
                if (metaDataVersionStamp == null) {
                    this.context.setMetaDataVersionStamp();
                }
            });
        }
        return AsyncUtil.DONE;
    }

    @Nonnull
    private static CompletableFuture<KeyValue> readStoreFirstKey(@Nonnull FDBRecordContext context, @Nonnull Subspace subspace, @Nonnull IsolationLevel isolationLevel) {
        Iterator iterator = context.readTransaction(isolationLevel.isSnapshot()).getRange(subspace.range(), 1).iterator();
        return context.instrument((StoreTimer.Event)FDBStoreTimer.Events.LOAD_RECORD_STORE_INFO, iterator.onHasNext().thenApply(arg_0 -> FDBRecordStore.lambda$readStoreFirstKey$81((AsyncIterator)iterator, arg_0)));
    }

    @Nonnull
    public CompletableFuture<Void> rebuildAllIndexes() {
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_KEY)));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_SECONDARY_SPACE_KEY)));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_RANGE_SPACE_KEY)));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_UNIQUENESS_VIOLATIONS_KEY)));
        LinkedList<CompletableFuture<Void>> work = new LinkedList<CompletableFuture<Void>>();
        this.addRebuildRecordCountsJob(work);
        return this.rebuildIndexes(this.getRecordMetaData().getIndexesToBuildSince(-1), Collections.emptyMap(), work, RebuildIndexReason.REBUILD_ALL, null);
    }

    @Nonnull
    public Map<Index, List<RecordType>> getIndexesToBuild() {
        if (this.recordStoreStateRef.get() == null) {
            throw this.uninitializedStoreException("cannot get indexes to build on uninitialized store");
        }
        Map<Index, List<RecordType>> indexesToBuild = this.getRecordMetaData().getIndexesToBuildSince(-1);
        this.beginRecordStoreStateRead();
        try {
            indexesToBuild.keySet().removeIf(this::isIndexReadable);
            Map<Index, List<RecordType>> map = indexesToBuild;
            return map;
        }
        finally {
            this.endRecordStoreStateRead();
        }
    }

    @Nonnull
    public CompletableFuture<Void> clearAndMarkIndexWriteOnly(@Nonnull String indexName) {
        return this.clearAndMarkIndexWriteOnly(this.metaDataProvider.getRecordMetaData().getIndex(indexName));
    }

    @Nonnull
    public CompletableFuture<Void> clearAndMarkIndexWriteOnly(@Nonnull Index index) {
        return this.markIndexWriteOnly(index).thenRun(() -> this.clearIndexData(index));
    }

    @Nonnull
    public StateCacheabilityOnOpen getStateCacheabilityOnOpen() {
        return this.stateCacheabilityOnOpen;
    }

    @Nonnull
    public CompletableFuture<Boolean> setStateCacheabilityAsync(boolean cacheable) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.setStateCacheabilityAsync(cacheable));
        }
        if (!this.formatVersion.isAtLeast(FormatVersion.CACHEABLE_STATE)) {
            throw this.recordCoreException("cannot mark record store state cacheable at format version " + String.valueOf(this.formatVersion));
        }
        if (this.isStateCacheableInternal() == cacheable) {
            return AsyncUtil.READY_FALSE;
        }
        return this.updateStoreHeaderAsync(headerBuilder -> headerBuilder.setCacheable(cacheable)).thenApply(ignore -> true);
    }

    public boolean setStateCacheability(boolean cacheable) {
        return this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_SET_STATE_CACHEABILITY, this.setStateCacheabilityAsync(cacheable));
    }

    private boolean isStateCacheableInternal() {
        if (this.recordStoreStateRef.get() == null) {
            throw this.uninitializedStoreException("cannot check record store state cacheability on uninitialized store");
        }
        return this.recordStoreStateRef.get().getStoreHeader().getCacheable();
    }

    private void validateCanAccessHeaderUserFields() {
        if (!this.formatVersion.isAtLeast(FormatVersion.HEADER_USER_FIELDS)) {
            throw this.recordCoreException("cannot access header user fields at current format version", new Object[]{LogMessageKeys.FORMAT_VERSION, this.formatVersion});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteString getHeaderUserField(@Nonnull String userField) {
        this.validateCanAccessHeaderUserFields();
        if (this.recordStoreStateRef.get() == null) {
            throw this.uninitializedStoreException("cannot get field from header on uninitialized store");
        }
        this.beginRecordStoreStateRead();
        try {
            RecordMetaDataProto.DataStoreInfo header = this.recordStoreStateRef.get().getStoreHeader();
            for (RecordMetaDataProto.DataStoreInfo.UserFieldEntry userFieldEntry : header.getUserFieldList()) {
                if (!userFieldEntry.getKey().equals(userField)) continue;
                ByteString byteString = userFieldEntry.getValue();
                return byteString;
            }
            Iterator<RecordMetaDataProto.DataStoreInfo.UserFieldEntry> iterator = null;
            return iterator;
        }
        finally {
            this.endRecordStoreStateRead();
        }
    }

    @Nonnull
    public CompletableFuture<Void> setHeaderUserFieldAsync(@Nonnull String userField, @Nonnull ByteString value) {
        return this.updateStoreHeaderAsync(storeHeaderBuilder -> {
            this.validateCanAccessHeaderUserFields();
            boolean found = false;
            for (RecordMetaDataProto.DataStoreInfo.UserFieldEntry.Builder userFieldEntryBuilder : storeHeaderBuilder.getUserFieldBuilderList()) {
                if (!userFieldEntryBuilder.getKey().equals(userField)) continue;
                userFieldEntryBuilder.setValue(value);
                found = true;
            }
            if (!found) {
                storeHeaderBuilder.addUserFieldBuilder().setKey(userField).setValue(value);
            }
            return storeHeaderBuilder;
        });
    }

    @Nonnull
    public CompletableFuture<Void> setHeaderUserFieldAsync(@Nonnull String userField, @Nonnull byte[] value) {
        return this.setHeaderUserFieldAsync(userField, ByteString.copyFrom(value));
    }

    public void setHeaderUserField(@Nonnull String userField, @Nonnull ByteString value) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_EDIT_HEADER_USER_FIELD, this.setHeaderUserFieldAsync(userField, value));
    }

    public void setHeaderUserField(@Nonnull String userField, @Nonnull byte[] value) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_EDIT_HEADER_USER_FIELD, this.setHeaderUserFieldAsync(userField, value));
    }

    @Nonnull
    public CompletableFuture<Void> clearHeaderUserFieldAsync(@Nonnull String userField) {
        return this.updateStoreHeaderAsync(storeHeaderBuilder -> {
            this.validateCanAccessHeaderUserFields();
            for (int i = storeHeaderBuilder.getUserFieldCount() - 1; i >= 0; --i) {
                RecordMetaDataProto.DataStoreInfo.UserFieldEntryOrBuilder userFieldEntry = storeHeaderBuilder.getUserFieldOrBuilder(i);
                if (!userFieldEntry.getKey().equals(userField)) continue;
                storeHeaderBuilder.removeUserField(i);
            }
            return storeHeaderBuilder;
        });
    }

    public void clearHeaderUserField(@Nonnull String userField) {
        this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_EDIT_HEADER_USER_FIELD, this.clearHeaderUserFieldAsync(userField));
    }

    public CompletableFuture<Void> updateRecordCountStateAsync(@Nonnull RecordMetaDataProto.DataStoreInfo.RecordCountState newState) {
        return this.updateStoreHeaderAsync(builder -> {
            boolean toReadable;
            if (!this.getFormatVersionEnum().isAtLeast(FormatVersion.RECORD_COUNT_STATE)) {
                throw new RecordCoreException("Store does not support updating record count state", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, this.getFormatVersionEnum()});
            }
            RecordMetaDataProto.DataStoreInfo.RecordCountState existing = this.getRecordStoreState().getStoreHeader().getRecordCountState();
            if (existing == newState) {
                return builder;
            }
            boolean toWriteOnly = existing == RecordMetaDataProto.DataStoreInfo.RecordCountState.READABLE && newState == RecordMetaDataProto.DataStoreInfo.RecordCountState.WRITE_ONLY;
            boolean bl = toReadable = existing == RecordMetaDataProto.DataStoreInfo.RecordCountState.WRITE_ONLY && newState == RecordMetaDataProto.DataStoreInfo.RecordCountState.READABLE;
            if (toWriteOnly || toReadable || newState == RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
                builder.setRecordCountState(newState);
                if (newState == RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
                    this.ensureContextActive().clear(Range.startsWith(this.getSubspace().pack(Tuple.from(RECORD_COUNT_KEY))));
                }
                return builder;
            }
            throw new RecordCoreException("Invalid state transition for RecordCountState", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.OLD, existing}).addLogInfo(new Object[]{LogMessageKeys.NEW, newState});
        });
    }

    public CompletableFuture<Void> setStoreLockStateAsync(@Nonnull RecordMetaDataProto.DataStoreInfo.StoreLockState.State state, @Nonnull String reason) {
        if (!this.getFormatVersionEnum().isAtLeast(FormatVersion.STORE_LOCK_STATE)) {
            throw new RecordCoreException("Store does not support setting a store lock state", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, this.getFormatVersionEnum()});
        }
        return this.updateStoreHeaderAsync(builder -> builder.setStoreLockState(RecordMetaDataProto.DataStoreInfo.StoreLockState.newBuilder().setLockState(state).setReason(reason).setTimestamp(System.currentTimeMillis())));
    }

    public CompletableFuture<Void> clearStoreLockStateAsync() {
        if (!this.getFormatVersionEnum().isAtLeast(FormatVersion.STORE_LOCK_STATE)) {
            throw new RecordCoreException("Store does not support setting a store lock state", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, this.getFormatVersionEnum()});
        }
        return this.updateStoreHeaderAsync(RecordMetaDataProto.DataStoreInfo.Builder::clearStoreLockState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexState(@Nonnull String indexName, byte[] indexKey, @Nonnull IndexState indexState) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.of("index state change", new Object[]{LogMessageKeys.INDEX_NAME, indexName, LogMessageKeys.TARGET_INDEX_STATE, indexState.name(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
        }
        if (this.recordStoreStateRef.get() == null) {
            throw this.uninitializedStoreException("cannot update index state on an uninitialized store");
        }
        this.beginRecordStoreStateWrite();
        try {
            this.context.setDirtyStoreState(true);
            if (this.isStateCacheableInternal()) {
                this.context.setMetaDataVersionStamp();
            }
            Transaction tr = this.context.ensureActive();
            if (IndexState.READABLE.equals((Object)indexState)) {
                tr.clear(indexKey);
            } else {
                tr.set(indexKey, Tuple.from(indexState.code()).pack());
            }
            this.recordStoreStateRef.updateAndGet(state -> {
                state.setState(indexName, indexState);
                return state;
            });
        }
        finally {
            this.endRecordStoreStateWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Boolean> markIndexNotReadable(@Nonnull String indexName, @Nonnull IndexState indexState) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.markIndexNotReadable(indexName, indexState));
        }
        this.addIndexStateReadConflict(indexName);
        this.beginRecordStoreStateWrite();
        boolean haveFuture = false;
        try {
            byte[] indexKey = this.indexStateSubspace().pack(indexName);
            Transaction tr = this.context.ensureActive();
            CompletionStage future = ((CompletableFuture)tr.get(indexKey).thenCompose(previous -> {
                if (previous == null) {
                    IndexingRangeSet indexRangeSet = IndexingRangeSet.forIndexBuild(this, this.getRecordMetaData().getIndex(indexName));
                    return ((CompletableFuture)indexRangeSet.isEmptyAsync().thenCompose(empty -> {
                        if (empty.booleanValue()) {
                            return indexRangeSet.insertRangeAsync(null, null);
                        }
                        return AsyncUtil.READY_FALSE;
                    })).thenApply(ignore -> {
                        this.updateIndexState(indexName, indexKey, indexState);
                        return true;
                    });
                }
                if (!Tuple.fromBytes(previous).get(0).equals(indexState.code())) {
                    this.updateIndexState(indexName, indexKey, indexState);
                    return AsyncUtil.READY_TRUE;
                }
                return AsyncUtil.READY_FALSE;
            })).whenComplete((b, t2) -> this.endRecordStoreStateWrite());
            haveFuture = true;
            CompletionStage completionStage = future;
            return completionStage;
        }
        finally {
            if (!haveFuture) {
                this.endRecordStoreStateWrite();
            }
        }
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexWriteOnly(@Nonnull String indexName) {
        return this.markIndexNotReadable(indexName, IndexState.WRITE_ONLY);
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexWriteOnly(@Nonnull Index index) {
        return this.markIndexWriteOnly(index.getName());
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexDisabled(@Nonnull String indexName) {
        return this.markIndexDisabled(this.metaDataProvider.getRecordMetaData().getIndex(indexName));
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexDisabled(@Nonnull Index index) {
        return this.markIndexNotReadable(index.getName(), IndexState.DISABLED).thenApply(changed -> {
            if (changed.booleanValue()) {
                this.clearIndexData(index);
            }
            return changed;
        });
    }

    @Nonnull
    public CompletableFuture<Optional<Range>> firstUnbuiltRange(@Nonnull Index index) {
        if (!this.getRecordMetaData().hasIndex(index.getName())) {
            throw new MetaDataException("Index " + index.getName() + " does not exist in meta-data.", new Object[0]);
        }
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(this, index);
        return rangeSet.firstMissingRangeAsync().thenApply(Optional::ofNullable);
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexReadableOrUniquePending(@Nonnull Index index) {
        return this.markIndexReadable(index, true);
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexReadable(@Nonnull Index index) {
        return this.markIndexReadable(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private CompletableFuture<Boolean> markIndexReadable(@Nonnull Index index, boolean allowUniquePending) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.markIndexReadable(index, allowUniquePending));
        }
        this.addIndexStateReadConflict(index.getName());
        this.beginRecordStoreStateWrite();
        boolean haveFuture = false;
        try {
            Transaction tr = this.ensureContextActive();
            byte[] indexKey = this.indexStateSubspace().pack(index.getName());
            CompletionStage future = ((CompletableFuture)((CompletableFuture)tr.get(indexKey).thenCompose(previous -> {
                if (previous != null) {
                    return this.checkAndUpdateBuiltIndexState(index, indexKey, allowUniquePending);
                }
                return AsyncUtil.READY_FALSE;
            })).whenComplete((b, t2) -> this.endRecordStoreStateWrite())).thenApply(this::addRemoveReplacedIndexesCommitCheckIfChanged);
            haveFuture = true;
            CompletionStage completionStage = future;
            return completionStage;
        }
        finally {
            if (!haveFuture) {
                this.endRecordStoreStateWrite();
            }
        }
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexReadable(@Nonnull String indexName) {
        return this.markIndexReadable(this.getRecordMetaData().getIndex(indexName));
    }

    private CompletableFuture<Boolean> checkAndUpdateBuiltIndexState(Index index, byte[] indexKey, boolean allowUniquePending) {
        CompletableFuture<Optional<Range>> builtFuture = this.firstUnbuiltRange(index);
        CompletionStage uniquenessFuture = index.isUnique() ? this.whenAllIndexUniquenessCommitChecks(index).thenCompose(vignore -> this.scanUniquenessViolations(index, 1).first()) : CompletableFuture.completedFuture(Optional.empty());
        return CompletableFuture.allOf(new CompletableFuture[]{builtFuture, uniquenessFuture}).thenApply(vignore -> {
            Optional firstUnbuilt = (Optional)this.context.join(builtFuture);
            Optional uniquenessViolation = (Optional)this.context.join(uniquenessFuture);
            if (firstUnbuilt.isPresent()) {
                throw new IndexNotBuiltException("Attempted to make unbuilt index readable", (Range)firstUnbuilt.get(), new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), "unbuiltRangeBegin", ByteArrayUtil2.loggable(((Range)firstUnbuilt.get()).begin), "unbuiltRangeEnd", ByteArrayUtil2.loggable(((Range)firstUnbuilt.get()).end), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.SUBSPACE_KEY, index.getSubspaceKey()});
            }
            if (uniquenessViolation.isPresent()) {
                if (allowUniquePending) {
                    if (this.isIndexReadableUniquePending(index)) {
                        return false;
                    }
                    this.updateIndexState(index.getName(), indexKey, IndexState.READABLE_UNIQUE_PENDING);
                    return true;
                }
                RecordIndexUniquenessViolation wrapped = new RecordIndexUniquenessViolation("Uniqueness violation when making index readable", (RecordIndexUniquenessViolation)uniquenessViolation.get());
                wrapped.addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
                throw wrapped;
            }
            this.updateIndexState(index.getName(), indexKey, IndexState.READABLE);
            this.clearReadableIndexBuildData(index);
            return true;
        });
    }

    private void logExceptionAsWarn(KeyValueLogMessage message, Throwable exception) {
        if (LOGGER.isWarnEnabled()) {
            for (Throwable ex = exception; ex != null; ex = ex.getCause()) {
                if (!(ex instanceof LoggableException)) continue;
                message.addKeysAndValues(((LoggableException)ex).getLogInfo());
            }
            message.addKeyAndValue((Object)this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context));
            LOGGER.warn(message.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompletableFuture<Boolean> uncheckedMarkIndexReadable(@Nonnull String indexName) {
        if (this.recordStoreStateRef.get() == null) {
            return this.preloadRecordStoreStateAsync().thenCompose(vignore -> this.uncheckedMarkIndexReadable(indexName));
        }
        this.addIndexStateReadConflict(indexName);
        this.beginRecordStoreStateWrite();
        boolean haveFuture = false;
        try {
            Transaction tr = this.ensureContextActive();
            byte[] indexKey = this.indexStateSubspace().pack(indexName);
            CompletionStage future = ((CompletableFuture)((CompletableFuture)tr.get(indexKey).thenApply(previous -> {
                if (previous != null) {
                    this.updateIndexState(indexName, indexKey, IndexState.READABLE);
                    return true;
                }
                return false;
            })).whenComplete((b, t2) -> this.endRecordStoreStateWrite())).thenApply(this::addRemoveReplacedIndexesCommitCheckIfChanged);
            haveFuture = true;
            CompletionStage completionStage = future;
            return completionStage;
        }
        finally {
            if (!haveFuture) {
                this.endRecordStoreStateWrite();
            }
        }
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    protected CompletableFuture<Void> preloadSubspaceAsync() {
        return this.getSubspaceAsync().thenApply(subspace -> null);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    protected CompletableFuture<Void> preloadRecordStoreStateAsync() {
        return this.preloadRecordStoreStateAsync(FDBRecordStoreBase.StoreExistenceCheck.NONE, IsolationLevel.SNAPSHOT, IsolationLevel.SNAPSHOT);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    protected CompletableFuture<Void> preloadRecordStoreStateAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck, @Nonnull IsolationLevel storeHeaderIsolationLevel, @Nonnull IsolationLevel indexStateIsolationLevel) {
        return this.loadRecordStoreStateAsync(existenceCheck, storeHeaderIsolationLevel, indexStateIsolationLevel).thenAccept(state -> {
            if (this.recordStoreStateRef.get() == null) {
                this.recordStoreStateRef.compareAndSet(null, state.toMutable());
            }
        });
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<RecordStoreState> loadRecordStoreStateAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
        return this.loadRecordStoreStateAsync(existenceCheck, IsolationLevel.SERIALIZABLE, IsolationLevel.SNAPSHOT);
    }

    @Nonnull
    private CompletableFuture<RecordStoreState> loadRecordStoreStateAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck, @Nonnull IsolationLevel storeHeaderIsolationLevel, @Nonnull IsolationLevel indexStateIsolationLevel) {
        return this.getSubspaceAsync().thenCompose(subspace -> this.loadRecordStoreStateInternalAsync(existenceCheck, storeHeaderIsolationLevel, indexStateIsolationLevel));
    }

    @Nonnull
    private CompletableFuture<RecordStoreState> loadRecordStoreStateInternalAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck, @Nonnull IsolationLevel storeHeaderIsolationLevel, @Nonnull IsolationLevel indexStateIsolationLevel) {
        CompletableFuture<RecordMetaDataProto.DataStoreInfo> storeHeaderFuture = this.loadStoreHeaderAsync(existenceCheck, storeHeaderIsolationLevel);
        CompletableFuture<Map<String, IndexState>> loadIndexStates = this.loadIndexStatesAsync(indexStateIsolationLevel);
        return this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.LOAD_RECORD_STORE_STATE, storeHeaderFuture.thenCombine(loadIndexStates, RecordStoreState::new));
    }

    @Nonnull
    private CompletableFuture<Map<String, IndexState>> loadIndexStatesAsync(@Nonnull IsolationLevel isolationLevel) {
        Subspace isSubspace = this.getSubspace().subspace(Tuple.from(INDEX_STATE_SPACE_KEY));
        KeyValueCursor cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(isSubspace).setContext(this.getContext())).setRange(TupleRange.ALL)).setContinuation(null)).setScanProperties(new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).setDefaultCursorStreamingMode(CursorStreamingMode.WANT_ALL).build()))).build();
        FDBStoreTimer timer = this.getTimer();
        CompletableFuture result = cursor.asList().thenApply(list -> {
            Map indexStateMap;
            if (list.isEmpty()) {
                indexStateMap = Collections.emptyMap();
            } else {
                ImmutableMap.Builder<String, IndexState> indexStateMapBuilder = ImmutableMap.builder();
                for (KeyValue kv : list) {
                    String indexName = isSubspace.unpack(kv.getKey()).getString(0);
                    Object code = Tuple.fromBytes(kv.getValue()).get(0);
                    indexStateMapBuilder.put(indexName, IndexState.fromCode(code));
                    if (timer == null) continue;
                    timer.increment(FDBStoreTimer.Counts.LOAD_STORE_STATE_KEY);
                    timer.increment(FDBStoreTimer.Counts.LOAD_STORE_STATE_KEY_BYTES, kv.getKey().length);
                    timer.increment(FDBStoreTimer.Counts.LOAD_STORE_STATE_VALUE_BYTES, kv.getValue().length);
                }
                indexStateMap = indexStateMapBuilder.build();
            }
            return indexStateMap;
        });
        if (timer != null) {
            result = timer.instrument(FDBStoreTimer.Events.LOAD_RECORD_STORE_INDEX_META_DATA, result, this.context.getExecutor());
        }
        return result;
    }

    private void addRecordsReadConflict() {
        if (this.recordsReadConflict) {
            return;
        }
        this.recordsReadConflict = true;
        Transaction tr = this.ensureContextActive();
        byte[] recordKey = this.getSubspace().pack(Tuple.from(RECORD_KEY));
        tr.addReadConflictRange(recordKey, ByteArrayUtil.strinc(recordKey));
    }

    private void addIndexStateReadConflict(@Nonnull String indexName) {
        if (!this.getRecordMetaData().hasIndex(indexName)) {
            throw new MetaDataException("Index " + indexName + " does not exist in meta-data.", new Object[0]);
        }
        if (this.indexStateReadConflicts.contains(indexName)) {
            return;
        }
        this.indexStateReadConflicts.add(indexName);
        Transaction tr = this.ensureContextActive();
        byte[] indexStateKey = this.getSubspace().pack(Tuple.from(INDEX_STATE_SPACE_KEY, indexName));
        tr.addReadConflictKey(indexStateKey);
    }

    private void addStoreStateReadConflict() {
        if (this.storeStateReadConflict) {
            return;
        }
        this.storeStateReadConflict = true;
        Transaction tr = this.ensureContextActive();
        byte[] indexStateKey = this.getSubspace().pack(Tuple.from(INDEX_STATE_SPACE_KEY));
        tr.addReadConflictRange(indexStateKey, ByteArrayUtil.strinc(indexStateKey));
    }

    @Nonnull
    public IndexState getIndexState(@Nonnull Index index) {
        return this.getIndexState(index.getName());
    }

    @Nonnull
    public IndexState getIndexState(@Nonnull String indexName) {
        this.addIndexStateReadConflict(indexName);
        return this.getRecordStoreState().getState(indexName);
    }

    public boolean isIndexReadable(@Nonnull Index index) {
        return this.isIndexReadable(index.getName());
    }

    public boolean isIndexReadable(@Nonnull String indexName) {
        return this.getIndexState(indexName).equals((Object)IndexState.READABLE);
    }

    public boolean isIndexReadableUniquePending(@Nonnull Index index) {
        return this.isIndexReadableUniquePending(index.getName());
    }

    public boolean isIndexReadableUniquePending(@Nonnull String indexName) {
        return this.getIndexState(indexName).equals((Object)IndexState.READABLE_UNIQUE_PENDING);
    }

    public boolean isIndexScannable(@Nonnull Index index) {
        return this.isIndexScannable(index.getName());
    }

    public boolean isIndexScannable(@Nonnull String indexName) {
        return this.getIndexState(indexName).isScannable();
    }

    public boolean isIndexWriteOnly(@Nonnull Index index) {
        return this.isIndexWriteOnly(index.getName());
    }

    public boolean isIndexWriteOnly(@Nonnull String indexName) {
        return this.getIndexState(indexName).equals((Object)IndexState.WRITE_ONLY);
    }

    public boolean isIndexDisabled(@Nonnull Index index) {
        return this.isIndexDisabled(index.getName());
    }

    public boolean isIndexDisabled(@Nonnull String indexName) {
        return this.getIndexState(indexName).equals((Object)IndexState.DISABLED);
    }

    public CompletableFuture<IndexBuildState> getIndexBuildStateAsync(Index index) {
        return IndexBuildState.loadIndexBuildStateAsync(this, index);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<IndexBuildProto.IndexBuildIndexingStamp> loadIndexingTypeStampAsync(Index index) {
        byte[] stampKey = IndexingSubspaces.indexBuildTypeSubspace(this, index).pack();
        return this.ensureContextActive().get(stampKey).thenApply(serializedStamp -> {
            if (serializedStamp == null) {
                return null;
            }
            try {
                return IndexBuildProto.IndexBuildIndexingStamp.parseFrom(serializedStamp);
            }
            catch (InvalidProtocolBufferException ex) {
                RecordCoreException protoEx = new RecordCoreException("invalid indexing type stamp", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.ACTUAL, ByteArrayUtil2.loggable(serializedStamp)});
                protoEx.initCause(ex);
                throw protoEx;
            }
        });
    }

    @API(value=API.Status.INTERNAL)
    public void saveIndexingTypeStamp(Index index, IndexBuildProto.IndexBuildIndexingStamp stamp) {
        byte[] stampKey = IndexingSubspaces.indexBuildTypeSubspace(this, index).pack();
        this.ensureContextActive().set(stampKey, stamp.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Index> sanitizeIndexes(@Nonnull List<Index> indexes, @Nonnull Predicate<Index> filter) {
        RecordStoreState localRecordStoreState = this.getRecordStoreState();
        localRecordStoreState.beginRead();
        try {
            if (localRecordStoreState.allIndexesReadable()) {
                indexes.forEach(index -> this.addIndexStateReadConflict(index.getName()));
                List<Index> list = indexes;
                return list;
            }
            List<Index> list = indexes.stream().filter(filter).collect(Collectors.toList());
            return list;
        }
        finally {
            localRecordStoreState.endRead();
        }
    }

    @Nonnull
    public List<Index> getReadableIndexes(@Nonnull RecordTypeOrBuilder recordType) {
        return this.sanitizeIndexes(recordType.getIndexes(), this::isIndexReadable);
    }

    @Nonnull
    public List<Index> getEnabledIndexes(@Nonnull RecordTypeOrBuilder recordType) {
        return this.sanitizeIndexes(recordType.getIndexes(), index -> !this.isIndexDisabled((Index)index));
    }

    @Nonnull
    public List<Index> getReadableMultiTypeIndexes(@Nonnull RecordTypeOrBuilder recordType) {
        return this.sanitizeIndexes(recordType.getMultiTypeIndexes(), this::isIndexReadable);
    }

    @Nonnull
    public List<Index> getEnabledMultiTypeIndexes(@Nonnull RecordTypeOrBuilder recordType) {
        return this.sanitizeIndexes(recordType.getMultiTypeIndexes(), index -> !this.isIndexDisabled((Index)index));
    }

    @Nonnull
    public List<Index> getReadableUniversalIndexes() {
        return this.sanitizeIndexes(this.getRecordMetaData().getUniversalIndexes(), this::isIndexReadable);
    }

    @Nonnull
    public List<Index> getEnabledUniversalIndexes() {
        return this.sanitizeIndexes(this.getRecordMetaData().getUniversalIndexes(), index -> !this.isIndexDisabled((Index)index));
    }

    @Nonnull
    public Map<Index, IndexState> getAllIndexStates() {
        RecordStoreState localRecordStoreState = this.getRecordStoreState();
        localRecordStoreState.beginRead();
        try {
            this.addStoreStateReadConflict();
            Map<Index, IndexState> map = this.getRecordMetaData().getAllIndexes().stream().collect(Collectors.toMap(Function.identity(), localRecordStoreState::getState));
            return map;
        }
        finally {
            localRecordStoreState.endRead();
        }
    }

    @Nonnull
    protected CompletableFuture<Void> rebuildIndexes(@Nonnull Map<Index, List<RecordType>> indexes, @Nonnull Map<Index, CompletableFuture<IndexState>> newStates, @Nonnull List<CompletableFuture<Void>> work, @Nonnull RebuildIndexReason reason, @Nullable Integer oldMetaDataVersion) {
        Iterator<Map.Entry<Index, List<RecordType>>> indexIter = indexes.entrySet().iterator();
        return AsyncUtil.whileTrue(() -> {
            Iterator workIter = work.iterator();
            while (workIter.hasNext()) {
                CompletableFuture workItem = (CompletableFuture)workIter.next();
                if (!workItem.isDone()) continue;
                this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ERROR_CHECK, workItem);
                workIter.remove();
            }
            while (work.size() < 10 && indexIter.hasNext()) {
                Map.Entry indexItem = (Map.Entry)indexIter.next();
                Index index = (Index)indexItem.getKey();
                List recordTypes = (List)indexItem.getValue();
                StringBuilder errMessageBuilder = new StringBuilder("unable to ");
                CompletableFuture rebuildOrMarkIndexSafely = MoreAsyncUtil.handleOnException(() -> newStates.getOrDefault(index, READY_READABLE).thenCompose(indexState -> this.rebuildOrMarkIndex(index, (IndexState)((Object)((Object)((Object)indexState))), recordTypes, reason, oldMetaDataVersion, errMessageBuilder)), exception -> {
                    this.logExceptionAsWarn(KeyValueLogMessage.build(errMessageBuilder.toString(), new Object[]{LogMessageKeys.INDEX_NAME, index.getName()}), (Throwable)exception);
                    return this.markIndexDisabled(index).thenApply(b -> null);
                });
                work.add(rebuildOrMarkIndexSafely);
            }
            if (work.isEmpty()) {
                return AsyncUtil.READY_FALSE;
            }
            return AsyncUtil.whenAny(work).thenApply(v -> true);
        }, this.getExecutor());
    }

    private boolean areAllRecordTypesSince(@Nullable Collection<RecordType> recordTypes, @Nullable Integer oldMetaDataVersion) {
        return oldMetaDataVersion != null && (oldMetaDataVersion == -1 || recordTypes != null && recordTypes.stream().allMatch(recordType -> {
            Integer sinceVersion = recordType.getSinceVersion();
            return sinceVersion != null && sinceVersion > oldMetaDataVersion;
        }));
    }

    protected CompletableFuture<Void> rebuildOrMarkIndex(@Nonnull Index index, @Nonnull IndexState indexState, @Nullable List<RecordType> recordTypes, @Nonnull RebuildIndexReason reason, @Nullable Integer oldMetaDataVersion, @Nonnull StringBuilder errMessageBuilder) {
        if (indexState != IndexState.DISABLED && this.areAllRecordTypesSince(recordTypes, oldMetaDataVersion)) {
            errMessageBuilder.append("rebuild index with no records");
            return this.rebuildIndexWithNoRecord(index, reason);
        }
        switch (indexState) {
            case WRITE_ONLY: {
                errMessageBuilder.append("clear and mark index write only");
                return this.clearAndMarkIndexWriteOnly(index).thenApply(b -> null);
            }
            case DISABLED: {
                errMessageBuilder.append("mark index disabled");
                return this.markIndexDisabled(index).thenApply(b -> null);
            }
        }
        errMessageBuilder.append("rebuild index");
        return this.rebuildIndex(index, reason);
    }

    @Nonnull
    private CompletableFuture<Void> rebuildIndexWithNoRecord(@Nonnull Index index, @Nonnull RebuildIndexReason reason) {
        boolean newStore;
        boolean bl = newStore = reason == RebuildIndexReason.NEW_STORE;
        if (newStore ? LOGGER.isDebugEnabled() : LOGGER.isInfoEnabled()) {
            KeyValueLogMessage msg = KeyValueLogMessage.build("rebuilding index with no record", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_VERSION, index.getLastModifiedVersion(), LogMessageKeys.REASON, reason.name(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.SUBSPACE_KEY, index.getSubspaceKey()});
            if (newStore) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(msg.toString());
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info(msg.toString());
            }
        }
        return this.markIndexReadable(index).thenApply(b -> null);
    }

    @Nonnull
    public CompletableFuture<Void> rebuildIndex(@Nonnull Index index) {
        return this.rebuildIndex(index, RebuildIndexReason.EXPLICIT);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    @VisibleForTesting
    public CompletableFuture<Void> rebuildIndex(@Nonnull Index index, @Nonnull RebuildIndexReason reason) {
        boolean newStore;
        boolean bl = newStore = reason == RebuildIndexReason.NEW_STORE;
        if (newStore ? LOGGER.isDebugEnabled() : LOGGER.isInfoEnabled()) {
            KeyValueLogMessage msg = KeyValueLogMessage.build("rebuilding index", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_VERSION, index.getLastModifiedVersion(), LogMessageKeys.REASON, reason.name(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.SUBSPACE_KEY, index.getSubspaceKey()});
            if (newStore) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(msg.toString());
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info(msg.toString());
            }
        }
        long startTime = System.nanoTime();
        OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this)).setIndex(index).build();
        CompletionStage future = ((CompletableFuture)indexBuilder.rebuildIndexAsync(this).thenCompose(vignore -> this.markIndexReadable(index))).handle((b, t2) -> {
            if (t2 != null) {
                this.logExceptionAsWarn(KeyValueLogMessage.build("rebuilding index failed", new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_VERSION, index.getLastModifiedVersion(), LogMessageKeys.REASON, reason.name(), LogMessageKeys.SUBSPACE_KEY, index.getSubspaceKey()}), (Throwable)t2);
            }
            indexBuilder.close();
            return null;
        });
        return this.context.instrument(FDBStoreTimer.Events.REBUILD_INDEX, this.context.instrument(reason.event, future, startTime), startTime);
    }

    private CompletableFuture<Void> checkPossiblyRebuild(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull RecordMetaDataProto.DataStoreInfo.Builder info, @Nonnull boolean[] dirty) {
        boolean metaDataVersionChanged;
        RecordMetaData metaData;
        int newMetaDataVersion;
        int newFormatVersion;
        int oldFormatVersion = info.getFormatVersion();
        boolean formatVersionChanged = oldFormatVersion != (newFormatVersion = Math.max(oldFormatVersion, this.formatVersion.getValueForSerialization()));
        this.formatVersion = FormatVersion.getFormatVersion(newFormatVersion);
        boolean newStore = oldFormatVersion == 0;
        int oldMetaDataVersion = newStore ? -1 : info.getMetaDataversion();
        if (oldMetaDataVersion > (newMetaDataVersion = (metaData = this.getRecordMetaData()).getVersion())) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new RecordStoreStaleMetaDataVersionException("Local meta-data has stale version", new Object[]{LogMessageKeys.LOCAL_VERSION, newMetaDataVersion, LogMessageKeys.STORED_VERSION, oldMetaDataVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
            return ret;
        }
        boolean bl = metaDataVersionChanged = oldMetaDataVersion != newMetaDataVersion;
        if (!formatVersionChanged && !metaDataVersionChanged) {
            return AsyncUtil.DONE;
        }
        if (LOGGER.isInfoEnabled()) {
            if (newStore) {
                LOGGER.info(KeyValueLogMessage.of("new record store", new Object[]{LogMessageKeys.FORMAT_VERSION, newFormatVersion, LogMessageKeys.META_DATA_VERSION, newMetaDataVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
            } else {
                if (formatVersionChanged) {
                    LOGGER.info(KeyValueLogMessage.of("format version changed", new Object[]{LogMessageKeys.OLD_VERSION, oldFormatVersion, LogMessageKeys.NEW_VERSION, newFormatVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
                if (metaDataVersionChanged) {
                    LOGGER.info(KeyValueLogMessage.of("meta-data version changed", new Object[]{LogMessageKeys.OLD_VERSION, oldMetaDataVersion, LogMessageKeys.NEW_VERSION, newMetaDataVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
            }
        }
        dirty[0] = true;
        return this.checkRebuild(userVersionChecker, info, metaData);
    }

    private CompletableFuture<Void> checkRebuild(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull RecordMetaDataProto.DataStoreInfo.Builder info, @Nonnull RecordMetaData metaData) {
        boolean metaDataVersionChanged;
        LinkedList<CompletableFuture<Void>> work = new LinkedList<CompletableFuture<Void>>();
        int oldFormatVersion = info.getFormatVersion();
        if (oldFormatVersion != this.formatVersion.getValueForSerialization()) {
            info.setFormatVersion(this.formatVersion.getValueForSerialization());
            if (oldFormatVersion >= MIN_FORMAT_VERSION && oldFormatVersion < SAVE_UNSPLIT_WITH_SUFFIX_FORMAT_VERSION && this.formatVersion.isAtLeast(FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX) && !metaData.isSplitLongRecords()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of("unsplit records stored at old format", new Object[]{LogMessageKeys.OLD_VERSION, oldFormatVersion, LogMessageKeys.NEW_VERSION, this.formatVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
                info.setOmitUnsplitRecordSuffix(true);
                this.omitUnsplitRecordSuffix = true;
            }
            if (oldFormatVersion >= MIN_FORMAT_VERSION && oldFormatVersion < SAVE_VERSION_WITH_RECORD_FORMAT_VERSION && metaData.isStoreRecordVersions() && !this.useOldVersionFormat()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of("migrating record versions to new format", new Object[]{LogMessageKeys.OLD_VERSION, oldFormatVersion, LogMessageKeys.NEW_VERSION, this.formatVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
                this.addConvertRecordVersions(work);
            }
        }
        boolean newStore = oldFormatVersion == 0;
        int oldMetaDataVersion = newStore ? -1 : info.getMetaDataversion();
        int newMetaDataVersion = metaData.getVersion();
        boolean bl = metaDataVersionChanged = oldMetaDataVersion != newMetaDataVersion;
        if (metaDataVersionChanged) {
            if (!metaData.isStoreRecordVersions() && !newStore && FDBRecordStore.useOldVersionFormat(oldFormatVersion, this.omitUnsplitRecordSuffix)) {
                Transaction tr = this.ensureContextActive();
                tr.clear(this.getSubspace().subspace(Tuple.from(RECORD_VERSION_KEY)).range());
            }
            info.setMetaDataversion(newMetaDataVersion);
        }
        boolean rebuildRecordCounts = this.checkPossiblyRebuildRecordCounts(metaData, info, work, oldFormatVersion);
        if (!metaDataVersionChanged) {
            return work.isEmpty() ? AsyncUtil.DONE : AsyncUtil.whenReady((CompletableFuture)work.get(0));
        }
        for (FormerIndex formerIndex : metaData.getFormerIndexesSince(oldMetaDataVersion)) {
            this.removeFormerIndex(formerIndex);
        }
        return this.checkRebuildIndexes(userVersionChecker, info, oldFormatVersion, metaData, oldMetaDataVersion, rebuildRecordCounts, work);
    }

    private CompletableFuture<Void> checkRebuildIndexes(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull RecordMetaDataProto.DataStoreInfo.Builder info, int oldFormatVersion, @Nonnull RecordMetaData metaData, int oldMetaDataVersion, boolean rebuildRecordCounts, List<CompletableFuture<Void>> work) {
        boolean newStore = oldFormatVersion == 0;
        Map<Index, List<RecordType>> indexes = metaData.getIndexesToBuildSince(oldMetaDataVersion);
        this.handleNoLongerUniqueIndex(metaData, work, indexes);
        if (!indexes.isEmpty()) {
            RecordType singleRecordTypeWithPrefixKey = this.singleRecordTypeWithPrefixKey(indexes);
            AtomicLong recordCountRef = new AtomicLong(-1L);
            Supplier<CompletableFuture<Long>> lazyRecordCount = FDBRecordStore.getAndRememberFutureLong(recordCountRef, () -> this.getRecordCountForRebuildIndexes(newStore, rebuildRecordCounts, indexes, singleRecordTypeWithPrefixKey));
            AtomicLong recordsSizeRef = new AtomicLong(-1L);
            Supplier<CompletableFuture<Long>> lazyRecordsSize = FDBRecordStore.getAndRememberFutureLong(recordsSizeRef, () -> this.getRecordSizeForRebuildIndexes(singleRecordTypeWithPrefixKey));
            if (singleRecordTypeWithPrefixKey == null && this.formatVersion.isAtLeast(FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX) && this.omitUnsplitRecordSuffix) {
                work.add((CompletableFuture<Void>)lazyRecordCount.get().thenAccept(recordCount -> {
                    if (recordCount == 0L) {
                        if (newStore ? LOGGER.isDebugEnabled() : LOGGER.isInfoEnabled()) {
                            KeyValueLogMessage msg = KeyValueLogMessage.build("upgrading unsplit format on empty store", new Object[]{LogMessageKeys.NEW_FORMAT_VERSION, this.formatVersion, this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
                            if (newStore) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(msg.toString());
                                }
                            } else if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(msg.toString());
                            }
                        }
                        this.omitUnsplitRecordSuffix = !this.formatVersion.isAtLeast(FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX);
                        info.clearOmitUnsplitRecordSuffix();
                        this.addRecordsReadConflict();
                    }
                }));
            }
            Map<Index, CompletableFuture<IndexState>> newStates = this.getStatesForRebuildIndexes(userVersionChecker, indexes, lazyRecordCount, lazyRecordsSize, newStore, oldMetaDataVersion, oldFormatVersion);
            return this.rebuildIndexes(indexes, newStates, work, newStore ? RebuildIndexReason.NEW_STORE : RebuildIndexReason.FEW_RECORDS, oldMetaDataVersion).thenRun(() -> {
                this.maybeLogIndexesNeedingRebuilding(newStates, recordCountRef, recordsSizeRef, rebuildRecordCounts, newStore);
                this.context.increment(FDBStoreTimer.Counts.INDEXES_NEED_REBUILDING, newStates.entrySet().size());
            });
        }
        return work.isEmpty() ? AsyncUtil.DONE : AsyncUtil.whenAll(work);
    }

    private void handleNoLongerUniqueIndex(@Nonnull RecordMetaData metaData, @Nonnull List<CompletableFuture<Void>> work, @Nonnull Map<Index, List<RecordType>> indexesToBuildSince) {
        for (Index index : metaData.getAllIndexes()) {
            IndexState indexState;
            if (indexesToBuildSince.containsKey(index) || index.isUnique() || (indexState = this.getIndexState(index)) != IndexState.READABLE_UNIQUE_PENDING && indexState != IndexState.WRITE_ONLY) continue;
            CompletionStage uniquenessFuture = AsyncUtil.getAll(this.getRecordContext().removeCommitChecks(commitCheck -> {
                if (commitCheck instanceof IndexUniquenessCommitCheck) {
                    return ((IndexUniquenessCommitCheck)commitCheck).getIndexSubspace().equals(this.indexSubspace(index));
                }
                return false;
            }, err -> err instanceof RecordIndexUniquenessViolation)).thenCompose(vignore -> this.getIndexMaintainer(index).clearUniquenessViolations());
            if (indexState == IndexState.READABLE_UNIQUE_PENDING) {
                work.add((CompletableFuture<Void>)((CompletableFuture)((CompletableFuture)uniquenessFuture).thenCompose(vignore -> this.markIndexReadable(index, false))).thenApply(vignore2 -> null));
                continue;
            }
            work.add((CompletableFuture<Void>)uniquenessFuture);
        }
    }

    private static Supplier<CompletableFuture<Long>> getAndRememberFutureLong(@Nonnull AtomicLong ref, @Nonnull Supplier<CompletableFuture<Long>> lazyFuture) {
        return Suppliers.memoize(() -> ((CompletableFuture)lazyFuture.get()).whenComplete((val, err) -> {
            if (err == null) {
                ref.set((long)val);
            }
        }));
    }

    @Nonnull
    protected CompletableFuture<Long> getRecordCountForRebuildIndexes(boolean newStore, boolean rebuildRecordCounts, @Nonnull Map<Index, List<RecordType>> indexes, @Nullable RecordType singleRecordTypeWithPrefixKey) {
        IndexQueryabilityFilter indexQueryabilityFilter = index -> !indexes.containsKey(index);
        if (singleRecordTypeWithPrefixKey != null) {
            try {
                return this.getSnapshotRecordCountForRecordType(singleRecordTypeWithPrefixKey.getName(), indexQueryabilityFilter);
            }
            catch (RecordCoreException recordCoreException) {
                // empty catch block
            }
        }
        if (!rebuildRecordCounts) {
            try {
                return this.getSnapshotRecordCount(EmptyKeyExpression.EMPTY, Key.Evaluated.EMPTY, indexQueryabilityFilter);
            }
            catch (RecordCoreException recordCoreException) {
                // empty catch block
            }
        }
        ExecuteProperties executeProperties = ExecuteProperties.newBuilder().setReturnedRowLimit(1).setIsolationLevel(IsolationLevel.SNAPSHOT).build();
        ScanProperties scanProperties = new ScanProperties(executeProperties);
        RecordCursor records = singleRecordTypeWithPrefixKey == null ? this.scanRecords(null, scanProperties) : this.scanRecords(TupleRange.allOf(singleRecordTypeWithPrefixKey.getRecordTypeKeyTuple()), null, scanProperties);
        return records.onNext().thenApply(result -> {
            if (result.hasNext()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.of("version check scan found non-empty store", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
                }
                return Long.MAX_VALUE;
            }
            if (newStore ? LOGGER.isDebugEnabled() : LOGGER.isInfoEnabled()) {
                KeyValueLogMessage msg = KeyValueLogMessage.build("version check scan found empty store", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
                if (newStore) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(msg.toString());
                    }
                } else if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(msg.toString());
                }
            }
            return 0L;
        });
    }

    @Nonnull
    private CompletableFuture<Long> getRecordSizeForRebuildIndexes(@Nullable RecordType singleRecordTypeWithPrefixKey) {
        if (singleRecordTypeWithPrefixKey == null) {
            return this.estimateRecordsSizeAsync();
        }
        return this.estimateRecordsSizeAsync(TupleRange.allOf(singleRecordTypeWithPrefixKey.getRecordTypeKeyTuple()));
    }

    @Nullable
    protected RecordType singleRecordTypeWithPrefixKey(@Nonnull Map<Index, List<RecordType>> indexes) {
        RecordType recordType = null;
        for (List<RecordType> entry : indexes.values()) {
            RecordType type1;
            List<RecordType> types;
            Collection<RecordType> collection = types = entry != null ? entry : this.getRecordMetaData().getRecordTypes().values();
            if (types.size() != 1) {
                return null;
            }
            RecordType recordType2 = type1 = entry != null ? entry.get(0) : (RecordType)types.iterator().next();
            if (recordType == null) {
                if (!type1.primaryKeyHasRecordTypePrefix()) {
                    return null;
                }
                recordType = type1;
                continue;
            }
            if (type1 == recordType) continue;
            return null;
        }
        return recordType;
    }

    private void addConvertRecordVersions(@Nonnull List<CompletableFuture<Void>> work) {
        if (this.useOldVersionFormat()) {
            throw this.recordCoreException("attempted to convert record versions when still using older format");
        }
        Subspace legacyVersionSubspace = this.getLegacyVersionSubspace();
        KeyValueCursor kvCursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(legacyVersionSubspace).setContext(this.getRecordContext())).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
        CompletionStage workFuture = kvCursor.forEach(kv -> {
            Tuple primaryKey = legacyVersionSubspace.unpack(kv.getKey());
            FDBRecordVersion version = FDBRecordVersion.fromBytes(kv.getValue(), false);
            byte[] newKeyBytes = this.getSubspace().pack(this.recordVersionKey(primaryKey));
            byte[] newValueBytes = SplitHelper.packVersion(version);
            this.ensureContextActive().set(newKeyBytes, newValueBytes);
        }).thenAccept(ignore -> this.ensureContextActive().clear(legacyVersionSubspace.range()));
        work.add((CompletableFuture<Void>)workFuture);
    }

    @API(value=API.Status.INTERNAL)
    @VisibleForTesting
    public Subspace getLegacyVersionSubspace() {
        return this.getSubspace().subspace(Tuple.from(RECORD_VERSION_KEY));
    }

    @Nonnull
    protected Map<Index, CompletableFuture<IndexState>> getStatesForRebuildIndexes(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker, @Nonnull Map<Index, List<RecordType>> indexes, @Nonnull Supplier<CompletableFuture<Long>> lazyRecordCount, @Nonnull Supplier<CompletableFuture<Long>> lazyRecordsSize, boolean newStore, int oldMetaDataVersion, int oldFormatVersion) {
        HashMap<Index, CompletableFuture<IndexState>> newStates = new HashMap<Index, CompletableFuture<IndexState>>();
        for (Map.Entry<Index, List<RecordType>> entry : indexes.entrySet()) {
            CompletionStage<IndexState> stateFuture;
            Index index = entry.getKey();
            List<RecordType> recordTypes = entry.getValue();
            boolean indexOnNewRecordTypes = this.areAllRecordTypesSince(recordTypes, oldMetaDataVersion);
            CompletableFuture<IndexState> completableFuture = stateFuture = userVersionChecker == null ? lazyRecordCount.get().thenApply(recordCount -> FDBRecordStore.disabledIfTooManyRecordsForRebuild(recordCount, indexOnNewRecordTypes)) : userVersionChecker.needRebuildIndex(index, lazyRecordCount, lazyRecordsSize, indexOnNewRecordTypes);
            if ("version".equals(index.getType()) && !newStore && oldFormatVersion < SAVE_VERSION_WITH_RECORD_FORMAT_VERSION && !this.useOldVersionFormat()) {
                stateFuture = stateFuture.thenApply(state -> {
                    if (IndexState.READABLE.equals(state)) {
                        return IndexState.DISABLED;
                    }
                    return state;
                });
            }
            newStates.put(index, (CompletableFuture<IndexState>)stateFuture);
        }
        return newStates;
    }

    private void maybeLogIndexesNeedingRebuilding(@Nonnull Map<Index, CompletableFuture<IndexState>> newStates, @Nonnull AtomicLong recordCountRef, @Nonnull AtomicLong recordsSizeRef, boolean rebuildRecordCounts, boolean newStore) {
        if (LOGGER.isDebugEnabled()) {
            long recordsSize;
            KeyValueLogMessage msg = KeyValueLogMessage.build("indexes need rebuilding", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
            long recordCount = recordCountRef.get();
            if (recordCount >= 0L) {
                msg.addKeyAndValue((Object)LogMessageKeys.RECORD_COUNT, recordCount == Long.MAX_VALUE ? "unknown" : Long.toString(recordCount));
            }
            if ((recordsSize = recordsSizeRef.get()) >= 0L) {
                msg.addKeyAndValue((Object)LogMessageKeys.RECORDS_SIZE_ESTIMATE, Long.toString(recordsSize));
            }
            if (rebuildRecordCounts) {
                msg.addKeyAndValue((Object)LogMessageKeys.REBUILD_RECORD_COUNTS, "true");
            }
            HashMap<String, List> stateNames = new HashMap<String, List>();
            for (Map.Entry<Index, CompletableFuture<IndexState>> stateEntry : newStates.entrySet()) {
                String stateName = MoreAsyncUtil.isCompletedNormally(stateEntry.getValue()) ? stateEntry.getValue().join().getLogName() : "UNKNOWN";
                stateNames.compute(stateName, (key, names) -> {
                    if (names == null) {
                        names = new ArrayList<String>();
                    }
                    names.add(((Index)stateEntry.getKey()).getName());
                    return names;
                });
            }
            msg.addKeysAndValues(stateNames);
            if (newStore) {
                msg.addKeyAndValue((Object)LogMessageKeys.NEW_STORE, "true");
            }
            LOGGER.debug(msg.toString());
        }
    }

    void clearIndexData(@Nonnull Index index) {
        this.context.clear(Range.startsWith(this.indexSubspace(index).pack()));
        this.context.clear(this.indexSecondarySubspace(index).range());
        IndexingRangeSet.forIndexBuild(this, index).clear();
        this.context.clear(this.indexUniquenessViolationsSubspace(index).range());
        IndexingSubspaces.eraseAllIndexingDataButTheLock(this.context, this, index);
    }

    public void removeFormerIndex(FormerIndex formerIndex) {
        if (LOGGER.isDebugEnabled()) {
            KeyValueLogMessage msg = KeyValueLogMessage.build("removing index", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context), LogMessageKeys.SUBSPACE_KEY, formerIndex.getSubspaceKey()});
            if (formerIndex.getFormerName() != null) {
                msg.addKeyAndValue((Object)LogMessageKeys.INDEX_NAME, formerIndex.getFormerName());
            }
            LOGGER.debug(msg.toString());
        }
        long startTime = System.nanoTime();
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_KEY, formerIndex.getSubspaceTupleKey())));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_SECONDARY_SPACE_KEY, formerIndex.getSubspaceTupleKey())));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_RANGE_SPACE_KEY, formerIndex.getSubspaceTupleKey())));
        this.context.clear(this.getSubspace().pack(Tuple.from(INDEX_STATE_SPACE_KEY, formerIndex.getSubspaceTupleKey())));
        this.context.clear(this.getSubspace().range(Tuple.from(INDEX_UNIQUENESS_VIOLATIONS_KEY, formerIndex.getSubspaceTupleKey())));
        if (this.getTimer() != null) {
            this.getTimer().recordSinceNanoTime(FDBStoreTimer.Events.REMOVE_FORMER_INDEX, startTime);
        }
    }

    private void clearReadableIndexBuildData(Index index) {
        IndexingRangeSet.forIndexBuild(this, index).clear();
        IndexingHeartbeat.clearAllHeartbeats(this, index);
    }

    public void vacuumReadableIndexesBuildData() {
        Map<Index, IndexState> indexStates = this.getAllIndexStates();
        for (Map.Entry<Index, IndexState> entry : indexStates.entrySet()) {
            if (!entry.getValue().equals((Object)IndexState.READABLE)) continue;
            this.clearReadableIndexBuildData(entry.getKey());
        }
    }

    protected boolean checkPossiblyRebuildRecordCounts(@Nonnull RecordMetaData metaData, @Nonnull RecordMetaDataProto.DataStoreInfo.Builder info, @Nonnull List<CompletableFuture<Void>> work, int oldFormatVersion) {
        boolean rebuildRecordCounts;
        boolean existingStore = oldFormatVersion > 0;
        KeyExpression countKeyExpression = metaData.getRecordCountKey();
        boolean bl = rebuildRecordCounts = existingStore && oldFormatVersion < RECORD_COUNT_ADDED_FORMAT_VERSION || countKeyExpression != null && this.formatVersion.isAtLeast(FormatVersion.RECORD_COUNT_KEY_ADDED) && (!info.hasRecordCountKey() || !KeyExpression.fromProto(info.getRecordCountKey()).equals(countKeyExpression)) || countKeyExpression == null && info.hasRecordCountKey();
        if (rebuildRecordCounts) {
            if (existingStore) {
                this.context.clear(this.getSubspace().range(Tuple.from(RECORD_COUNT_KEY)));
            }
            if (this.formatVersion.isAtLeast(FormatVersion.RECORD_COUNT_KEY_ADDED)) {
                if (countKeyExpression != null) {
                    info.setRecordCountKey(countKeyExpression.toKeyExpression());
                } else {
                    info.clearRecordCountKey();
                }
            }
            if (existingStore) {
                this.addRebuildRecordCountsJob(work);
            }
        }
        return rebuildRecordCounts;
    }

    public void addRebuildRecordCountsJob(List<CompletableFuture<Void>> work) {
        KeyExpression recordCountKey = this.getRecordMetaData().getRecordCountKey();
        if (recordCountKey == null || this.getRecordStoreState().getStoreHeader().getRecordCountState() == RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of("recounting all records", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)}));
        }
        HashMap counts = new HashMap();
        RecordCursor records = this.scanRecords(null, ScanProperties.FORWARD_SCAN);
        CompletableFuture future = records.forEach(rec -> {
            Key.Evaluated subkey = recordCountKey.evaluateSingleton(rec);
            counts.compute(subkey, (k, v) -> v == null ? 1L : v + 1L);
        }).thenApply(vignore -> {
            Transaction tr = this.ensureContextActive();
            byte[] bytes = new byte[8];
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            for (Map.Entry entry : counts.entrySet()) {
                buf.putLong((Long)entry.getValue());
                tr.set(this.getSubspace().pack(Tuple.from(RECORD_COUNT_KEY).addAll(((Key.Evaluated)entry.getKey()).toTupleAppropriateList())), bytes);
                buf.clear();
            }
            return null;
        });
        future = this.context.instrument((StoreTimer.Event)FDBStoreTimer.Events.RECOUNT_RECORDS, future);
        work.add(future);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public RecordCursor<Tuple> getPrimaryKeyBoundaries(@Nonnull Tuple low, @Nonnull Tuple high) {
        return this.getPrimaryKeyBoundaries(this.recordsSubspace().pack(low), this.recordsSubspace().pack(high));
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public RecordCursor<Tuple> getPrimaryKeyBoundaries(@Nullable TupleRange tupleRange) {
        if (tupleRange == null) {
            tupleRange = TupleRange.ALL;
        }
        Range range = tupleRange.toRange(this.recordsSubspace());
        return this.getPrimaryKeyBoundaries(range.begin, range.end);
    }

    private RecordCursor<Tuple> getPrimaryKeyBoundaries(byte[] rangeStart, byte[] rangeEnd) {
        Transaction transaction = this.ensureContextActive();
        CloseableAsyncIterator<byte[]> cursor = this.context.getDatabase().getLocalityProvider().getBoundaryKeys(transaction, rangeStart, rangeEnd);
        boolean hasSplitRecordSuffix = this.hasSplitRecordSuffix();
        DistinctFilterCursorClosure closure = new DistinctFilterCursorClosure();
        return RecordCursor.flatMapPipelined(ignore -> RecordCursor.fromIterator(this.getExecutor(), cursor), (result, ignore) -> RecordCursor.fromIterator(this.getExecutor(), transaction.snapshot().getRange((byte[])result, rangeEnd, 1).iterator()), null, 10).map(keyValue -> {
            Tuple recordKey = this.recordsSubspace().unpack(keyValue.getKey());
            return hasSplitRecordSuffix ? recordKey.popBack() : recordKey;
        }).filter(closure::pred);
    }

    @Nonnull
    public CompletableFuture<byte[]> repairRecordKeys(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.repairRecordKeys(continuation, scanProperties, false);
    }

    @Nonnull
    public CompletableFuture<byte[]> repairRecordKeys(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, boolean isDryRun) {
        if (this.getRecordMetaData().isSplitLongRecords()) {
            return CompletableFuture.completedFuture(null);
        }
        if (scanProperties.getExecuteProperties().getIsolationLevel().isSnapshot()) {
            throw new RecordCoreArgumentException("Cannot repair record key split markers at SNAPSHOT isolation level", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SCAN_PROPERTIES, scanProperties}).addLogInfo(new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
        }
        Subspace recordSubspace = this.recordsSubspace();
        KeyValueCursor cursor = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.withSubspace(recordSubspace).setContext(this.getRecordContext())).setContinuation(continuation)).setScanProperties(scanProperties)).build();
        AtomicReference nextContinuation = new AtomicReference();
        FDBRecordContext context = this.getContext();
        return AsyncUtil.whileTrue(() -> cursor.onNext().thenApply(result -> {
            if (!result.hasNext()) {
                if (result.hasStoppedBeforeEnd()) {
                    nextContinuation.set(result.getContinuation().toBytes());
                }
                return false;
            }
            this.repairRecordKeyIfNecessary(context, recordSubspace, (KeyValue)result.get(), isDryRun);
            return true;
        })).thenApply(ignored -> (byte[])nextContinuation.get());
    }

    private void repairRecordKeyIfNecessary(@Nonnull FDBRecordContext context, @Nonnull Subspace recordSubspace, @Nonnull KeyValue keyValue, boolean isDryRun) {
        RecordMetaData metaData = this.metaDataProvider.getRecordMetaData();
        Tuple recordKey = recordSubspace.unpack(keyValue.getKey());
        if (metaData.isStoreRecordVersions() && this.isMaybeVersion(recordKey)) {
            return;
        }
        Message protoRecord = this.serializer.deserialize(metaData, recordKey, keyValue.getValue(), this.getTimer());
        RecordType recordType = metaData.getRecordTypeForDescriptor(protoRecord.getDescriptorForType());
        KeyExpression primaryKeyExpression = recordType.getPrimaryKey();
        if (recordKey.size() == primaryKeyExpression.getColumnSize()) {
            context.increment(FDBStoreTimer.Counts.REPAIR_RECORD_KEY);
            Tuple newPrimaryKey = recordKey.add(0L);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Repairing primary key", new Object[]{LogMessageKeys.RECORD_TYPE, recordType.getName(), this.subspaceProvider.logKey(), this.subspaceProvider.toString(context), "dry_run", isDryRun, "orig_primary_key", recordKey, "new_primary_key", newPrimaryKey}));
            }
            if (!isDryRun) {
                Transaction tr = context.ensureActive();
                tr.clear(keyValue.getKey());
                tr.set(recordSubspace.pack(newPrimaryKey), keyValue.getValue());
            }
        } else if (recordKey.size() == primaryKeyExpression.getColumnSize() + 1) {
            Object suffix = recordKey.get(recordKey.size() - 1);
            if (!(suffix instanceof Long) || (Long)suffix != 0L) {
                context.increment(FDBStoreTimer.Counts.INVALID_SPLIT_SUFFIX);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(KeyValueLogMessage.of("Invalid split suffix", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(context), LogMessageKeys.RECORD_TYPE, recordType.getName(), LogMessageKeys.PRIMARY_KEY, recordKey}));
                }
            }
        } else {
            context.increment(FDBStoreTimer.Counts.INVALID_KEY_LENGTH);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of("Invalid key length", new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(context), LogMessageKeys.RECORD_TYPE, recordType.getName(), LogMessageKeys.PRIMARY_KEY, recordKey}));
            }
        }
    }

    private boolean isMaybeVersion(Tuple recordKey) {
        Object suffix = recordKey.get(recordKey.size() - 1);
        return suffix instanceof Long && (Long)suffix == -1L;
    }

    @Nonnull
    private RecordCoreException recordCoreException(@Nonnull String msg) {
        return new RecordCoreException(msg, new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
    }

    @Nonnull
    private RecordCoreException recordCoreException(@Nonnull String msg, Object ... keysAndValues) {
        RecordCoreException err = new RecordCoreException(msg, keysAndValues);
        err.addLogInfo(this.subspaceProvider.logKey().toString(), (Object)this.subspaceProvider.toString(this.context));
        return err;
    }

    @Nonnull
    private UninitializedRecordStoreException uninitializedStoreException(@Nonnull String msg) {
        return new UninitializedRecordStoreException(msg, new Object[]{this.subspaceProvider.logKey(), this.subspaceProvider.toString(this.context)});
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public synchronized IndexDeferredMaintenanceControl getIndexDeferredMaintenanceControl() {
        if (this.indexDeferredMaintenanceControl == null) {
            this.indexDeferredMaintenanceControl = new IndexDeferredMaintenanceControl();
        }
        return this.indexDeferredMaintenanceControl;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public Builder asBuilder() {
        return new Builder(this);
    }

    private static /* synthetic */ KeyValue lambda$readStoreFirstKey$81(AsyncIterator iterator, Boolean hasNext) {
        return hasNext != false ? (KeyValue)iterator.next() : null;
    }

    public static enum StateCacheabilityOnOpen {
        DEFAULT(false, false),
        CACHEABLE_IF_NEW(false, true),
        NOT_CACHEABLE(true, false),
        CACHEABLE(true, true);

        private final boolean updateExistingStores;
        private final boolean cacheable;

        private StateCacheabilityOnOpen(boolean updateExistingStores, boolean cacheable) {
            this.updateExistingStores = updateExistingStores;
            this.cacheable = cacheable;
        }

        public boolean isUpdateExistingStores() {
            return this.updateExistingStores;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }
    }

    class RecordsWhereDeleter {
        @Nonnull
        final RecordMetaData recordMetaData;
        @Nullable
        final RecordType recordType;
        @Nonnull
        final QueryComponent component;
        @Nullable
        final QueryComponent typelessComponent;
        @Nonnull
        final QueryToKeyMatcher matcher;
        @Nullable
        final QueryToKeyMatcher indexMatcher;
        @Nonnull
        final Collection<RecordType> allRecordTypes;
        @Nonnull
        final Collection<Index> allIndexes;
        @Nonnull
        final List<IndexMaintainer> indexMaintainers;
        @Nullable
        final Key.Evaluated evaluated;
        @Nullable
        final Key.Evaluated indexEvaluated;

        public RecordsWhereDeleter(QueryComponent component) {
            this.component = component;
            RecordTypeKeyComparison recordTypeKeyComparison = null;
            QueryComponent remainingComponent = null;
            if (component instanceof RecordTypeKeyComparison) {
                recordTypeKeyComparison = (RecordTypeKeyComparison)component;
            } else if (component instanceof AndComponent && ((AndComponent)component).getChildren().stream().anyMatch(c -> c instanceof RecordTypeKeyComparison)) {
                ArrayList remainingChildren = new ArrayList(((AndComponent)component).getChildren());
                Iterator iter = remainingChildren.iterator();
                while (iter.hasNext()) {
                    QueryComponent child = (QueryComponent)iter.next();
                    if (!(child instanceof RecordTypeKeyComparison)) continue;
                    recordTypeKeyComparison = (RecordTypeKeyComparison)child;
                    iter.remove();
                }
                remainingComponent = remainingChildren.size() == 1 ? (QueryComponent)remainingChildren.get(0) : Query.and(remainingChildren);
            }
            if (recordTypeKeyComparison != null && !FDBRecordStore.this.getRecordMetaData().primaryKeyHasRecordTypePrefix()) {
                throw FDBRecordStore.this.recordCoreException("record type version of deleteRecordsWhere can only be used when all record types have a type prefix");
            }
            this.matcher = new QueryToKeyMatcher(component);
            this.recordMetaData = FDBRecordStore.this.getRecordMetaData();
            if (recordTypeKeyComparison == null) {
                this.indexMatcher = this.matcher;
                this.allRecordTypes = this.recordMetaData.getRecordTypes().values();
                this.allIndexes = this.recordMetaData.getAllIndexes();
                this.recordType = null;
                this.typelessComponent = component;
            } else {
                this.recordType = this.recordMetaData.getRecordType(recordTypeKeyComparison.getName());
                this.indexMatcher = remainingComponent == null ? null : new QueryToKeyMatcher(remainingComponent);
                this.allRecordTypes = Collections.singletonList(this.recordType);
                List<Index> recordTypeIndexes = this.recordType.getAllIndexes();
                this.allIndexes = new LinkedHashSet<Index>(recordTypeIndexes);
                for (SyntheticRecordType<?> syntheticType : this.recordMetaData.getSyntheticRecordTypes().values()) {
                    if (!syntheticType.getConstituents().stream().anyMatch(c -> c.getRecordType().equals(this.recordType))) continue;
                    this.allIndexes.addAll(syntheticType.getAllIndexes());
                }
                this.typelessComponent = remainingComponent;
            }
            this.indexMaintainers = this.allIndexes.stream().filter(index -> !FDBRecordStore.this.isIndexDisabled((Index)index)).map(FDBRecordStore.this::getIndexMaintainer).collect(Collectors.toList());
            this.evaluated = this.deleteRecordsWhereCheckRecordTypes();
            this.indexEvaluated = recordTypeKeyComparison == null ? this.evaluated : Key.Evaluated.concatenate(this.evaluated.values().subList(1, this.evaluated.values().size()));
            this.deleteRecordsWhereCheckIndexes();
        }

        private Key.Evaluated deleteRecordsWhereCheckRecordTypes() {
            Key.Evaluated evaluated = null;
            for (RecordType recordType : this.allRecordTypes) {
                QueryToKeyMatcher.Match match = this.matcher.matchesSatisfyingQuery(recordType.getPrimaryKey());
                if (match.getType() != QueryToKeyMatcher.MatchType.EQUALITY) {
                    throw new Query.InvalidExpressionException("deleteRecordsWhere not matching primary key " + recordType.getName());
                }
                if (evaluated == null) {
                    evaluated = match.getEquality(FDBRecordStore.this, EvaluationContext.EMPTY);
                    continue;
                }
                if (evaluated.equals(match.getEquality(FDBRecordStore.this, EvaluationContext.EMPTY))) continue;
                throw FDBRecordStore.this.recordCoreException("Primary key prefixes don't align", "initialPrefix", evaluated, "secondPrefix", match.getEquality(FDBRecordStore.this, EvaluationContext.EMPTY), "recordType", recordType.getName());
            }
            if (evaluated == null) {
                return null;
            }
            KeyExpression recordCountKey = FDBRecordStore.this.getRecordMetaData().getRecordCountKey();
            if (recordCountKey != null && FDBRecordStore.this.recordStoreStateRef.get().getStoreHeader().getRecordCountState() != RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
                QueryToKeyMatcher.Match match = this.matcher.matchesSatisfyingQuery(recordCountKey);
                if (match.getType() != QueryToKeyMatcher.MatchType.EQUALITY) {
                    throw new Query.InvalidExpressionException("Record count key not matching for deleteRecordsWhere");
                }
                Key.Evaluated subkey = match.getEquality(FDBRecordStore.this, EvaluationContext.EMPTY);
                if (!evaluated.equals(subkey)) {
                    throw FDBRecordStore.this.recordCoreException("Record count key prefix doesn't align", "initialPrefix", evaluated, "secondPrefix", match.getEquality(FDBRecordStore.this, EvaluationContext.EMPTY));
                }
            }
            return evaluated;
        }

        private void deleteRecordsWhereCheckIndexes() {
            if (this.evaluated == null) {
                return;
            }
            for (IndexMaintainer index : this.indexMaintainers) {
                boolean canDelete = this.canDeleteWhereForIndex(index);
                if (canDelete) continue;
                throw new Query.InvalidExpressionException("deleteRecordsWhere not supported by index " + index.state.index.getName());
            }
        }

        private boolean canDeleteWhereForIndex(@Nonnull IndexMaintainer indexMaintainer) {
            Index index = indexMaintainer.state.index;
            Collection<RecordType> recordTypesForIndex = this.recordMetaData.recordTypesForIndex(index);
            boolean containsStoredTypes = false;
            boolean containsUnnestedTypes = false;
            boolean containsJoinedTypes = false;
            for (RecordType indexRecordType : recordTypesForIndex) {
                if (indexRecordType.isSynthetic()) {
                    if (indexRecordType instanceof UnnestedRecordType) {
                        containsUnnestedTypes = true;
                        continue;
                    }
                    if (indexRecordType instanceof JoinedRecordType) {
                        containsJoinedTypes = true;
                        continue;
                    }
                    return false;
                }
                containsStoredTypes = true;
            }
            if (containsStoredTypes && !containsUnnestedTypes && !containsJoinedTypes) {
                return this.canDeleteWhereForIndexOnStoredTypes(indexMaintainer);
            }
            if (containsUnnestedTypes && !containsStoredTypes && !containsJoinedTypes) {
                return this.canDeleteWhereForIndexOnUnnestedTypes(indexMaintainer);
            }
            if (containsJoinedTypes && !containsStoredTypes && !containsUnnestedTypes) {
                return this.canDeleteWhereForIndexOnJoinedTypes(indexMaintainer);
            }
            return false;
        }

        private boolean canDeleteWhereForIndexOnStoredTypes(@Nonnull IndexMaintainer indexMaintainer) {
            Index index = indexMaintainer.state.index;
            Collection<RecordType> recordTypesForIndex = this.recordMetaData.recordTypesForIndex(index);
            if (this.recordType == null || Key.Expressions.hasRecordTypePrefix(index.getRootExpression())) {
                return indexMaintainer.canDeleteWhere(this.matcher, this.evaluated);
            }
            if (recordTypesForIndex.size() > 1) {
                throw FDBRecordStore.this.recordCoreException("Index " + index.getName() + " applies to more record types than just " + this.recordType.getName());
            }
            if (this.indexMatcher == null) {
                return true;
            }
            return indexMaintainer.canDeleteWhere(this.indexMatcher, this.indexEvaluated);
        }

        private boolean canDeleteWhereForIndexOnJoinedTypes(@Nonnull IndexMaintainer indexMaintainer) {
            Index index = indexMaintainer.state.index;
            Collection<RecordType> recordTypesForIndex = this.recordMetaData.recordTypesForIndex(index);
            if (Key.Expressions.hasRecordTypePrefix(index.getRootExpression())) {
                return false;
            }
            if (this.recordType != null) {
                return false;
            }
            if (this.typelessComponent == null) {
                return false;
            }
            SyntheticRecordType joinedRecordType = null;
            for (RecordType indexRecordType : recordTypesForIndex) {
                if (!(indexRecordType instanceof JoinedRecordType) || joinedRecordType != null) {
                    return false;
                }
                joinedRecordType = (JoinedRecordType)indexRecordType;
            }
            if (joinedRecordType != null && joinedRecordType.getConstituents().size() == 2 && !((JoinedRecordType.JoinConstituent)joinedRecordType.getConstituents().get(0)).isOuterJoined() && !((JoinedRecordType.JoinConstituent)joinedRecordType.getConstituents().get(1)).isOuterJoined()) {
                QueryToKeyMatcher queryToKeyMatcher = new QueryToKeyMatcher(this.typelessComponent);
                boolean foundJoin = false;
                for (JoinedRecordType.Join join : ((JoinedRecordType)joinedRecordType).getJoins()) {
                    if (join.getLeft().getName().equals(join.getRight().getName()) || queryToKeyMatcher.matchesSatisfyingQuery(join.getLeftExpression()).getType() != QueryToKeyMatcher.MatchType.EQUALITY || queryToKeyMatcher.matchesSatisfyingQuery(join.getRightExpression()).getType() != QueryToKeyMatcher.MatchType.EQUALITY) continue;
                    foundJoin = true;
                    break;
                }
                if (!foundJoin) {
                    return false;
                }
                for (JoinedRecordType.JoinConstituent constituent : joinedRecordType.getConstituents()) {
                    boolean canDeleteWhere = this.canDeleteWhereOnConstituent(indexMaintainer, constituent.getName());
                    if (!canDeleteWhere) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean canDeleteWhereForIndexOnUnnestedTypes(@Nonnull IndexMaintainer indexMaintainer) {
            Index index = indexMaintainer.state.index;
            Collection<RecordType> recordTypesForIndex = this.recordMetaData.recordTypesForIndex(index);
            if (Key.Expressions.hasRecordTypePrefix(index.getRootExpression())) {
                return false;
            }
            String constituentName = null;
            for (RecordType indexRecordType : recordTypesForIndex) {
                SyntheticRecordType syntheticRecordType = (SyntheticRecordType)indexRecordType;
                if (syntheticRecordType instanceof UnnestedRecordType) {
                    UnnestedRecordType unnestedRecordType = (UnnestedRecordType)syntheticRecordType;
                    UnnestedRecordType.NestedConstituent parent = unnestedRecordType.getParentConstituent();
                    if (this.recordType != null && !this.recordType.equals(parent.getRecordType())) {
                        return false;
                    }
                    if (constituentName != null && !constituentName.equals(parent.getName())) {
                        return false;
                    }
                    constituentName = parent.getName();
                    continue;
                }
                return false;
            }
            if (constituentName == null) {
                return false;
            }
            return this.canDeleteWhereOnConstituent(indexMaintainer, constituentName);
        }

        private boolean canDeleteWhereOnConstituent(@Nonnull IndexMaintainer indexMaintainer, String constituentName) {
            QueryComponent syntheticQueryComponent;
            if (this.typelessComponent == null) {
                return true;
            }
            if (this.typelessComponent instanceof AndComponent) {
                List originalQueryComponents = ((AndComponent)this.typelessComponent).getChildren();
                ArrayList<QueryComponent> syntheticQueryComponents = new ArrayList<QueryComponent>(originalQueryComponents.size());
                for (QueryComponent c : originalQueryComponents) {
                    syntheticQueryComponents.add(Query.field(constituentName).matches(c));
                }
                syntheticQueryComponent = Query.and(syntheticQueryComponents);
            } else {
                syntheticQueryComponent = Query.field(constituentName).matches(this.typelessComponent);
            }
            QueryToKeyMatcher syntheticMatcher = new QueryToKeyMatcher(syntheticQueryComponent);
            return indexMaintainer.canDeleteWhere(syntheticMatcher, this.indexEvaluated);
        }

        private CompletableFuture<Void> run() {
            KeyExpression recordCountKey;
            if (this.evaluated == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.of("Tried to delete prefix with no record types", new Object[]{FDBRecordStore.this.subspaceProvider.logKey(), FDBRecordStore.this.subspaceProvider.toString(FDBRecordStore.this.context)}));
                }
                return AsyncUtil.DONE;
            }
            Transaction tr = FDBRecordStore.this.ensureContextActive();
            Tuple prefix = this.evaluated.toTuple();
            Range recordRange = FDBRecordStore.this.recordsSubspace().subspace(prefix).range();
            FDBRecordStore.this.context.clear(recordRange);
            if (FDBRecordStore.this.useOldVersionFormat() && FDBRecordStore.this.getRecordMetaData().isStoreRecordVersions()) {
                Range versionRange = FDBRecordStore.this.getSubspace().subspace(Tuple.from(RECORD_VERSION_KEY).addAll(prefix)).range();
                FDBRecordStore.this.context.clear(versionRange);
            }
            if ((recordCountKey = FDBRecordStore.this.getRecordMetaData().getRecordCountKey()) != null && FDBRecordStore.this.recordStoreStateRef.get().getStoreHeader().getRecordCountState() != RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) {
                if (prefix.size() == recordCountKey.getColumnSize()) {
                    FDBRecordStore.this.context.clear(FDBRecordStore.this.getSubspace().pack(Tuple.from(RECORD_COUNT_KEY).addAll(prefix)));
                } else {
                    FDBRecordStore.this.context.clear(FDBRecordStore.this.getSubspace().subspace(Tuple.from(RECORD_COUNT_KEY)).subspace(prefix).range());
                }
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            Tuple indexPrefix = this.indexEvaluated.toTuple();
            for (IndexMaintainer index : this.indexMaintainers) {
                CompletableFuture<Void> future = TupleHelpers.equals(prefix, indexPrefix) || Key.Expressions.hasRecordTypePrefix(index.state.index.getRootExpression()) ? index.deleteWhere(tr, prefix) : index.deleteWhere(tr, indexPrefix);
                if (MoreAsyncUtil.isCompletedNormally(future)) continue;
                futures.add(future);
            }
            return AsyncUtil.whenAll(futures);
        }
    }

    public static enum RebuildIndexReason {
        NEW_STORE(FDBStoreTimer.Events.REBUILD_INDEX_NEW_STORE),
        FEW_RECORDS(FDBStoreTimer.Events.REBUILD_INDEX_FEW_RECORDS),
        COUNTS_UNKNOWN(FDBStoreTimer.Events.REBUILD_INDEX_COUNTS_UNKNOWN),
        REBUILD_ALL(FDBStoreTimer.Events.REBUILD_INDEX_REBUILD_ALL),
        EXPLICIT(FDBStoreTimer.Events.REBUILD_INDEX_EXPLICIT),
        TEST(FDBStoreTimer.Events.REBUILD_INDEX_TEST);

        public final FDBStoreTimer.Events event;

        private RebuildIndexReason(FDBStoreTimer.Events event) {
            this.event = event;
        }
    }

    private static class DistinctFilterCursorClosure {
        private Tuple previousKey = null;

        private DistinctFilterCursorClosure() {
        }

        boolean pred(Tuple key) {
            if (key.equals(this.previousKey)) {
                return false;
            }
            this.previousKey = key;
            return true;
        }
    }

    @API(value=API.Status.UNSTABLE)
    public static class Builder
    implements FDBRecordStoreBase.BaseBuilder<Message, FDBRecordStore> {
        @Nullable
        private RecordSerializer<Message> serializer = DynamicMessageRecordSerializer.instance();
        private FormatVersion formatVersion = FormatVersion.getDefaultFormatVersion();
        @Nullable
        private RecordMetaDataProvider metaDataProvider;
        @Nullable
        private FDBMetaDataStore metaDataStore;
        @Nullable
        private FDBRecordContext context;
        @Nullable
        private FDBRecordStoreBase.UserVersionChecker userVersionChecker;
        @Nonnull
        private IndexMaintainerFactoryRegistry indexMaintainerRegistry = IndexMaintainerFactoryRegistryImpl.instance();
        @Nonnull
        private IndexMaintenanceFilter indexMaintenanceFilter = IndexMaintenanceFilter.NORMAL;
        @Nonnull
        private FDBRecordStoreBase.PipelineSizer pipelineSizer = DEFAULT_PIPELINE_SIZER;
        @Nullable
        protected SubspaceProvider subspaceProvider = null;
        @Nullable
        private FDBRecordStoreStateCache storeStateCache = null;
        @Nonnull
        private StateCacheabilityOnOpen stateCacheabilityOnOpen = StateCacheabilityOnOpen.DEFAULT;
        @Nonnull
        private PlanSerializationRegistry planSerializationRegistry = DefaultPlanSerializationRegistry.INSTANCE;

        protected Builder() {
        }

        protected Builder(Builder other) {
            this.copyFrom(other);
        }

        protected Builder(FDBRecordStore store) {
            this.copyFrom(store);
        }

        public void copyFrom(@Nonnull Builder other) {
            this.serializer = other.serializer;
            this.formatVersion = other.formatVersion;
            this.metaDataProvider = other.metaDataProvider;
            this.metaDataStore = other.metaDataStore;
            this.context = other.context;
            this.subspaceProvider = other.subspaceProvider;
            this.userVersionChecker = other.userVersionChecker;
            this.indexMaintainerRegistry = other.indexMaintainerRegistry;
            this.indexMaintenanceFilter = other.indexMaintenanceFilter;
            this.pipelineSizer = other.pipelineSizer;
            this.storeStateCache = other.storeStateCache;
            this.stateCacheabilityOnOpen = other.stateCacheabilityOnOpen;
            this.planSerializationRegistry = other.planSerializationRegistry;
        }

        public void copyFrom(@Nonnull FDBRecordStore store) {
            this.serializer = store.serializer;
            this.formatVersion = store.formatVersion;
            this.metaDataProvider = store.metaDataProvider;
            this.context = store.context;
            this.subspaceProvider = store.subspaceProvider;
            this.userVersionChecker = store.userVersionChecker;
            this.indexMaintainerRegistry = store.indexMaintainerRegistry;
            this.indexMaintenanceFilter = store.indexMaintenanceFilter;
            this.pipelineSizer = store.pipelineSizer;
            this.storeStateCache = store.storeStateCache;
            this.stateCacheabilityOnOpen = store.stateCacheabilityOnOpen;
            this.planSerializationRegistry = store.planSerializationRegistry;
        }

        @Override
        @Nullable
        public RecordSerializer<Message> getSerializer() {
            return this.serializer;
        }

        @Nonnull
        public Builder setSerializer(@Nonnull RecordSerializer<Message> serializer) {
            this.serializer = serializer;
            return this;
        }

        @Override
        @Deprecated(forRemoval=true)
        public int getFormatVersion() {
            return this.formatVersion.getValueForSerialization();
        }

        @Override
        public FormatVersion getFormatVersionEnum() {
            return this.formatVersion;
        }

        @Nonnull
        @Deprecated(forRemoval=true)
        public Builder setFormatVersion(int formatVersion) {
            this.formatVersion = FormatVersion.getFormatVersion(formatVersion);
            return this;
        }

        public Builder setFormatVersion(FormatVersion formatVersion) {
            return this.setFormatVersion(formatVersion.getValueForSerialization());
        }

        @Override
        @Nullable
        public RecordMetaDataProvider getMetaDataProvider() {
            return this.metaDataProvider;
        }

        @Nonnull
        public Builder setMetaDataProvider(@Nullable RecordMetaDataProvider metaDataProvider) {
            this.metaDataProvider = metaDataProvider;
            return this;
        }

        @Override
        @Nullable
        public FDBMetaDataStore getMetaDataStore() {
            return this.metaDataStore;
        }

        @Nonnull
        public Builder setMetaDataStore(@Nullable FDBMetaDataStore metaDataStore) {
            this.metaDataStore = metaDataStore;
            if (metaDataStore != null && this.context == null) {
                this.context = metaDataStore.getRecordContext();
            }
            return this;
        }

        @Override
        @Nullable
        public FDBRecordContext getContext() {
            return this.context;
        }

        @Nonnull
        public Builder setContext(@Nullable FDBRecordContext context) {
            this.context = context;
            return this;
        }

        @Override
        @Nullable
        public SubspaceProvider getSubspaceProvider() {
            return this.subspaceProvider;
        }

        @Nonnull
        public Builder setSubspaceProvider(@Nullable SubspaceProvider subspaceProvider) {
            this.subspaceProvider = subspaceProvider;
            return this;
        }

        @Nonnull
        @API(value=API.Status.UNSTABLE)
        public Builder setSubspace(@Nullable Subspace subspace) {
            this.subspaceProvider = subspace == null ? null : new SubspaceProviderBySubspace(subspace);
            return this;
        }

        @Nonnull
        public Builder setKeySpacePath(@Nullable KeySpacePath keySpacePath) {
            this.subspaceProvider = keySpacePath == null ? null : new SubspaceProviderByKeySpacePath(keySpacePath);
            return this;
        }

        @Override
        @Nullable
        public FDBRecordStoreBase.UserVersionChecker getUserVersionChecker() {
            return this.userVersionChecker;
        }

        @Nonnull
        public Builder setUserVersionChecker(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker) {
            this.userVersionChecker = userVersionChecker;
            return this;
        }

        @Override
        @Nonnull
        public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry() {
            return this.indexMaintainerRegistry;
        }

        @Nonnull
        public Builder setIndexMaintainerRegistry(@Nonnull IndexMaintainerFactoryRegistry indexMaintainerRegistry) {
            this.indexMaintainerRegistry = indexMaintainerRegistry;
            return this;
        }

        @Override
        @Nonnull
        public IndexMaintenanceFilter getIndexMaintenanceFilter() {
            return this.indexMaintenanceFilter;
        }

        @Nonnull
        public Builder setIndexMaintenanceFilter(@Nonnull IndexMaintenanceFilter indexMaintenanceFilter) {
            this.indexMaintenanceFilter = indexMaintenanceFilter;
            return this;
        }

        @Override
        @Nonnull
        public FDBRecordStoreBase.PipelineSizer getPipelineSizer() {
            return this.pipelineSizer;
        }

        @Nonnull
        public Builder setPipelineSizer(@Nonnull FDBRecordStoreBase.PipelineSizer pipelineSizer) {
            this.pipelineSizer = pipelineSizer;
            return this;
        }

        @Override
        @Nullable
        public FDBRecordStoreStateCache getStoreStateCache() {
            return this.storeStateCache;
        }

        @Nonnull
        public Builder setStoreStateCache(@Nullable FDBRecordStoreStateCache storeStateCache) {
            this.storeStateCache = storeStateCache;
            return this;
        }

        @Override
        @Nonnull
        public StateCacheabilityOnOpen getStateCacheabilityOnOpen() {
            return this.stateCacheabilityOnOpen;
        }

        @Nonnull
        public Builder setStateCacheabilityOnOpen(@Nonnull StateCacheabilityOnOpen stateCacheabilityOnOpen) {
            this.stateCacheabilityOnOpen = stateCacheabilityOnOpen;
            return this;
        }

        @Nonnull
        public PlanSerializationRegistry getPlanSerializationRegistry() {
            return this.planSerializationRegistry;
        }

        public void setPlanSerializationRegistry(@Nonnull PlanSerializationRegistry planSerializationRegistry) {
            this.planSerializationRegistry = planSerializationRegistry;
        }

        @Nonnull
        public Builder copyBuilder() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        public FDBRecordStore build() {
            if (this.context == null) {
                throw new RecordCoreException("record context must be supplied", new Object[0]);
            }
            if (this.subspaceProvider == null) {
                throw new RecordCoreException("subspace provider must be supplied", new Object[0]);
            }
            if (this.serializer == null) {
                throw new RecordCoreException("serializer must be supplied", new Object[0]);
            }
            return new FDBRecordStore(this.context, this.subspaceProvider, this.formatVersion, this.getMetaDataProviderForBuild(), this.serializer, this.indexMaintainerRegistry, this.indexMaintenanceFilter, this.pipelineSizer, this.storeStateCache, this.stateCacheabilityOnOpen, this.userVersionChecker, this.planSerializationRegistry);
        }

        @Override
        @Nonnull
        public CompletableFuture<FDBRecordStore> uncheckedOpenAsync() {
            CompletableFuture<Long> readVersionFuture = this.preloadReadVersion();
            CompletionStage preloadMetaData = readVersionFuture.thenCompose(ignore -> this.preloadMetaData());
            FDBRecordStore recordStore = this.build();
            CompletableFuture<Void> subspaceFuture = recordStore.preloadSubspaceAsync();
            CompletionStage loadStoreState = subspaceFuture.thenCompose(vignore -> recordStore.preloadRecordStoreStateAsync());
            return CompletableFuture.allOf(new CompletableFuture[]{preloadMetaData, loadStoreState}).thenApply(vignore -> recordStore);
        }

        @Override
        @Nonnull
        public CompletableFuture<FDBRecordStore> createOrOpenAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
            CompletableFuture<Long> readVersionFuture = this.preloadReadVersion();
            CompletionStage preloadMetaData = readVersionFuture.thenCompose(ignore -> this.preloadMetaData());
            FDBRecordStore recordStore = this.build();
            CompletableFuture<Boolean> checkVersion = recordStore.checkVersion(this.userVersionChecker, existenceCheck, (CompletableFuture<Void>)preloadMetaData);
            return checkVersion.thenApply(vignore -> recordStore);
        }

        @Nonnull
        private RecordMetaDataProvider getMetaDataProviderForBuild() {
            if (this.metaDataStore != null) {
                return this.metaDataStore;
            }
            if (this.metaDataProvider != null) {
                return this.metaDataProvider;
            }
            throw new RecordCoreException("Neither metaDataStore nor metaDataProvider was set in builder.", new Object[0]);
        }

        @Nonnull
        private CompletableFuture<Long> preloadReadVersion() {
            if (this.context == null) {
                throw new RecordCoreException("record context must be supplied", new Object[0]);
            }
            return this.context.getReadVersionAsync();
        }

        @Nonnull
        private CompletableFuture<Void> preloadMetaData() {
            if (this.metaDataStore != null) {
                return this.metaDataStore.preloadMetaData(this.metaDataProvider);
            }
            return AsyncUtil.DONE;
        }

        @API(value=API.Status.INTERNAL)
        public CompletableFuture<NonnullPair<Boolean, FDBRecordStore>> repairMissingHeader(int userVersion, FormatVersion minimumPossibleFormatVersion) {
            if (!this.formatVersion.isAtLeast(minimumPossibleFormatVersion)) {
                throw new RecordCoreArgumentException("minimumPossibleFormatVersion is greater than the target formatVerson", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, minimumPossibleFormatVersion}).addLogInfo(new Object[]{LogMessageKeys.NEW_FORMAT_VERSION, this.formatVersion});
            }
            if (!minimumPossibleFormatVersion.isAtLeast(FormatVersion.SAVE_VERSION_WITH_RECORD) && this.formatVersion.isAtLeast(FormatVersion.SAVE_UNSPLIT_WITH_SUFFIX)) {
                throw new RecordCoreArgumentException("minimumPossibleFormatVersion is not supported for target FormatVersion", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, minimumPossibleFormatVersion});
            }
            return this.uncheckedOpenAsync().thenCompose(store -> store.getStoreStateCache().get((FDBRecordStore)store, FDBRecordStoreBase.StoreExistenceCheck.NONE).thenCompose(storeStateCacheEntry -> this.repairMissingHeader(userVersion, (FDBRecordStore)store, storeStateCacheEntry.getRecordStoreState().getStoreHeader())));
        }

        private CompletableFuture<NonnullPair<Boolean, FDBRecordStore>> repairMissingHeader(int userVersion, @Nonnull FDBRecordStore store, @Nonnull RecordMetaDataProto.DataStoreInfo existing) {
            if (!existing.equals(RecordMetaDataProto.DataStoreInfo.getDefaultInstance())) {
                return store.checkVersion(this.userVersionChecker, FDBRecordStoreBase.StoreExistenceCheck.ERROR_IF_NOT_EXISTS).thenApply(checkVersionDidSomething -> NonnullPair.of(false, store));
            }
            RecordMetaData recordMetaData = this.metaDataProvider.getRecordMetaData();
            RecordMetaDataProto.DataStoreInfo.Builder dataStoreInfo = RecordMetaDataProto.DataStoreInfo.newBuilder().setFormatVersion(this.formatVersion.getValueForSerialization()).setMetaDataversion(recordMetaData.getVersion()).setUserVersion(userVersion).setLastUpdateTime(System.currentTimeMillis());
            if (recordMetaData.getRecordCountKey() != null) {
                if (this.formatVersion.isAtLeast(FormatVersion.RECORD_COUNT_KEY_ADDED)) {
                    dataStoreInfo.setRecordCountKey(recordMetaData.getRecordCountKey().toKeyExpression());
                }
                if (!this.formatVersion.isAtLeast(FormatVersion.RECORD_COUNT_STATE)) {
                    throw new RecordCoreException("Repair is not supported if the metadata has a RecordCountKey until FormatVersion.RECORD_COUNT_STATE", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FORMAT_VERSION, this.formatVersion});
                }
            }
            store.saveStoreHeader(dataStoreInfo.build());
            recordMetaData.getFormerIndexes().forEach(store::removeFormerIndex);
            CompletableFuture<Void> updateRecordCountState = recordMetaData.getRecordCountKey() != null ? store.updateRecordCountStateAsync(RecordMetaDataProto.DataStoreInfo.RecordCountState.DISABLED) : AsyncUtil.DONE;
            CompletionStage bumpMetaDataVersionStamp = updateRecordCountState.thenCompose(vignore -> this.context.getMetaDataVersionStampAsync(IsolationLevel.SNAPSHOT).thenAccept(metaDataVersionStamp -> {
                if (metaDataVersionStamp != null) {
                    this.context.setMetaDataVersionStamp();
                }
            }));
            return ((CompletableFuture)bumpMetaDataVersionStamp).thenCompose(vignore -> AsyncUtil.whenAll(recordMetaData.getAllIndexes().stream().map(store::markIndexDisabled).collect(Collectors.toList())).thenApply(ignored -> NonnullPair.of(true, store)));
        }
    }

    public static class IndexNotBuiltException
    extends RecordCoreException {
        @Nullable
        private final Range unbuiltRange;

        public IndexNotBuiltException(@Nonnull String message, @Nullable Range unbuiltRange, Object ... keyValues) {
            super(message, keyValues);
            this.unbuiltRange = unbuiltRange;
        }

        @Nullable
        public Range getUnbuiltRange() {
            return this.unbuiltRange;
        }
    }
}

