/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.ExecuteState;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordFunction;
import com.apple.foundationdb.record.RecordIndexUniquenessViolation;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.FallbackCursor;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.StoreRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBMetaDataStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBTypedRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintenanceFilter;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedRemoteFetchIndexException;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public interface FDBRecordStoreBase<M extends Message>
extends RecordMetaDataProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger(FDBRecordStoreBase.class);

    public FDBRecordStore getUntypedRecordStore();

    default public <N extends Message> FDBTypedRecordStore<N> getTypedRecordStore(@Nonnull RecordSerializer<N> serializer) {
        return new FDBTypedRecordStore<N>(this.getUntypedRecordStore(), serializer);
    }

    @Nonnull
    public FDBRecordContext getContext();

    @Nonnull
    default public Executor getExecutor() {
        return this.getContext().getExecutor();
    }

    @Nullable
    default public FDBStoreTimer getTimer() {
        return this.getContext().getTimer();
    }

    @Nullable
    public SubspaceProvider getSubspaceProvider();

    @Nonnull
    public RecordStoreState getRecordStoreState();

    @Nonnull
    public RecordSerializer<M> getSerializer();

    @Nonnull
    public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry();

    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull Index var1);

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M rec) {
        return this.saveRecordAsync(rec, (FDBRecordVersion)null);
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M rec, @Nonnull RecordExistenceCheck existenceCheck) {
        return this.saveRecordAsync(rec, existenceCheck, null, VersionstampSaveBehavior.DEFAULT);
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M rec, @Nullable FDBRecordVersion version) {
        return this.saveRecordAsync(rec, version, VersionstampSaveBehavior.DEFAULT);
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M rec, @Nullable FDBRecordVersion version, @Nonnull VersionstampSaveBehavior behavior) {
        return this.saveRecordAsync(rec, RecordExistenceCheck.NONE, version, behavior);
    }

    @Nonnull
    public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M var1, @Nonnull RecordExistenceCheck var2, @Nullable FDBRecordVersion var3, @Nonnull VersionstampSaveBehavior var4);

    @Nonnull
    public CompletableFuture<FDBStoredRecord<M>> dryRunSaveRecordAsync(@Nonnull M var1, @Nonnull RecordExistenceCheck var2, @Nullable FDBRecordVersion var3, @Nonnull VersionstampSaveBehavior var4);

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> dryRunSaveRecordAsync(@Nonnull M rec, @Nonnull RecordExistenceCheck existenceCheck) {
        return this.dryRunSaveRecordAsync(rec, existenceCheck, null, VersionstampSaveBehavior.DEFAULT);
    }

    @Nonnull
    default public FDBStoredRecord<M> saveRecord(@Nonnull M rec) {
        return this.saveRecord(rec, (FDBRecordVersion)null);
    }

    @Nonnull
    default public FDBStoredRecord<M> saveRecord(@Nonnull M rec, @Nonnull RecordExistenceCheck existenceCheck) {
        return this.saveRecord(rec, existenceCheck, null, VersionstampSaveBehavior.DEFAULT);
    }

    @Nonnull
    default public FDBStoredRecord<M> saveRecord(@Nonnull M rec, @Nullable FDBRecordVersion version) {
        return this.saveRecord(rec, version, VersionstampSaveBehavior.DEFAULT);
    }

    @Nonnull
    default public FDBStoredRecord<M> saveRecord(@Nonnull M rec, @Nullable FDBRecordVersion version, @Nonnull VersionstampSaveBehavior behavior) {
        return this.saveRecord(rec, RecordExistenceCheck.NONE, version, behavior);
    }

    @Nonnull
    default public FDBStoredRecord<M> saveRecord(@Nonnull M rec, @Nonnull RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull VersionstampSaveBehavior behavior) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_SAVE_RECORD, this.saveRecordAsync(rec, existenceCheck, version, behavior));
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> insertRecordAsync(@Nonnull M rec) {
        return this.saveRecordAsync(rec, RecordExistenceCheck.ERROR_IF_EXISTS);
    }

    @Nonnull
    default public FDBStoredRecord<M> insertRecord(@Nonnull M rec) {
        return this.saveRecord(rec, RecordExistenceCheck.ERROR_IF_EXISTS);
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> updateRecordAsync(@Nonnull M rec) {
        return this.saveRecordAsync(rec, RecordExistenceCheck.ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED);
    }

    @Nonnull
    default public FDBStoredRecord<M> updateRecord(@Nonnull M rec) {
        return this.saveRecord(rec, RecordExistenceCheck.ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED);
    }

    @Nullable
    default public FDBStoredRecord<M> loadRecord(@Nonnull Tuple primaryKey) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD, this.loadRecordAsync(primaryKey));
    }

    @Nullable
    default public FDBStoredRecord<M> loadRecord(@Nonnull Tuple primaryKey, boolean snapshot) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD, this.loadRecordAsync(primaryKey, snapshot));
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> loadRecordAsync(@Nonnull Tuple primaryKey) {
        return this.loadRecordAsync(primaryKey, false);
    }

    @Nonnull
    default public CompletableFuture<FDBStoredRecord<M>> loadRecordAsync(@Nonnull Tuple primaryKey, boolean snapshot) {
        return this.loadRecordInternal(primaryKey, ExecuteState.NO_LIMITS, snapshot);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBStoredRecord<M>> loadRecordInternal(@Nonnull Tuple var1, @Nonnull ExecuteState var2, boolean var3);

    @Nonnull
    public CompletableFuture<Void> preloadRecordAsync(@Nonnull Tuple var1);

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public CompletableFuture<FDBSyntheticRecord> loadSyntheticRecord(@Nonnull Tuple primaryKey) {
        return this.loadSyntheticRecord(primaryKey, IndexOrphanBehavior.ERROR);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<FDBSyntheticRecord> loadSyntheticRecord(@Nonnull Tuple var1, IndexOrphanBehavior var2);

    @Nonnull
    default public CompletableFuture<Boolean> recordExistsAsync(@Nonnull Tuple primaryKey) {
        return this.recordExistsAsync(primaryKey, IsolationLevel.SERIALIZABLE);
    }

    @Nonnull
    public CompletableFuture<Boolean> recordExistsAsync(@Nonnull Tuple var1, @Nonnull IsolationLevel var2);

    default public boolean recordExists(@Nonnull Tuple primaryKey) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_RECORD_EXISTS, this.recordExistsAsync(primaryKey));
    }

    default public boolean recordExists(@Nonnull Tuple primaryKey, @Nonnull IsolationLevel isolationLevel) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_RECORD_EXISTS, this.recordExistsAsync(primaryKey, isolationLevel));
    }

    public void addRecordReadConflict(@Nonnull Tuple var1);

    public void addRecordWriteConflict(@Nonnull Tuple var1);

    @Nonnull
    default public RecordCursor<FDBStoredRecord<M>> scanRecords(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanRecords(null, null, EndpointType.TREE_START, EndpointType.TREE_END, continuation, scanProperties);
    }

    @Nonnull
    default public RecordCursor<FDBStoredRecord<M>> scanRecords(@Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanRecords(range.getLow(), range.getHigh(), range.getLowEndpoint(), range.getHighEndpoint(), continuation, scanProperties);
    }

    @Nonnull
    public RecordCursor<FDBStoredRecord<M>> scanRecords(@Nullable Tuple var1, @Nullable Tuple var2, @Nonnull EndpointType var3, @Nonnull EndpointType var4, @Nullable byte[] var5, @Nonnull ScanProperties var6);

    @Nonnull
    @API(value=API.Status.INTERNAL)
    default public RecordCursor<Tuple> scanRecordKeys(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        throw new UnsupportedOperationException("scanRecordKeys should be implemented");
    }

    @Nonnull
    default public CompletableFuture<Integer> countRecords(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint) {
        return this.countRecords(low, high, lowEndpoint, highEndpoint, null, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    public CompletableFuture<Integer> countRecords(@Nullable Tuple var1, @Nullable Tuple var2, @Nonnull EndpointType var3, @Nonnull EndpointType var4, @Nullable byte[] var5, @Nonnull ScanProperties var6);

    @Nonnull
    public RecordCursor<IndexEntry> scanIndex(@Nonnull Index var1, @Nonnull IndexScanBounds var2, @Nullable byte[] var3, @Nonnull ScanProperties var4);

    @Nonnull
    default public RecordCursor<IndexEntry> scanIndex(@Nonnull Index index, @Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanIndex(index, new IndexScanRange(scanType, range), continuation, scanProperties);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull String indexName) {
        return this.scanIndexRecords(indexName, IsolationLevel.SERIALIZABLE);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull String indexName, IsolationLevel isolationLevel) {
        return this.scanIndexRecords(indexName, IndexScanType.BY_VALUE, TupleRange.ALL, null, new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).build()));
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull String indexName, @Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanIndexRecords(indexName, scanType, range, continuation, IndexOrphanBehavior.ERROR, scanProperties);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull String indexName, @Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ScanProperties scanProperties) {
        Index index = this.getRecordMetaData().getIndex(indexName);
        return this.scanIndexRecords(index, scanType, range, continuation, orphanBehavior, scanProperties);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull Index index, @Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ScanProperties scanProperties) {
        return this.fetchIndexRecords(this.scanIndex(index, scanType, range, continuation, scanProperties), orphanBehavior, scanProperties.getExecuteProperties().getState());
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull String indexName, @Nonnull IndexFetchMethod fetchMethod, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ScanProperties scanProperties) {
        return this.scanIndexRecords(this.getRecordMetaData().getIndex(indexName), fetchMethod, scanBounds, continuation, orphanBehavior, scanProperties);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull Index index, @Nonnull IndexFetchMethod fetchMethod, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ScanProperties scanProperties) {
        int commonPrimaryKeyLength = -1;
        if (fetchMethod != IndexFetchMethod.SCAN_AND_FETCH) {
            commonPrimaryKeyLength = this.getCommonPrimaryKeyLength(index);
        }
        return this.scanIndexRecords(index, fetchMethod, scanBounds, commonPrimaryKeyLength, continuation, orphanBehavior, scanProperties);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecords(@Nonnull Index index, @Nonnull IndexFetchMethod fetchMethod, @Nonnull IndexScanBounds scanBounds, int commonPrimaryKeyLength, @Nullable byte[] continuation, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ScanProperties scanProperties) {
        if (!(scanBounds instanceof IndexScanRange)) {
            throw new RecordCoreArgumentException("scanIndexRecords can only be used with IndexScanRange bounds", new Object[0]);
        }
        IndexScanRange scanRange = (IndexScanRange)scanBounds;
        switch (fetchMethod) {
            case SCAN_AND_FETCH: {
                return this.scanIndexRecords(index, scanRange.getScanType(), scanRange.getScanRange(), continuation, orphanBehavior, scanProperties);
            }
            case USE_REMOTE_FETCH: {
                return this.scanIndexRemoteFetch(index, scanBounds, commonPrimaryKeyLength, continuation, scanProperties, orphanBehavior);
            }
            case USE_REMOTE_FETCH_WITH_FALLBACK: {
                try {
                    RecordCursor<FDBIndexedRecord<M>> remoteFetchCursor = this.scanIndexRemoteFetch(index, scanBounds, commonPrimaryKeyLength, continuation, scanProperties, orphanBehavior);
                    return new FallbackCursor<FDBIndexedRecord<M>>(remoteFetchCursor, lastSuccessfulResult -> this.remoteFetchFallbackFrom(index, scanRange.getScanType(), scanRange.getScanRange(), continuation, orphanBehavior, scanProperties, (RecordCursorResult<FDBIndexedRecord<M>>)lastSuccessfulResult));
                }
                catch (UnsupportedRemoteFetchIndexException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        KeyValueLogMessage msg = KeyValueLogMessage.build("scanIndexRecords: Remote fetch unsupported, continuing with Index scan", new Object[]{LogMessageKeys.MESSAGE, ex.getMessage(), LogMessageKeys.INDEX_NAME, index.getName()});
                        SubspaceProvider subspaceProvider = this.getSubspaceProvider();
                        if (subspaceProvider != null) {
                            msg.addKeyAndValue((Object)subspaceProvider.logKey(), subspaceProvider.toString(this.getContext()));
                        }
                        LOGGER.info(msg.toString());
                    }
                    return this.scanIndexRecords(index, scanRange.getScanType(), scanRange.getScanRange(), continuation, orphanBehavior, scanProperties);
                }
                catch (Exception ex) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(KeyValueLogMessage.of("scanIndexRecords: Remote Fetch execution failed, falling back to Index scan", new Object[]{LogMessageKeys.INDEX_NAME, index.getName()}), ex);
                    }
                    return this.scanIndexRecords(index, scanRange.getScanType(), scanRange.getScanRange(), continuation, orphanBehavior, scanProperties);
                }
            }
        }
        throw new RecordCoreException("Unknown fetchMethod option", new Object[0]).addLogInfo("option", (Object)fetchMethod);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetch(@Nonnull String indexName, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior) {
        Index index = this.getRecordMetaData().getIndex(indexName);
        return this.scanIndexRemoteFetch(index, scanBounds, continuation, scanProperties, orphanBehavior);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetch(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior) {
        int commonPrimaryKeyLength = this.getCommonPrimaryKeyLength(index);
        return this.scanIndexRemoteFetch(index, scanBounds, commonPrimaryKeyLength, continuation, scanProperties, orphanBehavior);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetch(@Nonnull Index var1, @Nonnull IndexScanBounds var2, int var3, @Nullable byte[] var4, @Nonnull ScanProperties var5, @Nonnull IndexOrphanBehavior var6);

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public CompletableFuture<FDBIndexedRecord<M>> buildSingleRecord(@Nonnull FDBIndexedRawRecord var1);

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> fetchIndexRecords(@Nonnull RecordCursor<IndexEntry> indexCursor, @Nonnull IndexOrphanBehavior orphanBehavior) {
        return this.fetchIndexRecords(indexCursor, orphanBehavior, ExecuteState.NO_LIMITS);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> fetchIndexRecords(@Nonnull RecordCursor<IndexEntry> indexCursor, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ExecuteState executeState) {
        RecordCursor<FDBIndexedRecord<M>> recordCursor = indexCursor.mapPipelined(entry -> this.loadIndexEntryRecord((IndexEntry)entry, orphanBehavior, executeState), this.getPipelineSize(PipelineOperation.INDEX_TO_RECORD));
        if (orphanBehavior == IndexOrphanBehavior.SKIP) {
            recordCursor = recordCursor.filter(Objects::nonNull);
        }
        return recordCursor;
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecordsEqual(@Nonnull String indexName, Object ... values) {
        Tuple tuple = Tuple.from(values);
        TupleRange range = TupleRange.allOf(tuple);
        return this.scanIndexRecords(indexName, IndexScanType.BY_VALUE, range, null, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetchRecordsEqual(@Nonnull String indexName, Object ... values) {
        Tuple tuple = Tuple.from(values);
        TupleRange range = TupleRange.allOf(tuple);
        IndexScanRange bounds = new IndexScanRange(IndexScanType.BY_VALUE, range);
        return this.scanIndexRemoteFetch(indexName, (IndexScanBounds)bounds, null, ScanProperties.FORWARD_SCAN, IndexOrphanBehavior.ERROR);
    }

    @Nonnull
    default public RecordCursor<FDBIndexedRecord<M>> scanIndexRecordsBetween(@Nonnull String indexName, @Nullable Object low, @Nullable Object high) {
        Tuple lowTuple = Tuple.from(low);
        Tuple highTuple = Tuple.from(high);
        TupleRange range = new TupleRange(lowTuple, highTuple, EndpointType.RANGE_INCLUSIVE, EndpointType.RANGE_INCLUSIVE);
        return this.scanIndexRecords(indexName, IndexScanType.BY_VALUE, range, null, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    default public CompletableFuture<Boolean> hasIndexEntryRecord(@Nonnull IndexEntry entry, @Nonnull IsolationLevel isolationLevel) {
        return this.recordExistsAsync(entry.getPrimaryKey(), isolationLevel);
    }

    @Nonnull
    default public CompletableFuture<FDBIndexedRecord<M>> loadIndexEntryRecord(@Nonnull IndexEntry entry, @Nonnull IndexOrphanBehavior orphanBehavior) {
        return this.loadIndexEntryRecord(entry, orphanBehavior, ExecuteState.NO_LIMITS);
    }

    @Nonnull
    default public CompletableFuture<FDBIndexedRecord<M>> loadIndexEntryRecord(@Nonnull IndexEntry entry, @Nonnull IndexOrphanBehavior orphanBehavior, @Nonnull ExecuteState executeState) {
        Tuple primaryKey = entry.getPrimaryKey();
        return this.loadRecordInternal(primaryKey, executeState, false).thenApply(rec -> {
            if (rec == null) {
                switch (orphanBehavior) {
                    case SKIP: {
                        return null;
                    }
                    case RETURN: {
                        break;
                    }
                    case ERROR: {
                        if (this.getTimer() != null) {
                            this.getTimer().increment(FDBStoreTimer.Counts.BAD_INDEX_ENTRY);
                        }
                        throw new RecordCoreStorageException("record not found from index entry").addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, entry.getIndex().getName(), LogMessageKeys.PRIMARY_KEY, primaryKey, LogMessageKeys.INDEX_KEY, entry.getKey(), this.getSubspaceProvider().logKey(), this.getSubspaceProvider().toString(this.getContext())});
                    }
                    default: {
                        throw new RecordCoreException("Unexpected index orphan behavior: " + String.valueOf((Object)orphanBehavior), new Object[0]);
                    }
                }
            }
            return new FDBIndexedRecord(entry, rec);
        });
    }

    @Nonnull
    public static Tuple indexEntryKey(@Nonnull Index index, @Nonnull Tuple valueKey, @Nonnull Tuple primaryKey) {
        List<Object> primaryKeys = primaryKey.getItems();
        index.trimPrimaryKey(primaryKeys);
        if (primaryKeys.isEmpty()) {
            return valueKey;
        }
        return valueKey.addAll(primaryKeys);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull Tuple valueKey, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        TupleRange range = TupleRange.allOf(valueKey);
        return this.scanUniquenessViolations(index, range, continuation, scanProperties);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull Key.Evaluated indexKey, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanUniquenessViolations(index, indexKey.toTuple(), continuation, scanProperties);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull Tuple valueKey) {
        return this.scanUniquenessViolations(index, valueKey, null, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull Key.Evaluated indexKey) {
        return this.scanUniquenessViolations(index, indexKey, null, ScanProperties.FORWARD_SCAN);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scanUniquenessViolations(index, TupleRange.ALL, continuation, scanProperties);
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, int limit) {
        return this.scanUniquenessViolations(index, null, new ScanProperties(ExecuteProperties.newBuilder().setReturnedRowLimit(limit).setIsolationLevel(IsolationLevel.SERIALIZABLE).build()));
    }

    @Nonnull
    default public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index) {
        return this.scanUniquenessViolations(index, Integer.MAX_VALUE);
    }

    @Nonnull
    public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index var1, @Nonnull TupleRange var2, @Nullable byte[] var3, @Nonnull ScanProperties var4);

    @Nonnull
    default public CompletableFuture<Void> resolveUniquenessViolation(@Nonnull Index index, @Nonnull Key.Evaluated indexKey, @Nullable Tuple primaryKey) {
        return this.resolveUniquenessViolation(index, indexKey.toTuple(), primaryKey);
    }

    @Nonnull
    public CompletableFuture<Void> resolveUniquenessViolation(@Nonnull Index var1, @Nonnull Tuple var2, @Nullable Tuple var3);

    @Nonnull
    public static Tuple uniquenessViolationKey(@Nonnull Tuple valueKey, @Nonnull Tuple primaryKey) {
        return valueKey.addAll(primaryKey);
    }

    @Nonnull
    public CompletableFuture<Boolean> dryRunDeleteRecordAsync(@Nonnull Tuple var1);

    @Nonnull
    public CompletableFuture<Boolean> deleteRecordAsync(@Nonnull Tuple var1);

    default public boolean deleteRecord(@Nonnull Tuple primaryKey) {
        return this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_DELETE_RECORD, this.deleteRecordAsync(primaryKey));
    }

    public void deleteAllRecords();

    default public void deleteRecordsWhere(@Nonnull QueryComponent component) {
        this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_DELETE_RECORD, this.deleteRecordsWhereAsync(component));
    }

    default public void deleteRecordsWhere(@Nonnull String recordType, @Nullable QueryComponent component) {
        this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_DELETE_RECORD, this.deleteRecordsWhereAsync(recordType, component));
    }

    @Nonnull
    public CompletableFuture<Void> deleteRecordsWhereAsync(@Nonnull QueryComponent var1);

    @Nonnull
    default public CompletableFuture<Void> deleteRecordsWhereAsync(@Nonnull String recordType, @Nullable QueryComponent component) {
        return this.deleteRecordsWhereAsync(FDBRecordStore.mergeRecordTypeAndComponent(recordType, component));
    }

    @Nonnull
    public PipelineSizer getPipelineSizer();

    default public int getPipelineSize(@Nonnull PipelineOperation pipelineOperation) {
        return this.getPipelineSizer().getPipelineSize(pipelineOperation);
    }

    @Nonnull
    public CompletableFuture<Long> estimateStoreSizeAsync();

    @Nonnull
    default public CompletableFuture<Long> estimateRecordsSizeAsync() {
        return this.estimateRecordsSizeAsync(TupleRange.ALL);
    }

    @Nonnull
    public CompletableFuture<Long> estimateRecordsSizeAsync(@Nonnull TupleRange var1);

    @Nonnull
    default public CompletableFuture<Long> getSnapshotRecordCount() {
        return this.getSnapshotRecordCount(EmptyKeyExpression.EMPTY, Key.Evaluated.EMPTY);
    }

    @Nonnull
    default public CompletableFuture<Long> getSnapshotRecordCount(@Nonnull KeyExpression key, @Nonnull Key.Evaluated value) {
        return this.getSnapshotRecordCount(key, value, IndexQueryabilityFilter.TRUE);
    }

    @Nonnull
    public CompletableFuture<Long> getSnapshotRecordCount(@Nonnull KeyExpression var1, @Nonnull Key.Evaluated var2, @Nonnull IndexQueryabilityFilter var3);

    @Nonnull
    default public CompletableFuture<Long> getSnapshotRecordCountForRecordType(@Nonnull String recordTypeName) {
        return this.getSnapshotRecordCountForRecordType(recordTypeName, IndexQueryabilityFilter.TRUE);
    }

    @Nonnull
    public CompletableFuture<Long> getSnapshotRecordCountForRecordType(@Nonnull String var1, @Nonnull IndexQueryabilityFilter var2);

    default public CompletableFuture<Long> getSnapshotRecordUpdateCount() {
        return this.getSnapshotRecordUpdateCount(EmptyKeyExpression.EMPTY, Key.Evaluated.EMPTY);
    }

    default public CompletableFuture<Long> getSnapshotRecordUpdateCount(@Nonnull KeyExpression key, @Nonnull Key.Evaluated value) {
        return this.getSnapshotRecordUpdateCount(key, value, IndexQueryabilityFilter.TRUE);
    }

    default public CompletableFuture<Long> getSnapshotRecordUpdateCount(@Nonnull KeyExpression key, @Nonnull Key.Evaluated value, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        return this.evaluateAggregateFunction(Collections.emptyList(), IndexFunctionHelper.countUpdates(key), TupleRange.allOf(value.toTuple()), IsolationLevel.SNAPSHOT, indexQueryabilityFilter).thenApply(tuple -> tuple.getLong(0));
    }

    @Nonnull
    default public <T> CompletableFuture<T> evaluateRecordFunction(@Nonnull RecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        return this.evaluateRecordFunction(EvaluationContext.EMPTY, function, rec);
    }

    @Nonnull
    default public <T> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull RecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        if (function instanceof IndexRecordFunction) {
            IndexRecordFunction indexRecordFunction = (IndexRecordFunction)function;
            return this.evaluateIndexRecordFunction(evaluationContext, indexRecordFunction, rec);
        }
        if (function instanceof StoreRecordFunction) {
            StoreRecordFunction storeRecordFunction = (StoreRecordFunction)function;
            return this.evaluateStoreFunction(evaluationContext, storeRecordFunction, rec);
        }
        throw new RecordCoreException("Cannot evaluate record function " + String.valueOf(function), new Object[0]);
    }

    @Nonnull
    public <T> CompletableFuture<T> evaluateIndexRecordFunction(@Nonnull EvaluationContext var1, @Nonnull IndexRecordFunction<T> var2, @Nonnull FDBRecord<M> var3);

    @Nonnull
    default public <T> CompletableFuture<T> evaluateStoreFunction(@Nonnull StoreRecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        return this.evaluateStoreFunction(EvaluationContext.EMPTY, function, rec);
    }

    @Nonnull
    public <T> CompletableFuture<T> evaluateStoreFunction(@Nonnull EvaluationContext var1, @Nonnull StoreRecordFunction<T> var2, @Nonnull FDBRecord<M> var3);

    @Nonnull
    default public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull List<String> recordTypeNames, @Nonnull IndexAggregateFunction aggregateFunction, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        return this.evaluateAggregateFunction(recordTypeNames, aggregateFunction, aggregateFunction.adjustRange(evaluationContext, range), isolationLevel);
    }

    @Nonnull
    default public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull List<String> recordTypeNames, @Nonnull IndexAggregateFunction aggregateFunction, @Nonnull Key.Evaluated value, @Nonnull IsolationLevel isolationLevel) {
        return this.evaluateAggregateFunction(recordTypeNames, aggregateFunction, TupleRange.allOf(value.toTuple()), isolationLevel);
    }

    @Nonnull
    default public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull List<String> recordTypeNames, @Nonnull IndexAggregateFunction aggregateFunction, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        return this.evaluateAggregateFunction(recordTypeNames, aggregateFunction, range, isolationLevel, IndexQueryabilityFilter.TRUE);
    }

    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull List<String> var1, @Nonnull IndexAggregateFunction var2, @Nonnull TupleRange var3, @Nonnull IsolationLevel var4, @Nonnull IndexQueryabilityFilter var5);

    @Nonnull
    default public FDBQueriedRecord<M> queriedRecord(@Nonnull FDBStoredRecord<M> storedRecord) {
        return FDBQueriedRecord.stored(storedRecord);
    }

    @Nonnull
    default public FDBQueriedRecord<M> queriedRecord(@Nonnull FDBIndexedRecord<M> indexedRecord) {
        return FDBQueriedRecord.indexed(indexedRecord);
    }

    @Nonnull
    default public FDBQueriedRecord<M> coveredIndexQueriedRecord(@Nonnull Index index, @Nonnull IndexEntry indexEntry, @Nonnull RecordType recordType, @Nonnull M partialRecord, boolean hasPrimaryKey) {
        return FDBQueriedRecord.covered(index, indexEntry, hasPrimaryKey ? indexEntry.getPrimaryKey() : TupleHelpers.EMPTY, recordType, partialRecord);
    }

    @Nonnull
    default public RecordCursor<FDBQueriedRecord<M>> executeQuery(@Nonnull RecordQuery query) {
        return this.executeQuery(this.planQuery(query));
    }

    @Nonnull
    default public RecordCursor<FDBQueriedRecord<M>> executeQuery(@Nonnull RecordQuery query, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return this.executeQuery(this.planQuery(query), continuation, executeProperties);
    }

    @Nonnull
    default public RecordCursor<FDBQueriedRecord<M>> executeQuery(@Nonnull RecordQueryPlan plan) {
        return plan.execute(this, EvaluationContext.EMPTY);
    }

    @Nonnull
    default public RecordCursor<FDBQueriedRecord<M>> executeQuery(@Nonnull RecordQueryPlan plan, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        return plan.execute(this, EvaluationContext.EMPTY, continuation, executeProperties);
    }

    @Nonnull
    default public RecordCursor<QueryResult> executeQuery(@Nonnull RecordQueryPlan plan, @Nullable byte[] continuation, @Nonnull EvaluationContext evaluationContext, @Nonnull ExecuteProperties executeProperties) {
        return plan.executePlan(this, evaluationContext, continuation, executeProperties);
    }

    @Nonnull
    default public CascadesPlanner getCascadesPlanner() {
        return new CascadesPlanner(this.getRecordMetaData(), this.getRecordStoreState(), this.getIndexMaintainerRegistry());
    }

    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery var1, @Nonnull ParameterRelationshipGraph var2);

    public RecordQueryPlan planQuery(@Nonnull RecordQuery var1, @Nonnull ParameterRelationshipGraph var2, @Nonnull RecordQueryPlannerConfiguration var3);

    @Nonnull
    default public RecordQueryPlan planQuery(@Nonnull RecordQuery query) {
        return this.planQuery(query, ParameterRelationshipGraph.empty());
    }

    @API(value=API.Status.INTERNAL)
    default public RecordCursor<FDBIndexedRecord<M>> remoteFetchFallbackFrom(Index index, IndexScanType scanType, TupleRange scanRange, byte[] continuation, IndexOrphanBehavior orphanBehavior, ScanProperties scanProperties, RecordCursorResult<FDBIndexedRecord<M>> lastSuccessfulResult) {
        if (lastSuccessfulResult == null) {
            return this.scanIndexRecords(index, scanType, scanRange, continuation, orphanBehavior, scanProperties);
        }
        return this.scanIndexRecords(index, scanType, scanRange, lastSuccessfulResult.getContinuation().toBytes(), orphanBehavior, scanProperties);
    }

    @Nullable
    @API(value=API.Status.INTERNAL)
    default public KeyExpression getCommonPrimaryKey(@Nonnull Index index) {
        RecordMetaData metaData = this.getRecordMetaData();
        Collection<RecordType> recordTypes = metaData.recordTypesForIndex(index);
        return RecordMetaData.commonPrimaryKey(recordTypes);
    }

    @API(value=API.Status.INTERNAL)
    default public int getCommonPrimaryKeyLength(@Nonnull Index index) {
        RecordMetaData metaData = this.getRecordMetaData();
        Collection<RecordType> recordTypes = metaData.recordTypesForIndex(index);
        return RecordMetaData.commonPrimaryKeyLength(recordTypes);
    }

    public static enum VersionstampSaveBehavior {
        DEFAULT,
        NO_VERSION,
        WITH_VERSION,
        IF_PRESENT;

    }

    public static enum RecordExistenceCheck {
        NONE,
        ERROR_IF_EXISTS,
        ERROR_IF_NOT_EXISTS,
        ERROR_IF_RECORD_TYPE_CHANGED,
        ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED;


        public boolean errorIfExists() {
            return this == ERROR_IF_EXISTS;
        }

        public boolean errorIfNotExists() {
            return this == ERROR_IF_NOT_EXISTS || this == ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED;
        }

        public boolean errorIfTypeChanged() {
            return this == ERROR_IF_RECORD_TYPE_CHANGED || this == ERROR_IF_NOT_EXISTS_OR_RECORD_TYPE_CHANGED;
        }
    }

    public static interface PipelineSizer {
        public int getPipelineSize(@Nonnull PipelineOperation var1);
    }

    public static interface BaseBuilder<M extends Message, R extends FDBRecordStoreBase<M>> {
        @Nullable
        public RecordSerializer<M> getSerializer();

        @Nonnull
        public BaseBuilder<M, R> setSerializer(@Nonnull RecordSerializer<M> var1);

        @Deprecated(forRemoval=true)
        public int getFormatVersion();

        default public FormatVersion getFormatVersionEnum() {
            return FormatVersion.getFormatVersion(this.getFormatVersion());
        }

        @Deprecated(forRemoval=true)
        @Nonnull
        public BaseBuilder<M, R> setFormatVersion(int var1);

        default public BaseBuilder<M, R> setFormatVersion(FormatVersion formatVersion) {
            return this.setFormatVersion(formatVersion.getValueForSerialization());
        }

        @Nullable
        public RecordMetaDataProvider getMetaDataProvider();

        @Nonnull
        public BaseBuilder<M, R> setMetaDataProvider(@Nullable RecordMetaDataProvider var1);

        @Nullable
        public FDBMetaDataStore getMetaDataStore();

        @Nonnull
        public BaseBuilder<M, R> setMetaDataStore(@Nullable FDBMetaDataStore var1);

        @Nullable
        public FDBRecordContext getContext();

        @Nonnull
        public BaseBuilder<M, R> setContext(@Nullable FDBRecordContext var1);

        @Nullable
        public SubspaceProvider getSubspaceProvider();

        @Nonnull
        public BaseBuilder<M, R> setSubspaceProvider(@Nullable SubspaceProvider var1);

        @Nonnull
        @API(value=API.Status.UNSTABLE)
        public BaseBuilder<M, R> setSubspace(@Nullable Subspace var1);

        @Nonnull
        public BaseBuilder<M, R> setKeySpacePath(@Nullable KeySpacePath var1);

        @Nullable
        public UserVersionChecker getUserVersionChecker();

        @Nonnull
        public BaseBuilder<M, R> setUserVersionChecker(@Nullable UserVersionChecker var1);

        @Nonnull
        public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry();

        @Nonnull
        public BaseBuilder<M, R> setIndexMaintainerRegistry(@Nonnull IndexMaintainerFactoryRegistry var1);

        @Nonnull
        public IndexMaintenanceFilter getIndexMaintenanceFilter();

        @Nonnull
        public BaseBuilder<M, R> setIndexMaintenanceFilter(@Nonnull IndexMaintenanceFilter var1);

        @Nonnull
        public PipelineSizer getPipelineSizer();

        @Nonnull
        public BaseBuilder<M, R> setPipelineSizer(@Nonnull PipelineSizer var1);

        @Nullable
        @API(value=API.Status.EXPERIMENTAL)
        public FDBRecordStoreStateCache getStoreStateCache();

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        public BaseBuilder<M, R> setStoreStateCache(@Nonnull FDBRecordStoreStateCache var1);

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        public FDBRecordStore.StateCacheabilityOnOpen getStateCacheabilityOnOpen();

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        public BaseBuilder<M, R> setStateCacheabilityOnOpen(@Nonnull FDBRecordStore.StateCacheabilityOnOpen var1);

        @Nonnull
        public BaseBuilder<M, R> copyBuilder();

        @Nonnull
        public R build();

        @Nonnull
        default public R uncheckedOpen() {
            return (R)((FDBRecordStoreBase)this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_RECORD_STORE_STATE, this.uncheckedOpenAsync()));
        }

        @Nonnull
        default public R create() {
            return (R)((FDBRecordStoreBase)this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_VERSION, this.createAsync()));
        }

        @Nonnull
        default public R open() {
            return (R)((FDBRecordStoreBase)this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_VERSION, this.openAsync()));
        }

        @Nonnull
        default public R createOrOpen() {
            return (R)((FDBRecordStoreBase)this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_VERSION, this.createOrOpenAsync()));
        }

        @Nonnull
        default public R createOrOpen(@Nonnull StoreExistenceCheck existenceCheck) {
            return (R)((FDBRecordStoreBase)this.getContext().asyncToSync(FDBStoreTimer.Waits.WAIT_CHECK_VERSION, this.createOrOpenAsync(existenceCheck)));
        }

        @Nonnull
        public CompletableFuture<R> uncheckedOpenAsync();

        @Nonnull
        default public CompletableFuture<R> createAsync() {
            return this.createOrOpenAsync(StoreExistenceCheck.ERROR_IF_EXISTS);
        }

        @Nonnull
        default public CompletableFuture<R> openAsync() {
            return this.createOrOpenAsync(StoreExistenceCheck.ERROR_IF_NOT_EXISTS);
        }

        @Nonnull
        default public CompletableFuture<R> createOrOpenAsync() {
            return this.createOrOpenAsync(StoreExistenceCheck.ERROR_IF_NO_INFO_AND_NOT_EMPTY);
        }

        @Nonnull
        public CompletableFuture<R> createOrOpenAsync(@Nonnull StoreExistenceCheck var1);
    }

    public static enum StoreExistenceCheck {
        NONE,
        ERROR_IF_NO_INFO_AND_HAS_RECORDS_OR_INDEXES,
        ERROR_IF_NO_INFO_AND_NOT_EMPTY,
        ERROR_IF_EXISTS,
        ERROR_IF_NOT_EXISTS;

    }

    public static interface UserVersionChecker {
        default public CompletableFuture<Integer> checkUserVersion(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader, RecordMetaDataProvider metaData) {
            boolean newStore = storeHeader.getFormatVersion() == 0;
            int oldMetaDataVersion = newStore ? -1 : storeHeader.getMetaDataversion();
            int oldUserVersion = newStore ? -1 : storeHeader.getUserVersion();
            return this.checkUserVersion(oldUserVersion, oldMetaDataVersion, metaData);
        }

        @Deprecated
        @API(value=API.Status.DEPRECATED)
        public CompletableFuture<Integer> checkUserVersion(int var1, int var2, RecordMetaDataProvider var3);

        default public IndexState needRebuildIndex(Index index, long recordCount, boolean indexOnNewRecordTypes) {
            return FDBRecordStore.disabledIfTooManyRecordsForRebuild(recordCount, indexOnNewRecordTypes);
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        default public CompletableFuture<IndexState> needRebuildIndex(Index index, Supplier<CompletableFuture<Long>> lazyRecordCount, Supplier<CompletableFuture<Long>> lazyEstimatedSize, boolean indexOnNewRecordTypes) {
            return lazyRecordCount.get().thenApply(recordCount -> this.needRebuildIndex(index, (long)recordCount, indexOnNewRecordTypes));
        }
    }
}

