/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public enum FDBRecordStoreKeyspace {
    STORE_INFO(0L),
    RECORD(1L),
    INDEX(2L),
    INDEX_SECONDARY_SPACE(3L),
    RECORD_COUNT(4L),
    INDEX_STATE_SPACE(5L),
    INDEX_RANGE_SPACE(6L),
    INDEX_UNIQUENESS_VIOLATIONS_SPACE(7L),
    RECORD_VERSION_SPACE(8L),
    INDEX_BUILD_SPACE(9L);

    private long id;
    @Nonnull
    private Object key;

    private FDBRecordStoreKeyspace(long id) {
        this.id = id;
        this.key = id;
    }

    public long id() {
        return this.id;
    }

    @Nonnull
    public Object key() {
        return this.key;
    }

    public static FDBRecordStoreKeyspace fromKey(Object key) {
        if (key != null && key instanceof Long) {
            long id = (Long)key;
            for (FDBRecordStoreKeyspace keySpace : FDBRecordStoreKeyspace.values()) {
                if (id != keySpace.id) continue;
                return keySpace;
            }
        }
        throw new RecordCoreException("Unrecognized keyspace: " + String.valueOf(key), new Object[0]);
    }
}

