/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Versionstamp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBRecordVersion
implements Comparable<FDBRecordVersion> {
    private static final byte[] INCOMPLETE_GLOBAL_VERSION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final int GLOBAL_VERSION_LENGTH = 10;
    public static final int VERSION_LENGTH = 12;
    public static final FDBRecordVersion MIN_VERSION = FDBRecordVersion.complete(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final FDBRecordVersion MAX_VERSION = FDBRecordVersion.complete(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1});
    @Nonnull
    private final byte[] versionBytes;
    private final boolean complete;
    private final int localVersion;

    private static boolean isGlobalVersionComplete(@Nonnull byte[] versionBytes) {
        for (int i = 0; i < 10; ++i) {
            if (versionBytes[i] == INCOMPLETE_GLOBAL_VERSION[i]) continue;
            return true;
        }
        return false;
    }

    private static void validateLocalVersion(int localVersion) {
        if (localVersion < 0 || localVersion > 65535) {
            throw new RecordCoreException("Specified local version has invalid value " + localVersion, new Object[0]);
        }
    }

    private FDBRecordVersion(boolean complete, @Nonnull byte[] versionBytes, boolean copy) {
        if (versionBytes.length != 12) {
            throw new RecordCoreException("Specified version has invalid byte length " + versionBytes.length + " != 12", new Object[0]);
        }
        if (complete != FDBRecordVersion.isGlobalVersionComplete(versionBytes)) {
            throw new RecordCoreException(complete ? "Specified version has incomplete global version" : "Specified version has a complete global version", new Object[0]);
        }
        this.versionBytes = copy ? Arrays.copyOf(versionBytes, 12) : versionBytes;
        this.complete = complete;
        this.localVersion = ((versionBytes[10] & 0xFF) << 8) + (versionBytes[11] & 0xFF);
    }

    @Nonnull
    public static FDBRecordVersion complete(@Nonnull byte[] globalVersion, int localVersion) {
        if (globalVersion.length != 10) {
            throw new RecordCoreException("Specified global version has invalid length " + globalVersion.length, new Object[0]);
        }
        if (Arrays.equals(INCOMPLETE_GLOBAL_VERSION, globalVersion)) {
            throw new RecordCoreException("Specified version has incomplete global version", new Object[0]);
        }
        FDBRecordVersion.validateLocalVersion(localVersion);
        ByteBuffer buffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        buffer.put(globalVersion);
        buffer.putShort((short)localVersion);
        return new FDBRecordVersion(true, buffer.array(), false);
    }

    @Nonnull
    public static FDBRecordVersion complete(@Nonnull byte[] versionBytes) {
        return FDBRecordVersion.complete(versionBytes, true);
    }

    @Nonnull
    public static FDBRecordVersion complete(@Nonnull byte[] versionBytes, boolean copy) {
        return new FDBRecordVersion(true, versionBytes, copy);
    }

    @Nonnull
    public static FDBRecordVersion incomplete(int localVersion) {
        FDBRecordVersion.validateLocalVersion(localVersion);
        ByteBuffer buffer = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        buffer.put(INCOMPLETE_GLOBAL_VERSION);
        buffer.putShort((short)localVersion);
        return new FDBRecordVersion(false, buffer.array(), false);
    }

    @Nonnull
    public static FDBRecordVersion fromBytes(@Nonnull byte[] versionBytes) {
        return FDBRecordVersion.fromBytes(versionBytes, true);
    }

    @Nonnull
    public static FDBRecordVersion fromBytes(@Nonnull byte[] versionBytes, boolean copy) {
        if (versionBytes.length != 12) {
            throw new RecordCoreException("Specified version bytes have invalid length " + versionBytes.length, new Object[0]);
        }
        boolean complete = FDBRecordVersion.isGlobalVersionComplete(versionBytes);
        return new FDBRecordVersion(complete, versionBytes, copy);
    }

    @Nonnull
    public static FDBRecordVersion fromVersionstamp(@Nonnull Versionstamp versionstamp) {
        return FDBRecordVersion.fromVersionstamp(versionstamp, true);
    }

    @Nonnull
    public static FDBRecordVersion fromVersionstamp(@Nonnull Versionstamp versionstamp, boolean copy) {
        return new FDBRecordVersion(versionstamp.isComplete(), versionstamp.getBytes(), copy);
    }

    @Nonnull
    public static FDBRecordVersion firstInDBVersion(long dbVersion) {
        return FDBRecordVersion.complete(ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN).putLong(dbVersion).putInt(0).array(), false);
    }

    public static FDBRecordVersion firstInGlobalVersion(@Nonnull byte[] globalVersion) {
        return FDBRecordVersion.complete(globalVersion, 0);
    }

    public static FDBRecordVersion lastInDBVersion(long dbVersion) {
        return FDBRecordVersion.complete(ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN).putLong(dbVersion).putInt(-1).array(), false);
    }

    public static FDBRecordVersion lastInGlobalVersion(@Nonnull byte[] globalVersion) {
        return FDBRecordVersion.complete(globalVersion, 65535);
    }

    @Nonnull
    public Versionstamp toVersionstamp() {
        return this.toVersionstamp(true);
    }

    @Nonnull
    public Versionstamp toVersionstamp(boolean copy) {
        return Versionstamp.fromBytes(this.toBytes(copy));
    }

    @Nonnull
    public byte[] toBytes() {
        return this.toBytes(true);
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI"}, justification="option is explicitly set to do this")
    public byte[] toBytes(boolean copy) {
        if (copy) {
            return Arrays.copyOf(this.versionBytes, this.versionBytes.length);
        }
        return this.versionBytes;
    }

    @Nonnull
    public ByteBuffer writeTo(@Nonnull ByteBuffer buffer) {
        return buffer.put(this.versionBytes);
    }

    public int writeTo(@Nonnull byte[] bytes) {
        return this.writeTo(bytes, 0);
    }

    public int writeTo(@Nonnull byte[] bytes, int offset) {
        if (offset < 0 || offset + this.versionBytes.length > bytes.length) {
            throw new RecordCoreArgumentException("insufficient space in array to write version information", new Object[0]);
        }
        System.arraycopy(this.versionBytes, 0, bytes, offset, this.versionBytes.length);
        return offset + this.versionBytes.length;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getLocalVersion() {
        return this.localVersion;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI"}, justification="not mutated later")
    public byte[] getGlobalVersion() {
        if (this.isComplete()) {
            return Arrays.copyOfRange(this.versionBytes, 0, 10);
        }
        throw new IncompleteRecordVersionException();
    }

    public long getDBVersion() {
        if (this.isComplete()) {
            return ByteBuffer.wrap(this.versionBytes).order(ByteOrder.BIG_ENDIAN).getLong();
        }
        throw new IncompleteRecordVersionException();
    }

    @Nonnull
    public FDBRecordVersion next() {
        if (this.isComplete()) {
            byte[] newVersionBytes = Arrays.copyOf(this.versionBytes, 12);
            boolean stopped = false;
            for (int i = newVersionBytes.length - 1; i >= 0; --i) {
                if ((newVersionBytes[i] & 0xFF) != 255) {
                    newVersionBytes[i] = (byte)((newVersionBytes[i] & 0xFF) + 1);
                    stopped = true;
                    break;
                }
                newVersionBytes[i] = 0;
            }
            if (!stopped || !FDBRecordVersion.isGlobalVersionComplete(newVersionBytes)) {
                throw new RecordCoreException("Attempted to increment maximum version", new Object[0]);
            }
            return FDBRecordVersion.complete(newVersionBytes, false);
        }
        return FDBRecordVersion.incomplete(this.getLocalVersion() + 1);
    }

    @Nonnull
    public FDBRecordVersion prev() {
        if (this.isComplete()) {
            byte[] newVersionBytes = Arrays.copyOf(this.versionBytes, 12);
            boolean stopped = false;
            for (int i = newVersionBytes.length - 1; i >= 0; --i) {
                if (newVersionBytes[i] != 0) {
                    newVersionBytes[i] = (byte)((newVersionBytes[i] & 0xFF) - 1);
                    stopped = true;
                    break;
                }
                newVersionBytes[i] = -1;
            }
            if (!stopped) {
                throw new RecordCoreException("Attempted to decrement minimum version", new Object[0]);
            }
            return FDBRecordVersion.complete(newVersionBytes, false);
        }
        return FDBRecordVersion.incomplete(this.getLocalVersion() - 1);
    }

    @Nonnull
    public FDBRecordVersion withCommittedVersion(@Nullable byte[] committedVersion) {
        if (this.isComplete()) {
            throw new RecordCoreException("version is already complete", new Object[0]);
        }
        if (committedVersion == null) {
            throw new RecordCoreArgumentException("the given committed version was for a read-only transaction", new Object[0]);
        }
        return FDBRecordVersion.complete(committedVersion, this.getLocalVersion());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof FDBRecordVersion)) {
            return false;
        }
        FDBRecordVersion other = (FDBRecordVersion)o;
        if (this.isComplete() && other.isComplete()) {
            return Arrays.equals(this.versionBytes, other.toBytes(false));
        }
        return !this.isComplete() && !other.isComplete() && this.getLocalVersion() == other.getLocalVersion();
    }

    @Override
    public int compareTo(@Nonnull FDBRecordVersion other) {
        if (this.isComplete()) {
            if (other.isComplete()) {
                return ByteArrayUtil.compareUnsigned(this.versionBytes, other.versionBytes);
            }
            return -1;
        }
        if (other.isComplete()) {
            return 1;
        }
        return Integer.compare(this.getLocalVersion(), other.getLocalVersion());
    }

    public int hashCode() {
        return Arrays.hashCode(this.versionBytes);
    }

    @Nonnull
    public String toString() {
        return "FDBRecordVersion(" + ByteArrayUtil.printable(this.versionBytes) + ")";
    }

    public static class IncompleteRecordVersionException
    extends RecordCoreException {
        public IncompleteRecordVersionException() {
            super("Attempted to get global version on incomplete RecordVersion", new Object[0]);
        }
    }
}

