/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProviderBySubspace;
import com.apple.foundationdb.subspace.Subspace;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class FDBStoreBase {
    @Nonnull
    protected final FDBRecordContext context;
    @Nonnull
    protected final SubspaceProvider subspaceProvider;
    @Nullable
    private CompletableFuture<Subspace> subspaceFuture;
    @Nullable
    private Subspace subspace;

    @API(value=API.Status.UNSTABLE)
    protected FDBStoreBase(@Nonnull FDBRecordContext context, @Nonnull Subspace subspace) {
        this.context = context;
        this.subspaceProvider = new SubspaceProviderBySubspace(subspace);
    }

    protected FDBStoreBase(@Nonnull FDBRecordContext context, @Nonnull SubspaceProvider subspaceProvider) {
        this.context = context;
        this.subspaceProvider = subspaceProvider;
    }

    @Nonnull
    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    @Nonnull
    public FDBRecordContext getRecordContext() {
        return this.context;
    }

    @Nonnull
    public Transaction ensureContextActive() {
        return this.context.ensureActive();
    }

    @Nonnull
    public SubspaceProvider getSubspaceProvider() {
        return this.subspaceProvider;
    }

    @Nonnull
    public CompletableFuture<Subspace> getSubspaceAsync() {
        if (this.subspaceFuture == null) {
            return this.subspaceProvider.getSubspaceAsync(this.context).whenComplete((s2, e) -> {
                if (e == null) {
                    this.subspace = s2;
                    this.subspaceFuture = CompletableFuture.completedFuture(this.subspace);
                }
            });
        }
        return this.subspaceFuture;
    }

    @Nonnull
    public Subspace getSubspace() {
        if (this.subspace == null) {
            this.subspace = this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_KEYSPACE_PATH_RESOLVE, this.getSubspaceAsync());
        }
        return this.subspace;
    }

    public void addConflictForSubspace(boolean write) {
        Range range = this.getSubspace().range();
        Transaction tr = this.context.ensureActive();
        if (write) {
            tr.addWriteConflictRange(range.begin, range.end);
        } else {
            tr.addReadConflictRange(range.begin, range.end);
        }
    }

    @Nullable
    public FDBStoreTimer getTimer() {
        return this.context.getTimer();
    }

    public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future) {
        return this.context.instrument(event, future);
    }

    public <T> CompletableFuture<T> instrument(Set<StoreTimer.Event> events, CompletableFuture<T> future) {
        return this.context.instrument(events, future);
    }

    public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future, long startTime) {
        return this.context.instrument(event, future, startTime);
    }

    public void record(@Nonnull StoreTimer.Event event, long timeDelta) {
        this.context.record(event, timeDelta);
    }

    public void increment(@Nonnull StoreTimer.Count count) {
        this.context.increment(count);
    }

    public void increment(@Nonnull StoreTimer.Count count, int amount) {
        this.context.increment(count, amount);
    }
}

