/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBStoreTimer
extends StoreTimer {
    protected static final Set<StoreTimer.Aggregate> ALL_AGGREGATES = ((ImmutableSet.Builder)new ImmutableSet.Builder().add(CountAggregates.values())).build();

    protected static Stream<StoreTimer.Event> possibleEvents() {
        return Stream.of(Events.values(), DetailEvents.values(), Waits.values(), Counts.values(), CountAggregates.values(), RecordSerializer.Events.values()).flatMap(Arrays::stream);
    }

    @Override
    @Nonnull
    public Set<StoreTimer.Aggregate> getAggregates() {
        return ALL_AGGREGATES;
    }

    @Override
    public void recordTimeout(StoreTimer.Wait event, long startTime) {
        long totalNanos = System.nanoTime() - startTime;
        this.getCounter(Events.TIMEOUTS, true).record(totalNanos);
        this.getTimeoutCounter(event, true).record(totalNanos);
    }

    static {
        FDBStoreTimer.checkEventNameUniqueness(FDBStoreTimer.possibleEvents());
    }

    public static enum Events implements StoreTimer.Event
    {
        PERFORM_NO_OP("perform no-op"),
        GET_READ_VERSION("get read version"),
        BATCH_GET_READ_VERSION("batch priority get read version"),
        INJECTED_GET_READ_VERSION_LATENCY("injected get read version latency"),
        COMMIT("commit transaction"),
        INJECTED_COMMIT_LATENCY("injected commit latency"),
        COMMIT_READ_ONLY("commit read-only transaction"),
        COMMIT_FAILURE("commit transaction with failure"),
        ESTIMATE_SIZE("estimate the size of a key range"),
        SAVE_META_DATA("save meta-data"),
        LOAD_META_DATA("load meta-data"),
        LOAD_RECORD_STORE_STATE("load record store state"),
        LOAD_RECORD_STORE_INFO("load record store info"),
        LOAD_RECORD_STORE_INDEX_META_DATA("load record store index meta-data"),
        GET_META_DATA_CACHE_VERSION("get meta-data cache version"),
        GET_META_DATA_CACHE_ENTRY("get meta-data cache entry"),
        SAVE_RECORD("save record"),
        LOAD_RECORD("load record"),
        SCAN_RECORDS("scan records"),
        SCAN_INDEX_KEYS("scan index"),
        SCAN_REMOTE_FETCH_ENTRY("remote fetch index entry"),
        DELETE_RECORD("delete record"),
        SKIP_INDEX_RECORD_BY_PREDICATE("skip index record by index predicates"),
        USE_INDEX_RECORD_BY_PREDICATE("use index record by index predicates"),
        SKIP_INDEX_RECORD("skip index record"),
        SKIP_INDEX_ENTRY("skip index entry"),
        SAVE_INDEX_ENTRY("save index entry"),
        DELETE_INDEX_ENTRY("delete index entry"),
        MUTATE_INDEX_ENTRY("mutate index entry"),
        MERGE_INDEX("merge index"),
        REBUILD_INDEX("rebuild index for any reason"),
        REBUILD_INDEX_NEW_STORE("rebuild index for a new store"),
        REBUILD_INDEX_FEW_RECORDS("rebuild index with few records"),
        REBUILD_INDEX_COUNTS_UNKNOWN("rebuild index with counts unknown"),
        REBUILD_INDEX_REBUILD_ALL("rebuild index during rebuild all"),
        REBUILD_INDEX_EXPLICIT("rebuild index by an explicit request"),
        REBUILD_INDEX_TEST("rebuild index during test"),
        INDEXER_DELAY("indexer delay"),
        RANGE_SET_INSERT("insert into range set"),
        RANGE_SET_LIST_MISSING("list missing ranges from range set"),
        RANGE_SET_FIND_FIRST_MISSING("find first missing range from range set"),
        RANGE_SET_CONTAINS("range set contains key"),
        RANGE_SET_IS_EMPTY("range set is empty"),
        REMOVE_FORMER_INDEX("remove former index"),
        RECOUNT_RECORDS("recount records"),
        CHECK_INDEX_UNIQUENESS("check index uniqueness"),
        CHECK_VERSION("check meta-data version"),
        DIRECTORY_READ("directory read"),
        SCOPED_DIRECTORY_LAYER_READ("read the value from the scoped directory layer"),
        SCOPED_DIRECTORY_LAYER_CREATE("create the value in the scoped directory layer"),
        EXTENDED_DIRECTORY_LAYER_READ("read the value from the extended directory layer"),
        EXTENDED_DIRECTORY_LAYER_CREATE("create the value in the extended directory layer"),
        INTERNING_LAYER_READ("read the value from the interning layer"),
        INTERNING_LAYER_CREATE("create the value in the interning layer"),
        LOAD_BOUNDARY_KEYS("load boundary keys"),
        READ_SAMPLE_KEY("read sample key"),
        PLAN_QUERY("plan query"),
        QUERY_FILTER("filter records"),
        QUERY_AGGREGATE("aggregate records"),
        QUERY_TYPE_FILTER("filter records by type"),
        QUERY_TEXT_FILTER("filter records by text contents"),
        QUERY_INTERSECTION("compare query records for intersection"),
        QUERY_UNION("compare query records for union"),
        QUERY_DISTINCT("compare query records for distinct"),
        QUERY_PK_DISTINCT("compare record primary key for distinct"),
        QUERY_SELECTOR("execute one iteration of selected plan"),
        QUERY_COMPARATOR("execute multiple plans and compare results"),
        TIME_WINDOW_LEADERBOARD_GET_DIRECTORY("leaderboard get directory"),
        TIME_WINDOW_LEADERBOARD_UPDATE_DIRECTORY("leaderboard update directory"),
        TIME_WINDOW_LEADERBOARD_TRIM_SCORES("leaderboard trim scores"),
        TIME_WINDOW_LEADERBOARD_GET_SUB_DIRECTORY("leaderboard get sub-directory"),
        TIME_WINDOW_LEADERBOARD_SAVE_SUB_DIRECTORY("leaderboard save sub-directory"),
        RETRY_DELAY("retry delay"),
        TIMEOUTS("timeouts"),
        COMMITS("commits"),
        FETCHES("fetches"),
        TRANSACTION_TIME("transaction time");

        private final String title;
        private final String logKey;

        private Events(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.Event.super.logKey();
        }

        private Events(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }

    public static enum DetailEvents implements StoreTimer.DetailEvent
    {
        GET_RECORD_RAW_VALUE("get record raw value"),
        GET_RECORD_RANGE_RAW_FIRST_CHUNK("get record range raw first chunk"),
        GET_SCAN_RANGE_RAW_FIRST_CHUNK("get scan range raw first chunk"),
        RANKED_SET_INIT("ranked set init"),
        RANKED_SET_NEXT_LOOKUP("ranked set next lookup"),
        RANKED_SET_NEXT_LOOKUP_KEY("ranked set next lookup key"),
        RANKED_SET_CONTAINS("ranked set contains"),
        RANKED_SET_ADD_LEVEL_ZERO_KEY("ranked set add level 0 key"),
        RANKED_SET_ADD_INCREMENT_LEVEL_KEY("ranked set add increment level key"),
        RANKED_SET_ADD_INSERT_LEVEL_KEY("ranked set add insert level key"),
        RESOLVER_STATE_READ("read resolver state"),
        RD_CACHE_DIRECTORY_SCAN("reverse directory cache hard miss, scanning directory subspace"),
        LOCKS_REGISTERED("register lock"),
        LOCKS_ACQUIRED("acquire lock");

        private final String title;
        private final String logKey;

        private DetailEvents(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.DetailEvent.super.logKey();
        }

        private DetailEvents(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }

    public static enum Waits implements StoreTimer.Wait
    {
        WAIT_ERROR_CHECK("check for error completion"),
        WAIT_PERFORM_NO_OP("wait for performing a no-op"),
        WAIT_GET_READ_VERSION("get_read_version"),
        WAIT_COMMIT("wait for commit"),
        WAIT_APPROXIMATE_TRANSACTION_SIZE("wait to get the approximate transaction size"),
        WAIT_ESTIMATE_SIZE("wait to estimate the size of a key range"),
        WAIT_SAVE_META_DATA("wait for save meta-data"),
        WAIT_LOAD_META_DATA("wait for load meta-data"),
        WAIT_LOAD_RECORD_STORE_STATE("wait for load record store state"),
        WAIT_LOAD_RECORD("wait for load record"),
        WAIT_LOAD_RECORD_VERSION("wait for load record version"),
        WAIT_SAVE_RECORD("wait for save record"),
        WAIT_RECORD_EXISTS("wait to check if a record exists"),
        WAIT_DELETE_RECORD("wait for delete record"),
        WAIT_DIRECTORY_RESOLVE("wait for directory resolve"),
        WAIT_CHECK_VERSION("wait for check version"),
        WAIT_ONLINE_BUILD_INDEX("wait for online build index"),
        WAIT_STOP_ONLINE_INDEX_BUILD("wait for stopping ongoing online index builds"),
        WAIT_CHECK_ONGOING_ONLINE_INDEX_BUILD("wait for checking ongoing online index builds"),
        WAIT_ONLINE_MERGE_INDEX("wait for online merge index"),
        WAIT_BUILD_ENDPOINTS("wait for building endpoints"),
        WAIT_SCAN_RECORDS("wait for scan records"),
        WAIT_SCAN_INDEX_RECORDS("wait for scan index records"),
        WAIT_GET_INDEX_BUILD_STATE("wait for getting index build state"),
        WAIT_EXECUTE_QUERY("wait for execute query"),
        WAIT_REVERSE_DIRECTORY_SCAN("wait for reverse directory scan"),
        WAIT_REVERSE_DIRECTORY_LOOKUP("wait for reverse directory lookup"),
        WAIT_REVERSE_DIRECTORY_LOCATE("wait for finding reverse directory location"),
        WAIT_INDEX_OPERATION("wait for index operation"),
        WAIT_INDEX_TYPESTAMP_OPERATION("wait for indexing type stamp operation"),
        WAIT_INDEX_CLEAR_HEARTBEATS("Wait for clearing indexing heartbeats"),
        WAIT_INDEX_READ_HEARTBEATS("Wait for reading indexing heartbeats"),
        WAIT_ADD_INDEX("wait for adding an index"),
        WAIT_DROP_INDEX("wait for dropping an index"),
        WAIT_UPDATE_RECORDS_DESCRIPTOR("wait for updating the records descriptor"),
        WAIT_MUTATE_METADATA("wait for meta-data mutation"),
        WAIT_UPDATE_STORE_RECORD_VERSIONS("wait for updating if record versions must be stored"),
        WAIT_ENABLE_SPLIT_LONG_RECORDS("wait for enabling splitting long records"),
        WAIT_VERSION_STAMP("wait for version stamp"),
        WAIT_META_DATA_VERSION_STAMP("wait for meta-data version stamp"),
        WAIT_ADVANCE_CURSOR("wait for advance cursor"),
        WAIT_KEYSPACE_SCAN("wait scanning keyspace"),
        WAIT_KEYSPACE_LIST("wait for listing keyspace"),
        WAIT_KEYSPACE_CLEAR("wait for clearing keyspace"),
        WAIT_KEYSPACE_PATH_RESOLVE("wait for keyspace path resolve"),
        WAIT_LOCATABLE_RESOLVER_COMPUTE_DIGEST("wait for computing directory layer digest"),
        WAIT_LOCATABLE_RESOLVER_MAPPING_COPY("wait for copying contents of directory layer"),
        WAIT_RETRY_DELAY("wait for retry delay"),
        WAIT_COLLECT_STATISTICS("wait for statistics to be collected of a record store or index"),
        WAIT_GET_BOUNDARY("wait for boundary result from locality api"),
        WAIT_SET_STATE_CACHEABILITY("wait to set state cacheability"),
        WAIT_INIT_SYNC_SESSION("wait for initializing a synchronized session"),
        WAIT_CHECK_SYNC_SESSION("wait for checking a synchronized session"),
        WAIT_END_SYNC_SESSION("wait for ending a synchronized session"),
        WAIT_EDIT_HEADER_USER_FIELD("wait to edit a header user field"),
        WAIT_LOAD_SYSTEM_KEY("wait for reading a key from the FDB system keyspace"),
        WAIT_VALIDATE_RESOLVER("wait validating resolver"),
        WAIT_LOAD_LUCENE_PARTITION_METADATA("wait to load lucene partition metadata");

        private final String title;
        private final String logKey;

        private Waits(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.Wait.super.logKey();
        }

        private Waits(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }

    public static enum Counts implements StoreTimer.Count
    {
        OPEN_CONTEXT("open record context", false),
        CLOSE_CONTEXT("close record context", false),
        CLOSE_CONTEXT_OPEN_TOO_LONG("close record context open too long", false),
        CREATE_RECORD_STORE("create record store", false),
        STORE_STATE_CACHE_HIT("store info cache hit", false),
        STORE_STATE_CACHE_MISS("store info cache miss", false),
        SAVE_RECORD_KEY("number of record keys saved", false, null, true),
        SAVE_RECORD_KEY_BYTES("number of record key bytes saved", true, null, true),
        SAVE_RECORD_VALUE_BYTES("number of record value bytes saved", true, null, true),
        LOAD_SCAN_ENTRY("number of entries loaded by some scan", false),
        LOAD_KEY_VALUE("number of keys loaded", false),
        LOAD_TEXT_ENTRY("number of text entries loaded", false),
        LOAD_RECORD_KEY("number of record keys loaded", false),
        LOAD_RECORD_KEY_BYTES("number of record key bytes loaded", true),
        LOAD_RECORD_VALUE_BYTES("number of record value bytes loaded", true),
        SAVE_INDEX_KEY("number of index keys saved", false, null, true),
        SAVE_INDEX_KEY_BYTES("number of index key bytes saved", true, null, true),
        SAVE_INDEX_VALUE_BYTES("number of index value bytes saved", true, null, true),
        LOAD_INDEX_KEY("number of index keys loaded", false),
        LOAD_INDEX_KEY_BYTES("number of index key bytes loaded", true),
        LOAD_INDEX_VALUE_BYTES("number of index value bytes loaded", true),
        LOAD_STORE_STATE_KEY("number of store state keys loaded", false),
        LOAD_STORE_STATE_KEY_BYTES("number of store state key bytes loaded", true),
        LOAD_STORE_STATE_VALUE_BYTES("number of store state value bytes loaded", true),
        DELETE_RECORD_KEY("number of record keys deleted", false, null, true),
        DELETE_RECORD_KEY_BYTES("number of record key bytes deleted", true, null, true),
        DELETE_RECORD_VALUE_BYTES("number of record value bytes deleted", true, null, true),
        DELETE_INDEX_KEY("number of index keys deleted", false, null, true),
        DELETE_INDEX_KEY_BYTES("number of index key bytes deleted", true, null, true),
        DELETE_INDEX_VALUE_BYTES("number of index value bytes deleted", true, null, true),
        REPLACE_RECORD_VALUE_BYTES("number of record value bytes replaced", true, null, true),
        REVERSE_DIR_PERSISTENT_CACHE_MISS_COUNT("number of persistent cache misses", false),
        REVERSE_DIR_PERSISTENT_CACHE_HIT_COUNT("number of persistent cache hits", false),
        RANGE_SET_CLEAR("range set clears", false),
        PLAN_COVERING_INDEX("number of covering index plans", false),
        PLAN_FILTER("number of filter plans", false),
        PLAN_AGGREGATE("number of streaming aggregate plans", false),
        PLAN_INDEX("number of index plans", false),
        PLAN_OVERSCAN_INDEX("number of overscan index plans", false),
        PLAN_IN_PARAMETER("number of in plans with parameters", false),
        PLAN_IN_UNION("number of in union plans", false),
        PLAN_IN_VALUES("number of in plans with values", false),
        PLAN_IN_COMPARAND("number of in plans with comparison comparands", false),
        PLAN_INTERSECTION("number of intersection plans", false),
        PLAN_LOAD_BY_KEYS("number of load-by-keys plans", false),
        PLAN_SCAN("number of scan plans", false),
        PLAN_SCORE_FOR_RANK("number of score-for-rank plans", false),
        PLAN_TYPE_FILTER("number of type filter plans", false),
        PLAN_UNION("number of union plans", false),
        PLAN_UNORDERED_UNION("number of unordered union plans", false),
        PLAN_DISTINCT("number of unordered distinct plans", false),
        PLAN_PK_DISTINCT("number of unordered distinct plans by primary key", false),
        PLAN_FETCH("number of fetch from partial record plans", false),
        PLAN_COMPOSED_BITMAP_INDEX("number of composed bitmap plans", false),
        PLAN_SORT("number of sort plans", false),
        PLAN_DAM("number of dam plans", false),
        PLAN_SYNTHETIC_TYPE("number of synthetic record types plans", false),
        PLAN_RECURSIVE_UNION("number of recursive union plans", false),
        QUERY_FILTER_GIVEN("number of records given to any filter within any plan", false),
        QUERY_FILTER_PASSED("number of records passed by any filter within any plan", false),
        QUERY_FILTER_PLAN_GIVEN("number of records given to RecordQueryFilterPlan", false),
        QUERY_FILTER_PLAN_PASSED("number of records passed by RecordQueryFilterPlan", false),
        QUERY_TYPE_FILTER_PLAN_GIVEN("number of records given to RecordQueryTypeFilterPlan", false),
        QUERY_TYPE_FILTER_PLAN_PASSED("number of records passed by RecordQueryTypeFilterPlan", false),
        QUERY_TEXT_FILTER_PLAN_GIVEN("number of records given to a filter within a RecordQueryTextIndexPlan", false),
        QUERY_TEXT_FILTER_PLAN_PASSED("number of records passed by a filter within a RecordQueryTextIndexPlan", false),
        QUERY_DISTINCT_PLAN_DUPLICATES("number of duplicates found by RecordQueryUnorderedDistinctPlan", false),
        QUERY_DISTINCT_PLAN_UNIQUES("number of unique records found by RecordQueryUnorderedDistinctPlan", false),
        QUERY_PK_DISTINCT_PLAN_DUPLICATES("number of duplicates found by RecordQueryUnorderedPrimaryKeyDistinctPlan", false),
        QUERY_PK_DISTINCT_PLAN_UNIQUES("number of unique records found by RecordQueryUnorderedPrimaryKeyDistinctPlan", false),
        QUERY_INTERSECTION_PLAN_MATCHES("number of matching records found by RecordQueryIntersectionPlan", false),
        QUERY_INTERSECTION_PLAN_NONMATCHES("number of non-matching records found by RecordQueryIntersectionPlan", false),
        QUERY_UNION_PLAN_DUPLICATES("number of duplicates found by RecordQueryUnorderedDistinctPlan", false),
        QUERY_UNION_PLAN_UNIQUES("number of unique records found by RecordQueryUnorderedDistinctPlan", false),
        QUERY_DISCARDED("number of records loaded but filtered out", false),
        QUERY_AGGREGATE_GROUPS("number of aggregate groups", false),
        QUERY_AGGREGATE_GROUP_MAX_SIZE("max size of aggregate group", false),
        PLAN_COMPARATOR("number of comparator plans", false),
        PLAN_SELECTOR("number of selector plans", false),
        QUERY_COMPARATOR_MATCH("number of records matched", false),
        QUERY_COMPARATOR_MISMATCH("number of record comparison mismatched", false),
        QUERY_COMPARATOR_COMPARED("number of comparisons", false),
        SET_READ_VERSION_TO_LAST_SEEN("set read version to last seen version", false),
        ONLINE_INDEX_BUILDER_RECORDS_SCANNED("number of records scanned by online index build", false),
        ONLINE_INDEX_BUILDER_RECORDS_INDEXED("number of records indexed by online index build", false),
        ONLINE_INDEX_BUILDER_RANGES_BY_COUNT("number of indexer iterations terminated by scan limit", false),
        ONLINE_INDEX_BUILDER_RANGES_BY_SIZE("number of indexer iterations terminated by write limit", false),
        ONLINE_INDEX_BUILDER_RANGES_BY_TIME("number of indexer iterations terminated by time limit", false),
        ONLINE_INDEX_BUILDER_RANGES_BY_DEPLETION("number of indexer iterations terminated by cursor's range depletion", false),
        MUTUAL_INDEXER_FULL_START("counter: start indexing a 'FULL' fragment", false),
        MUTUAL_INDEXER_FULL_DONE("counter: done indexing a 'FULL' fragment", false),
        MUTUAL_INDEXER_ANY_START("counter: start indexing an 'ANY' fragment", false),
        MUTUAL_INDEXER_ANY_DONE("counter: done indexing an 'ANY' fragment", false),
        MUTUAL_INDEXER_ANY_JUMP("counter: had conflicts while indexing an 'ANY' fragment, jump ahead", false),
        INDEX_SCRUBBER_MISSING_ENTRIES("number of missing index entries detected by online scrubber", false),
        INDEX_SCRUBBER_DANGLING_ENTRIES("number of dangling index entries detected by online scrubber", false),
        TIME_WINDOW_LEADERBOARD_ADD_WINDOW("number of leaderboard windows added", false),
        TIME_WINDOW_LEADERBOARD_DELETE_WINDOW("number of leaderboard windows deleted", false),
        TIME_WINDOW_LEADERBOARD_OVERLAPPING_CHANGED("number of leaderboard conditional rebuilds", false),
        BAD_INDEX_ENTRY("number of occurrences of bad index entries", false),
        REPAIR_RECORD_KEY("repair record key", false, null, true),
        INVALID_SPLIT_SUFFIX("invalid split suffix", false),
        INVALID_KEY_LENGTH("invalid record key", false),
        INDEXES_NEED_REBUILDING("indexes need rebuilding", false),
        BYTES_READ("bytes read", true),
        BYTES_WRITTEN("bytes written", true, null, true),
        READS("reads", false),
        RANGE_READS("range reads", false),
        REMOTE_FETCH("remote fetch reads", false),
        WRITES("writes", false, null, true),
        DELETES("deletes", false, null, true),
        RANGE_DELETES("range deletes", false, null, true),
        MUTATIONS("mutations", false, null, true),
        JNI_CALLS("jni calls", false),
        BYTES_FETCHED("bytes fetched", false),
        RANGE_FETCHES("range fetches", false),
        RANGE_KEYVALUES_FETCHED("range key-values ", false),
        CHUNK_READ_FAILURES("read fails", false),
        COMMITS_FAILED("commits failed", false),
        CONFLICTS("conflicts", false),
        COMMIT_UNKNOWN("commit unknown", false),
        TRANSACTION_TOO_LARGE("transaction too large", false),
        EMPTY_SCANS("empty scans", false),
        MULTIDIMENSIONAL_LEAF_NODE_READS("leaf nodes read", false),
        MULTIDIMENSIONAL_LEAF_NODE_READ_BYTES("leaf node bytes read", true),
        MULTIDIMENSIONAL_LEAF_NODE_WRITES("leaf nodes written", false),
        MULTIDIMENSIONAL_LEAF_NODE_WRITE_BYTES("leaf node bytes written", true),
        MULTIDIMENSIONAL_INTERMEDIATE_NODE_READS("intermediate nodes read", false),
        MULTIDIMENSIONAL_INTERMEDIATE_NODE_READ_BYTES("intermediate node bytes read", true),
        MULTIDIMENSIONAL_INTERMEDIATE_NODE_WRITES("intermediate nodes written", false),
        MULTIDIMENSIONAL_INTERMEDIATE_NODE_WRITE_BYTES("intermediate node bytes written", true),
        MULTIDIMENSIONAL_CHILD_NODE_DISCARDS("child node discards", false),
        LOCKS_ATTEMPTED("number of attempts to register a lock", false),
        LOCKS_RELEASED("number of locks released", false);

        private final String title;
        private final boolean isSize;
        private final String logKey;
        private final boolean delayedUntilCommit;

        private Counts(String title, boolean isSize, String logKey, boolean delayedUntilCommit) {
            this.title = title;
            this.isSize = isSize;
            this.logKey = logKey != null ? logKey : StoreTimer.Count.super.logKey();
            this.delayedUntilCommit = delayedUntilCommit;
        }

        private Counts(String title, boolean isSize) {
            this(title, isSize, null, false);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public boolean isDelayedUntilCommit() {
            return this.delayedUntilCommit;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }

        @Override
        public boolean isSize() {
            return this.isSize;
        }
    }

    public static enum CountAggregates implements StoreTimer.Aggregate,
    StoreTimer.Count
    {
        BYTES_DELETED("bytes deleted", Counts.DELETE_RECORD_KEY_BYTES, Counts.DELETE_RECORD_VALUE_BYTES, Counts.DELETE_INDEX_KEY_BYTES, Counts.DELETE_INDEX_VALUE_BYTES, Counts.REPLACE_RECORD_VALUE_BYTES);

        @Nonnull
        private final String title;
        private final boolean isSize;
        @Nonnull
        private final String logKey;
        @Nonnull
        private final Set<StoreTimer.Count> events;

        private CountAggregates(String title, StoreTimer.Count ... events) {
            this(title, (String)null, events);
        }

        private CountAggregates(@Nonnull String title, String logKey, StoreTimer.Count ... events) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.Aggregate.super.logKey();
            this.events = ImmutableSet.copyOf((StoreTimer.Count[])this.validate((first, other) -> {
                if (first.isSize() != other.isSize()) {
                    throw new IllegalArgumentException("All counts must have the same isSize()");
                }
            }, events));
            this.isSize = events[0].isSize();
        }

        @Override
        @Nonnull
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }

        public Set<StoreTimer.Count> getComponentEvents() {
            return this.events;
        }

        @Override
        @Nullable
        public StoreTimer.Counter compute(@Nonnull StoreTimer storeTimer) {
            return this.compute(storeTimer, this.events);
        }

        @Override
        public boolean isSize() {
            return this.isSize;
        }
    }
}

