/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecordBuilder;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBStoredRecord<M extends Message>
implements FDBIndexableRecord<M> {
    @Nonnull
    private final Tuple primaryKey;
    @Nonnull
    private final RecordType recordType;
    @Nonnull
    private final M protoRecord;
    @Nullable
    private final FDBRecordVersion recordVersion;
    private final int keyCount;
    private final int keySize;
    private final int valueSize;
    private final boolean split;
    private final boolean versionedInline;

    public FDBStoredRecord(@Nonnull Tuple primaryKey, @Nonnull RecordType recordType, @Nonnull M protoRecord, @Nonnull FDBStoredSizes size, @Nullable FDBRecordVersion recordVersion) {
        this(primaryKey, recordType, protoRecord, size.getKeyCount(), size.getKeySize(), size.getValueSize(), size.isSplit(), size.isVersionedInline(), recordVersion);
    }

    @API(value=API.Status.INTERNAL)
    public FDBStoredRecord(@Nonnull Tuple primaryKey, @Nonnull RecordType recordType, @Nonnull M protoRecord, int keyCount, int keySize, int valueSize, boolean split, boolean versionedInline, @Nullable FDBRecordVersion recordVersion) {
        this.primaryKey = primaryKey;
        this.recordType = recordType;
        this.protoRecord = protoRecord;
        this.keyCount = keyCount;
        this.keySize = keySize;
        this.valueSize = valueSize;
        this.split = split;
        this.recordVersion = recordVersion;
        this.versionedInline = versionedInline;
    }

    @Override
    @Nonnull
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    @Nonnull
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    @Nonnull
    public M getRecord() {
        return this.protoRecord;
    }

    @Override
    public boolean hasVersion() {
        return this.recordVersion != null;
    }

    @Override
    @Nullable
    public FDBRecordVersion getVersion() {
        return this.recordVersion;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    @Override
    public boolean isVersionedInline() {
        return this.versionedInline;
    }

    @Nonnull
    public static <M extends Message> FDBStoredRecordBuilder<M> newBuilder() {
        return new FDBStoredRecordBuilder();
    }

    @Nonnull
    public static <M extends Message> FDBStoredRecordBuilder<M> newBuilder(@Nonnull M protoRecord) {
        return new FDBStoredRecordBuilder<M>(protoRecord);
    }

    public FDBStoredRecordBuilder<M> asBuilder() {
        return new FDBStoredRecordBuilder(this);
    }

    @Nonnull
    public FDBStoredRecord<M> withVersion(@Nullable FDBRecordVersion recordVersion) {
        return new FDBStoredRecord<M>(this.primaryKey, this.recordType, this.protoRecord, this, recordVersion);
    }

    @Nonnull
    public FDBStoredRecord<M> withCommittedVersion(@Nullable byte[] committedVersion) {
        if (this.recordVersion == null || this.recordVersion.isComplete()) {
            return this;
        }
        return this.withVersion(this.recordVersion.withCommittedVersion(committedVersion));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDBStoredRecord that = (FDBStoredRecord)o;
        if (!this.primaryKey.equals(that.primaryKey)) {
            return false;
        }
        if (!this.recordType.getName().equals(that.recordType.getName())) {
            return false;
        }
        if (!this.protoRecord.equals(that.protoRecord)) {
            return false;
        }
        if (this.recordVersion == null && that.recordVersion != null || this.recordVersion != null && !this.recordVersion.equals(that.recordVersion)) {
            return false;
        }
        return this.keyCount == that.keyCount && this.keySize == that.keySize && this.valueSize == that.valueSize && this.split == that.split && this.versionedInline == that.versionedInline;
    }

    public int hashCode() {
        int result = this.primaryKey.hashCode();
        result = 31 * result + this.recordType.getName().hashCode();
        result = 31 * result + this.protoRecord.hashCode();
        result = 31 * result + this.keyCount;
        result = 31 * result + this.keySize;
        result = 31 * result + this.valueSize;
        if (this.recordVersion != null) {
            result = 31 * result + this.recordVersion.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.recordType.getName());
        str.append(this.primaryKey);
        if (this.hasVersion()) {
            str.append(this.recordVersion);
        }
        return str.toString();
    }
}

