/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBStoredRecordBuilder<M extends Message>
implements FDBRecord<M>,
FDBStoredSizes {
    @Nullable
    private Tuple primaryKey;
    @Nullable
    private RecordType recordType;
    @Nullable
    private M protoRecord;
    @Nullable
    private FDBRecordVersion recordVersion;
    private int keyCount;
    private int keySize;
    private int valueSize;
    private boolean split;
    private boolean versionedInline;

    public FDBStoredRecordBuilder() {
    }

    public FDBStoredRecordBuilder(@Nonnull M protoRecord) {
        this.protoRecord = protoRecord;
    }

    public FDBStoredRecordBuilder(@Nonnull FDBStoredRecord<M> record) {
        this.protoRecord = record.getRecord();
        this.primaryKey = record.getPrimaryKey();
        this.recordType = record.getRecordType();
        this.keyCount = record.getKeyCount();
        this.keySize = record.getKeySize();
        this.valueSize = record.getValueSize();
        this.split = record.isSplit();
        this.recordVersion = record.getVersion();
        this.versionedInline = record.isVersionedInline();
    }

    @Override
    @Nonnull
    public Tuple getPrimaryKey() {
        if (this.primaryKey == null) {
            throw new RecordCoreException("primary key has not been set", new Object[0]);
        }
        return this.primaryKey;
    }

    @Override
    @Nonnull
    public RecordType getRecordType() {
        if (this.recordType == null) {
            throw new RecordCoreException("record type has not been set", new Object[0]);
        }
        return this.recordType;
    }

    @Override
    @Nonnull
    public M getRecord() {
        if (this.protoRecord == null) {
            throw new RecordCoreException("record has not been set", new Object[0]);
        }
        return this.protoRecord;
    }

    @Override
    public boolean hasVersion() {
        return this.recordVersion != null;
    }

    @Override
    @Nullable
    public FDBRecordVersion getVersion() {
        return this.recordVersion;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    @Override
    public boolean isVersionedInline() {
        return this.versionedInline;
    }

    public FDBStoredRecordBuilder<M> setPrimaryKey(Tuple primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FDBStoredRecordBuilder<M> setRecordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public FDBStoredRecordBuilder<M> setRecord(M record) {
        this.protoRecord = record;
        return this;
    }

    public FDBStoredRecordBuilder<M> setVersion(FDBRecordVersion recordVersion) {
        this.recordVersion = recordVersion;
        return this;
    }

    public FDBStoredRecordBuilder<M> setKeyCount(int keyCount) {
        this.keyCount = keyCount;
        return this;
    }

    public FDBStoredRecordBuilder<M> setKeySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    public FDBStoredRecordBuilder<M> setValueSize(int valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    public FDBStoredRecordBuilder<M> setSplit(boolean split) {
        this.split = split;
        return this;
    }

    public FDBStoredRecordBuilder<M> setVersionedInline(boolean versionedInline) {
        this.versionedInline = versionedInline;
        return this;
    }

    public FDBStoredRecordBuilder<M> setSize(@Nonnull FDBStoredSizes size) {
        this.keyCount = size.getKeyCount();
        this.keySize = size.getKeySize();
        this.valueSize = size.getValueSize();
        this.split = size.isSplit();
        this.versionedInline = size.isVersionedInline();
        return this;
    }

    public FDBStoredRecord<M> build() {
        return new FDBStoredRecord<M>(this.getPrimaryKey(), this.getRecordType(), this.getRecord(), this.getKeyCount(), this.getKeySize(), this.getValueSize(), this.isSplit(), this.isVersionedInline(), this.getVersion());
    }
}

