/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredSizes;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FDBSyntheticRecord
implements FDBIndexableRecord<Message> {
    @Nonnull
    private final Tuple primaryKey;
    @Nonnull
    private final SyntheticRecordType<?> recordType;
    @Nonnull
    private final Message protoRecord;
    @Nonnull
    private final Map<String, FDBStoredRecord<? extends Message>> constituents;
    private final int keyCount;
    private final int keySize;
    private final int valueSize;

    protected FDBSyntheticRecord(@Nonnull Tuple primaryKey, @Nonnull SyntheticRecordType<?> recordType, @Nonnull Message protoRecord, @Nonnull FDBStoredSizes size, @Nonnull Map<String, FDBStoredRecord<? extends Message>> constituents) {
        this.primaryKey = primaryKey;
        this.recordType = recordType;
        this.protoRecord = protoRecord;
        this.constituents = constituents;
        this.keyCount = size.getKeyCount();
        this.keySize = size.getKeySize();
        this.valueSize = size.getValueSize();
    }

    @Nonnull
    public static FDBSyntheticRecord of(@Nonnull SyntheticRecordType<?> recordType, @Nonnull Map<String, FDBStoredRecord<? extends Message>> constituents) {
        ArrayList<Object> constituentPrimaryKeys = new ArrayList<Object>(recordType.getConstituents().size() + 1);
        constituentPrimaryKeys.add(recordType.getRecordTypeKey());
        DynamicMessage.Builder recordBuilder = DynamicMessage.newBuilder(recordType.getDescriptor());
        SplitHelper.SizeInfo size = new SplitHelper.SizeInfo();
        for (int i = 0; i < recordType.getConstituents().size(); ++i) {
            SyntheticRecordType.Constituent constituent = (SyntheticRecordType.Constituent)recordType.getConstituents().get(i);
            FDBStoredRecord<? extends Message> constituentRecord = constituents.get(constituent.getName());
            if (constituentRecord == null) {
                constituentPrimaryKeys.add(null);
                continue;
            }
            constituentPrimaryKeys.add(constituentRecord.getPrimaryKey());
            Descriptors.FieldDescriptor field = recordType.getDescriptor().getFields().get(i);
            recordBuilder.setField(field, constituentRecord.getRecord());
            size.add(constituentRecord);
        }
        if (recordType instanceof UnnestedRecordType) {
            UnnestedRecordType unnestedRecordType = (UnnestedRecordType)recordType;
            String parentName = unnestedRecordType.getParentConstituent().getName();
            Descriptors.FieldDescriptor positionsField = recordType.getDescriptor().findFieldByName("__positions");
            Descriptors.Descriptor positionsDescriptor = positionsField.getMessageType();
            DynamicMessage.Builder positionsBuilder = DynamicMessage.newBuilder(positionsDescriptor);
            for (Map.Entry<String, FDBStoredRecord<? extends Message>> constituent : constituents.entrySet()) {
                if (parentName.equals(constituent.getKey())) continue;
                long index = constituent.getValue().getPrimaryKey().getLong(0);
                positionsBuilder.setField(positionsDescriptor.findFieldByName(constituent.getKey()), index);
            }
            recordBuilder.setField(positionsField, positionsBuilder.build());
        }
        return new FDBSyntheticRecord(Tuple.fromList(constituentPrimaryKeys), recordType, recordBuilder.build(), size, constituents);
    }

    @Override
    @Nonnull
    public Tuple getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    @Nonnull
    public SyntheticRecordType<?> getRecordType() {
        return this.recordType;
    }

    @Override
    @Nonnull
    public Message getRecord() {
        return this.protoRecord;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean isSplit() {
        return false;
    }

    @Override
    public boolean hasVersion() {
        return false;
    }

    @Override
    @Nullable
    public FDBRecordVersion getVersion() {
        return null;
    }

    @Override
    public boolean isVersionedInline() {
        return false;
    }

    @Nonnull
    public Map<String, FDBStoredRecord<? extends Message>> getConstituents() {
        return this.constituents;
    }

    @Nullable
    public FDBStoredRecord<? extends Message> getConstituent(@Nonnull String name) {
        return this.constituents.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDBSyntheticRecord that = (FDBSyntheticRecord)o;
        if (!TupleHelpers.equals(this.primaryKey, that.primaryKey)) {
            return false;
        }
        if (!this.recordType.getName().equals(that.recordType.getName())) {
            return false;
        }
        if (!this.protoRecord.equals(that.protoRecord)) {
            return false;
        }
        return this.keyCount == that.keyCount && this.keySize == that.keySize && this.valueSize == that.valueSize;
    }

    public int hashCode() {
        return Objects.hash(this.primaryKey, this.recordType, this.protoRecord, this.constituents, this.keyCount, this.keySize, this.valueSize);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getRecordType().getName());
        str.append(this.constituents);
        return str.toString();
    }
}

