/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.system.SystemKeyspace;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FDBSystemOperations {
    @Nullable
    private static String nullableUtf8(@Nullable byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    private static <T> T asyncToSync(@Nonnull FDBDatabaseRunner runner, @Nonnull CompletableFuture<T> operation) {
        return runner.asyncToSync(FDBStoreTimer.Waits.WAIT_LOAD_SYSTEM_KEY, operation);
    }

    @Nonnull
    public static CompletableFuture<String> getPrimaryDatacenterAsync(@Nonnull FDBDatabaseRunner runner) {
        return runner.runAsync(context -> {
            Transaction tr = context.ensureActive();
            tr.options().setReadSystemKeys();
            return tr.get(SystemKeyspace.PRIMARY_DATACENTER_KEY).thenApply(FDBSystemOperations::nullableUtf8);
        }, Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "FDBSystemOperations::getPrimaryDatacenterAsync"}));
    }

    @Nullable
    public static String getPrimaryDatacenter(@Nonnull FDBDatabaseRunner runner) {
        return FDBSystemOperations.asyncToSync(runner, FDBSystemOperations.getPrimaryDatacenterAsync(runner));
    }

    @Nonnull
    private static CompletableFuture<String> getConnectionStringAsyncInternal(@Nonnull FDBRecordContext context) {
        return context.ensureActive().get(SystemKeyspace.CONNECTION_STR_KEY).thenApply(FDBSystemOperations::nullableUtf8);
    }

    @Nonnull
    public static CompletableFuture<String> getConnectionStringAsync(@Nonnull FDBDatabaseRunner runner) {
        return runner.runAsync(FDBSystemOperations::getConnectionStringAsyncInternal, Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "FDBSystemOperations::getConnectionStringAsync"}));
    }

    @Nullable
    public static String getConnectionString(@Nonnull FDBDatabaseRunner runner) {
        return FDBSystemOperations.asyncToSync(runner, FDBSystemOperations.getConnectionStringAsync(runner));
    }

    private static CompletableFuture<String> getClusterFilePathAsyncInternal(@Nonnull FDBRecordContext context) {
        return context.ensureActive().get(SystemKeyspace.CLUSTER_FILE_PATH_KEY).thenApply(FDBSystemOperations::nullableUtf8);
    }

    @Nonnull
    public static CompletableFuture<String> getClusterFilePathAsync(@Nonnull FDBDatabaseRunner runner) {
        return runner.runAsync(FDBSystemOperations::getClusterFilePathAsyncInternal, Arrays.asList(new Object[]{LogMessageKeys.TRANSACTION_NAME, "FDBSystemOperations::getClusterFilePathAsync"}));
    }

    @Nullable
    public static String getClusterFilePath(@Nonnull FDBDatabaseRunner runner) {
        return FDBSystemOperations.asyncToSync(runner, FDBSystemOperations.getClusterFilePathAsync(runner));
    }

    private FDBSystemOperations() {
    }
}

