/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.APIVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBTransactionContext {
    private final Executor executor;
    @Nonnull
    protected final FDBDatabase database;
    @Nullable
    protected Transaction transaction;
    @Nullable
    protected FDBStoreTimer timer;
    @Nullable
    protected FDBStoreTimer delayedTimer;

    protected FDBTransactionContext(@Nonnull FDBDatabase database, @Nonnull Transaction transaction, @Nullable FDBStoreTimer timer, @Nullable FDBStoreTimer delayedTimer) {
        this.database = database;
        this.transaction = transaction;
        this.executor = transaction.getExecutor();
        this.timer = timer;
        this.delayedTimer = delayedTimer;
        if (timer != null) {
            timer.increment(FDBStoreTimer.Counts.OPEN_CONTEXT);
        }
    }

    @Nonnull
    public FDBDatabase getDatabase() {
        return this.database;
    }

    @Nonnull
    public Transaction ensureActive() {
        return this.transaction;
    }

    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public ScheduledExecutorService getScheduledExecutor() {
        return this.database.getScheduledExecutor();
    }

    @Nonnull
    public CompletableFuture<Long> getApproximateTransactionSize() {
        return this.transaction.getApproximateSize();
    }

    @API(value=API.Status.INTERNAL)
    public APIVersion getAPIVersion() {
        return this.database.getAPIVersion();
    }

    @API(value=API.Status.INTERNAL)
    public boolean isAPIVersionAtLeast(@Nonnull APIVersion apiVersion) {
        return this.getAPIVersion().isAtLeast(apiVersion);
    }

    @Nullable
    public FDBStoreTimer getTimer() {
        return this.timer;
    }

    @Nullable
    public FDBStoreTimer getTimerForEvent(@Nonnull StoreTimer.Event event) {
        return event.isDelayedUntilCommit() ? this.delayedTimer : this.timer;
    }

    @Deprecated
    @API(value=API.Status.DEPRECATED)
    public void setTimer(@Nullable FDBStoreTimer timer) {
        this.timer = timer;
    }

    public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(event);
        if (eventTimer != null) {
            future = eventTimer.instrument(event, future, this.getExecutor());
        }
        return future;
    }

    public <T> CompletableFuture<T> instrument(Set<StoreTimer.Event> events, CompletableFuture<T> future) {
        if (events.isEmpty() || this.timer == null && this.delayedTimer == null) {
            return future;
        }
        if (events.size() == 1) {
            StoreTimer.Event event = events.iterator().next();
            return this.instrument(event, future);
        }
        long startTime = System.nanoTime();
        return future.whenComplete((vignore, errIgnore) -> {
            long timeDifferenceNanos = System.nanoTime() - startTime;
            for (StoreTimer.Event event : events) {
                FDBStoreTimer eventTimer = this.getTimerForEvent(event);
                if (eventTimer == null) continue;
                eventTimer.record(event, timeDifferenceNanos);
            }
        });
    }

    public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future, long startTime) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(event);
        if (eventTimer != null) {
            future = eventTimer.instrument(event, future, this.getExecutor(), startTime);
        }
        return future;
    }

    public <T> RecordCursor<T> instrument(StoreTimer.Event event, RecordCursor<T> inner) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(event);
        if (eventTimer != null) {
            inner = eventTimer.instrument(event, inner);
        }
        return inner;
    }

    public void record(@Nonnull StoreTimer.Event event, long timeDelta) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(event);
        if (eventTimer != null) {
            eventTimer.record(event, timeDelta);
        }
    }

    public void recordSize(@Nonnull StoreTimer.SizeEvent sizeEvent, long size) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(sizeEvent);
        if (eventTimer != null) {
            eventTimer.recordSize(sizeEvent, size);
        }
    }

    public void increment(@Nonnull StoreTimer.Count count) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(count);
        if (eventTimer != null) {
            eventTimer.increment(count);
        }
    }

    public void increment(@Nonnull StoreTimer.Count count, int amount) {
        FDBStoreTimer eventTimer = this.getTimerForEvent(count);
        if (eventTimer != null) {
            eventTimer.increment(count, amount);
        }
    }
}

