/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteState;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordIndexUniquenessViolation;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.StoreRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.MessageBuilderRecordSerializer;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.TypedRecordSerializer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBMetaDataStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintenanceFilter;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.provider.foundationdb.storestate.FDBRecordStoreStateCache;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FDBTypedRecordStore<M extends Message>
implements FDBRecordStoreBase<M> {
    @Nonnull
    private final FDBRecordStore untypedStore;
    @Nonnull
    private final RecordSerializer<M> typedSerializer;

    protected FDBTypedRecordStore(@Nonnull FDBRecordStore untypedStore, @Nonnull RecordSerializer<M> typedSerializer) {
        this.untypedStore = untypedStore;
        this.typedSerializer = typedSerializer;
    }

    @Override
    public FDBRecordStore getUntypedRecordStore() {
        return this.untypedStore;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.untypedStore.getRecordMetaData();
    }

    @Override
    @Nonnull
    public FDBRecordContext getContext() {
        return this.untypedStore.getContext();
    }

    @Override
    @Nullable
    public SubspaceProvider getSubspaceProvider() {
        return this.untypedStore.getSubspaceProvider();
    }

    @Override
    @Nonnull
    public RecordStoreState getRecordStoreState() {
        return this.untypedStore.getRecordStoreState();
    }

    @Override
    @Nonnull
    public RecordSerializer<M> getSerializer() {
        return this.typedSerializer;
    }

    @Override
    @Nonnull
    public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry() {
        return this.untypedStore.getIndexMaintainerRegistry();
    }

    @Override
    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull Index index) {
        return this.untypedStore.getIndexMaintainer(index);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<M>> saveRecordAsync(@Nonnull M rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.untypedStore.saveTypedRecord(this.typedSerializer, rec, existenceCheck, version, behavior);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<M>> dryRunSaveRecordAsync(@Nonnull M rec, @Nonnull FDBRecordStoreBase.RecordExistenceCheck existenceCheck, @Nullable FDBRecordVersion version, @Nonnull FDBRecordStoreBase.VersionstampSaveBehavior behavior) {
        return this.untypedStore.saveTypedRecord(this.typedSerializer, rec, existenceCheck, version, behavior, true, false);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBStoredRecord<M>> loadRecordInternal(@Nonnull Tuple primaryKey, @Nonnull ExecuteState executeState, boolean snapshot) {
        return this.untypedStore.loadTypedRecord(this.typedSerializer, primaryKey, snapshot);
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> preloadRecordAsync(@Nonnull Tuple primaryKey) {
        return this.untypedStore.preloadRecordAsync(primaryKey);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBSyntheticRecord> loadSyntheticRecord(@Nonnull Tuple primaryKey, IndexOrphanBehavior orphanBehavior) {
        throw new RecordCoreException("api unsupported on typed store", new Object[0]);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> recordExistsAsync(@Nonnull Tuple primaryKey, @Nonnull IsolationLevel isolationLevel) {
        return this.untypedStore.recordExistsAsync(primaryKey, isolationLevel);
    }

    @Override
    public void addRecordReadConflict(@Nonnull Tuple primaryKey) {
        this.untypedStore.addRecordReadConflict(primaryKey);
    }

    @Override
    public void addRecordWriteConflict(@Nonnull Tuple primaryKey) {
        this.untypedStore.addRecordWriteConflict(primaryKey);
    }

    @Override
    @Nonnull
    public RecordCursor<FDBStoredRecord<M>> scanRecords(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.untypedStore.scanTypedRecords(this.typedSerializer, low, high, lowEndpoint, highEndpoint, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<Tuple> scanRecordKeys(@Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.untypedStore.scanRecordKeys(continuation, scanProperties);
    }

    @Override
    @Nonnull
    public CompletableFuture<Integer> countRecords(@Nullable Tuple low, @Nullable Tuple high, @Nonnull EndpointType lowEndpoint, @Nonnull EndpointType highEndpoint, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.untypedStore.countRecords(low, high, lowEndpoint, highEndpoint, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<IndexEntry> scanIndex(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.untypedStore.scanIndex(index, scanBounds, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public RecordCursor<FDBIndexedRecord<M>> scanIndexRemoteFetch(@Nonnull Index index, @Nonnull IndexScanBounds scanBounds, int commonPrimaryKeyLength, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, @Nonnull IndexOrphanBehavior orphanBehavior) {
        return this.untypedStore.scanIndexRemoteFetchInternal(index, scanBounds, commonPrimaryKeyLength, continuation, this.typedSerializer, scanProperties, orphanBehavior);
    }

    @Override
    @Nonnull
    public CompletableFuture<FDBIndexedRecord<M>> buildSingleRecord(@Nonnull FDBIndexedRawRecord indexedRawRecord) {
        return this.untypedStore.buildSingleRecordInternal(indexedRawRecord, this.typedSerializer, null);
    }

    @Override
    @Nonnull
    public RecordCursor<RecordIndexUniquenessViolation> scanUniquenessViolations(@Nonnull Index index, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.untypedStore.scanUniquenessViolations(index, range, continuation, scanProperties);
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> resolveUniquenessViolation(@Nonnull Index index, @Nonnull Tuple valueKey, @Nullable Tuple primaryKey) {
        return this.untypedStore.resolveUniquenessViolation(index, valueKey, primaryKey);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> dryRunDeleteRecordAsync(@Nonnull Tuple primaryKey) {
        return this.untypedStore.deleteTypedRecord(this.typedSerializer, primaryKey, true);
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> deleteRecordAsync(@Nonnull Tuple primaryKey) {
        return this.untypedStore.deleteTypedRecord(this.typedSerializer, primaryKey, false);
    }

    @Override
    public void deleteAllRecords() {
        this.untypedStore.deleteAllRecords();
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> deleteRecordsWhereAsync(@Nonnull QueryComponent component) {
        return this.untypedStore.deleteRecordsWhereAsync(component);
    }

    @Override
    @Nonnull
    public FDBRecordStoreBase.PipelineSizer getPipelineSizer() {
        return this.untypedStore.getPipelineSizer();
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> estimateStoreSizeAsync() {
        return this.untypedStore.estimateStoreSizeAsync();
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> estimateRecordsSizeAsync(@Nonnull TupleRange range) {
        return this.untypedStore.estimateRecordsSizeAsync(range);
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> getSnapshotRecordCount(@Nonnull KeyExpression key, @Nonnull Key.Evaluated value, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        return this.untypedStore.getSnapshotRecordCount(key, value, indexQueryabilityFilter);
    }

    @Override
    @Nonnull
    public CompletableFuture<Long> getSnapshotRecordCountForRecordType(@Nonnull String recordTypeName, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        return this.untypedStore.getSnapshotRecordCountForRecordType(recordTypeName, indexQueryabilityFilter);
    }

    @Override
    @Nonnull
    public <T> CompletableFuture<T> evaluateIndexRecordFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        return this.untypedStore.evaluateTypedIndexRecordFunction(evaluationContext, function, rec);
    }

    @Override
    @Nonnull
    public <T> CompletableFuture<T> evaluateStoreFunction(@Nonnull EvaluationContext evaluationContext, @Nonnull StoreRecordFunction<T> function, @Nonnull FDBRecord<M> rec) {
        return this.untypedStore.evaluateTypedStoreFunction(evaluationContext, function, rec);
    }

    @Override
    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull List<String> recordTypeNames, @Nonnull IndexAggregateFunction aggregateFunction, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        return this.untypedStore.evaluateAggregateFunction(recordTypeNames, aggregateFunction, range, isolationLevel, indexQueryabilityFilter);
    }

    @Override
    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        return this.untypedStore.planQuery(query, parameterRelationshipGraph);
    }

    @Override
    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph, @Nonnull RecordQueryPlannerConfiguration plannerConfiguration) {
        return this.untypedStore.planQuery(query, parameterRelationshipGraph, plannerConfiguration);
    }

    @Override
    @Nonnull
    public RecordQueryPlan planQuery(@Nonnull RecordQuery query) {
        return this.planQuery(query, ParameterRelationshipGraph.empty());
    }

    @Nonnull
    public static <M extends Message> Builder<M> newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static <M extends Message> Builder<M> newBuilder(@Nonnull RecordSerializer<M> serializer) {
        return new Builder().setSerializer((RecordSerializer)serializer);
    }

    @Nonnull
    public static <M extends Message, U extends Message, B extends Message.Builder> Builder<M> newBuilder(@Nonnull Descriptors.FieldDescriptor fieldDescriptor, @Nonnull Supplier<B> builderSupplier, @Nonnull Predicate<U> tester, @Nonnull Function<U, M> getter, @Nonnull BiConsumer<B, M> setter) {
        TypedRecordSerializer<M, U, B> typedSerializer = new TypedRecordSerializer<M, U, B>(fieldDescriptor, builderSupplier, tester, getter, setter);
        MessageBuilderRecordSerializer untypedSerializer = new MessageBuilderRecordSerializer(builderSupplier::get);
        return FDBTypedRecordStore.newBuilder(typedSerializer).setUntypedSerializer(untypedSerializer);
    }

    @Nonnull
    public static <M extends Message, U extends Message, B extends Message.Builder> Builder<M> newBuilder(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Descriptors.FieldDescriptor fieldDescriptor, @Nonnull Supplier<B> builderSupplier, @Nonnull Predicate<U> tester, @Nonnull Function<U, M> getter, @Nonnull BiConsumer<B, M> setter) {
        RecordMetaData metaData = RecordMetaData.build(fileDescriptor);
        return FDBTypedRecordStore.newBuilder(fieldDescriptor, builderSupplier, tester, getter, setter).setMetaDataProvider(metaData);
    }

    @Nonnull
    public Builder<M> asBuilder() {
        return new Builder(this);
    }

    public static class Builder<M extends Message>
    implements FDBRecordStoreBase.BaseBuilder<M, FDBTypedRecordStore<M>> {
        @Nonnull
        private final FDBRecordStore.Builder untypedStoreBuilder;
        @Nullable
        private RecordSerializer<M> typedSerializer;

        protected Builder() {
            this.untypedStoreBuilder = FDBRecordStore.newBuilder();
        }

        protected Builder(Builder<M> other) {
            this.untypedStoreBuilder = other.untypedStoreBuilder.copyBuilder();
            this.typedSerializer = other.typedSerializer;
        }

        protected Builder(FDBTypedRecordStore<M> store) {
            this.untypedStoreBuilder = store.untypedStore.asBuilder();
            this.typedSerializer = store.typedSerializer;
        }

        @Override
        @Nullable
        public RecordSerializer<M> getSerializer() {
            return this.typedSerializer;
        }

        @Nonnull
        public Builder<M> setSerializer(@Nullable RecordSerializer<M> typedSerializer) {
            this.typedSerializer = typedSerializer;
            return this;
        }

        @Nonnull
        public RecordSerializer<Message> getUntypedSerializer() {
            return this.untypedStoreBuilder.getSerializer();
        }

        @Nonnull
        public Builder<M> setUntypedSerializer(@Nonnull RecordSerializer<Message> serializer) {
            this.untypedStoreBuilder.setSerializer((RecordSerializer)serializer);
            return this;
        }

        @Override
        @Deprecated(forRemoval=true)
        public int getFormatVersion() {
            return this.untypedStoreBuilder.getFormatVersion();
        }

        @Override
        public FormatVersion getFormatVersionEnum() {
            return this.untypedStoreBuilder.getFormatVersionEnum();
        }

        @Nonnull
        @Deprecated(forRemoval=true)
        public Builder<M> setFormatVersion(int formatVersion) {
            this.untypedStoreBuilder.setFormatVersion(formatVersion);
            return this;
        }

        @Override
        public FDBRecordStoreBase.BaseBuilder<M, FDBTypedRecordStore<M>> setFormatVersion(FormatVersion formatVersion) {
            this.untypedStoreBuilder.setFormatVersion(formatVersion);
            return this;
        }

        @Override
        @Nullable
        public RecordMetaDataProvider getMetaDataProvider() {
            return this.untypedStoreBuilder.getMetaDataProvider();
        }

        @Nonnull
        public Builder<M> setMetaDataProvider(@Nullable RecordMetaDataProvider metaDataProvider) {
            this.untypedStoreBuilder.setMetaDataProvider(metaDataProvider);
            return this;
        }

        @Override
        @Nullable
        public FDBMetaDataStore getMetaDataStore() {
            return this.untypedStoreBuilder.getMetaDataStore();
        }

        @Nonnull
        public Builder<M> setMetaDataStore(@Nullable FDBMetaDataStore metaDataStore) {
            this.untypedStoreBuilder.setMetaDataStore(metaDataStore);
            return this;
        }

        @Override
        @Nullable
        public FDBRecordContext getContext() {
            return this.untypedStoreBuilder.getContext();
        }

        @Nonnull
        public Builder<M> setContext(@Nullable FDBRecordContext context) {
            this.untypedStoreBuilder.setContext(context);
            return this;
        }

        @Override
        @Nullable
        public SubspaceProvider getSubspaceProvider() {
            return this.untypedStoreBuilder.getSubspaceProvider();
        }

        @Nonnull
        public Builder<M> setSubspaceProvider(@Nullable SubspaceProvider subspaceProvider) {
            this.untypedStoreBuilder.setSubspaceProvider(subspaceProvider);
            return this;
        }

        @Nonnull
        public Builder<M> setSubspace(@Nullable Subspace subspace) {
            this.untypedStoreBuilder.setSubspace(subspace);
            return this;
        }

        @Nonnull
        public Builder<M> setKeySpacePath(@Nullable KeySpacePath keySpacePath) {
            this.untypedStoreBuilder.setKeySpacePath(keySpacePath);
            return this;
        }

        @Override
        @Nullable
        public FDBRecordStoreBase.UserVersionChecker getUserVersionChecker() {
            return this.untypedStoreBuilder.getUserVersionChecker();
        }

        @Nonnull
        public Builder<M> setUserVersionChecker(@Nullable FDBRecordStoreBase.UserVersionChecker userVersionChecker) {
            this.untypedStoreBuilder.setUserVersionChecker(userVersionChecker);
            return this;
        }

        @Override
        @Nonnull
        public IndexMaintainerFactoryRegistry getIndexMaintainerRegistry() {
            return this.untypedStoreBuilder.getIndexMaintainerRegistry();
        }

        @Nonnull
        public Builder<M> setIndexMaintainerRegistry(@Nonnull IndexMaintainerFactoryRegistry indexMaintainerRegistry) {
            this.untypedStoreBuilder.setIndexMaintainerRegistry(indexMaintainerRegistry);
            return this;
        }

        @Override
        @Nonnull
        public IndexMaintenanceFilter getIndexMaintenanceFilter() {
            return this.untypedStoreBuilder.getIndexMaintenanceFilter();
        }

        @Nonnull
        public Builder<M> setIndexMaintenanceFilter(@Nonnull IndexMaintenanceFilter indexMaintenanceFilter) {
            this.untypedStoreBuilder.setIndexMaintenanceFilter(indexMaintenanceFilter);
            return this;
        }

        @Override
        @Nonnull
        public FDBRecordStoreBase.PipelineSizer getPipelineSizer() {
            return this.untypedStoreBuilder.getPipelineSizer();
        }

        @Nonnull
        public Builder<M> setPipelineSizer(@Nonnull FDBRecordStoreBase.PipelineSizer pipelineSizer) {
            this.untypedStoreBuilder.setPipelineSizer(pipelineSizer);
            return this;
        }

        @Override
        @Nonnull
        public FDBRecordStoreStateCache getStoreStateCache() {
            return this.untypedStoreBuilder.getStoreStateCache();
        }

        @Nonnull
        public Builder<M> setStoreStateCache(@Nonnull FDBRecordStoreStateCache storeStateCache) {
            this.untypedStoreBuilder.setStoreStateCache(storeStateCache);
            return this;
        }

        @Override
        @Nonnull
        public FDBRecordStore.StateCacheabilityOnOpen getStateCacheabilityOnOpen() {
            return this.untypedStoreBuilder.getStateCacheabilityOnOpen();
        }

        @Override
        @Nonnull
        public FDBRecordStoreBase.BaseBuilder<M, FDBTypedRecordStore<M>> setStateCacheabilityOnOpen(@Nonnull FDBRecordStore.StateCacheabilityOnOpen stateCacheabilityOnOpen) {
            this.untypedStoreBuilder.setStateCacheabilityOnOpen(stateCacheabilityOnOpen);
            return this;
        }

        @Override
        @Nonnull
        public CompletableFuture<FDBTypedRecordStore<M>> uncheckedOpenAsync() {
            return this.untypedStoreBuilder.uncheckedOpenAsync().thenApply(untypedStore -> new FDBTypedRecordStore<M>((FDBRecordStore)untypedStore, this.typedSerializer));
        }

        @Override
        @Nonnull
        public CompletableFuture<FDBTypedRecordStore<M>> createOrOpenAsync(@Nonnull FDBRecordStoreBase.StoreExistenceCheck existenceCheck) {
            return this.untypedStoreBuilder.createOrOpenAsync(existenceCheck).thenApply(untypedStore -> new FDBTypedRecordStore<M>((FDBRecordStore)untypedStore, this.typedSerializer));
        }

        @Override
        @Nonnull
        public FDBTypedRecordStore<M> build() {
            if (this.typedSerializer == null) {
                throw new RecordCoreException("typed serializer must be specified", new Object[0]);
            }
            if (this.untypedStoreBuilder.getSerializer() == null) {
                this.untypedStoreBuilder.setSerializer((RecordSerializer)this.typedSerializer.widen());
            }
            return new FDBTypedRecordStore<M>(this.untypedStoreBuilder.build(), this.typedSerializer);
        }

        @Nonnull
        public Builder<M> copyBuilder() {
            return new Builder<M>(this);
        }
    }
}

