/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedFormatVersionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public enum FormatVersion implements Comparable<FormatVersion>
{
    INFO_ADDED(1),
    RECORD_COUNT_ADDED(2),
    RECORD_COUNT_KEY_ADDED(3),
    FORMAT_CONTROL(4),
    SAVE_UNSPLIT_WITH_SUFFIX(5),
    SAVE_VERSION_WITH_RECORD(6),
    CACHEABLE_STATE(7),
    HEADER_USER_FIELDS(8),
    READABLE_UNIQUE_PENDING(9),
    CHECK_INDEX_BUILD_TYPE_DURING_UPDATE(10),
    RECORD_COUNT_STATE(11),
    STORE_LOCK_STATE(12);

    private final int value;
    private static final Map<Integer, FormatVersion> VERSIONS;
    private static final FormatVersion MAX_SUPPORTED_VERSION;

    private FormatVersion(int value) {
        this.value = value;
    }

    static FormatVersion getMinimumVersion() {
        return INFO_ADDED;
    }

    public static FormatVersion getMaximumSupportedVersion() {
        return MAX_SUPPORTED_VERSION;
    }

    public static FormatVersion getDefaultFormatVersion() {
        return CACHEABLE_STATE;
    }

    @API(value=API.Status.INTERNAL)
    int getValueForSerialization() {
        return this.value;
    }

    @API(value=API.Status.INTERNAL)
    static void validateFormatVersion(int candidateVersion, SubspaceProvider subspaceProvider) {
        if (candidateVersion < FormatVersion.getMinimumVersion().getValueForSerialization() || candidateVersion > FormatVersion.getMaximumSupportedVersion().getValueForSerialization()) {
            throw new UnsupportedFormatVersionException("Unsupported format version " + candidateVersion, new Object[]{subspaceProvider.logKey(), subspaceProvider});
        }
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public static FormatVersion getFormatVersion(int candidateVersion) {
        FormatVersion candidate = VERSIONS.get(candidateVersion);
        if (candidate == null) {
            throw new UnsupportedFormatVersionException("Unsupported format version " + candidateVersion, new Object[0]);
        }
        return candidate;
    }

    public boolean isAtLeast(FormatVersion other) {
        return this.compareTo(other) >= 0;
    }

    static {
        VERSIONS = Arrays.stream(FormatVersion.values()).collect(Collectors.toUnmodifiableMap(FormatVersion::getValueForSerialization, version -> version));
        MAX_SUPPORTED_VERSION = Arrays.stream(FormatVersion.values()).max(Comparator.naturalOrder()).orElseThrow();
    }
}

