/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class IndexAggregateGroupKeys {
    @Nonnull
    public abstract Key.Evaluated getGroupKeys(@Nullable FDBRecordStoreBase<?> var1, @Nullable EvaluationContext var2);

    public abstract int getColumnSize();

    public static Optional<IndexAggregateGroupKeys> conditionsToGroupKeys(@Nonnull IndexAggregateFunction function, @Nullable QueryComponent conditions) {
        return IndexAggregateGroupKeys.conditionsToGroupKeys(function.getOperand(), conditions);
    }

    public static Optional<IndexAggregateGroupKeys> conditionsToGroupKeys(@Nonnull KeyExpression operand, @Nullable QueryComponent conditions) {
        KeyExpression groupingKey = IndexFunctionHelper.getGroupingKey(operand);
        if (conditions == null) {
            if (groupingKey.getColumnSize() == 0) {
                return Optional.of(new Conditions(Collections.emptyList()));
            }
        } else {
            QueryToKeyMatcher matcher = new QueryToKeyMatcher(conditions);
            QueryToKeyMatcher.Match match = matcher.matchesSatisfyingQuery(groupingKey);
            if (match.getType() != QueryToKeyMatcher.MatchType.NO_MATCH) {
                return Optional.of(new Conditions(match.getEqualityComparisons()));
            }
        }
        return Optional.empty();
    }

    public static IndexAggregateGroupKeys indexScanToGroupKeys(@Nonnull String recordKey, int prefixSize) {
        return new IndexScan(recordKey, prefixSize);
    }

    @API(value=API.Status.EXPERIMENTAL)
    protected static class Conditions
    extends IndexAggregateGroupKeys {
        @Nonnull
        private final List<Comparisons.Comparison> comparisons;

        protected Conditions(@Nonnull List<Comparisons.Comparison> comparisons) {
            this.comparisons = comparisons;
        }

        @Override
        @Nonnull
        public Key.Evaluated getGroupKeys(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (this.comparisons.isEmpty()) {
                return Key.Evaluated.EMPTY;
            }
            return Key.Evaluated.concatenate(this.comparisons.stream().map(c -> c.getComparand(store, context)).collect(Collectors.toList()));
        }

        @Override
        public int getColumnSize() {
            return this.comparisons.size();
        }
    }

    @API(value=API.Status.EXPERIMENTAL)
    protected static class IndexScan
    extends IndexAggregateGroupKeys {
        @Nonnull
        private final String recordKey;
        private final int prefixSize;

        protected IndexScan(@Nonnull String recordKey, int prefixSize) {
            this.recordKey = recordKey;
            this.prefixSize = prefixSize;
        }

        @Override
        @Nonnull
        public Key.Evaluated getGroupKeys(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (context == null) {
                throw Comparisons.EvaluationContextRequiredException.instance();
            }
            FDBQueriedRecord record = (FDBQueriedRecord)context.getBinding(this.recordKey);
            IndexEntry indexEntry = record.getIndexEntry();
            return Key.Evaluated.fromTuple(TupleHelpers.subTuple(indexEntry.getKey(), 0, this.prefixSize));
        }

        @Override
        public int getColumnSize() {
            return this.prefixSize;
        }
    }
}

