/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.AggregateFunctionNotSupportedException;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class IndexBuildState {
    @Nonnull
    private final IndexState indexState;
    @Nullable
    private final Long recordsScanned;
    @Nullable
    private final Long recordsInTotal;

    @Nonnull
    public static CompletableFuture<IndexBuildState> loadIndexBuildStateAsync(FDBRecordStoreBase<?> store, Index index) {
        CompletableFuture<Long> recordsInTotalFuture;
        IndexState indexState = store.getUntypedRecordStore().getIndexState(index);
        if (indexState != IndexState.WRITE_ONLY) {
            return CompletableFuture.completedFuture(new IndexBuildState(indexState));
        }
        try {
            recordsInTotalFuture = store.getSnapshotRecordCount();
        }
        catch (AggregateFunctionNotSupportedException ex) {
            recordsInTotalFuture = CompletableFuture.completedFuture(null);
        }
        return IndexBuildState.loadRecordsScannedAsync(store, index).thenCombine(recordsInTotalFuture, (scannedRecords, recordsInTotal) -> new IndexBuildState(indexState, (Long)scannedRecords, (Long)recordsInTotal));
    }

    @Nonnull
    public static CompletableFuture<Long> loadRecordsScannedAsync(FDBRecordStoreBase<?> store, Index index) {
        return store.getContext().ensureActive().get(IndexingSubspaces.indexBuildScannedRecordsSubspace(store, index).getKey()).thenApply(FDBRecordStore::decodeRecordCount);
    }

    @Nonnull
    public IndexState getIndexState() {
        return this.indexState;
    }

    @Nullable
    public Long getRecordsScanned() {
        return this.recordsScanned;
    }

    @Nullable
    public Long getRecordsInTotal() {
        return this.recordsInTotal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexBuildState{");
        sb.append("indexState=").append((Object)this.indexState);
        if (this.indexState == IndexState.WRITE_ONLY) {
            sb.append(", scannedRecords=").append(this.recordsScanned);
            sb.append(", totalRecords=").append(this.recordsInTotal == null ? "UNKNOWN" : this.recordsInTotal);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexBuildState that = (IndexBuildState)o;
        return this.indexState == that.indexState && Objects.equals(this.recordsScanned, that.recordsScanned) && Objects.equals(this.recordsInTotal, that.recordsInTotal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexState, this.recordsScanned, this.recordsInTotal});
    }

    private IndexBuildState(IndexState indexState, @Nullable Long recordsScanned, @Nullable Long recordsInTotal) {
        this.indexState = indexState;
        this.recordsScanned = recordsScanned;
        this.recordsInTotal = recordsInTotal;
    }

    private IndexBuildState(IndexState indexState) {
        this(indexState, null, null);
    }
}

