/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.record.metadata.Index;
import java.util.HashSet;
import java.util.Set;

public class IndexDeferredMaintenanceControl {
    private Set<Index> mergeRequiredIndexes = null;
    private boolean autoMergeDuringCommit = false;
    private long mergesLimit = 0L;
    private long mergesFound;
    private long mergesTried;
    private long totalMerges;
    private long timeQuotaMillis;
    private long sizeQuotaBytes;
    private int repartitionDocumentCount = 0;
    private boolean repartitionCapped = false;
    private LastStep lastStep = LastStep.NONE;

    public synchronized Set<Index> getMergeRequiredIndexes() {
        return this.mergeRequiredIndexes;
    }

    public synchronized void setMergeRequiredIndexes(Index mergeRequiredIndex) {
        if (this.mergeRequiredIndexes == null) {
            this.mergeRequiredIndexes = new HashSet<Index>();
        }
        this.mergeRequiredIndexes.add(mergeRequiredIndex);
    }

    public boolean shouldAutoMergeDuringCommit() {
        return this.autoMergeDuringCommit;
    }

    public void setAutoMergeDuringCommit(boolean autoMergeDuringCommit) {
        this.autoMergeDuringCommit = autoMergeDuringCommit;
    }

    public long getMergesLimit() {
        return this.mergesLimit;
    }

    public void setMergesLimit(long mergesLimit) {
        this.mergesLimit = mergesLimit;
    }

    public long getMergesFound() {
        return this.mergesFound;
    }

    public void setMergesFound(long mergesFound) {
        this.mergesFound = mergesFound;
    }

    public long getMergesTried() {
        return this.mergesTried;
    }

    public void setMergesTried(long mergesTried) {
        this.mergesTried = mergesTried;
        this.totalMerges += mergesTried;
    }

    public void mergeHadFailed() {
        if (this.mergesTried > 0L && this.totalMerges >= this.mergesTried) {
            this.totalMerges -= this.mergesTried;
        }
    }

    public long getTotalMerges() {
        return this.totalMerges;
    }

    public long getTimeQuotaMillis() {
        return this.timeQuotaMillis;
    }

    public void setTimeQuotaMillis(long timeQuotaMillis) {
        this.timeQuotaMillis = timeQuotaMillis;
    }

    public long getSizeQuotaBytes() {
        return this.sizeQuotaBytes;
    }

    public void setSizeQuotaBytes(long sizeQuotaBytes) {
        this.sizeQuotaBytes = sizeQuotaBytes;
    }

    public LastStep getLastStep() {
        return this.lastStep;
    }

    public void setLastStep(LastStep lastStep) {
        this.lastStep = lastStep;
    }

    public int getRepartitionDocumentCount() {
        return this.repartitionDocumentCount;
    }

    public void setRepartitionDocumentCount(int repartitionDocumentCount) {
        this.repartitionDocumentCount = repartitionDocumentCount;
    }

    public boolean repartitionCapped() {
        return this.repartitionCapped;
    }

    public void setRepartitionCapped(boolean repartitionCapped) {
        this.repartitionCapped = repartitionCapped;
    }

    public static enum LastStep {
        NONE,
        REPARTITION,
        MERGE;

    }
}

