/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexAggregateFunctionCall;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexFunctionHelper {
    private IndexFunctionHelper() {
    }

    public static Optional<IndexMaintainer> indexMaintainerForRecordFunction(@Nonnull FDBRecordStore store, @Nonnull IndexRecordFunction<?> function, @Nonnull FDBRecord<?> record) {
        String recordType = record.getRecordType().getName();
        return IndexFunctionHelper.indexMaintainerForRecordFunction(store, function, Collections.singletonList(recordType));
    }

    public static Optional<IndexMaintainer> indexMaintainerForRecordFunction(@Nonnull FDBRecordStore store, @Nonnull IndexRecordFunction<?> function, @Nonnull List<String> recordTypeNames) {
        if (function.getIndex() != null) {
            Index index = store.getRecordMetaData().getIndex(function.getIndex());
            if (store.getRecordStoreState().isReadable(index)) {
                return Optional.of(store.getIndexMaintainer(index));
            }
        }
        return IndexFunctionHelper.indexesForRecordTypes(store, recordTypeNames).filter(store::isIndexReadable).map(store::getIndexMaintainer).filter(i -> i.canEvaluateRecordFunction(function)).min(Comparator.comparing(i -> i.state.index.getColumnSize()));
    }

    public static Optional<IndexMaintainer> indexMaintainerForAggregateFunction(@Nonnull FDBRecordStore store, @Nonnull IndexAggregateFunction function, @Nonnull List<String> recordTypeNames, @Nonnull IndexQueryabilityFilter indexFilter) {
        if (function.getIndex() != null) {
            Index index = store.getRecordMetaData().getIndex(function.getIndex());
            if (store.getRecordStoreState().isReadable(index)) {
                return Optional.of(store.getIndexMaintainer(index));
            }
        }
        return IndexFunctionHelper.indexesForRecordTypes(store, recordTypeNames).filter(store::isIndexReadable).filter(indexFilter::isQueryable).map(store::getIndexMaintainer).filter(i -> i.canEvaluateAggregateFunction(function)).min(Comparator.comparing(i -> i.state.index.getColumnSize()));
    }

    protected static Optional<Pair<IndexAggregateFunction, IndexMaintainer>> bindIndexForPermutableAggregateFunctionCall(@Nonnull FDBRecordStore store, @Nonnull IndexAggregateFunctionCall functionCall, @Nonnull List<String> recordTypeNames, @Nonnull IndexQueryabilityFilter indexFilter) {
        Verify.verify(functionCall.isGroupingPermutable());
        return IndexFunctionHelper.indexesForRecordTypes(store, recordTypeNames).filter(store::isIndexReadable).filter(indexFilter::isQueryable).flatMap(index -> functionCall.enumerateIndexAggregateFunctionCandidates(index.getName()).flatMap(indexAggregateFunction -> {
            IndexMaintainer indexMaintainer = store.getIndexMaintainer((Index)index);
            return indexMaintainer.canEvaluateAggregateFunction((IndexAggregateFunction)indexAggregateFunction) ? Stream.of(Pair.of(indexAggregateFunction, indexMaintainer)) : Stream.empty();
        })).min(Comparator.comparing(pair -> {
            IndexMaintainer indexMaintainer = (IndexMaintainer)pair.getRight();
            return indexMaintainer.state.index.getColumnSize();
        }));
    }

    public static Stream<Index> indexesForRecordTypes(@Nonnull FDBRecordStore store, @Nonnull List<String> recordTypeNames) {
        return IndexFunctionHelper.indexesForRecordTypes(store.getRecordMetaData(), recordTypeNames);
    }

    public static Stream<Index> indexesForRecordTypes(@Nonnull RecordMetaData metaData, @Nonnull Collection<String> recordTypeNames) {
        if (recordTypeNames.isEmpty()) {
            return metaData.getUniversalIndexes().stream();
        }
        if (recordTypeNames.size() == 1) {
            return metaData.getIndexableRecordType(recordTypeNames.iterator().next()).getIndexes().stream();
        }
        Set asSet = recordTypeNames.stream().map(metaData::getIndexableRecordType).collect(Collectors.toSet());
        return ((RecordType)asSet.iterator().next()).getMultiTypeIndexes().stream().filter(i -> asSet.equals(new HashSet<RecordType>(metaData.recordTypesForIndex((Index)i))));
    }

    public static boolean isGroupPrefix(@Nonnull KeyExpression functionOperand, @Nonnull KeyExpression indexRoot) {
        if (functionOperand.equals(indexRoot)) {
            return true;
        }
        return IndexFunctionHelper.getGroupedKey(functionOperand).equals(IndexFunctionHelper.getGroupedKey(indexRoot)) && IndexFunctionHelper.getGroupingKey(functionOperand).isPrefixKey(IndexFunctionHelper.getGroupingKey(indexRoot));
    }

    public static KeyExpression getGroupedKey(@Nonnull KeyExpression key) {
        if (!(key instanceof GroupingKeyExpression)) {
            return key;
        }
        GroupingKeyExpression grouping = (GroupingKeyExpression)key;
        return IndexFunctionHelper.groupKey(IndexFunctionHelper.getSubKey(grouping.getWholeKey(), grouping.getGroupingCount(), grouping.getColumnSize()));
    }

    public static KeyExpression getGroupingKey(@Nonnull KeyExpression key) {
        if (!(key instanceof GroupingKeyExpression)) {
            return EmptyKeyExpression.EMPTY;
        }
        GroupingKeyExpression grouping = (GroupingKeyExpression)key;
        return IndexFunctionHelper.groupKey(IndexFunctionHelper.getSubKey(grouping.getWholeKey(), 0, grouping.getGroupingCount()));
    }

    protected static KeyExpression groupKey(@Nonnull KeyExpression key) {
        if (key instanceof ThenKeyExpression) {
            int n;
            List<KeyExpression> children = ((ThenKeyExpression)key).getChildren();
            for (n = children.size(); n > 0 && children.get(n - 1) instanceof EmptyKeyExpression; --n) {
            }
            if (n == 0) {
                return Key.Expressions.empty();
            }
            if (n == 1) {
                return children.get(0);
            }
            if (n < children.size()) {
                return new ThenKeyExpression(children.subList(0, n));
            }
        }
        return key;
    }

    protected static KeyExpression getSubKey(KeyExpression key, int start, int end) {
        if (start == end) {
            return EmptyKeyExpression.EMPTY;
        }
        if (start == 0 && end == key.getColumnSize()) {
            return key;
        }
        if (key instanceof ThenKeyExpression) {
            return IndexFunctionHelper.getThenSubKey((ThenKeyExpression)key, start, end);
        }
        if (key instanceof NestingKeyExpression) {
            NestingKeyExpression nesting = (NestingKeyExpression)key;
            return new NestingKeyExpression(nesting.getParent(), IndexFunctionHelper.getSubKey(nesting.getChild(), start, end));
        }
        throw new RecordCoreException("grouping breaks apart key other than Then", new Object[0]);
    }

    protected static KeyExpression getThenSubKey(ThenKeyExpression then, int columnStart, int columnEnd) {
        List<KeyExpression> children = then.getChildren();
        int columnPosition = 0;
        int startChildPosition = -1;
        int startChildStart = -1;
        int startChildEnd = -1;
        for (int childPosition = 0; childPosition < children.size(); ++childPosition) {
            KeyExpression child = children.get(childPosition);
            int childColumns = child.getColumnSize();
            if (startChildPosition < 0 && columnPosition + childColumns > columnStart) {
                startChildPosition = childPosition;
                startChildStart = columnStart - columnPosition;
                startChildEnd = childColumns;
            }
            if (columnPosition + childColumns >= columnEnd) {
                int endChildEnd = columnEnd - columnPosition;
                if (childPosition == startChildPosition) {
                    if (startChildPosition == 0 && endChildEnd == childColumns) {
                        return child;
                    }
                    return IndexFunctionHelper.getSubKey(child, startChildStart, endChildEnd);
                }
                if (startChildStart == 0 && endChildEnd == childColumns) {
                    return new ThenKeyExpression(children.subList(startChildPosition, childPosition + 1));
                }
                ArrayList<KeyExpression> keys = new ArrayList<KeyExpression>(childPosition - startChildPosition + 1);
                keys.add(IndexFunctionHelper.getSubKey(children.get(startChildPosition), startChildStart, startChildEnd));
                if (childPosition > startChildPosition + 1) {
                    keys.addAll(children.subList(startChildPosition + 1, childPosition));
                }
                keys.add(IndexFunctionHelper.getSubKey(child, 0, endChildEnd));
                return new ThenKeyExpression(keys);
            }
            columnPosition += childColumns;
        }
        throw new RecordCoreException("column counts are not consistent", new Object[0]);
    }

    public static IndexAggregateFunction count(@Nonnull KeyExpression by) {
        return new IndexAggregateFunction("count", new GroupingKeyExpression(by, 0), null);
    }

    public static IndexAggregateFunction countUpdates(@Nonnull KeyExpression by) {
        return new IndexAggregateFunction("count_updates", new GroupingKeyExpression(by, 0), null);
    }

    public static Optional<IndexAggregateFunction> bindAggregateFunction(@Nonnull FDBRecordStore store, @Nonnull IndexAggregateFunction function, @Nonnull List<String> recordTypeNames, @Nonnull IndexQueryabilityFilter indexFilter) {
        return IndexFunctionHelper.indexMaintainerForAggregateFunction(store, function, recordTypeNames, indexFilter).map(i -> function.cloneWithIndex(i.state.index.getName()));
    }

    public static Optional<IndexAggregateFunction> bindAggregateFunctionCall(@Nonnull FDBRecordStore store, @Nonnull IndexAggregateFunctionCall functionCall, @Nonnull List<String> recordTypeNames, @Nonnull IndexQueryabilityFilter indexFilter) {
        if (functionCall.isGroupingPermutable()) {
            return IndexFunctionHelper.bindIndexForPermutableAggregateFunctionCall(store, functionCall, recordTypeNames, indexFilter).map(Pair::getLeft);
        }
        return IndexFunctionHelper.bindAggregateFunction(store, functionCall.toIndexAggregateFunction(null), recordTypeNames, indexFilter);
    }

    @Nonnull
    public static <T> IndexRecordFunction<T> recordFunctionWithSubrecordCondition(@Nonnull FDBRecordStore store, @Nonnull IndexRecordFunction<T> recordFunction, @Nonnull FDBRecord<?> record, @Nonnull QueryComponent condition) {
        IndexMaintainer indexMaintainer = IndexFunctionHelper.indexMaintainerForRecordFunction(store, recordFunction, record).orElseThrow(() -> new RecordCoreException("Record function " + String.valueOf(recordFunction) + " requires appropriate index on " + record.getRecordType().getName(), new Object[0]));
        Index index = indexMaintainer.state.index;
        List<KeyExpression> indexFields = index.getRootExpression().normalizeKeyForPositions();
        int scalarPrefixCount = 0;
        KeyExpression firstRepeated = null;
        for (KeyExpression indexField : indexFields) {
            if (indexField.createsDuplicates()) {
                firstRepeated = indexField;
                break;
            }
            ++scalarPrefixCount;
        }
        if (firstRepeated == null) {
            throw new RecordCoreException("Record function " + String.valueOf(recordFunction) + " condition " + String.valueOf(condition) + " does not select a repeated field in " + indexMaintainer.state.index.getName(), new Object[0]);
        }
        QueryToKeyMatcher matcher = new QueryToKeyMatcher(condition);
        QueryToKeyMatcher.Match match = matcher.matchesSatisfyingQuery(firstRepeated);
        if (match.getType() != QueryToKeyMatcher.MatchType.EQUALITY) {
            throw new RecordCoreException("Record function " + String.valueOf(recordFunction) + " condition " + String.valueOf(condition) + " does not match " + indexMaintainer.state.index.getName(), new Object[0]);
        }
        return new IndexRecordFunctionWithSubrecordValues<T>(recordFunction, index, scalarPrefixCount, match);
    }

    @Nullable
    public static Key.Evaluated recordFunctionIndexEntry(@Nonnull FDBRecordStore store, @Nonnull Index index, @Nonnull EvaluationContext context, @Nullable IndexRecordFunction<?> recordFunction, @Nonnull FDBRecord<?> record, int groupSize) {
        KeyExpression expression = index.getRootExpression();
        if (!(recordFunction instanceof IndexRecordFunctionWithSubrecordValues)) {
            return expression.evaluateSingleton(record);
        }
        IndexRecordFunctionWithSubrecordValues recordFunctionWithSubrecordValues = (IndexRecordFunctionWithSubrecordValues)recordFunction;
        int scalarPrefixCount = recordFunctionWithSubrecordValues.getScalarPrefixCount();
        List<Object> toMatch = recordFunctionWithSubrecordValues.getValues(store, context).values();
        List<Object> prev = null;
        Key.Evaluated match = null;
        for (Key.Evaluated key : expression.evaluate(record)) {
            List<Object> subrecord = key.values();
            for (int i = 0; i < groupSize; ++i) {
                if (i < scalarPrefixCount) {
                    if (prev == null || Objects.equals(prev.get(i), subrecord.get(i))) continue;
                    throw new RecordCoreException("All subrecords should match for non-constrained keys", new Object[0]);
                }
                if (!toMatch.get(i - scalarPrefixCount).equals(subrecord.get(i))) continue;
                if (match != null) {
                    throw new RecordCoreException("More than one matching subrecord", new Object[0]);
                }
                match = key;
            }
            prev = subrecord;
        }
        return match;
    }

    static class IndexRecordFunctionWithSubrecordValues<T>
    extends IndexRecordFunction<T> {
        private final int scalarPrefixCount;
        @Nonnull
        private final QueryToKeyMatcher.Match match;

        protected IndexRecordFunctionWithSubrecordValues(@Nonnull IndexRecordFunction<T> recordFunction, @Nonnull Index index, int scalarPrefixCount, @Nonnull QueryToKeyMatcher.Match match) {
            super(recordFunction.getName(), recordFunction.getOperand(), index.getName());
            this.scalarPrefixCount = scalarPrefixCount;
            this.match = match;
        }

        public int getScalarPrefixCount() {
            return this.scalarPrefixCount;
        }

        public Key.Evaluated getValues(@Nonnull FDBRecordStore store, @Nonnull EvaluationContext context) {
            return this.match.getEquality(store, context);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IndexRecordFunctionWithSubrecordValues that = (IndexRecordFunctionWithSubrecordValues)o;
            return this.scalarPrefixCount == that.scalarPrefixCount && this.match.equals(that.match);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.scalarPrefixCount, this.match);
        }
    }
}

