/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRawRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.UnsupportedRemoteFetchIndexException;
import com.apple.foundationdb.record.provider.foundationdb.indexes.InvalidIndexEntry;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class IndexMaintainer {
    protected final IndexMaintainerState state;

    protected IndexMaintainer(IndexMaintainerState state) {
        this.state = state;
    }

    @Nonnull
    public Subspace getIndexSubspace() {
        return this.state.indexSubspace;
    }

    @Nonnull
    public Subspace getSecondarySubspace() {
        return this.state.store.indexSecondarySubspace(this.state.index);
    }

    @Nonnull
    public abstract RecordCursor<IndexEntry> scan(@Nonnull IndexScanType var1, @Nonnull TupleRange var2, @Nullable byte[] var3, @Nonnull ScanProperties var4);

    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        return this.scan(scanBounds.getScanType(), ((IndexScanRange)scanBounds).getScanRange(), continuation, scanProperties);
    }

    @Nonnull
    public abstract <M extends Message> CompletableFuture<Void> update(@Nullable FDBIndexableRecord<M> var1, @Nullable FDBIndexableRecord<M> var2);

    @Nonnull
    public abstract <M extends Message> CompletableFuture<Void> updateWhileWriteOnly(@Nullable FDBIndexableRecord<M> var1, @Nullable FDBIndexableRecord<M> var2);

    @Nonnull
    public abstract RecordCursor<IndexEntry> scanUniquenessViolations(@Nonnull TupleRange var1, @Nullable byte[] var2, @Nonnull ScanProperties var3);

    public CompletableFuture<Void> clearUniquenessViolations() {
        if (this.state.index.isUnique()) {
            throw new RecordCoreException(this.state.index.getName() + " is unique and cannot clear uniqueness violations", new Object[0]);
        }
        return AsyncUtil.DONE;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public abstract RecordCursor<InvalidIndexEntry> validateEntries(@Nullable byte[] var1, @Nullable ScanProperties var2);

    public abstract boolean canEvaluateRecordFunction(@Nonnull IndexRecordFunction<?> var1);

    @Nullable
    public abstract <M extends Message> List<IndexEntry> evaluateIndex(@Nonnull FDBRecord<M> var1);

    @Nullable
    public abstract <M extends Message> List<IndexEntry> filteredIndexEntries(@Nullable FDBIndexableRecord<M> var1);

    @Nonnull
    public abstract <T, M extends Message> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext var1, @Nonnull IndexRecordFunction<T> var2, @Nonnull FDBRecord<M> var3);

    @Nonnull
    protected <T> CompletableFuture<T> unsupportedRecordFunction(@Nonnull IndexRecordFunction<T> function) {
        throw new RecordCoreException("Index " + this.state.index.getName() + " does not support " + String.valueOf(function), new Object[0]);
    }

    public abstract boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction var1);

    @Nonnull
    public abstract CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction var1, @Nonnull TupleRange var2, @Nonnull IsolationLevel var3);

    @Nonnull
    protected CompletableFuture<Tuple> unsupportedAggregateFunction(@Nonnull IndexAggregateFunction function) {
        throw new RecordCoreException("Index " + this.state.index.getName() + " does not support " + String.valueOf(function), new Object[0]);
    }

    public abstract boolean isIdempotent();

    @Nonnull
    public abstract CompletableFuture<Boolean> addedRangeWithKey(@Nonnull Tuple var1);

    public abstract boolean canDeleteWhere(@Nonnull QueryToKeyMatcher var1, @Nonnull Key.Evaluated var2);

    public abstract CompletableFuture<Void> deleteWhere(@Nonnull Transaction var1, @Nonnull Tuple var2);

    public abstract CompletableFuture<IndexOperationResult> performOperation(@Nonnull IndexOperation var1);

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public RecordCursor<FDBIndexedRawRecord> scanRemoteFetch(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties, int commonPrimaryKeyLength) {
        throw new UnsupportedRemoteFetchIndexException("scanRemoteFetch operation is not supported by this index maintainer for Index " + this.state.index.getName(), new Object[0]);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public abstract CompletableFuture<Void> mergeIndex();

    @Nullable
    @API(value=API.Status.EXPERIMENTAL)
    public IndexScrubbingTools<?> getIndexScrubbingTools(IndexScrubbingTools.ScrubbingType typeIgnore) {
        throw new UnsupportedOperationException("This index does not support scrubbing");
    }
}

