/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistry;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class IndexMaintainerFactoryRegistryImpl
implements IndexMaintainerFactoryRegistry {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexMaintainerFactoryRegistryImpl.class);
    @Nonnull
    protected static final IndexMaintainerFactoryRegistryImpl INSTANCE = new IndexMaintainerFactoryRegistryImpl();
    @Nonnull
    private final Map<String, IndexMaintainerFactory> registry = IndexMaintainerFactoryRegistryImpl.initRegistry();

    @Nonnull
    public static IndexMaintainerFactoryRegistry instance() {
        return INSTANCE;
    }

    @Nonnull
    protected static Map<String, IndexMaintainerFactory> initRegistry() {
        HashMap<String, IndexMaintainerFactory> registry = new HashMap<String, IndexMaintainerFactory>();
        for (IndexMaintainerFactory factory : ServiceLoaderProvider.load(IndexMaintainerFactory.class)) {
            for (String type : factory.getIndexTypes()) {
                if (registry.containsKey(type)) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn(KeyValueLogMessage.of("duplicate index maintainer", new Object[]{LogMessageKeys.INDEX_TYPE, type}));
                    continue;
                }
                registry.put(type, factory);
            }
        }
        return registry;
    }

    protected IndexMaintainerFactoryRegistryImpl() {
    }

    @Override
    @Nonnull
    public IndexMaintainerFactory getIndexMaintainerFactory(@Nonnull Index index) {
        IndexMaintainerFactory factory = this.registry.get(index.getType());
        if (factory == null) {
            throw new MetaDataException("Unknown index type for " + String.valueOf(index), new Object[0]);
        }
        return factory;
    }
}

