/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.PIndexScanComparisons;
import com.apple.foundationdb.record.planprotos.PIndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanRange;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class IndexScanComparisons
implements IndexScanParameters {
    @Nonnull
    private final IndexScanType scanType;
    @Nonnull
    private final ScanComparisons scanComparisons;

    protected IndexScanComparisons(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexScanComparisons indexScanComparisonsProto) {
        this(IndexScanType.fromProto(serializationContext, Objects.requireNonNull(indexScanComparisonsProto.getScanType())), ScanComparisons.fromProto(serializationContext, Objects.requireNonNull(indexScanComparisonsProto.getScanComparisons())));
    }

    public IndexScanComparisons(@Nonnull IndexScanType scanType, @Nonnull ScanComparisons scanComparisons) {
        this.scanType = scanType;
        this.scanComparisons = scanComparisons;
    }

    @Nonnull
    public static IndexScanComparisons byValue() {
        return IndexScanComparisons.byValue(null);
    }

    @Nonnull
    public static IndexScanComparisons byValue(@Nullable ScanComparisons scanComparisons) {
        return IndexScanComparisons.byValue(scanComparisons, IndexScanType.BY_VALUE);
    }

    @Nonnull
    public static IndexScanComparisons byValue(@Nullable ScanComparisons scanComparisons, @Nonnull IndexScanType scanType) {
        if (scanComparisons == null) {
            scanComparisons = ScanComparisons.EMPTY;
        }
        return new IndexScanComparisons(scanType, scanComparisons);
    }

    @Override
    @Nonnull
    public IndexScanType getScanType() {
        return this.scanType;
    }

    @Nonnull
    public ScanComparisons getComparisons() {
        return this.scanComparisons;
    }

    @Override
    @Nonnull
    public IndexScanRange bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        return new IndexScanRange(this.scanType, this.scanComparisons.toTupleRange(store, context));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return this.scanType.planHash(mode) + this.scanComparisons.planHash(mode);
    }

    @Override
    public boolean isUnique(@Nonnull Index index) {
        return this.scanComparisons.isEquality() && this.scanComparisons.size() == index.getColumnSize();
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        TupleRange tupleRange = this.scanComparisons.toTupleRangeWithoutContext();
        return tupleRange == null ? this.scanComparisons.explain() : ExplainTokensWithPrecedence.of(new ExplainTokens().addToString(tupleRange));
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        TupleRange tupleRange;
        if (!this.scanType.equals(IndexScanType.BY_VALUE)) {
            detailsBuilder.add((Object)"scan type: {{scanType}}");
            attributeMapBuilder.put("scanType", Attribute.gml(this.scanType.toString()));
        }
        if ((tupleRange = this.scanComparisons.toTupleRangeWithoutContext()) != null) {
            detailsBuilder.add((Object)("range: " + tupleRange.getLowEndpoint().toString(false) + "{{low}}, {{high}}" + tupleRange.getHighEndpoint().toString(true)));
            attributeMapBuilder.put("low", Attribute.gml(tupleRange.getLow() == null ? "-\u221e" : tupleRange.getLow().toString()));
            attributeMapBuilder.put("high", Attribute.gml(tupleRange.getHigh() == null ? "\u221e" : tupleRange.getHigh().toString()));
        } else {
            detailsBuilder.add((Object)"comparisons: {{comparisons}}");
            attributeMapBuilder.put("comparisons", Attribute.gml(this.scanComparisons.toString()));
        }
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.scanComparisons.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public IndexScanParameters rebase(@Nonnull AliasMap translationMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(translationMap), false);
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexScanComparisons that = (IndexScanComparisons)other;
        if (!this.scanType.equals(that.scanType)) {
            return false;
        }
        return this.scanComparisons.semanticEquals(that.scanComparisons, aliasMap);
    }

    @Override
    public int semanticHashCode() {
        int result = this.scanType.hashCode();
        result = 31 * result + this.scanComparisons.semanticHashCode();
        return result;
    }

    @Override
    @Nonnull
    public IndexScanParameters translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        ScanComparisons translatedScanComparisons = this.scanComparisons.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedScanComparisons != this.scanComparisons) {
            return this.withScanComparisons(translatedScanComparisons);
        }
        return this;
    }

    @Nonnull
    protected IndexScanParameters withScanComparisons(@Nonnull ScanComparisons newScanComparisons) {
        return new IndexScanComparisons(this.scanType, newScanComparisons);
    }

    public String toString() {
        return String.valueOf(this.scanType) + ":" + String.valueOf(this.scanComparisons);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        return this.toIndexScanComparisonsProto(serializationContext);
    }

    @Nonnull
    public PIndexScanComparisons toIndexScanComparisonsProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanComparisons.newBuilder().setScanType(this.scanType.toProto(serializationContext)).setScanComparisons(this.scanComparisons.toProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PIndexScanParameters toIndexScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanParameters.newBuilder().setIndexScanComparisons(this.toIndexScanComparisonsProto(serializationContext)).build();
    }

    @Nonnull
    public static IndexScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexScanComparisons indexScanComparisonsProto) {
        return new IndexScanComparisons(serializationContext, indexScanComparisonsProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PIndexScanComparisons, IndexScanComparisons> {
        @Override
        @Nonnull
        public Class<PIndexScanComparisons> getProtoMessageClass() {
            return PIndexScanComparisons.class;
        }

        @Override
        @Nonnull
        public IndexScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexScanComparisons indexScanComparisonsProto) {
            return IndexScanComparisons.fromProto(serializationContext, indexScanComparisonsProto);
        }
    }
}

