/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexScrubber;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class IndexScrubbing
extends IndexingBase {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexScrubbing.class);
    @Nonnull
    private static final IndexBuildProto.IndexBuildIndexingStamp myIndexingTypeStamp = IndexScrubbing.compileIndexingTypeStamp();
    @Nonnull
    private final OnlineIndexScrubber.ScrubbingPolicy scrubbingPolicy;
    @Nonnull
    private final AtomicLong issueCounter;
    private long scanCounter = 0L;
    private int logWarningCounter;
    private final IndexScrubbingTools.ScrubbingType scrubbingType;
    private final String scrubberName;

    public IndexScrubbing(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy, @Nonnull OnlineIndexScrubber.ScrubbingPolicy scrubbingPolicy, @Nonnull AtomicLong issueCounter, IndexScrubbingTools.ScrubbingType scrubbingType) {
        super(common, policy, true);
        this.scrubbingPolicy = scrubbingPolicy;
        this.logWarningCounter = scrubbingPolicy.getLogWarningsLimit();
        this.issueCounter = issueCounter;
        this.scrubbingType = scrubbingType;
        this.scrubberName = "scrub " + String.valueOf((Object)scrubbingType) + " entries for " + common.getIndex().getType() + " index";
    }

    @Override
    List<Object> indexingLogMessageKeyValues() {
        return Arrays.asList(new Object[]{LogMessageKeys.INDEXING_METHOD, this.scrubberName, LogMessageKeys.ALLOW_REPAIR, this.scrubbingPolicy.allowRepair(), LogMessageKeys.RANGE_ID, this.scrubbingPolicy.getScrubbingRangeId(), LogMessageKeys.RANGE_RESET, this.scrubbingPolicy.isScrubbingRangeReset(), LogMessageKeys.SCRUB_TYPE, this.scrubbingType, LogMessageKeys.SCAN_LIMIT, this.scrubbingPolicy.getEntriesScanLimit()});
    }

    @Override
    @Nonnull
    IndexBuildProto.IndexBuildIndexingStamp getIndexingTypeStamp(FDBRecordStore store) {
        return myIndexingTypeStamp;
    }

    @Nonnull
    static IndexBuildProto.IndexBuildIndexingStamp compileIndexingTypeStamp() {
        return IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.SCRUB_REPAIR).build();
    }

    @Override
    CompletableFuture<Void> buildIndexInternalAsync() {
        return this.getRunner().runAsync(context -> context.getReadVersionAsync().thenCompose(ignore -> this.indexScrub()), this.common.indexLogMessageKeyValues("IndexScrubbing::buildIndexInternalAsync"));
    }

    @Nonnull
    private CompletableFuture<Void> indexScrub() {
        List<Object> additionalLogMessageKeyValues = Arrays.asList(new Object[]{LogMessageKeys.CALLING_METHOD, "indexScrub"});
        return this.iterateAllRanges(additionalLogMessageKeyValues, this::indexScrubRangeOnly);
    }

    @Nonnull
    private CompletableFuture<Boolean> indexScrubRangeOnly(@Nonnull FDBRecordStore store, @Nonnull AtomicLong recordsScanned) {
        Index index = this.common.getIndex();
        RecordMetaData metaData = store.getRecordMetaData();
        RecordMetaDataProvider recordMetaDataProvider = this.common.getRecordStoreBuilder().getMetaDataProvider();
        if (recordMetaDataProvider == null || !metaData.equals(recordMetaDataProvider.getRecordMetaData())) {
            throw new MetaDataException("Store does not have the same metadata", new Object[0]);
        }
        IndexMaintainer maintainer = store.getIndexMaintainer(index);
        IndexScrubbingTools<?> tools = maintainer.getIndexScrubbingTools(this.scrubbingType);
        if (tools == null) {
            throw new UnsupportedOperationException("This index does not support scrubbing type " + String.valueOf((Object)this.scrubbingType));
        }
        return this.indexScrubRangeOnly(store, recordsScanned, index, tools, maintainer.isIdempotent());
    }

    private <T> CompletableFuture<Boolean> indexScrubRangeOnly(@Nonnull FDBRecordStore store, @Nonnull AtomicLong recordsScanned, Index index, IndexScrubbingTools<T> tools, boolean isIdempotent) {
        this.validateOrThrowEx(store.getIndexState(index).isScannable(), "scrubbed index is not readable");
        this.validateOrThrowEx(isIdempotent, "scrubbed index is not idempotent");
        IndexingRangeSet rangeSet = this.getRangeset(store, index);
        tools.presetCommonParams(index, this.scrubbingPolicy.allowRepair(), this.common.getIndexContext().isSynthetic, this.common.getAllRecordTypes());
        return rangeSet.firstMissingRangeAsync().thenCompose(range -> {
            if (range == null) {
                this.logScrubberRangeReset("range exhausted");
                rangeSet.clear();
                return AsyncUtil.READY_FALSE;
            }
            Tuple rangeStart = RangeSet.isFirstKey(range.begin) ? null : Tuple.fromBytes(range.begin);
            Tuple rangeEnd = RangeSet.isFinalKey(range.end) ? null : Tuple.fromBytes(range.end);
            TupleRange tupleRange = TupleRange.between(rangeStart, rangeEnd);
            RecordCursor cursor = tools.getCursor(tupleRange, store, this.getLimit() + 1);
            AtomicBoolean hasMore = new AtomicBoolean(true);
            AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
            long scanLimit = this.scrubbingPolicy.getEntriesScanLimit();
            LinkedList issueList = new LinkedList();
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.iterateRangeOnly(store, cursor, (recordStore, result) -> this.handleOneItem((FDBRecordStore)recordStore, (RecordCursorResult)result, tools, issueList), lastResult, hasMore, recordsScanned, isIdempotent).thenApply(vignore -> hasMore.get() ? tools.getKeyFromCursorResult((RecordCursorResult)lastResult.get()) : rangeEnd)).thenCompose(continuation -> IndexScrubbing.updateRangeAndCheckIfExhausted(rangeSet, rangeStart, rangeEnd, continuation))).thenApply(ret -> this.checkScanLimit((Boolean)ret, recordsScanned, scanLimit))).whenComplete((ignore, err) -> this.reportIssues(issueList, (Throwable)err));
        });
    }

    private <T> CompletableFuture<FDBStoredRecord<Message>> handleOneItem(FDBRecordStore store, RecordCursorResult<T> result, IndexScrubbingTools<T> tools, List<IndexScrubbingTools.Issue> issueList) {
        return tools.handleOneItem(store, result).thenApply(issue -> {
            if (issue == null) {
                return null;
            }
            issueList.add((IndexScrubbingTools.Issue)issue);
            return issue.recordToIndex;
        });
    }

    private static CompletableFuture<Boolean> updateRangeAndCheckIfExhausted(IndexingRangeSet rangeSet, Tuple rangeStart, Tuple rangeEnd, Tuple continuation) {
        return rangeSet.insertRangeAsync(IndexScrubbing.packOrNull(rangeStart), IndexScrubbing.packOrNull(continuation), true).thenApply(ignore -> IndexScrubbing.notAllRangesExhausted(continuation, rangeEnd));
    }

    private Boolean checkScanLimit(Boolean ret, @Nonnull AtomicLong recordsScanned, long scanLimit) {
        if (scanLimit > 0L) {
            this.scanCounter += recordsScanned.get();
            if (scanLimit <= this.scanCounter) {
                return false;
            }
        }
        return ret;
    }

    private void reportIssues(List<IndexScrubbingTools.Issue> issueList, Throwable err) {
        if (err != null || issueList == null || issueList.isEmpty()) {
            return;
        }
        for (IndexScrubbingTools.Issue issue : issueList) {
            this.issueCounter.incrementAndGet();
            if (issue.logMessage != null && LOGGER.isWarnEnabled() && this.logWarningCounter > 0) {
                --this.logWarningCounter;
                LOGGER.warn(issue.logMessage.addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
            }
            if (issue.timerCounter == null) continue;
            this.timerIncrement(issue.timerCounter);
        }
    }

    IndexingRangeSet getRangeset(FDBRecordStore store, Index index) {
        switch (this.scrubbingType) {
            case MISSING: {
                return IndexingRangeSet.forScrubbingRecords(store, index, this.scrubbingPolicy.getScrubbingRangeId());
            }
            case DANGLING: {
                return IndexingRangeSet.forScrubbingIndex(store, index, this.scrubbingPolicy.getScrubbingRangeId());
            }
        }
        throw new RecordCoreArgumentException("Unpredicted scrubbing type ", new Object[0]);
    }

    @Override
    @Nonnull
    protected CompletableFuture<Void> setScrubberTypeOrThrow(FDBRecordStore store) {
        IndexBuildProto.IndexBuildIndexingStamp indexingTypeStamp = this.getIndexingTypeStamp(store);
        this.validateOrThrowEx(indexingTypeStamp.getMethod().equals(IndexBuildProto.IndexBuildIndexingStamp.Method.SCRUB_REPAIR), "Not a scrubber type-stamp");
        Index index = this.common.getIndex();
        IndexingRangeSet rangeSet = this.getRangeset(store, index);
        if (this.scrubbingPolicy.isScrubbingRangeReset()) {
            this.logScrubberRangeReset("forced reset");
            rangeSet.clear();
            return AsyncUtil.DONE;
        }
        return rangeSet.firstMissingRangeAsync().thenAccept(recordRange -> {
            if (recordRange == null) {
                this.logScrubberRangeReset("range exhausted detected");
                rangeSet.clear();
            }
        });
    }

    private void logScrubberRangeReset(String reason) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.build("Reset index scrubbing range", new Object[0]).addKeysAndValues(this.common.indexLogMessageKeyValues()).addKeyAndValue((Object)LogMessageKeys.REASON, reason).toString());
        }
    }

    @Override
    CompletableFuture<Void> rebuildIndexInternalAsync(FDBRecordStore store) {
        throw new UnsupportedOperationException();
    }
}

