/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBError;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.StoreTimerSnapshot;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.IndexingMerger;
import com.apple.foundationdb.record.provider.foundationdb.IndexingMultiTargetByRecords;
import com.apple.foundationdb.record.provider.foundationdb.IndexingSubspaces;
import com.apple.foundationdb.record.provider.foundationdb.IndexingThrottle;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingHeartbeat;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public abstract class IndexingBase {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingBase.class);
    @Nonnull
    protected final IndexingCommon common;
    @Nonnull
    protected final OnlineIndexer.IndexingPolicy policy;
    @Nonnull
    private final IndexingThrottle throttle;
    private final boolean isScrubber;
    private long timeOfLastProgressLogMillis = 0L;
    private StoreTimerSnapshot lastProgressSnapshot = null;
    private boolean forceStampOverwrite = false;
    private final long startingTimeMillis;
    private Map<String, IndexingMerger> indexingMergerMap = null;
    @Nullable
    private IndexingHeartbeat heartbeat = null;

    IndexingBase(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy) {
        this(common, policy, false);
    }

    IndexingBase(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy, boolean isScrubber) {
        this.common = common;
        this.policy = policy;
        this.isScrubber = isScrubber;
        this.throttle = new IndexingThrottle(common, isScrubber);
        this.startingTimeMillis = System.currentTimeMillis();
    }

    protected FDBDatabaseRunner getRunner() {
        return this.common.getRunner();
    }

    protected CompletableFuture<FDBRecordStore> openRecordStore(@Nonnull FDBRecordContext context) {
        return this.common.getRecordStoreBuilder().copyBuilder().setContext(context).openAsync();
    }

    @Nullable
    protected static byte[] packOrNull(@Nullable Tuple tuple) {
        return tuple == null ? null : tuple.pack();
    }

    @Nonnull
    protected CompletableFuture<FDBStoredRecord<Message>> recordIfInIndexedTypes(FDBStoredRecord<Message> rec) {
        return CompletableFuture.completedFuture(rec != null && this.common.getAllRecordTypes().contains(rec.getRecordType()) ? rec : null);
    }

    public CompletableFuture<Void> buildIndexAsync(boolean markReadable) {
        KeyValueLogMessage message = KeyValueLogMessage.build("build index online", new Object[]{LogMessageKeys.SHOULD_MARK_READABLE, markReadable, LogMessageKeys.INDEXER_ID, this.common.getIndexerId()});
        long startNanos = System.nanoTime();
        FDBDatabaseRunner runner = this.getRunner();
        FDBStoreTimer timer = runner.getTimer();
        if (timer != null) {
            this.lastProgressSnapshot = StoreTimerSnapshot.from(timer);
        }
        return MoreAsyncUtil.composeWhenComplete(this.handleStateAndDoBuildIndexAsync(markReadable, message), (result, ex) -> {
            message.addKeysAndValues(this.indexingLogMessageKeyValues()).addKeysAndValues(this.common.indexLogMessageKeyValues()).addKeyAndValue((Object)LogMessageKeys.TOTAL_MICROS, TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startNanos));
            if (LOGGER.isWarnEnabled() && ex != null) {
                message.addKeyAndValue((Object)LogMessageKeys.RESULT, "failure");
                message.addKeysAndValues(this.throttle.logMessageKeyValues());
                LOGGER.warn(message.toString(), (Throwable)ex);
            } else if (LOGGER.isInfoEnabled()) {
                message.addKeyAndValue((Object)LogMessageKeys.RESULT, "success");
                LOGGER.info(message.toString());
            }
            return this.clearHeartbeats().handle((ignoreRet, ignoreEx) -> null);
        }, this.getRunner().getDatabase()::mapAsyncToSyncException);
    }

    abstract List<Object> indexingLogMessageKeyValues();

    @Nonnull
    private CompletableFuture<Void> handleStateAndDoBuildIndexAsync(boolean markReadable, KeyValueLogMessage message) {
        List<Index> targetIndexes = this.common.getTargetIndexes();
        Index primaryIndex = targetIndexes.get(0);
        return ((CompletableFuture)((CompletableFuture)this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> {
            IndexState indexState = store.getIndexState(primaryIndex);
            if (this.isScrubber) {
                this.validateOrThrowEx(indexState.isScannable(), "Scrubber was called for a non-readable index. Index:" + primaryIndex.getName() + " State: " + String.valueOf((Object)indexState));
                return this.setScrubberTypeOrThrow((FDBRecordStore)store).thenApply(ignore -> true);
            }
            OnlineIndexer.IndexingPolicy.DesiredAction desiredAction = this.policy.getStateDesiredAction(indexState);
            if (desiredAction == OnlineIndexer.IndexingPolicy.DesiredAction.ERROR) {
                throw new ValidationException("Index state is not as expected", new Object[]{LogMessageKeys.INDEX_NAME, primaryIndex.getName(), LogMessageKeys.INDEX_VERSION, primaryIndex.getLastModifiedVersion(), LogMessageKeys.INDEX_STATE, indexState});
            }
            if (desiredAction == OnlineIndexer.IndexingPolicy.DesiredAction.MARK_READABLE) {
                return this.markIndexReadable(markReadable).thenCompose(ignore -> AsyncUtil.READY_FALSE);
            }
            boolean shouldClear = desiredAction == OnlineIndexer.IndexingPolicy.DesiredAction.REBUILD;
            boolean shouldBuild = shouldClear || indexState != IndexState.READABLE;
            message.addKeyAndValue((Object)LogMessageKeys.INITIAL_INDEX_STATE, (Object)indexState);
            message.addKeyAndValue((Object)LogMessageKeys.INDEXING_POLICY_DESIRED_ACTION, (Object)desiredAction);
            message.addKeyAndValue((Object)LogMessageKeys.SHOULD_BUILD_INDEX, shouldBuild);
            message.addKeyAndValue((Object)LogMessageKeys.SHOULD_CLEAR_EXISTING_DATA, shouldClear);
            if (!shouldBuild) {
                return AsyncUtil.READY_FALSE;
            }
            ArrayList<Index> indexesToClear = new ArrayList<Index>(targetIndexes.size());
            if (shouldClear) {
                indexesToClear.add(primaryIndex);
                this.enforceStampOverwrite();
            }
            boolean continuedBuild = !shouldClear && indexState == IndexState.WRITE_ONLY;
            for (Index targetIndex : targetIndexes.subList(1, targetIndexes.size())) {
                IndexState state = store.getIndexState(targetIndex);
                if (state != indexState) {
                    if (this.policy.getStateDesiredAction(state) != OnlineIndexer.IndexingPolicy.DesiredAction.REBUILD || continuedBuild) {
                        throw new ValidationException("A target index state doesn't match the primary index state", new Object[]{LogMessageKeys.INDEX_NAME, primaryIndex.getName(), LogMessageKeys.INDEX_STATE, indexState, LogMessageKeys.TARGET_INDEX_NAME, targetIndex.getName(), LogMessageKeys.TARGET_INDEX_STATE, state});
                    }
                    indexesToClear.add(targetIndex);
                    continue;
                }
                if (!shouldClear) continue;
                indexesToClear.add(targetIndex);
            }
            return ((CompletableFuture)((CompletableFuture)AsyncUtil.whenAll(indexesToClear.stream().map(store::clearAndMarkIndexWriteOnly).collect(Collectors.toList())).thenCompose(vignore -> this.markIndexesWriteOnly(continuedBuild, (FDBRecordStore)store))).thenCompose(vignore -> this.setIndexingTypeOrThrow((FDBRecordStore)store, continuedBuild))).thenApply(ignore -> true);
        }), this.common.indexLogMessageKeyValues("IndexingBase::handleIndexingState")).thenCompose(doIndex -> doIndex != false ? this.buildIndexInternalAsync().thenApply(ignore -> markReadable) : AsyncUtil.READY_FALSE)).thenCompose(this::markIndexReadable)).thenApply(ignore -> null);
    }

    private CompletableFuture<Void> markIndexesWriteOnly(boolean continueBuild, FDBRecordStore store) {
        if (continueBuild) {
            return AsyncUtil.DONE;
        }
        return this.forEachTargetIndex(store::markIndexWriteOnly);
    }

    @Nonnull
    public CompletableFuture<Boolean> markReadableIfBuilt() {
        AtomicBoolean allReadable = new AtomicBoolean(true);
        return this.getRunner().runAsync(context -> ((CompletableFuture)this.openRecordStore((FDBRecordContext)context).thenCompose(store -> this.forEachTargetIndex(index -> {
            if (store.isIndexReadable((Index)index)) {
                return AsyncUtil.DONE;
            }
            IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, index);
            return rangeSet.firstMissingRangeAsync().thenCompose(range -> {
                if (range != null) {
                    allReadable.set(false);
                    return AsyncUtil.DONE;
                }
                return store.markIndexReadable((Index)index).thenApply(vignore2 -> null);
            });
        }))).thenApply(ignore -> allReadable.get()), this.common.indexLogMessageKeyValues("IndexingBase::markReadableIfBuilt"));
    }

    @Nonnull
    public CompletableFuture<Boolean> markIndexReadable(boolean markReadablePlease) {
        if (!markReadablePlease) {
            return AsyncUtil.READY_FALSE;
        }
        AtomicReference runtimeExceptionAtomicReference = new AtomicReference();
        AtomicBoolean anythingChanged = new AtomicBoolean(false);
        return this.forEachTargetIndex(index -> this.markIndexReadableForIndex((Index)index, anythingChanged, runtimeExceptionAtomicReference)).thenApply(ignore -> {
            RuntimeException ex = (RuntimeException)runtimeExceptionAtomicReference.get();
            if (ex != null) {
                throw ex;
            }
            this.heartbeat = null;
            return anythingChanged.get();
        });
    }

    private CompletableFuture<Boolean> markIndexReadableForIndex(Index index, AtomicBoolean anythingChanged, AtomicReference<RuntimeException> runtimeExceptionAtomicReference) {
        return this.getRunner().runAsync(context -> this.common.getRecordStoreBuilder().copyBuilder().setContext((FDBRecordContext)context).openAsync().thenCompose(store -> {
            this.clearHeartbeatForIndex((FDBRecordStore)store, index);
            return this.policy.shouldAllowUniquePendingState((FDBRecordStore)store) ? store.markIndexReadableOrUniquePending(index) : store.markIndexReadable(index);
        })).handle((changed, ex) -> {
            if (ex == null) {
                if (Boolean.TRUE.equals(changed)) {
                    anythingChanged.set(true);
                }
                return changed;
            }
            runtimeExceptionAtomicReference.set((RuntimeException)ex);
            return false;
        });
    }

    public void enforceStampOverwrite() {
        this.forceStampOverwrite = true;
    }

    @Nonnull
    private CompletableFuture<Void> setIndexingTypeOrThrow(FDBRecordStore store, boolean continuedBuild) {
        IndexBuildProto.IndexBuildIndexingStamp indexingTypeStamp = this.getIndexingTypeStamp(store);
        IndexBuildProto.IndexBuildIndexingStamp.Method method = indexingTypeStamp.getMethod();
        boolean allowMutual = method == IndexBuildProto.IndexBuildIndexingStamp.Method.MUTUAL_BY_RECORDS || method == IndexBuildProto.IndexBuildIndexingStamp.Method.SCRUB_REPAIR;
        this.heartbeat = new IndexingHeartbeat(this.common.getIndexerId(), indexingTypeStamp.getMethod().toString(), this.common.config.getLeaseLengthMillis(), allowMutual);
        return this.forEachTargetIndex(index -> this.setIndexingTypeOrThrow(store, continuedBuild, (Index)index, indexingTypeStamp).thenCompose(ignore -> this.updateHeartbeat(store, (Index)index)));
    }

    @Nonnull
    private CompletableFuture<Void> setIndexingTypeOrThrow(FDBRecordStore store, boolean continuedBuild, Index index, IndexBuildProto.IndexBuildIndexingStamp newStamp) {
        if (this.forceStampOverwrite && !continuedBuild) {
            store.saveIndexingTypeStamp(index, newStamp);
            return AsyncUtil.DONE;
        }
        return store.loadIndexingTypeStampAsync(index).thenCompose(savedStamp -> {
            if (savedStamp == null) {
                if (continuedBuild && newStamp.getMethod() != IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS) {
                    return this.isWriteOnlyButNoRecordScanned(store, index).thenCompose(noRecordScanned -> this.throwAsByRecordsUnlessNoRecordWasScanned((boolean)noRecordScanned, store, index, newStamp));
                }
                store.saveIndexingTypeStamp(index, newStamp);
                return AsyncUtil.DONE;
            }
            if (newStamp.equals(savedStamp)) {
                return AsyncUtil.DONE;
            }
            if (IndexingBase.isTypeStampBlocked(savedStamp) && !this.policy.shouldAllowUnblock(savedStamp.getBlockID())) {
                throw this.newPartlyBuiltException((IndexBuildProto.IndexBuildIndexingStamp)savedStamp, newStamp, index);
            }
            if (IndexingBase.areSimilar(newStamp, savedStamp)) {
                store.saveIndexingTypeStamp(index, newStamp);
                return AsyncUtil.DONE;
            }
            if (continuedBuild && this.shouldAllowTypeConversionContinue(newStamp, (IndexBuildProto.IndexBuildIndexingStamp)savedStamp)) {
                store.saveIndexingTypeStamp(index, newStamp);
                return AsyncUtil.DONE;
            }
            if (this.forceStampOverwrite) {
                return this.isWriteOnlyButNoRecordScanned(store, index).thenCompose(noRecordScanned -> this.throwUnlessNoRecordWasScanned((boolean)noRecordScanned, store, index, newStamp, (IndexBuildProto.IndexBuildIndexingStamp)savedStamp));
            }
            throw this.newPartlyBuiltException((IndexBuildProto.IndexBuildIndexingStamp)savedStamp, newStamp, index);
        });
    }

    private boolean shouldAllowTypeConversionContinue(IndexBuildProto.IndexBuildIndexingStamp newStamp, IndexBuildProto.IndexBuildIndexingStamp savedStamp) {
        return this.policy.shouldAllowTypeConversionContinue(newStamp, savedStamp);
    }

    private static boolean areSimilar(IndexBuildProto.IndexBuildIndexingStamp newStamp, IndexBuildProto.IndexBuildIndexingStamp savedStamp) {
        return newStamp.equals(savedStamp) || IndexingBase.blocklessStampOf(newStamp).equals(IndexingBase.blocklessStampOf(savedStamp));
    }

    private static IndexBuildProto.IndexBuildIndexingStamp blocklessStampOf(IndexBuildProto.IndexBuildIndexingStamp stamp) {
        return stamp.toBuilder().setBlock(false).setBlockID("").setBlockExpireEpochMilliSeconds(0L).build();
    }

    @Nonnull
    private CompletableFuture<Void> throwAsByRecordsUnlessNoRecordWasScanned(boolean noRecordScanned, FDBRecordStore store, Index index, IndexBuildProto.IndexBuildIndexingStamp indexingTypeStamp) {
        if (noRecordScanned) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.build("no scanned ranges - continue indexing", new Object[0]).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
            }
            store.saveIndexingTypeStamp(index, indexingTypeStamp);
            return AsyncUtil.DONE;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.build("continuation with null type stamp, assuming previous by-records scan", new Object[0]).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString());
        }
        IndexBuildProto.IndexBuildIndexingStamp fakeSavedStamp = IndexingMultiTargetByRecords.compileSingleTargetLegacyIndexingTypeStamp();
        throw this.newPartlyBuiltException(fakeSavedStamp, indexingTypeStamp, index);
    }

    @Nonnull
    private CompletableFuture<Void> throwUnlessNoRecordWasScanned(boolean noRecordScanned, FDBRecordStore store, Index index, IndexBuildProto.IndexBuildIndexingStamp indexingTypeStamp, IndexBuildProto.IndexBuildIndexingStamp savedStamp) {
        if (noRecordScanned) {
            store.saveIndexingTypeStamp(index, indexingTypeStamp);
            return AsyncUtil.DONE;
        }
        throw this.newPartlyBuiltException(savedStamp, indexingTypeStamp, index);
    }

    @Nonnull
    protected CompletableFuture<Void> setScrubberTypeOrThrow(FDBRecordStore store) {
        throw new ValidationException("Called setScrubberTypeOrThrow in a non-scrubbing path", "isScrubber", this.isScrubber);
    }

    @Nonnull
    abstract IndexBuildProto.IndexBuildIndexingStamp getIndexingTypeStamp(FDBRecordStore var1);

    abstract CompletableFuture<Void> buildIndexInternalAsync();

    private CompletableFuture<Boolean> isWriteOnlyButNoRecordScanned(FDBRecordStore store, Index index) {
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, index);
        return rangeSet.firstMissingRangeAsync().thenCompose(range -> {
            if (range == null) {
                return AsyncUtil.READY_FALSE;
            }
            return CompletableFuture.completedFuture(RangeSet.isFirstKey(range.begin) && RangeSet.isFinalKey(range.end));
        });
    }

    private RecordCoreException newPartlyBuiltException(IndexBuildProto.IndexBuildIndexingStamp savedStamp, IndexBuildProto.IndexBuildIndexingStamp expectedStamp, Index index) {
        return new PartlyBuiltException(savedStamp, expectedStamp, index, this.common.getIndexerId(), savedStamp.getBlock() ? "This index was partly built, and blocked" : "This index was partly built by another method");
    }

    protected CompletableFuture<Boolean> doneOrThrottleDelayAndMaybeLogProgress(boolean done, List<Object> additionalLogMessageKeyValues) {
        if (done) {
            return AsyncUtil.READY_FALSE;
        }
        long toWait = this.throttle.waitTimeMilliseconds();
        if (LOGGER.isInfoEnabled() && this.shouldLogBuildProgress()) {
            FDBStoreTimer timer = this.getRunner().getTimer();
            FDBStoreTimer metricsDiff = null;
            if (timer != null) {
                metricsDiff = this.lastProgressSnapshot == null ? timer : StoreTimer.getDifference(timer, this.lastProgressSnapshot);
                this.lastProgressSnapshot = StoreTimerSnapshot.from(timer);
            }
            LOGGER.info(KeyValueLogMessage.build("Indexer: Built Range", new Object[]{LogMessageKeys.DELAY, toWait}).addKeysAndValues(additionalLogMessageKeyValues != null ? additionalLogMessageKeyValues : Collections.emptyList()).addKeysAndValues(this.indexingLogMessageKeyValues()).addKeysAndValues(this.common.indexLogMessageKeyValues()).addKeysAndValues(this.throttle.logMessageKeyValues()).addKeysAndValues(metricsDiff == null ? Collections.emptyMap() : metricsDiff.getKeysAndValues()).toString());
        }
        this.validateTimeLimit(toWait);
        CompletableFuture delay = MoreAsyncUtil.delayedFuture(toWait, TimeUnit.MILLISECONDS, this.getRunner().getScheduledExecutor()).thenApply(vignore3 -> true);
        if (this.getRunner().getTimer() != null) {
            delay = this.getRunner().getTimer().instrument(FDBStoreTimer.Events.INDEXER_DELAY, delay, this.getRunner().getExecutor());
        }
        return delay;
    }

    private void validateTimeLimit(long toWait) {
        long timeLimitMilliseconds = this.common.config.getTimeLimitMilliseconds();
        if (timeLimitMilliseconds == 0L) {
            return;
        }
        long now = System.currentTimeMillis() + toWait;
        if (this.startingTimeMillis + timeLimitMilliseconds >= now) {
            return;
        }
        throw new TimeLimitException("Time Limit Exceeded", new Object[]{LogMessageKeys.TIME_LIMIT_MILLIS, timeLimitMilliseconds, LogMessageKeys.TIME_STARTED_MILLIS, this.startingTimeMillis, LogMessageKeys.TIME_ENDED_MILLIS, now, LogMessageKeys.TIME_TO_WAIT_MILLIS, toWait});
    }

    private boolean shouldLogBuildProgress() {
        long interval = this.common.config.getProgressLogIntervalMillis();
        long now = System.currentTimeMillis();
        if (interval < 0L || interval != 0L && interval > now - this.timeOfLastProgressLogMillis) {
            return false;
        }
        this.timeOfLastProgressLogMillis = now;
        return true;
    }

    public int getLimit() {
        return this.throttle.getLimit();
    }

    public <R> CompletableFuture<R> buildCommitRetryAsync(@Nonnull BiFunction<FDBRecordStore, AtomicLong, CompletableFuture<R>> buildFunction, @Nullable List<Object> additionalLogMessageKeyValues) {
        return this.buildCommitRetryAsync(buildFunction, additionalLogMessageKeyValues, false);
    }

    public <R> CompletableFuture<R> buildCommitRetryAsync(@Nonnull BiFunction<FDBRecordStore, AtomicLong, CompletableFuture<R>> buildFunction, @Nullable List<Object> additionalLogMessageKeyValues, boolean duringRangesIteration) {
        return this.throttle.buildCommitRetryAsync(buildFunction, null, additionalLogMessageKeyValues, duringRangesIteration);
    }

    protected void timerIncrement(StoreTimer.Count event) {
        FDBStoreTimer timer = this.getRunner().getTimer();
        if (timer != null) {
            timer.increment(event);
        }
    }

    @Nonnull
    private <T> CompletableFuture<Void> forEachTargetIndex(Function<Index, CompletableFuture<T>> function) {
        List<Index> targetIndexes = this.common.getTargetIndexes();
        return AsyncUtil.whenAll(targetIndexes.stream().map(function).collect(Collectors.toList()));
    }

    @Nonnull
    private <T> CompletableFuture<Void> forEachTargetIndexContext(Function<IndexingCommon.IndexContext, CompletableFuture<T>> function) {
        List<IndexingCommon.IndexContext> indexContexts = this.common.getTargetIndexContexts();
        return AsyncUtil.whenAll(indexContexts.stream().map(function).collect(Collectors.toList()));
    }

    protected <T> CompletableFuture<Void> iterateRangeOnly(@Nonnull FDBRecordStore store, @Nonnull RecordCursor<T> cursor, @Nonnull BiFunction<FDBRecordStore, RecordCursorResult<T>, CompletableFuture<FDBStoredRecord<Message>>> getRecordToIndex, @Nonnull AtomicReference<RecordCursorResult<T>> nextResultCont, @Nonnull AtomicBoolean hasMore, @Nullable AtomicLong recordsScanned, boolean isIdempotent) {
        AtomicLong recordsScannedCounter = new AtomicLong();
        AtomicReference<Object> nextResult = new AtomicReference<Object>(null);
        this.deferAutoMergeDuringCommit(store);
        return ((CompletableFuture)this.validateTypeStamp(store).thenCompose(ignore -> AsyncUtil.whileTrue(() -> cursor.onNext().thenCompose(result -> this.policy.isReverseScanOrder() ? this.handleCursorResultReverse(store, (RecordCursorResult)result, getRecordToIndex, nextResultCont, recordsScannedCounter, hasMore, isIdempotent) : this.handleCursorResult(store, (RecordCursorResult)result, getRecordToIndex, nextResult, nextResultCont, recordsScannedCounter, hasMore, isIdempotent)), cursor.getExecutor()))).thenApply(vignore -> {
            long recordsScannedInTransaction = recordsScannedCounter.get();
            if (recordsScanned != null) {
                recordsScanned.addAndGet(recordsScannedInTransaction);
            }
            if (this.common.isTrackProgress()) {
                for (Index index : this.common.getTargetIndexes()) {
                    Subspace scannedRecordsSubspace = IndexingSubspaces.indexBuildScannedRecordsSubspace(store, index);
                    store.context.ensureActive().mutate(MutationType.ADD, scannedRecordsSubspace.getKey(), FDBRecordStore.encodeRecordCount(recordsScannedInTransaction));
                }
            }
            return null;
        });
    }

    private <T> CompletableFuture<Boolean> handleCursorResult(@Nonnull FDBRecordStore store, @Nonnull RecordCursorResult<T> cursorResult, @Nonnull BiFunction<FDBRecordStore, RecordCursorResult<T>, CompletableFuture<FDBStoredRecord<Message>>> getRecordToIndex, @Nonnull AtomicReference<RecordCursorResult<T>> nextResult, @Nonnull AtomicReference<RecordCursorResult<T>> nextResultCont, @Nonnull AtomicLong recordsScannedCounter, @Nonnull AtomicBoolean hasMore, boolean isIdempotent) {
        boolean isExhausted;
        RecordCursorResult<T> currResult;
        if (cursorResult.hasNext()) {
            currResult = nextResult.get();
            nextResult.set(cursorResult);
            if (currResult == null) {
                return AsyncUtil.READY_TRUE;
            }
            isExhausted = false;
        } else {
            this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_COUNT);
            if (!cursorResult.getNoNextReason().isSourceExhausted()) {
                nextResultCont.set(nextResult.get());
                hasMore.set(true);
                return AsyncUtil.READY_FALSE;
            }
            currResult = nextResult.get();
            if (currResult == null) {
                hasMore.set(false);
                return AsyncUtil.READY_FALSE;
            }
            nextResult.set(null);
            isExhausted = true;
        }
        this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RECORDS_SCANNED);
        recordsScannedCounter.incrementAndGet();
        return getRecordToIndex.apply(store, currResult).thenCompose(rec -> {
            if (null == rec) {
                if (isExhausted) {
                    hasMore.set(false);
                    return AsyncUtil.READY_FALSE;
                }
                return AsyncUtil.READY_TRUE;
            }
            if (isIdempotent) {
                store.addRecordReadConflict(rec.getPrimaryKey());
            }
            this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RECORDS_INDEXED);
            CompletableFuture<Void> updateMaintainer = this.updateMaintainerBuilder(store, (FDBStoredRecord<Message>)rec);
            if (isExhausted) {
                this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_DEPLETION);
                hasMore.set(false);
                return updateMaintainer.thenApply(vignore -> false);
            }
            return updateMaintainer.thenCompose(vignore -> this.hadTransactionReachedLimits(store).thenApply(shouldCommit -> {
                if (shouldCommit.booleanValue()) {
                    nextResultCont.set((RecordCursorResult)nextResult.get());
                    hasMore.set(true);
                    return false;
                }
                return true;
            }));
        });
    }

    private <T> CompletableFuture<Boolean> handleCursorResultReverse(@Nonnull FDBRecordStore store, @Nonnull RecordCursorResult<T> cursorResult, @Nonnull BiFunction<FDBRecordStore, RecordCursorResult<T>, CompletableFuture<FDBStoredRecord<Message>>> getRecordToIndex, @Nonnull AtomicReference<RecordCursorResult<T>> nextResultCont, @Nonnull AtomicLong recordsScannedCounter, @Nonnull AtomicBoolean hasMore, boolean isIdempotent) {
        if (!cursorResult.hasNext()) {
            this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_COUNT);
            if (cursorResult.getNoNextReason().isSourceExhausted()) {
                this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_DEPLETION);
                hasMore.set(false);
            } else {
                hasMore.set(true);
            }
            return AsyncUtil.READY_FALSE;
        }
        this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RECORDS_SCANNED);
        recordsScannedCounter.incrementAndGet();
        nextResultCont.set(cursorResult);
        return getRecordToIndex.apply(store, cursorResult).thenCompose(rec -> {
            if (null == rec) {
                return AsyncUtil.READY_TRUE;
            }
            if (isIdempotent) {
                store.addRecordReadConflict(rec.getPrimaryKey());
            }
            this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RECORDS_INDEXED);
            CompletableFuture<Void> updateMaintainer = this.updateMaintainerBuilder(store, (FDBStoredRecord<Message>)rec);
            return updateMaintainer.thenCompose(vignore -> this.hadTransactionReachedLimits(store).thenApply(shouldCommit -> {
                if (shouldCommit.booleanValue()) {
                    hasMore.set(true);
                    return false;
                }
                return true;
            }));
        });
    }

    private CompletableFuture<Boolean> hadTransactionReachedLimits(FDBRecordStore store) {
        long transactionTimeLimitMilliseconds = this.common.config.getTransactionTimeLimitMilliseconds();
        if (transactionTimeLimitMilliseconds > 0L && transactionTimeLimitMilliseconds < store.getContext().getTransactionAge()) {
            this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_TIME);
            return AsyncUtil.READY_TRUE;
        }
        long maxWriteLimit = this.common.config.getMaxWriteLimitBytes();
        if (maxWriteLimit > 0L) {
            return store.getContext().getApproximateTransactionSize().thenApply(size -> {
                if (size > maxWriteLimit) {
                    this.timerIncrement(FDBStoreTimer.Counts.ONLINE_INDEX_BUILDER_RANGES_BY_SIZE);
                    return true;
                }
                return false;
            });
        }
        return AsyncUtil.READY_FALSE;
    }

    private CompletableFuture<Void> validateTypeStamp(@Nonnull FDBRecordStore store) {
        if (this.isScrubber) {
            return AsyncUtil.DONE;
        }
        IndexBuildProto.IndexBuildIndexingStamp expectedTypeStamp = this.getIndexingTypeStamp(store);
        return this.forEachTargetIndex(index -> CompletableFuture.allOf(new CompletableFuture[]{this.updateHeartbeat(store, (Index)index), store.loadIndexingTypeStampAsync((Index)index).thenAccept(typeStamp -> this.validateTypeStamp((IndexBuildProto.IndexBuildIndexingStamp)typeStamp, expectedTypeStamp, (Index)index))}));
    }

    private CompletableFuture<Void> updateHeartbeat(FDBRecordStore store, Index index) {
        return this.heartbeat == null ? AsyncUtil.DONE : this.heartbeat.checkAndUpdateHeartbeat(store, index);
    }

    private CompletableFuture<Void> clearHeartbeats() {
        if (this.heartbeat == null) {
            return AsyncUtil.DONE;
        }
        return this.getRunner().runAsync(context -> this.common.getRecordStoreBuilder().copyBuilder().setContext((FDBRecordContext)context).openAsync().thenApply(store -> {
            this.clearHeartbeats((FDBRecordStore)store);
            return null;
        }));
    }

    private void clearHeartbeats(FDBRecordStore store) {
        if (this.heartbeat != null) {
            for (Index index : this.common.getTargetIndexes()) {
                this.heartbeat.clearHeartbeat(store, index);
            }
        }
    }

    private void clearHeartbeatForIndex(FDBRecordStore store, Index index) {
        if (this.heartbeat != null) {
            this.heartbeat.clearHeartbeat(store, index);
        }
    }

    private void validateTypeStamp(IndexBuildProto.IndexBuildIndexingStamp typeStamp, IndexBuildProto.IndexBuildIndexingStamp expectedTypeStamp, Index index) {
        if (typeStamp == null && expectedTypeStamp.getMethod() == IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS) {
            return;
        }
        if (typeStamp == null || typeStamp.getMethod() != expectedTypeStamp.getMethod() || IndexingBase.isTypeStampBlocked(typeStamp)) {
            throw new PartlyBuiltException(typeStamp, expectedTypeStamp, index, this.common.getIndexerId(), "Indexing stamp had changed");
        }
    }

    private static boolean isTypeStampBlocked(IndexBuildProto.IndexBuildIndexingStamp typeStamp) {
        return typeStamp.getBlock() && (typeStamp.getBlockExpireEpochMilliSeconds() == 0L || typeStamp.getBlockExpireEpochMilliSeconds() > System.currentTimeMillis());
    }

    @Nonnull
    SyntheticRecordFromStoredRecordPlan syntheticPlanForIndex(@Nonnull FDBRecordStore store, @Nonnull IndexingCommon.IndexContext indexContext) {
        if (!indexContext.isSynthetic) {
            throw new RecordCoreException("unable to create synthetic plan for non-synthetic index", new Object[0]);
        }
        RecordQueryPlanner queryPlanner = new RecordQueryPlanner(store.getRecordMetaData(), store.getRecordStoreState().withWriteOnlyIndexes(Collections.singletonList(indexContext.index.getName())));
        SyntheticRecordPlanner syntheticPlanner = new SyntheticRecordPlanner(store, queryPlanner);
        return syntheticPlanner.forIndex(indexContext.index);
    }

    private CompletableFuture<Void> updateMaintainerBuilder(@Nonnull FDBRecordStore store, FDBStoredRecord<Message> rec) {
        return this.forEachTargetIndexContext(indexContext -> {
            if (!indexContext.recordTypes.contains(rec.getRecordType())) {
                return AsyncUtil.DONE;
            }
            if (indexContext.isSynthetic) {
                SyntheticRecordFromStoredRecordPlan syntheticPlan = this.syntheticPlanForIndex(store, (IndexingCommon.IndexContext)indexContext);
                IndexMaintainer maintainer = store.getIndexMaintainer(indexContext.index);
                return syntheticPlan.execute(store, rec).forEachAsync(syntheticRecord -> maintainer.update(null, syntheticRecord), 1);
            }
            return store.getIndexMaintainer(indexContext.index).update(null, rec);
        });
    }

    protected CompletableFuture<Void> iterateAllRanges(List<Object> additionalLogMessageKeyValues, BiFunction<FDBRecordStore, AtomicLong, CompletableFuture<Boolean>> iterateRange) {
        return this.iterateAllRanges(additionalLogMessageKeyValues, iterateRange, null);
    }

    protected CompletableFuture<Void> iterateAllRanges(List<Object> additionalLogMessageKeyValues, BiFunction<FDBRecordStore, AtomicLong, CompletableFuture<Boolean>> iterateRange, @Nullable Function<FDBException, Optional<Boolean>> shouldReturnQuietly) {
        return AsyncUtil.whileTrue(() -> ((CompletableFuture)this.throttle.buildCommitRetryAsync(iterateRange, shouldReturnQuietly, additionalLogMessageKeyValues, true).handle((hasMore, ex) -> {
            if (ex == null) {
                Set<Index> indexSet = this.throttle.getAndResetMergeRequiredIndexes();
                if (indexSet != null && !indexSet.isEmpty()) {
                    return this.mergeIndexes(indexSet).thenCompose(ignore -> this.doneOrThrottleDelayAndMaybeLogProgress(hasMore == false, additionalLogMessageKeyValues));
                }
                return this.doneOrThrottleDelayAndMaybeLogProgress(hasMore == false, additionalLogMessageKeyValues);
            }
            RuntimeException unwrappedEx = this.getRunner().getDatabase().mapAsyncToSyncException((Throwable)ex);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.build("possibly non-fatal error encountered building range", new Object[0]).addKeysAndValues(this.common.indexLogMessageKeyValues()).toString(), (Throwable)ex);
            }
            throw unwrappedEx;
        })).thenCompose(Function.identity()), this.getRunner().getExecutor());
    }

    public CompletableFuture<Void> mergeIndexes() {
        return this.mergeIndexes(new HashSet<Index>(this.common.getTargetIndexes()));
    }

    private CompletableFuture<Void> mergeIndexes(Set<Index> indexSet) {
        return AsyncUtil.whenAll(indexSet.stream().map(index -> this.getIndexingMerger((Index)index).mergeIndex()).collect(Collectors.toList()));
    }

    private synchronized IndexingMerger getIndexingMerger(Index index) {
        if (this.indexingMergerMap == null) {
            this.indexingMergerMap = new HashMap<String, IndexingMerger>();
        }
        return this.indexingMergerMap.computeIfAbsent(index.getName(), k -> new IndexingMerger(index, this.common, this.policy.getInitialMergesCountLimit()));
    }

    private void deferAutoMergeDuringCommit(FDBRecordStore store) {
        store.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
    }

    protected static boolean notAllRangesExhausted(Tuple cont, Tuple end) {
        return end != null || cont != null;
    }

    protected ScanProperties scanPropertiesWithLimits(boolean isIdempotent) {
        IsolationLevel isolationLevel = isIdempotent ? IsolationLevel.SNAPSHOT : IsolationLevel.SERIALIZABLE;
        boolean isReverse = this.policy.isReverseScanOrder();
        ExecuteProperties.Builder executeProperties = ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel).setReturnedRowLimit(this.getLimit() + (isReverse ? 0 : 1));
        return new ScanProperties(executeProperties.build(), isReverse);
    }

    @Nonnull
    public CompletableFuture<Void> rebuildIndexAsync(@Nonnull FDBRecordStore store) {
        this.validateOrThrowEx(!this.policy.isReverseScanOrder(), "rebuild do not support reverse scan order");
        return ((CompletableFuture)((CompletableFuture)this.forEachTargetIndex(index -> store.clearAndMarkIndexWriteOnly((Index)index).thenCompose(bignore -> {
            IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, index);
            return rangeSet.insertRangeAsync(null, null);
        })).thenCompose(vignore -> this.setIndexingTypeOrThrow(store, false))).thenCompose(vignore -> this.rebuildIndexInternalAsync(store))).whenComplete((ignore, ignoreEx) -> this.clearHeartbeats(store));
    }

    abstract CompletableFuture<Void> rebuildIndexInternalAsync(FDBRecordStore var1);

    protected void validateOrThrowEx(boolean isValid, @Nonnull String msg) {
        if (!isValid) {
            throw new ValidationException(msg, new Object[]{LogMessageKeys.INDEX_NAME, this.common.getTargetIndexesNames(), LogMessageKeys.SOURCE_INDEX, this.policy.getSourceIndex(), LogMessageKeys.INDEXER_ID, this.common.getIndexerId()});
        }
    }

    protected void validateSameMetadataOrThrow(FDBRecordStore store) {
        RecordMetaData metaData = store.getRecordMetaData();
        RecordMetaDataProvider recordMetaDataProvider = this.common.getRecordStoreBuilder().getMetaDataProvider();
        if (recordMetaDataProvider == null || !metaData.equals(recordMetaDataProvider.getRecordMetaData())) {
            throw new MetaDataException("Store does not have the same metadata", new Object[0]);
        }
    }

    CompletableFuture<Map<String, IndexBuildProto.IndexBuildIndexingStamp>> performIndexingStampOperation(@Nullable IndexingStampOperation op, @Nullable String id, @Nullable Long ttlSeconds) {
        ConcurrentHashMap newStamps = new ConcurrentHashMap();
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> this.forEachTargetIndex(index -> store.loadIndexingTypeStampAsync((Index)index).thenApply(stamp -> this.performIndexingStampOperation(newStamps, (FDBRecordStore)store, (Index)index, (IndexBuildProto.IndexBuildIndexingStamp)stamp, op, id, ttlSeconds))))).thenApply(ignore -> newStamps);
    }

    boolean performIndexingStampOperation(@Nonnull ConcurrentHashMap<String, IndexBuildProto.IndexBuildIndexingStamp> newStamps, @Nonnull FDBRecordStore store, @Nonnull Index index, @Nullable IndexBuildProto.IndexBuildIndexingStamp stamp, @Nullable IndexingStampOperation op, @Nullable String id, @Nullable Long ttlSeconds) {
        if (op == null || stamp == null || op.equals((Object)IndexingStampOperation.QUERY)) {
            newStamps.put(index.getName(), stamp != null ? stamp : IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.NONE).build());
            return false;
        }
        IndexBuildProto.IndexBuildIndexingStamp.Builder builder = stamp.toBuilder();
        if (op == IndexingStampOperation.BLOCK) {
            builder.setBlock(true);
            builder.setBlockID(id == null ? "" : id);
            if (ttlSeconds != null && ttlSeconds > 0L) {
                builder.setBlockExpireEpochMilliSeconds(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttlSeconds));
            }
        }
        if (op == IndexingStampOperation.UNBLOCK && (id == null || id.isEmpty() || id.equals(stamp.getBlockID()))) {
            builder.setBlock(false);
        }
        IndexBuildProto.IndexBuildIndexingStamp newStamp = builder.build();
        store.saveIndexingTypeStamp(index, newStamp);
        newStamps.put(index.getName(), newStamp);
        return true;
    }

    public CompletableFuture<Map<UUID, IndexBuildProto.IndexBuildHeartbeat>> getIndexingHeartbeats(int maxCount) {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> IndexingHeartbeat.getIndexingHeartbeats(store, this.common.getPrimaryIndex(), maxCount)));
    }

    public CompletableFuture<Integer> clearIndexingHeartbeats(long minAgeMilliseconds, int maxIteration) {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> IndexingHeartbeat.clearIndexingHeartbeats(store, this.common.getPrimaryIndex(), minAgeMilliseconds, maxIteration)));
    }

    public static boolean isValidationException(@Nullable Throwable ex) {
        for (Throwable current = ex; current != null; current = current.getCause()) {
            if (!(current instanceof ValidationException)) continue;
            return true;
        }
        return false;
    }

    public static PartlyBuiltException getAPartlyBuiltExceptionIfApplicable(@Nullable Throwable ex) {
        return IndexingBase.findException(ex, PartlyBuiltException.class);
    }

    public static UnexpectedReadableException getUnexpectedReadableIfApplicable(@Nullable Throwable ex) {
        return IndexingBase.findException(ex, UnexpectedReadableException.class);
    }

    protected static <T> T findException(@Nullable Throwable ex, Class<T> classT) {
        Set seenSet = Collections.newSetFromMap(new IdentityHashMap());
        for (Throwable current = ex; current != null && !seenSet.contains(current); current = current.getCause()) {
            if (classT.isInstance(current)) {
                return classT.cast(current);
            }
            seenSet.add(current);
        }
        return null;
    }

    protected static boolean shouldLessenWork(@Nullable FDBException ex) {
        if (ex == null) {
            return false;
        }
        HashSet<Integer> lessenWorkCodes = new HashSet<Integer>(Arrays.asList(FDBError.TIMED_OUT.code(), FDBError.TRANSACTION_TOO_OLD.code(), FDBError.NOT_COMMITTED.code(), FDBError.TRANSACTION_TIMED_OUT.code(), FDBError.COMMIT_READ_INCOMPLETE.code(), FDBError.TRANSACTION_TOO_LARGE.code()));
        return lessenWorkCodes.contains(ex.getCode());
    }

    public static class ValidationException
    extends RecordCoreException {
        ValidationException(@Nonnull String msg, Object ... keyValues) {
            super(msg, keyValues);
        }
    }

    public static class PartlyBuiltException
    extends RecordCoreException {
        final IndexBuildProto.IndexBuildIndexingStamp savedStamp;
        final IndexBuildProto.IndexBuildIndexingStamp expectedStamp;
        final String indexName;

        public PartlyBuiltException(IndexBuildProto.IndexBuildIndexingStamp savedStamp, IndexBuildProto.IndexBuildIndexingStamp expectedStamp, Index index, UUID uuid, @Nonnull String msg) {
            super(msg, new Object[]{LogMessageKeys.INDEX_NAME, index, LogMessageKeys.INDEX_VERSION, index.getLastModifiedVersion(), LogMessageKeys.EXPECTED, PartlyBuiltException.stampToString(expectedStamp), LogMessageKeys.ACTUAL, PartlyBuiltException.stampToString(savedStamp), LogMessageKeys.INDEXER_ID, uuid});
            this.savedStamp = savedStamp;
            this.expectedStamp = expectedStamp;
            this.indexName = index.getName();
        }

        public boolean wasBlocked() {
            return this.savedStamp.getBlock();
        }

        public IndexBuildProto.IndexBuildIndexingStamp getSavedStamp() {
            return this.savedStamp;
        }

        public String getSavedStampString() {
            return PartlyBuiltException.stampToString(this.getSavedStamp());
        }

        public IndexBuildProto.IndexBuildIndexingStamp getExpectedStamp() {
            return this.expectedStamp;
        }

        public String getExpectedStampString() {
            return PartlyBuiltException.stampToString(this.getExpectedStamp());
        }

        public static String stampToString(IndexBuildProto.IndexBuildIndexingStamp stamp) {
            if (stamp == null) {
                return "IndexingStamp(<null>)";
            }
            StringBuilder str = new StringBuilder("IndexingStamp(").append(stamp.getMethod()).append(", target:").append(stamp.getTargetIndexList());
            if (stamp.getBlock()) {
                long expirationMillis;
                str.append(", blocked");
                String id = stamp.getBlockID();
                if (!id.isEmpty()) {
                    str.append(", blockId{").append(id).append("} ");
                }
                if ((expirationMillis = stamp.getBlockExpireEpochMilliSeconds()) > 0L) {
                    try {
                        str.append(", blockExpires{").append(Instant.ofEpochMilli(expirationMillis)).append("}");
                    }
                    catch (DateTimeException ignore) {
                        str.append(", blockExpires{value=").append(expirationMillis).append("}");
                    }
                }
            }
            return str.append(")").toString();
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    public static class TimeLimitException
    extends RecordCoreException {
        TimeLimitException(@Nonnull String msg, Object ... keyValues) {
            super(msg, keyValues);
        }
    }

    static enum IndexingStampOperation {
        QUERY,
        BLOCK,
        UNBLOCK;

    }

    public static class UnexpectedReadableException
    extends RecordCoreException {
        final boolean allReadable;

        public UnexpectedReadableException(boolean allReadable, @Nonnull String msg, Object ... keyValues) {
            super(msg, keyValues);
            this.allReadable = allReadable;
        }
    }
}

