/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FormatVersion;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class IndexingByIndex
extends IndexingBase {
    private IndexBuildProto.IndexBuildIndexingStamp myIndexingTypeStamp = null;

    IndexingByIndex(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy) {
        super(common, policy);
    }

    @Override
    @Nonnull
    IndexBuildProto.IndexBuildIndexingStamp getIndexingTypeStamp(FDBRecordStore store) {
        if (this.myIndexingTypeStamp == null) {
            Index srcIndex = this.getSourceIndex(store.getRecordMetaData());
            this.myIndexingTypeStamp = IndexingByIndex.compileIndexingTypeStamp(srcIndex);
        }
        return this.myIndexingTypeStamp;
    }

    @Nonnull
    private static IndexBuildProto.IndexBuildIndexingStamp compileIndexingTypeStamp(Index srcIndex) {
        return IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.BY_INDEX).setSourceIndexSubspaceKey(ZeroCopyByteString.wrap(Tuple.from(srcIndex.getSubspaceKey()).pack())).setSourceIndexLastModifiedVersion(srcIndex.getLastModifiedVersion()).build();
    }

    @Override
    List<Object> indexingLogMessageKeyValues() {
        return Arrays.asList(new Object[]{LogMessageKeys.INDEXING_METHOD, "by index", LogMessageKeys.SOURCE_INDEX, this.policy.getSourceIndex(), LogMessageKeys.SUBSPACE_KEY, this.policy.getSourceIndexSubspaceKey()});
    }

    @Nonnull
    private Index getSourceIndex(RecordMetaData metaData) {
        if (this.policy.getSourceIndexSubspaceKey() != null) {
            return metaData.getIndexFromSubspaceKey(this.policy.getSourceIndexSubspaceKey());
        }
        if (this.policy.getSourceIndex() != null) {
            return metaData.getIndex(this.policy.getSourceIndex());
        }
        throw new IndexingBase.ValidationException("no source index", new Object[]{LogMessageKeys.INDEX_NAME, this.common.getIndex().getName(), LogMessageKeys.SOURCE_INDEX, this.policy.getSourceIndex(), LogMessageKeys.INDEXER_ID, this.common.getIndexerId()});
    }

    @Override
    @Nonnull
    CompletableFuture<Void> buildIndexInternalAsync() {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> {
            this.validateSourceAndTargetIndexes((FDBRecordStore)store);
            return context.getReadVersionAsync().thenCompose(ignore -> this.buildIndexFromIndex());
        }), this.common.indexLogMessageKeyValues("IndexingByIndex::buildIndexInternalAsync"));
    }

    @Nonnull
    private CompletableFuture<Void> buildIndexFromIndex() {
        List<Object> additionalLogMessageKeyValues = Arrays.asList(new Object[]{LogMessageKeys.CALLING_METHOD, "buildIndexFromIndex"});
        return this.iterateAllRanges(additionalLogMessageKeyValues, this::buildRangeOnly);
    }

    @Nonnull
    private CompletableFuture<Boolean> buildRangeOnly(@Nonnull FDBRecordStore store, @Nonnull AtomicLong recordsScanned) {
        this.validateSameMetadataOrThrow(store);
        Index index = this.common.getIndex();
        IndexMaintainer maintainer = store.getIndexMaintainer(index);
        this.validateIdempotenceIfNecessary(store, maintainer);
        Index srcIndex = this.getSourceIndex(store.getRecordMetaData());
        this.validateOrThrowEx(store.isIndexScannable(srcIndex), "source index is not scannable");
        boolean isIdempotent = maintainer.isIdempotent();
        ScanProperties scanProperties = this.scanPropertiesWithLimits(isIdempotent);
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, index);
        return rangeSet.firstMissingRangeAsync().thenCompose(range -> {
            if (range == null) {
                return AsyncUtil.READY_FALSE;
            }
            Tuple rangeStart = RangeSet.isFirstKey(range.begin) ? null : Tuple.fromBytes(range.begin);
            Tuple rangeEnd = RangeSet.isFinalKey(range.end) ? null : Tuple.fromBytes(range.end);
            TupleRange tupleRange = TupleRange.between(rangeStart, rangeEnd);
            RecordCursor cursor = store.scanIndexRecords(srcIndex.getName(), IndexScanType.BY_VALUE, tupleRange, null, scanProperties);
            AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
            AtomicBoolean hasMore = new AtomicBoolean(true);
            return this.iterateRangeOnly(store, cursor, this::getRecordIfTypeMatch, lastResult, hasMore, recordsScanned, isIdempotent).thenCompose(ignore -> this.postIterateRangeOnly(rangeSet, hasMore.get(), lastResult, rangeStart, rangeEnd, scanProperties.isReverse()));
        });
    }

    private CompletableFuture<Boolean> postIterateRangeOnly(IndexingRangeSet rangeSet, boolean hasMore, AtomicReference<RecordCursorResult<FDBIndexedRecord<Message>>> lastResult, Tuple rangeStart, Tuple rangeEnd, boolean isReverse) {
        if (isReverse) {
            Tuple continuation = hasMore ? lastResult.get().get().getIndexEntry().getKey() : rangeStart;
            return rangeSet.insertRangeAsync(IndexingByIndex.packOrNull(continuation), IndexingByIndex.packOrNull(rangeEnd), true).thenApply(ignore -> hasMore || rangeStart != null);
        }
        Tuple continuation = hasMore ? lastResult.get().get().getIndexEntry().getKey() : rangeEnd;
        return rangeSet.insertRangeAsync(IndexingByIndex.packOrNull(rangeStart), IndexingByIndex.packOrNull(continuation), true).thenApply(ignore -> hasMore || rangeEnd != null);
    }

    @Nonnull
    private CompletableFuture<FDBStoredRecord<Message>> getRecordIfTypeMatch(FDBRecordStore store, @Nonnull RecordCursorResult<FDBIndexedRecord<Message>> cursorResult) {
        FDBIndexedRecord<Message> indexResult = cursorResult.get();
        FDBStoredRecord<Message> rec = indexResult == null ? null : indexResult.getStoredRecord();
        return this.recordIfInIndexedTypes(rec);
    }

    @Override
    @Nonnull
    CompletableFuture<Void> rebuildIndexInternalAsync(FDBRecordStore store) {
        AtomicReference nextResultCont = new AtomicReference();
        AtomicLong recordScanned = new AtomicLong();
        return AsyncUtil.whileTrue(() -> {
            this.validateSourceAndTargetIndexes(store);
            return this.rebuildRangeOnly(store, (Tuple)nextResultCont.get(), recordScanned).thenApply(cont -> {
                if (cont == null) {
                    return false;
                }
                nextResultCont.set(cont);
                return true;
            });
        }, store.getExecutor());
    }

    @Nonnull
    private CompletableFuture<Tuple> rebuildRangeOnly(@Nonnull FDBRecordStore store, Tuple cont, @Nonnull AtomicLong recordsScanned) {
        this.validateSameMetadataOrThrow(store);
        Index index = this.common.getIndex();
        IndexMaintainer maintainer = store.getIndexMaintainer(index);
        this.validateIdempotenceIfNecessary(store, maintainer);
        Index srcIndex = this.getSourceIndex(store.getRecordMetaData());
        this.validateOrThrowEx(store.isIndexScannable(srcIndex), "source index is not scannable");
        ExecuteProperties.Builder executeProperties = ExecuteProperties.newBuilder().setIsolationLevel(maintainer.isIdempotent() ? IsolationLevel.SNAPSHOT : IsolationLevel.SERIALIZABLE);
        ScanProperties scanProperties = new ScanProperties(executeProperties.build());
        TupleRange tupleRange = TupleRange.between(cont, null);
        RecordCursor cursor = store.scanIndexRecords(srcIndex.getName(), IndexScanType.BY_VALUE, tupleRange, null, scanProperties);
        AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
        AtomicBoolean hasMore = new AtomicBoolean(true);
        return this.iterateRangeOnly(store, cursor, this::getRecordIfTypeMatch, lastResult, hasMore, recordsScanned, maintainer.isIdempotent()).thenApply(vignore -> hasMore.get() ? ((FDBIndexedRecord)((RecordCursorResult)lastResult.get()).get()).getIndexEntry().getKey() : null);
    }

    private void validateSourceAndTargetIndexes(FDBRecordStore store) {
        RecordMetaData metaData = store.getRecordMetaData();
        Index srcIndex = this.getSourceIndex(metaData);
        Collection<RecordType> srcRecordTypes = metaData.recordTypesForIndex(srcIndex);
        this.validateOrThrowEx(this.common.getAllRecordTypes().size() == 1, "target index has multiple types");
        this.validateOrThrowEx(srcRecordTypes.size() == 1, "source index has multiple types");
        this.validateOrThrowEx(srcRecordTypes.stream().noneMatch(RecordType::isSynthetic), "source index is on synthetic record types");
        this.validateOrThrowEx(!srcIndex.getRootExpression().createsDuplicates(), "source index creates duplicates");
        this.validateOrThrowEx("value".equals(srcIndex.getType()), "source index is not a VALUE index");
        this.validateOrThrowEx(this.common.getAllRecordTypes().containsAll(srcRecordTypes), "source index's type is not equal to target index's");
    }

    private void validateIdempotenceIfNecessary(@Nonnull FDBRecordStore store, @Nonnull IndexMaintainer maintainer) {
        if (!store.getFormatVersionEnum().isAtLeast(FormatVersion.CHECK_INDEX_BUILD_TYPE_DURING_UPDATE)) {
            this.validateOrThrowEx(maintainer.isIdempotent(), "target index is not idempotent");
        }
    }
}

