/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexOperationConfig;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexingCommon {
    private final UUID indexerId = UUID.randomUUID();
    @Nonnull
    private final FDBDatabaseRunner runner;
    @Nonnull
    private final FDBRecordStore.Builder recordStoreBuilder;
    @Nonnull
    private final AtomicLong totalRecordsScanned;
    private final boolean trackProgress;
    @Nonnull
    OnlineIndexOperationConfig config;
    @Nullable
    private final Function<OnlineIndexOperationConfig, OnlineIndexOperationConfig> configLoader;
    private int configLoaderInvocationCount = 0;
    @Nonnull
    private Collection<RecordType> allRecordTypes;
    @Nonnull
    private final List<IndexContext> targetIndexContexts;
    public static final int UNLIMITED = Integer.MAX_VALUE;

    IndexingCommon(@Nonnull FDBDatabaseRunner runner, @Nonnull FDBRecordStore.Builder recordStoreBuilder, @Nonnull List<Index> targetIndexes, @Nullable Collection<RecordType> allRecordTypes, @Nullable UnaryOperator<OnlineIndexOperationConfig> configLoader, @Nonnull OnlineIndexOperationConfig config, boolean trackProgress) {
        this.runner = runner;
        this.configLoader = configLoader;
        this.config = config;
        this.trackProgress = trackProgress;
        this.recordStoreBuilder = recordStoreBuilder;
        this.totalRecordsScanned = new AtomicLong(0L);
        this.targetIndexContexts = new ArrayList<IndexContext>(targetIndexes.size());
        this.allRecordTypes = new HashSet<RecordType>();
        this.fillTargetIndexers(targetIndexes, allRecordTypes);
    }

    private void fillTargetIndexers(@Nonnull List<Index> targetIndexes, @Nullable Collection<RecordType> recordTypes) {
        boolean presetTypes = false;
        if (recordTypes != null) {
            if (targetIndexes.size() > 1) {
                throw new IndexingBase.ValidationException("Can't use preset record types with multi target indexing", new Object[0]);
            }
            presetTypes = true;
        }
        if (this.recordStoreBuilder.getMetaDataProvider() == null) {
            throw new MetaDataException("record store builder must include metadata", new Object[0]);
        }
        RecordMetaData metaData = this.recordStoreBuilder.getMetaDataProvider().getRecordMetaData();
        for (Index targetIndex : targetIndexes) {
            Collection<RecordType> types = presetTypes ? recordTypes : metaData.recordTypesForIndex(targetIndex);
            boolean isSynthetic = false;
            if (types.stream().anyMatch(RecordType::isSynthetic)) {
                types = SyntheticRecordPlanner.storedRecordTypesForIndex(metaData, targetIndex, types);
                isSynthetic = true;
            }
            this.targetIndexContexts.add(new IndexContext(targetIndex, types, isSynthetic));
            this.allRecordTypes.addAll(types);
        }
    }

    public UUID getIndexerId() {
        return this.indexerId;
    }

    public List<Object> indexLogMessageKeyValues() {
        return this.indexLogMessageKeyValues(null);
    }

    public List<Object> indexLogMessageKeyValues(@Nullable String transactionName) {
        return this.indexLogMessageKeyValues(transactionName, null);
    }

    public List<Object> indexLogMessageKeyValues(@Nullable String transactionName, @Nullable List<Object> moreKeyValues) {
        ArrayList<Object> keyValues = new ArrayList<Object>();
        this.logIf(transactionName != null, keyValues, new Object[]{LogMessageKeys.TRANSACTION_NAME, transactionName});
        this.logIf(true, keyValues, new Object[]{LogMessageKeys.TARGET_INDEX_NAME, this.getTargetIndexesNames(), LogMessageKeys.RECORDS_SCANNED, this.totalRecordsScanned.get(), LogMessageKeys.INDEXER_ID, this.indexerId});
        SubspaceProvider subspaceProvider = this.getRecordStoreBuilder().getSubspaceProvider();
        if (subspaceProvider != null) {
            keyValues.add((Object)subspaceProvider.logKey());
            keyValues.add(subspaceProvider);
        }
        if (moreKeyValues != null && !moreKeyValues.isEmpty()) {
            keyValues.addAll(moreKeyValues);
        }
        return keyValues;
    }

    private void logIf(boolean condition, List<Object> list, Object ... a) {
        if (condition) {
            list.addAll(Arrays.asList(a));
        }
    }

    @Nonnull
    public FDBDatabaseRunner getRunner() {
        return this.runner;
    }

    @Nonnull
    IndexContext getIndexContext() {
        if (this.isMultiTarget()) {
            throw new IndexingBase.ValidationException("Multi target index exist, but an operation that assumes a single index was called", new Object[0]);
        }
        return this.targetIndexContexts.get(0);
    }

    @Nonnull
    public Index getIndex() {
        return this.getIndexContext().index;
    }

    @Nonnull
    public Index getPrimaryIndex() {
        return this.targetIndexContexts.get((int)0).index;
    }

    @Nonnull
    public Collection<RecordType> getAllRecordTypes() {
        return this.allRecordTypes;
    }

    @Nullable
    public TupleRange computeRecordsRange() {
        Tuple low = null;
        Tuple high = null;
        for (RecordType recordType : this.getAllRecordTypes()) {
            if (!recordType.primaryKeyHasRecordTypePrefix() || recordType.isSynthetic()) {
                return null;
            }
            Tuple prefix = recordType.getRecordTypeKeyTuple();
            if (low == null) {
                low = high = prefix;
                continue;
            }
            if (low.compareTo(prefix) > 0) {
                low = prefix;
                continue;
            }
            if (high.compareTo(prefix) >= 0) continue;
            high = prefix;
        }
        return low == null ? null : TupleRange.betweenInclusive(low, high);
    }

    @Nonnull
    public List<IndexContext> getTargetIndexContexts() {
        return this.targetIndexContexts;
    }

    @Nonnull
    public List<Index> getTargetIndexes() {
        return this.targetIndexContexts.stream().map(targetIndexContext -> targetIndexContext.index).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getTargetIndexesNames() {
        return this.getTargetIndexes().stream().map(Index::getName).collect(Collectors.toList());
    }

    boolean isMultiTarget() {
        return this.targetIndexContexts.size() > 1;
    }

    public boolean isTrackProgress() {
        return this.trackProgress;
    }

    @Nonnull
    public FDBRecordStore.Builder getRecordStoreBuilder() {
        return this.recordStoreBuilder;
    }

    @Nonnull
    public AtomicLong getTotalRecordsScanned() {
        return this.totalRecordsScanned;
    }

    public int getConfigLoaderInvocationCount() {
        return this.configLoaderInvocationCount;
    }

    public boolean loadConfig() {
        if (this.configLoader == null) {
            return false;
        }
        ++this.configLoaderInvocationCount;
        this.config = this.configLoader.apply(this.config);
        return true;
    }

    public void close() {
        this.runner.close();
    }

    public static class IndexContext {
        @Nonnull
        public final Index index;
        @Nonnull
        public final Collection<RecordType> recordTypes;
        public final boolean isSynthetic;

        IndexContext(@Nonnull Index index, @Nonnull Collection<RecordType> recordTypes, boolean isSynthetic) {
            this.index = index;
            this.recordTypes = recordTypes;
            this.isSynthetic = isSynthetic;
        }
    }
}

