/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.SubspaceProvider;
import com.apple.foundationdb.record.util.Result;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class IndexingMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingMerger.class);
    private final Index index;
    private long mergesLimit;
    private int mergeSuccesses = 0;
    private long timeQuotaMillis = 0L;
    private final IndexingCommon common;
    private int repartitionDocumentCount = 0;
    private int repartitionSecondChances = 0;

    public IndexingMerger(Index index, IndexingCommon common, long initialMergesCountLimit) {
        this.index = index;
        this.common = common;
        this.mergesLimit = initialMergesCountLimit;
    }

    private CompletableFuture<FDBRecordStore> openRecordStore(FDBRecordContext context) {
        return this.common.getRecordStoreBuilder().copyBuilder().setContext(context).openAsync();
    }

    CompletableFuture<Void> mergeIndex() {
        AtomicInteger failureCountLimit = new AtomicInteger(1000);
        AtomicReference mergeControlRef = new AtomicReference();
        FDBStoreTimer timer = this.common.getRunner().getTimer();
        AtomicLong mergeStartTime = new AtomicLong();
        return AsyncUtil.whileTrue(() -> ((CompletableFuture)this.common.getRunner().runAsync(context -> ((CompletableFuture)this.openRecordStore((FDBRecordContext)context).thenCompose(store -> {
            mergeStartTime.set(System.nanoTime());
            IndexDeferredMaintenanceControl mergeControl = store.getIndexDeferredMaintenanceControl();
            mergeControlRef.set(mergeControl);
            mergeControl.setMergesLimit(this.mergesLimit);
            mergeControl.setTimeQuotaMillis(this.timeQuotaMillis);
            mergeControl.setRepartitionDocumentCount(this.repartitionDocumentCount);
            mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.NONE);
            mergeControl.setRepartitionCapped(false);
            return store.getIndexMaintainer(this.index).mergeIndex();
        })).thenApply(ignore -> false), Result::of, this.common.indexLogMessageKeyValues()).handle((ignore, e) -> {
            if (timer != null && mergeStartTime.get() > 0L) {
                timer.recordSinceNanoTime(FDBStoreTimer.Events.MERGE_INDEX, mergeStartTime.get());
            }
            mergeStartTime.set(0L);
            IndexDeferredMaintenanceControl mergeControl = (IndexDeferredMaintenanceControl)mergeControlRef.get();
            if (e == null) {
                return this.handleSuccess(mergeControl);
            }
            if (mergeControl == null) {
                throw this.common.getRunner().getDatabase().mapAsyncToSyncException((Throwable)e);
            }
            if (0 > failureCountLimit.decrementAndGet()) {
                this.giveUpMerging(mergeControl, (Throwable)e);
            }
            return this.handleFailure(mergeControl, (Throwable)e);
        })).thenCompose(Function.identity()), this.common.getRunner().getExecutor());
    }

    private CompletableFuture<Boolean> handleSuccess(IndexDeferredMaintenanceControl mergeControl) {
        if (this.mergesLimit > 0L && this.mergeSuccesses > 2) {
            this.mergeSuccesses = 0;
            this.mergesLimit = this.mergesLimit * 5L / 4L;
        }
        ++this.mergeSuccesses;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.mergerLogMessage("IndexMerge: Success", mergeControl));
        }
        this.timeQuotaMillis = 0L;
        if (this.repartitionDocumentCount > 0) {
            this.repartitionDocumentCount = 0;
        }
        boolean hasMore = this.shouldGiveRepartitionSecondChance(mergeControl) || mergeControl.getMergesFound() > mergeControl.getMergesTried();
        return hasMore ? AsyncUtil.READY_TRUE : AsyncUtil.READY_FALSE;
    }

    private CompletableFuture<Boolean> handleFailure(IndexDeferredMaintenanceControl mergeControl, Throwable e) {
        mergeControl.mergeHadFailed();
        FDBException ex = IndexingBase.findException(e, FDBException.class);
        IndexDeferredMaintenanceControl.LastStep lastStep = mergeControl.getLastStep();
        if (!IndexingBase.shouldLessenWork(ex)) {
            this.giveUpMerging(mergeControl, e);
        }
        switch (lastStep) {
            case REPARTITION: {
                this.handleRepartitioningFailure(mergeControl, e);
                break;
            }
            case MERGE: {
                if (mergeControl.getMergesTried() < 2L) {
                    this.handleSingleMergeFailure(mergeControl, e);
                    break;
                }
                this.handleMultiMergeFailure(mergeControl, e);
                break;
            }
            default: {
                this.giveUpMerging(mergeControl, e);
            }
        }
        return AsyncUtil.READY_TRUE;
    }

    private void handleRepartitioningFailure(IndexDeferredMaintenanceControl mergeControl, Throwable e) {
        this.repartitionDocumentCount = mergeControl.getRepartitionDocumentCount();
        if (this.repartitionDocumentCount == -1) {
            this.giveUpMerging(mergeControl, e);
        }
        this.repartitionDocumentCount /= 2;
        if (this.repartitionDocumentCount == 0) {
            this.repartitionDocumentCount = -1;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.mergerLogMessage("IndexMerge: Repartitioning failure", mergeControl), e);
        }
    }

    private boolean shouldGiveRepartitionSecondChance(IndexDeferredMaintenanceControl mergeControl) {
        if (this.repartitionDocumentCount == -1 && this.repartitionSecondChances == 0) {
            ++this.repartitionSecondChances;
            this.repartitionDocumentCount = 0;
            return true;
        }
        if (mergeControl.repartitionCapped()) {
            mergeControl.setRepartitionCapped(false);
            this.repartitionDocumentCount = 0;
            return true;
        }
        this.repartitionSecondChances = 0;
        return false;
    }

    private void handleMultiMergeFailure(IndexDeferredMaintenanceControl mergeControl, Throwable e) {
        this.mergesLimit = mergeControl.getMergesTried() / 2L;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.mergerLogMessage("IndexMerge: Merges diluted", mergeControl), e);
        }
    }

    private void handleSingleMergeFailure(IndexDeferredMaintenanceControl mergeControl, Throwable e) {
        this.timeQuotaMillis = mergeControl.getTimeQuotaMillis();
        if (this.timeQuotaMillis <= 2L) {
            this.giveUpMerging(mergeControl, e);
        }
        this.timeQuotaMillis /= 2L;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.mergerLogMessage("IndexMerge: Decrease time quota", mergeControl), e);
        }
    }

    private void giveUpMerging(IndexDeferredMaintenanceControl mergeControl, Throwable e) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(this.mergerLogMessage("IndexMerge: Gave up merge", mergeControl), e);
        }
        throw this.common.getRunner().getDatabase().mapAsyncToSyncException(e);
    }

    List<Object> mergerKeysAndValues(IndexDeferredMaintenanceControl mergeControl) {
        return List.of(new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName(), LogMessageKeys.INDEX_MERGES_LAST_LIMIT, mergeControl.getMergesLimit(), LogMessageKeys.INDEX_MERGES_LAST_FOUND, mergeControl.getMergesFound(), LogMessageKeys.INDEX_MERGES_LAST_TRIED, mergeControl.getMergesTried(), LogMessageKeys.INDEX_MERGES_NUM_COMPLETED, mergeControl.getTotalMerges(), LogMessageKeys.INDEX_MERGES_CONTEXT_TIME_QUOTA, mergeControl.getTimeQuotaMillis(), LogMessageKeys.INDEX_REPARTITION_DOCUMENT_COUNT, mergeControl.getRepartitionDocumentCount(), LogMessageKeys.INDEX_DEFERRED_ACTION_STEP, mergeControl.getLastStep()});
    }

    String mergerLogMessage(String ttl, IndexDeferredMaintenanceControl mergeControl) {
        KeyValueLogMessage msg = KeyValueLogMessage.build(ttl, new Object[0]);
        msg.addKeysAndValues(this.mergerKeysAndValues(mergeControl));
        SubspaceProvider subspaceProvider = this.common.getRecordStoreBuilder().getSubspaceProvider();
        if (subspaceProvider != null) {
            msg.addKeyAndValue((Object)subspaceProvider.logKey(), subspaceProvider);
        }
        return msg.toString();
    }
}

