/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexingMultiTargetByRecords
extends IndexingBase {
    private IndexBuildProto.IndexBuildIndexingStamp myIndexingTypeStamp = null;

    IndexingMultiTargetByRecords(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy) {
        super(common, policy);
    }

    @Override
    @Nonnull
    IndexBuildProto.IndexBuildIndexingStamp getIndexingTypeStamp(FDBRecordStore store) {
        if (this.myIndexingTypeStamp == null) {
            this.myIndexingTypeStamp = IndexingMultiTargetByRecords.compileIndexingTypeStamp(this.common.getTargetIndexesNames());
        }
        return this.myIndexingTypeStamp;
    }

    @Nonnull
    private static IndexBuildProto.IndexBuildIndexingStamp compileIndexingTypeStamp(List<String> targetIndexes) {
        if (targetIndexes.isEmpty()) {
            throw new IndexingBase.ValidationException("No target index was set", new Object[0]);
        }
        if (targetIndexes.size() == 1) {
            return IndexingMultiTargetByRecords.compileSingleTargetLegacyIndexingTypeStamp();
        }
        return IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.MULTI_TARGET_BY_RECORDS).addAllTargetIndex(targetIndexes).build();
    }

    @Nonnull
    protected static IndexBuildProto.IndexBuildIndexingStamp compileSingleTargetLegacyIndexingTypeStamp() {
        return IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.BY_RECORDS).build();
    }

    private static boolean areTheyAllIdempotent(@Nonnull FDBRecordStore store, List<Index> targetIndexes) {
        return targetIndexes.stream().allMatch(targetIndex -> store.getIndexMaintainer((Index)targetIndex).isIdempotent());
    }

    @Override
    List<Object> indexingLogMessageKeyValues() {
        return Arrays.asList(new Object[]{LogMessageKeys.INDEXING_METHOD, "multi target by records", LogMessageKeys.TARGET_INDEX_NAME, this.common.getTargetIndexesNames()});
    }

    @Override
    @Nonnull
    CompletableFuture<Void> buildIndexInternalAsync() {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> context.getReadVersionAsync().thenCompose(ignore -> this.buildMultiTargetIndex())), this.common.indexLogMessageKeyValues("IndexingMultiTargetByRecords::buildIndexInternalAsync"));
    }

    @Nonnull
    private CompletableFuture<Void> buildMultiTargetIndex() {
        byte[] rangeStart;
        byte[] rangeEnd;
        TupleRange tupleRange = this.common.computeRecordsRange();
        if (tupleRange == null) {
            rangeEnd = null;
            rangeStart = null;
        } else {
            Range range = tupleRange.toRange();
            rangeStart = range.begin;
            rangeEnd = ByteArrayUtil.strinc(range.end);
        }
        CompletableFuture<Object> maybePresetRangeFuture = rangeStart == null ? CompletableFuture.completedFuture(null) : this.buildCommitRetryAsync((store, recordsScanned) -> {
            List<Index> targetIndexes = this.common.getTargetIndexes();
            List<IndexingRangeSet> targetRangeSets = targetIndexes.stream().map(targetIndex -> IndexingRangeSet.forIndexBuild(store, targetIndex)).collect(Collectors.toList());
            return CompletableFuture.allOf(IndexingMultiTargetByRecords.insertRanges(targetRangeSets, null, rangeStart), IndexingMultiTargetByRecords.insertRanges(targetRangeSets, rangeEnd, null)).thenApply(ignore -> null);
        }, null);
        List<Object> additionalLogMessageKeyValues = Arrays.asList(new Object[]{LogMessageKeys.CALLING_METHOD, "buildMultiTargetIndex", LogMessageKeys.RANGE_START, rangeStart, LogMessageKeys.RANGE_END, rangeEnd});
        return maybePresetRangeFuture.thenCompose(ignore -> this.iterateAllRanges(additionalLogMessageKeyValues, this::buildRangeOnly));
    }

    @Nonnull
    private CompletableFuture<Boolean> buildRangeOnly(@Nonnull FDBRecordStore store, @Nonnull AtomicLong recordsScanned) {
        this.validateSameMetadataOrThrow(store);
        List<Index> targetIndexes = this.common.getTargetIndexes();
        boolean isIdempotent = IndexingMultiTargetByRecords.areTheyAllIdempotent(store, targetIndexes);
        ScanProperties scanProperties = this.scanPropertiesWithLimits(isIdempotent);
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, this.common.getPrimaryIndex());
        return rangeSet.firstMissingRangeAsync().thenCompose(range -> {
            if (range == null) {
                return AsyncUtil.READY_FALSE;
            }
            Tuple rangeStart = RangeSet.isFirstKey(range.begin) ? null : Tuple.fromBytes(range.begin);
            Tuple rangeEnd = RangeSet.isFinalKey(range.end) ? null : Tuple.fromBytes(range.end);
            TupleRange tupleRange = TupleRange.between(rangeStart, rangeEnd);
            RecordCursor cursor = store.scanRecords(tupleRange, null, scanProperties);
            AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
            AtomicBoolean hasMore = new AtomicBoolean(true);
            List targetRangeSets = targetIndexes.stream().map(targetIndex -> IndexingRangeSet.forIndexBuild(store, targetIndex)).collect(Collectors.toList());
            return this.iterateRangeOnly(store, cursor, this::getRecordIfTypeMatch, lastResult, hasMore, recordsScanned, isIdempotent).thenCompose(ignore -> this.postIterateRangeOnly(targetRangeSets, hasMore.get(), lastResult, rangeStart, rangeEnd, scanProperties.isReverse()));
        });
    }

    private CompletableFuture<Boolean> postIterateRangeOnly(List<IndexingRangeSet> targetRangeSets, boolean hasMore, AtomicReference<RecordCursorResult<FDBStoredRecord<Message>>> lastResult, Tuple rangeStart, Tuple rangeEnd, boolean isReverse) {
        if (isReverse) {
            Tuple continuation = hasMore ? lastResult.get().get().getPrimaryKey() : rangeStart;
            return IndexingMultiTargetByRecords.insertRanges(targetRangeSets, IndexingMultiTargetByRecords.packOrNull(continuation), IndexingMultiTargetByRecords.packOrNull(rangeEnd)).thenApply(ignore -> hasMore || rangeStart != null);
        }
        Tuple continuation = hasMore ? lastResult.get().get().getPrimaryKey() : rangeEnd;
        return IndexingMultiTargetByRecords.insertRanges(targetRangeSets, IndexingMultiTargetByRecords.packOrNull(rangeStart), IndexingMultiTargetByRecords.packOrNull(continuation)).thenApply(ignore -> hasMore || rangeEnd != null);
    }

    private static CompletableFuture<Void> insertRanges(List<IndexingRangeSet> rangeSets, byte[] start, byte[] end) {
        return AsyncUtil.whenAll(rangeSets.stream().map(set -> set.insertRangeAsync(start, end, true)).collect(Collectors.toList()));
    }

    private CompletableFuture<FDBStoredRecord<Message>> getRecordIfTypeMatch(FDBRecordStore store, @Nonnull RecordCursorResult<FDBStoredRecord<Message>> cursorResult) {
        FDBStoredRecord<Message> rec = cursorResult.get();
        return this.recordIfInIndexedTypes(rec);
    }

    @Override
    @Nonnull
    CompletableFuture<Void> rebuildIndexInternalAsync(FDBRecordStore store) {
        TupleRange tupleRange = this.common.computeRecordsRange();
        Tuple rangeStart = tupleRange == null ? null : tupleRange.getLow();
        Tuple rangeEndInclusive = tupleRange == null ? null : tupleRange.getHigh();
        AtomicReference<Tuple> nextResultCont = new AtomicReference<Tuple>(rangeStart);
        AtomicLong recordScanned = new AtomicLong();
        return AsyncUtil.whileTrue(() -> this.rebuildRangeOnly(store, (Tuple)nextResultCont.get(), recordScanned, rangeEndInclusive).thenApply(cont -> {
            if (cont == null) {
                return false;
            }
            nextResultCont.set((Tuple)cont);
            return true;
        }), store.getExecutor());
    }

    @Nonnull
    private CompletableFuture<Tuple> rebuildRangeOnly(@Nonnull FDBRecordStore store, Tuple cont, @Nonnull AtomicLong recordsScanned, @Nullable Tuple rangeEndInclusive) {
        this.validateSameMetadataOrThrow(store);
        boolean isIdempotent = IndexingMultiTargetByRecords.areTheyAllIdempotent(store, this.common.getTargetIndexes());
        IsolationLevel isolationLevel = isIdempotent ? IsolationLevel.SNAPSHOT : IsolationLevel.SERIALIZABLE;
        ExecuteProperties.Builder executeProperties = ExecuteProperties.newBuilder().setIsolationLevel(isolationLevel);
        ScanProperties scanProperties = new ScanProperties(executeProperties.build());
        TupleRange tupleRange = TupleRange.betweenInclusive(cont, rangeEndInclusive);
        RecordCursor cursor = store.scanRecords(tupleRange, null, scanProperties);
        AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
        AtomicBoolean hasMore = new AtomicBoolean(true);
        return this.iterateRangeOnly(store, cursor, this::getRecordIfTypeMatch, lastResult, hasMore, recordsScanned, isIdempotent).thenApply(vignore -> hasMore.get() ? ((FDBStoredRecord)((RecordCursorResult)lastResult.get()).get()).getPrimaryKey() : null);
    }
}

