/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.RangeSet;
import com.apple.foundationdb.record.IndexBuildProto;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexingBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexingCommon;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexing.IndexingRangeSet;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.IntMath;
import com.google.protobuf.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingMutuallyByRecords
extends IndexingBase {
    private IndexBuildProto.IndexBuildIndexingStamp myIndexingTypeStamp = null;
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingMutuallyByRecords.class);
    private List<Tuple> fragmentBoundaries;
    private int fragmentNum;
    private int fragmentStep;
    private int fragmentFirst;
    private int fragmentCurrent;
    private FragmentIterationType fragmentIterationType;
    private int loopProtectionCounter = 0;
    private String loopProtectionToken = "";
    private FDBException anyJumperEx = null;
    private int anyJumperCurrent;
    private Range anyJumperRange;

    public IndexingMutuallyByRecords(@Nonnull IndexingCommon common, @Nonnull OnlineIndexer.IndexingPolicy policy, @Nullable List<Tuple> fragmentBoundaries) {
        super(common, policy);
        this.fragmentBoundaries = fragmentBoundaries;
        this.validateOrThrowEx(!policy.isReverseScanOrder(), "Mutual indexing does not support reverse scan order");
    }

    @Override
    @Nonnull
    IndexBuildProto.IndexBuildIndexingStamp getIndexingTypeStamp(FDBRecordStore store) {
        if (this.myIndexingTypeStamp == null) {
            this.myIndexingTypeStamp = IndexingMutuallyByRecords.compileIndexingTypeStamp(this.common.getTargetIndexesNames());
        }
        return this.myIndexingTypeStamp;
    }

    @Nonnull
    private static IndexBuildProto.IndexBuildIndexingStamp compileIndexingTypeStamp(List<String> targetIndexes) {
        if (targetIndexes.isEmpty()) {
            throw new IndexingBase.ValidationException("No target index was set", new Object[0]);
        }
        return IndexBuildProto.IndexBuildIndexingStamp.newBuilder().setMethod(IndexBuildProto.IndexBuildIndexingStamp.Method.MUTUAL_BY_RECORDS).addAllTargetIndex(targetIndexes).build();
    }

    private static boolean areTheyAllIdempotent(@Nonnull FDBRecordStore store, List<Index> targetIndexes) {
        return targetIndexes.stream().allMatch(targetIndex -> store.getIndexMaintainer((Index)targetIndex).isIdempotent());
    }

    @Override
    List<Object> indexingLogMessageKeyValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(new Object[]{LogMessageKeys.INDEXING_METHOD, "mutual multi target by records", LogMessageKeys.TARGET_INDEX_NAME, this.common.getTargetIndexesNames()}));
        list.addAll(this.fragmentLogMessageKeyValues());
        return list;
    }

    private List<Tuple> getPrimaryKeyBoundaries(@Nonnull FDBRecordStore store) {
        List<Tuple> boundaries;
        TupleRange tupleRange = this.common.computeRecordsRange();
        store.getContext().getReadVersion();
        try (RecordCursor<Tuple> cursor = store.getPrimaryKeyBoundaries(tupleRange);){
            boundaries = cursor.asList().join();
        }
        if (boundaries == null) {
            boundaries = new ArrayList<Tuple>();
        }
        if (tupleRange == null) {
            boundaries.add(0, null);
            boundaries.add(null);
        } else {
            if (boundaries.isEmpty() || tupleRange.getLow() == null || tupleRange.getLow().compareTo(boundaries.get(0)) < 0) {
                boundaries.add(0, tupleRange.getLow());
            }
            if (tupleRange.getHigh() == null || tupleRange.getHigh().compareTo(boundaries.get(boundaries.size() - 1)) > 0) {
                boundaries.add(tupleRange.getHigh());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of("got boundaries", new Object[]{LogMessageKeys.INDEX_NAME, this.common.getTargetIndexesNames(), LogMessageKeys.RANGE, tupleRange, LogMessageKeys.KEY_COUNT, boundaries.size()}));
        }
        return boundaries;
    }

    private int getPrimeStep(int size, Random rn) {
        this.validateOrThrowEx(size > 0, "No ranges to build");
        if (size < 3) {
            return 1;
        }
        for (int attempts = 0; attempts < 800; ++attempts) {
            int step = rn.nextInt(size);
            if ((step & 1) == 0) {
                --step;
            }
            if (step < 2) {
                return 1;
            }
            if (size % step == 0 || !IntMath.isPrime(step)) continue;
            return step;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(KeyValueLogMessage.of("too many attempts to generate random prime. Using step 1", new Object[]{LogMessageKeys.TARGET_INDEX_NAME, this.common.getTargetIndexesNames()}));
        }
        return 1;
    }

    private void setFragmentationData(@Nonnull FDBRecordStore store) {
        if (this.fragmentBoundaries == null || this.fragmentBoundaries.isEmpty()) {
            this.fragmentBoundaries = this.getPrimaryKeyBoundaries(store);
        }
        ThreadLocalRandom rn = ThreadLocalRandom.current();
        this.fragmentNum = this.fragmentBoundaries.size() - 1;
        this.fragmentStep = this.getPrimeStep(this.fragmentNum, rn);
        this.fragmentCurrent = this.fragmentFirst = ((Random)rn).nextInt(this.fragmentNum);
        this.fragmentIterationType = FragmentIterationType.FULL;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.build("fragmentation init values", new Object[0]).addKeysAndValues(this.fragmentLogMessageKeyValues()).toString());
        }
    }

    private List<Object> fragmentLogMessageKeyValues() {
        return new ArrayList<Object>(Arrays.asList(new Serializable[]{LogMessageKeys.INDEXING_FRAGMENTATION_COUNT, Integer.valueOf(this.fragmentNum), LogMessageKeys.INDEXING_FRAGMENTATION_STEP, Integer.valueOf(this.fragmentStep), LogMessageKeys.INDEXING_FRAGMENTATION_FIRST, Integer.valueOf(this.fragmentFirst), LogMessageKeys.INDEXING_FRAGMENTATION_CURRENT, Integer.valueOf(this.fragmentCurrent), LogMessageKeys.INDEXING_FRAGMENTATION_TYPE, this.fragmentIterationType}));
    }

    private Range fragmentGet() {
        byte[] byArray;
        byte[] lowBytes;
        byte[] byArray2;
        int i = this.getFragmentCurrent();
        Tuple low = this.fragmentBoundaries.get(i);
        Tuple high = this.fragmentBoundaries.get(i + 1);
        if (low == null) {
            byte[] byArray3 = new byte[1];
            byArray2 = byArray3;
            byArray3[0] = 0;
        } else {
            byArray2 = lowBytes = low.pack();
        }
        if (high == null) {
            byte[] byArray4 = new byte[1];
            byArray = byArray4;
            byArray4[0] = -1;
        } else {
            byArray = high.pack();
        }
        byte[] highBytes = byArray;
        return new Range(lowBytes, highBytes);
    }

    private int getFragmentCurrent() {
        return this.fragmentCurrent;
    }

    private void fragmentPlusPlus() {
        this.fragmentCurrent += this.fragmentStep;
        this.fragmentCurrent %= this.fragmentNum;
        if (this.getFragmentCurrent() == this.fragmentFirst) {
            this.fragmentIterationTypePlusPlus();
        }
    }

    private void fragmentIterationTypePlusPlus() {
        if (this.fragmentIterationType == FragmentIterationType.ANY) {
            this.fragmentIterationType = FragmentIterationType.RECOVER;
        }
        if (this.fragmentIterationType == FragmentIterationType.FULL) {
            this.fragmentIterationType = FragmentIterationType.ANY;
        }
    }

    @Override
    @Nonnull
    CompletableFuture<Void> buildIndexInternalAsync() {
        return this.getRunner().runAsync(context -> this.openRecordStore((FDBRecordContext)context).thenCompose(store -> context.getReadVersionAsync().thenCompose(ignore -> {
            this.setFragmentationData((FDBRecordStore)store);
            return this.buildMultiTargetIndex();
        })), this.common.indexLogMessageKeyValues("IndexingMutuallyByRecords::buildIndexInternalAsync", this.fragmentLogMessageKeyValues()));
    }

    @Nonnull
    private CompletableFuture<Void> buildMultiTargetIndex() {
        byte[] rangeStart;
        byte[] rangeEnd;
        TupleRange tupleRange = this.common.computeRecordsRange();
        if (tupleRange == null) {
            rangeEnd = null;
            rangeStart = null;
        } else {
            Range range = tupleRange.toRange();
            rangeStart = range.begin;
            rangeEnd = range.end;
        }
        CompletableFuture<Object> maybePresetRangeFuture = rangeStart == null ? CompletableFuture.completedFuture(null) : this.buildCommitRetryAsync((store, recordsScanned) -> {
            List<Index> targetIndexes = this.common.getTargetIndexes();
            List<IndexingRangeSet> targetRangeSets = targetIndexes.stream().map(targetIndex -> IndexingRangeSet.forIndexBuild(store, targetIndex)).collect(Collectors.toList());
            return CompletableFuture.allOf(IndexingMutuallyByRecords.insertRanges(targetRangeSets, null, rangeStart), IndexingMutuallyByRecords.insertRanges(targetRangeSets, rangeEnd, null)).thenApply(ignore -> null);
        }, null);
        List<Object> additionalLogMessageKeyValues = Arrays.asList(new Object[]{LogMessageKeys.CALLING_METHOD, "mutualMultiTargetIndex-wrapper", LogMessageKeys.RANGE_START, rangeStart, LogMessageKeys.RANGE_END, rangeEnd});
        return maybePresetRangeFuture.thenCompose(ignore -> this.iterateAllRanges(additionalLogMessageKeyValues, (store, recordsScanned) -> this.buildRangeOnly((FDBRecordStore)store)));
    }

    @Nonnull
    private CompletableFuture<Boolean> buildRangeOnly(@Nonnull FDBRecordStore store) {
        if (this.fragmentIterationType == FragmentIterationType.RECOVER) {
            throw new IndexingBase.ValidationException("Mutual indexing failure - third iteration", new Object[0]);
        }
        this.validateSameMetadataOrThrow(store);
        IndexingRangeSet rangeSet = IndexingRangeSet.forIndexBuild(store, this.common.getPrimaryIndex());
        return rangeSet.listMissingRangesAsync().thenCompose(missingRanges -> this.buildNextRangeOnly(IndexingMutuallyByRecords.sortAndSquash(missingRanges)));
    }

    private CompletableFuture<Boolean> buildNextRangeOnly(List<Range> missingRanges) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of("buildNextRangeOnly", new Object[]{LogMessageKeys.MISSING_RANGES, missingRanges}));
        }
        if (missingRanges.isEmpty()) {
            return AsyncUtil.READY_FALSE;
        }
        while (true) {
            Range rangeToBuild;
            Range fragmentRange = this.fragmentGet();
            if (this.fragmentIterationType == FragmentIterationType.RECOVER) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(KeyValueLogMessage.of("Entering recovery mode", new Object[]{LogMessageKeys.SPLIT_RANGES, missingRanges}));
                }
                return AsyncUtil.READY_TRUE;
            }
            boolean isFull = this.fragmentIterationType == FragmentIterationType.FULL;
            Range range = rangeToBuild = isFull ? IndexingMutuallyByRecords.fullyUnBuiltRange(missingRanges, fragmentRange) : IndexingMutuallyByRecords.partlyUnBuiltRange(missingRanges, fragmentRange);
            if (this.anyJumperSaysBuild(rangeToBuild)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(KeyValueLogMessage.build("fragment/range to build", new Object[]{LogMessageKeys.SCAN_TYPE, this.fragmentIterationType, LogMessageKeys.RANGE, rangeToBuild, LogMessageKeys.ORIGINAL_RANGE, fragmentRange}).addKeysAndValues(this.fragmentLogMessageKeyValues()).toString());
                }
                this.timerIncrement(isFull ? FDBStoreTimer.Counts.MUTUAL_INDEXER_FULL_START : FDBStoreTimer.Counts.MUTUAL_INDEXER_ANY_START);
                this.infiniteLoopProtection(rangeToBuild, missingRanges);
                ArrayList<Object> additionalLogMessageKeyValues = new ArrayList<Object>(Arrays.asList(new Object[]{LogMessageKeys.CALLING_METHOD, "mutualMultiTargetIndex", LogMessageKeys.RANGE, rangeToBuild, LogMessageKeys.ORIGINAL_RANGE, fragmentRange}));
                additionalLogMessageKeyValues.addAll(this.fragmentLogMessageKeyValues());
                return this.iterateAllRanges(additionalLogMessageKeyValues, (store, recordsScanned) -> this.buildThisRangeOnly((FDBRecordStore)store, (AtomicLong)recordsScanned, rangeToBuild), this.anyJumperCallback(rangeToBuild)).thenCompose(ignore -> AsyncUtil.READY_TRUE);
            }
            if (this.anyJumperEx != null) continue;
            this.timerIncrement(isFull ? FDBStoreTimer.Counts.MUTUAL_INDEXER_FULL_DONE : FDBStoreTimer.Counts.MUTUAL_INDEXER_ANY_DONE);
            this.fragmentPlusPlus();
        }
    }

    private CompletableFuture<Boolean> buildThisRangeOnly(@Nonnull FDBRecordStore store, @Nonnull AtomicLong recordsScanned, Range thisRange) {
        List<Index> targetIndexes = this.common.getTargetIndexes();
        List targetRangeSets = targetIndexes.stream().map(targetIndex -> IndexingRangeSet.forIndexBuild(store, targetIndex)).collect(Collectors.toList());
        boolean isIdempotent = IndexingMutuallyByRecords.areTheyAllIdempotent(store, targetIndexes);
        ScanProperties scanProperties = this.scanPropertiesWithLimits(isIdempotent);
        return ((IndexingRangeSet)targetRangeSets.get(0)).firstMissingRangeAsync(thisRange.begin, thisRange.end).thenCompose(range -> {
            if (range == null) {
                return AsyncUtil.READY_FALSE;
            }
            Tuple rangeStart = RangeSet.isFirstKey(range.begin) ? null : Tuple.fromBytes(range.begin);
            Tuple rangeEnd = RangeSet.isFinalKey(range.end) ? null : Tuple.fromBytes(range.end);
            TupleRange tupleRange = TupleRange.between(rangeStart, rangeEnd);
            RecordCursor cursor = store.scanRecords(tupleRange, null, scanProperties);
            AtomicReference lastResult = new AtomicReference(RecordCursorResult.exhausted());
            AtomicBoolean hasMore = new AtomicBoolean(true);
            return ((CompletableFuture)this.iterateRangeOnly(store, cursor, this::getRecordIfTypeMatch, lastResult, hasMore, recordsScanned, isIdempotent).thenApply(vignore -> hasMore.get() ? ((FDBStoredRecord)((RecordCursorResult)lastResult.get()).get()).getPrimaryKey() : rangeEnd)).thenCompose(cont -> IndexingMutuallyByRecords.insertRanges(targetRangeSets, IndexingMutuallyByRecords.packOrNull(rangeStart), IndexingMutuallyByRecords.packOrNull(cont)).thenApply(ignore -> IndexingMutuallyByRecords.notAllRangesExhausted(cont, rangeEnd)));
        });
    }

    @Nullable
    @VisibleForTesting
    static Range fullyUnBuiltRange(List<Range> missingRanges, Range fragmentRange) {
        for (Range range : missingRanges) {
            if (ByteArrayUtil.compareUnsigned(range.end, fragmentRange.end) < 0) continue;
            if (ByteArrayUtil.compareUnsigned(range.begin, fragmentRange.begin) > 0) break;
            return IndexingMutuallyByRecords.notEmptyRange(fragmentRange);
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    static Range partlyUnBuiltRange(List<Range> missingRanges, Range fragmentRange) {
        for (Range range : missingRanges) {
            byte[] end;
            byte[] begin;
            if (ByteArrayUtil.compareUnsigned(range.begin, fragmentRange.end) > 0 || ByteArrayUtil.compareUnsigned(range.end, fragmentRange.begin) < 0 || ByteArrayUtil.compareUnsigned(begin = ByteArrayUtil.compareUnsigned(range.begin, fragmentRange.begin) >= 0 ? range.begin : fragmentRange.begin, end = ByteArrayUtil.compareUnsigned(range.end, fragmentRange.end) <= 0 ? range.end : fragmentRange.end) >= 0) continue;
            return IndexingMutuallyByRecords.notEmptyRange(new Range(begin, end));
        }
        return null;
    }

    @Nullable
    private static Range notEmptyRange(Range range) {
        return ByteArrayUtil.compareUnsigned(range.begin, range.end) >= 0 ? null : range;
    }

    @VisibleForTesting
    static List<Range> sortAndSquash(List<Range> ranges) {
        ranges.sort((a, b) -> ByteArrayUtil.compareUnsigned(a.begin, b.begin));
        boolean squasshed = false;
        for (int i = 0; i < ranges.size() - 1; ++i) {
            if (ByteArrayUtil.compareUnsigned(ranges.get((int)i).end, ranges.get((int)(i + 1)).begin) < 0) continue;
            squasshed = true;
            ranges.set(i + 1, new Range(ranges.get((int)i).begin, ByteArrayUtil.compareUnsigned(ranges.get((int)i).end, ranges.get((int)(i + 1)).end) >= 0 ? ranges.get((int)i).end : ranges.get((int)(i + 1)).end));
            ranges.set(i, null);
        }
        return squasshed ? ranges.stream().filter(Objects::nonNull).collect(Collectors.toList()) : ranges;
    }

    private static CompletableFuture<Void> insertRanges(List<IndexingRangeSet> rangeSets, byte[] start, byte[] end) {
        return AsyncUtil.whenAll(rangeSets.stream().map(set -> set.insertRangeAsync(start, end, true)).collect(Collectors.toList()));
    }

    private void infiniteLoopProtection(Range range, List<Range> missingRanges) {
        String token = range.toString();
        if (token.equals(this.loopProtectionToken)) {
            ++this.loopProtectionCounter;
            if (this.loopProtectionCounter > 1000) {
                throw new IndexingBase.ValidationException("Potential infinite loop", new Object[]{LogMessageKeys.RANGE, token, LogMessageKeys.MISSING_RANGES, missingRanges});
            }
        } else {
            this.loopProtectionCounter = 0;
            this.loopProtectionToken = token;
        }
    }

    boolean anyJumperSaysBuild(@Nullable Range rangeToBuild) {
        if (rangeToBuild == null) {
            this.anyJumperEx = null;
            return false;
        }
        if (this.anyJumperEx == null) {
            return true;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.build("anyJumper: check if should jump", new Object[]{"anyJumperRange", this.anyJumperRange, "anyJumperCurrent", this.anyJumperCurrent, "anyJumperEx", this.anyJumperEx, LogMessageKeys.RANGE, rangeToBuild}).addKeysAndValues(this.fragmentLogMessageKeyValues()).toString());
        }
        if (this.anyJumperCurrent != this.fragmentCurrent) {
            this.anyJumperEx = null;
            return true;
        }
        if (this.anyJumperRange.equals(rangeToBuild)) {
            throw this.anyJumperEx;
        }
        this.timerIncrement(FDBStoreTimer.Counts.MUTUAL_INDEXER_ANY_JUMP);
        this.anyJumperEx = null;
        return false;
    }

    private Function<FDBException, Optional<Boolean>> anyJumperCallback(Range rangeToBuild) {
        return ex -> {
            if (ex == null || this.anyJumperEx != null) {
                this.anyJumperEx = null;
                return Optional.empty();
            }
            this.anyJumperEx = ex;
            this.anyJumperRange = rangeToBuild;
            this.anyJumperCurrent = this.fragmentCurrent;
            return Optional.of(false);
        };
    }

    private CompletableFuture<FDBStoredRecord<Message>> getRecordIfTypeMatch(FDBRecordStore store, @Nonnull RecordCursorResult<FDBStoredRecord<Message>> cursorResult) {
        FDBStoredRecord<Message> rec = cursorResult.get();
        return this.recordIfInIndexedTypes(rec);
    }

    @Override
    @Nonnull
    CompletableFuture<Void> rebuildIndexInternalAsync(FDBRecordStore store) {
        throw new IndexingBase.ValidationException("Mutual inline rebuild doesn't make any sense", new Object[0]);
    }

    static enum FragmentIterationType {
        FULL,
        ANY,
        RECOVER;

    }
}

