/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.UUID;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public final class IndexingSubspaces {
    private static final Object INDEX_BUILD_LOCK_KEY = 0L;
    private static final Object INDEX_BUILD_SCANNED_RECORDS = 1L;
    private static final Object INDEX_BUILD_TYPE_VERSION = 2L;
    private static final Object INDEX_SCRUBBED_INDEX_RANGES_ZERO = 3L;
    private static final Object INDEX_SCRUBBED_RECORDS_RANGES_ZERO = 4L;
    private static final Object INDEX_SCRUBBED_RECORDS_RANGES = 5L;
    private static final Object INDEX_SCRUBBED_INDEX_RANGES = 6L;
    private static final Object INDEX_BUILD_HEARTBEAT_PREFIX = 7L;

    private IndexingSubspaces() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    private static Subspace indexBuildSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, Object key) {
        return store.getUntypedRecordStore().indexBuildSubspace(index).subspace(Tuple.from(key));
    }

    @Nonnull
    public static Subspace indexBuildLockSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_BUILD_LOCK_KEY);
    }

    @Nonnull
    public static Subspace indexBuildScannedRecordsSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_BUILD_SCANNED_RECORDS);
    }

    @Nonnull
    public static Subspace indexBuildTypeSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_BUILD_TYPE_VERSION);
    }

    @Nonnull
    public static Subspace indexHeartbeatSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_BUILD_HEARTBEAT_PREFIX);
    }

    @Nonnull
    public static byte[] indexHeartbeatSubspaceBytes(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull UUID indexerId) {
        return IndexingSubspaces.indexHeartbeatSubspace(store, index).subspace(Tuple.from(indexerId)).pack();
    }

    @Nonnull
    private static Subspace indexScrubRecordsRangeSubspaceZero(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_SCRUBBED_RECORDS_RANGES_ZERO);
    }

    @Nonnull
    private static Subspace indexScrubRecordsRangeSubspaceRoot(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_SCRUBBED_RECORDS_RANGES);
    }

    @Nonnull
    public static Subspace indexScrubRecordsRangeSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, int rangeId) {
        return rangeId == 0 ? IndexingSubspaces.indexScrubRecordsRangeSubspaceZero(store, index) : IndexingSubspaces.indexScrubRecordsRangeSubspaceRoot(store, index).subspace(Tuple.from(rangeId));
    }

    @Nonnull
    private static Subspace indexScrubIndexRangeSubspaceZero(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_SCRUBBED_INDEX_RANGES_ZERO);
    }

    @Nonnull
    private static Subspace indexScrubIndexRangeSubspaceRoot(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index) {
        return IndexingSubspaces.indexBuildSubspace(store, index, INDEX_SCRUBBED_INDEX_RANGES);
    }

    @Nonnull
    public static Subspace indexScrubIndexRangeSubspace(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, int rangeId) {
        return rangeId == 0 ? IndexingSubspaces.indexScrubIndexRangeSubspaceZero(store, index) : IndexingSubspaces.indexScrubIndexRangeSubspaceRoot(store, index).subspace(Tuple.from(rangeId));
    }

    public static void eraseAllIndexingScrubbingData(@Nonnull FDBRecordContext context, @Nonnull FDBRecordStore store, @Nonnull Index index) {
        context.clear(Range.startsWith(IndexingSubspaces.indexScrubIndexRangeSubspaceZero(store, index).pack()));
        context.clear(Range.startsWith(IndexingSubspaces.indexScrubIndexRangeSubspaceRoot(store, index).pack()));
        context.clear(Range.startsWith(IndexingSubspaces.indexScrubRecordsRangeSubspaceZero(store, index).pack()));
        context.clear(Range.startsWith(IndexingSubspaces.indexScrubRecordsRangeSubspaceRoot(store, index).pack()));
    }

    public static void eraseAllIndexingDataButTheLock(@Nonnull FDBRecordContext context, @Nonnull FDBRecordStore store, @Nonnull Index index) {
        IndexingSubspaces.eraseAllIndexingScrubbingData(context, store, index);
        context.clear(Range.startsWith(IndexingSubspaces.indexBuildScannedRecordsSubspace(store, index).pack()));
        context.clear(Range.startsWith(IndexingSubspaces.indexBuildTypeSubspace(store, index).pack()));
        context.clear(Range.startsWith(IndexingSubspaces.indexHeartbeatSubspace(store, index).pack()));
    }
}

