/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.KeyArrayResult;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.TransactionOptions;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.INTERNAL)
abstract class InstrumentedReadTransaction<T extends ReadTransaction>
implements ReadTransaction {
    protected static final int MAX_KEY_LENGTH = 10000;
    protected static final int MAX_VALUE_LENGTH = 100000;
    private static final int MAX_LOGGED_BYTES = 400;
    @Nullable
    protected StoreTimer timer;
    @Nullable
    protected StoreTimer delayedTimer;
    @Nonnull
    protected T underlying;
    protected final boolean enableAssertions;

    public InstrumentedReadTransaction(@Nullable StoreTimer timer, @Nullable StoreTimer delayedTimer, @Nonnull T underlying, boolean enableAssertions) {
        this.timer = timer;
        this.delayedTimer = delayedTimer;
        this.underlying = underlying;
        this.enableAssertions = enableAssertions;
    }

    @Nullable
    protected StoreTimer getTimerForEvent(StoreTimer.Event event) {
        return event.isDelayedUntilCommit() ? this.delayedTimer : this.timer;
    }

    @Override
    public boolean isSnapshot() {
        return this.underlying.isSnapshot();
    }

    @Override
    public CompletableFuture<Long> getReadVersion() {
        return this.underlying.getReadVersion();
    }

    @Override
    public void setReadVersion(long l) {
        this.underlying.setReadVersion(l);
    }

    @Override
    public boolean addReadConflictRangeIfNotSnapshot(byte[] keyBegin, byte[] keyEnd) {
        return this.underlying.addReadConflictRangeIfNotSnapshot(this.checkKey(keyBegin), this.checkKey(keyEnd));
    }

    @Override
    public boolean addReadConflictKeyIfNotSnapshot(byte[] key) {
        return this.underlying.addReadConflictKeyIfNotSnapshot(this.checkKey(key));
    }

    @Override
    public CompletableFuture<byte[]> get(byte[] key) {
        this.increment(FDBStoreTimer.Counts.READS);
        return this.underlying.get(this.checkKey(key)).thenApply(this::recordRead);
    }

    @Override
    public CompletableFuture<byte[]> getKey(KeySelector keySelector) {
        this.increment(FDBStoreTimer.Counts.READS);
        return this.underlying.getKey(this.checkKey(keySelector)).thenApply(this::recordRead);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end)));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit, boolean reverse) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit, reverse));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit, boolean reverse, StreamingMode streamingMode) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit, reverse, streamingMode));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end)));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit, boolean reverse) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit, reverse));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit, boolean reverse, StreamingMode streamingMode) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(begin), this.checkKey(end), limit, reverse, streamingMode));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(range)));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(range), limit));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit, boolean reverse) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(range), limit, reverse));
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit, boolean reverse, StreamingMode streamingMode) {
        return new ByteCountingAsyncIterable<KeyValue>(this.underlying.getRange(this.checkKey(range), limit, reverse, streamingMode));
    }

    @Override
    public AsyncIterable<MappedKeyValue> getMappedRange(KeySelector begin, KeySelector end, byte[] mapper, int limit, boolean reverse, StreamingMode mode) {
        this.increment(FDBStoreTimer.Counts.REMOTE_FETCH);
        return new ByteCountingAsyncIterable<MappedKeyValue>(this.underlying.getMappedRange(begin, end, mapper, limit, reverse, mode), InstrumentedReadTransaction::countMappedKeyValueBytes);
    }

    @Override
    public CompletableFuture<KeyArrayResult> getRangeSplitPoints(Range range, long chunkSize) {
        return this.underlying.getRangeSplitPoints(range, chunkSize);
    }

    @Override
    public CompletableFuture<KeyArrayResult> getRangeSplitPoints(byte[] begin, byte[] end, long chunkSize) {
        return this.underlying.getRangeSplitPoints(begin, end, chunkSize);
    }

    @Override
    public CompletableFuture<Long> getEstimatedRangeSizeBytes(byte[] begin, byte[] end) {
        return this.underlying.getEstimatedRangeSizeBytes(begin, end);
    }

    @Override
    public CompletableFuture<Long> getEstimatedRangeSizeBytes(Range range) {
        return this.underlying.getEstimatedRangeSizeBytes(range);
    }

    @Override
    public TransactionOptions options() {
        return this.underlying.options();
    }

    public <V> V read(Function<? super ReadTransaction, V> function) {
        return function.apply(this);
    }

    public <V> CompletableFuture<V> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<V>> function) {
        return AsyncUtil.applySafely(function, this);
    }

    @Override
    public Executor getExecutor() {
        return this.underlying.getExecutor();
    }

    @Nullable
    protected byte[] recordRead(@Nullable byte[] value) {
        if (value != null) {
            this.increment(FDBStoreTimer.Counts.BYTES_READ, value.length);
        }
        return value;
    }

    protected void increment(StoreTimer.Count count) {
        StoreTimer eventTimer = this.getTimerForEvent(count);
        if (eventTimer != null) {
            eventTimer.increment(count);
        }
    }

    protected void increment(StoreTimer.Count count, int amount) {
        StoreTimer eventTimer = this.getTimerForEvent(count);
        if (eventTimer != null) {
            eventTimer.increment(count, amount);
        }
    }

    protected void recordSinceNanoTime(StoreTimer.Event event, long nanoTime) {
        StoreTimer eventTimer = this.getTimerForEvent(event);
        if (eventTimer != null) {
            eventTimer.recordSinceNanoTime(event, nanoTime);
        }
    }

    @Nonnull
    protected KeySelector checkKey(@Nonnull KeySelector keySelector) {
        this.checkKey(keySelector.getKey());
        return keySelector;
    }

    @Nonnull
    protected Range checkKey(@Nonnull Range range) {
        this.checkKey(range.begin);
        this.checkKey(range.end);
        return range;
    }

    @Nonnull
    protected byte[] checkKey(@Nonnull byte[] key) {
        if (this.enableAssertions && key.length > 10000) {
            throw new FDBExceptions.FDBStoreKeySizeException("Key length exceeds limit", new Object[]{LogMessageKeys.KEY_SIZE, key.length, LogMessageKeys.KEY, this.loggable(key)});
        }
        return key;
    }

    @Nonnull
    protected byte[] checkValue(@Nonnull byte[] key, @Nonnull byte[] value) {
        if (this.enableAssertions && value.length > 100000) {
            throw new FDBExceptions.FDBStoreValueSizeException("Value length exceeds limit", new Object[]{LogMessageKeys.VALUE_SIZE, value.length, LogMessageKeys.KEY, this.loggable(key), LogMessageKeys.VALUE, this.loggable(value)});
        }
        return value;
    }

    @Nonnull
    protected String loggable(@Nonnull byte[] value) {
        if (value.length <= 420) {
            return Objects.requireNonNull(ByteArrayUtil2.loggable(value));
        }
        byte[] portion = Arrays.copyOfRange(value, 0, 400);
        return ByteArrayUtil2.loggable(portion) + "+" + (value.length - 400) + " bytes";
    }

    private static int countKeyValueBytes(KeyValue kv) {
        return kv.getKey().length + kv.getValue().length;
    }

    private static int countMappedKeyValueBytes(MappedKeyValue mkv) {
        return InstrumentedReadTransaction.countKeyValueBytes(mkv) + mkv.getRangeResult().stream().mapToInt(InstrumentedReadTransaction::countKeyValueBytes).sum();
    }

    private class ByteCountingAsyncIterable<K extends KeyValue>
    implements AsyncIterable<K> {
        private final AsyncIterable<K> underlying;
        private final Function<K, Integer> counterOp;

        public ByteCountingAsyncIterable(AsyncIterable<K> underlying) {
            this(underlying, x$0 -> InstrumentedReadTransaction.countKeyValueBytes(x$0));
        }

        public ByteCountingAsyncIterable(AsyncIterable<K> underlying, Function<K, Integer> counterOp) {
            this.underlying = underlying;
            this.counterOp = counterOp;
        }

        @Override
        public @NonNull AsyncIterator<K> iterator() {
            InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.READS);
            InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.RANGE_READS);
            return new ByteCountingAsyncIterator<K>(this.underlying.iterator(), this.counterOp);
        }

        @Override
        public CompletableFuture<List<K>> asList() {
            InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.READS);
            InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.RANGE_READS);
            return this.underlying.asList().thenApply(keyValues -> {
                if (keyValues.isEmpty()) {
                    InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.EMPTY_SCANS);
                } else {
                    int bytes = 0;
                    for (KeyValue kv : keyValues) {
                        bytes += this.counterOp.apply(kv).intValue();
                    }
                    InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.BYTES_READ, bytes);
                }
                return keyValues;
            });
        }
    }

    private class ByteCountingAsyncIterator<K extends KeyValue>
    implements AsyncIterator<K> {
        private final AsyncIterator<K> underlying;
        private final Function<K, Integer> counterOp;
        private volatile boolean hasAnyOrRecordedEmpty;

        public ByteCountingAsyncIterator(AsyncIterator<K> iterator, Function<K, Integer> counterOp) {
            this.underlying = iterator;
            this.counterOp = counterOp;
        }

        @Override
        public CompletableFuture<Boolean> onHasNext() {
            return this.underlying.onHasNext().whenComplete((doesHaveNext, err) -> {
                if (err == null) {
                    this.handleHasNext((boolean)doesHaveNext);
                }
            });
        }

        @Override
        public boolean hasNext() {
            boolean doesHaveNext = this.underlying.hasNext();
            this.handleHasNext(doesHaveNext);
            return doesHaveNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleHasNext(boolean doesHaveNext) {
            if (doesHaveNext) {
                this.hasAnyOrRecordedEmpty = true;
            } else if (!this.hasAnyOrRecordedEmpty) {
                ByteCountingAsyncIterator byteCountingAsyncIterator = this;
                synchronized (byteCountingAsyncIterator) {
                    if (!this.hasAnyOrRecordedEmpty) {
                        InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.EMPTY_SCANS);
                        this.hasAnyOrRecordedEmpty = true;
                    }
                }
            }
        }

        @Override
        public K next() {
            KeyValue next = (KeyValue)this.underlying.next();
            InstrumentedReadTransaction.this.increment(FDBStoreTimer.Counts.BYTES_READ, this.counterOp.apply(next));
            return (K)next;
        }

        @Override
        public void cancel() {
            this.underlying.cancel();
        }
    }
}

