/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBError;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.InstrumentedReadTransaction;
import com.apple.foundationdb.record.provider.foundationdb.TransactionListener;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class InstrumentedTransaction
extends InstrumentedReadTransaction<Transaction>
implements Transaction {
    @Nullable
    protected ReadTransaction snapshot;
    protected final FDBDatabase database;
    @Nullable
    protected final TransactionListener listener;
    private final long startNanos = System.nanoTime();
    private boolean endTimeRecorded = false;

    public InstrumentedTransaction(@Nullable StoreTimer timer, @Nullable StoreTimer delayedTimer, @Nonnull FDBDatabase database, @Nullable TransactionListener listener, @Nonnull Transaction underlying, boolean enableAssertions) {
        super(timer, delayedTimer, underlying, enableAssertions);
        this.database = database;
        this.listener = listener;
        if (listener != null) {
            listener.create(database, this);
        }
    }

    @Override
    public void addReadConflictRange(byte[] keyBegin, byte[] keyEnd) {
        ((Transaction)this.underlying).addReadConflictRange(this.checkKey(keyBegin), this.checkKey(keyEnd));
    }

    @Override
    public void addReadConflictKey(byte[] key) {
        ((Transaction)this.underlying).addReadConflictKey(this.checkKey(key));
    }

    @Override
    public void addWriteConflictRange(byte[] keyBegin, byte[] keyEnd) {
        ((Transaction)this.underlying).addWriteConflictRange(this.checkKey(keyBegin), this.checkKey(keyEnd));
    }

    @Override
    public void addWriteConflictKey(byte[] key) {
        ((Transaction)this.underlying).addWriteConflictKey(this.checkKey(key));
    }

    @Override
    public void set(byte[] key, byte[] value) {
        ((Transaction)this.underlying).set(this.checkKey(key), this.checkValue(key, value));
        this.increment(FDBStoreTimer.Counts.WRITES);
        this.increment(FDBStoreTimer.Counts.BYTES_WRITTEN, key.length + value.length);
    }

    @Override
    public void clear(byte[] key) {
        ((Transaction)this.underlying).clear(this.checkKey(key));
        this.increment(FDBStoreTimer.Counts.DELETES);
    }

    @Override
    public void clear(byte[] keyBegin, byte[] keyEnd) {
        ((Transaction)this.underlying).clear(this.checkKey(keyBegin), this.checkKey(keyEnd));
        this.increment(FDBStoreTimer.Counts.DELETES);
        this.increment(FDBStoreTimer.Counts.RANGE_DELETES);
    }

    @Override
    public void clear(Range range) {
        this.checkKey(range.begin);
        this.checkKey(range.end);
        ((Transaction)this.underlying).clear(range);
        this.increment(FDBStoreTimer.Counts.DELETES);
        this.increment(FDBStoreTimer.Counts.RANGE_DELETES);
    }

    @Override
    @Deprecated
    public void clearRangeStartsWith(byte[] prefix) {
        ((Transaction)this.underlying).clearRangeStartsWith(this.checkKey(prefix));
        this.increment(FDBStoreTimer.Counts.DELETES);
        this.increment(FDBStoreTimer.Counts.RANGE_DELETES);
    }

    @Override
    public void mutate(MutationType opType, byte[] key, byte[] param) {
        ((Transaction)this.underlying).mutate(opType, this.checkKey(key), param);
        this.increment(FDBStoreTimer.Counts.MUTATIONS);
    }

    @Override
    public CompletableFuture<Void> commit() {
        long startTimeNanos = System.nanoTime();
        return ((Transaction)this.underlying).commit().whenComplete((v, ex) -> {
            this.trackCommitFailures((Throwable)ex);
            this.recordEndTime();
            if (ex == null && this.timer != null && this.delayedTimer != null) {
                this.timer.add(this.delayedTimer);
                this.delayedTimer.reset();
            }
            if (this.listener != null) {
                this.listener.commit(this.database, this, this.timer, (Throwable)ex);
            }
            this.recordSinceNanoTime(FDBStoreTimer.Events.COMMITS, startTimeNanos);
        });
    }

    private void trackCommitFailures(@Nullable Throwable ex) {
        if (ex != null) {
            this.increment(FDBStoreTimer.Counts.COMMITS_FAILED);
        }
        while (ex != null && !(ex instanceof FDBException)) {
            ex = ex.getCause();
        }
        if (ex != null) {
            FDBError error = FDBError.fromCode(((FDBException)ex).getCode());
            switch (error) {
                case NOT_COMMITTED: {
                    this.increment(FDBStoreTimer.Counts.CONFLICTS);
                    break;
                }
                case COMMIT_UNKNOWN_RESULT: {
                    this.increment(FDBStoreTimer.Counts.COMMIT_UNKNOWN);
                    break;
                }
                case TRANSACTION_TOO_LARGE: {
                    this.increment(FDBStoreTimer.Counts.TRANSACTION_TOO_LARGE);
                    break;
                }
            }
        }
    }

    @Override
    public Long getCommittedVersion() {
        return ((Transaction)this.underlying).getCommittedVersion();
    }

    @Override
    public CompletableFuture<byte[]> getVersionstamp() {
        return ((Transaction)this.underlying).getVersionstamp();
    }

    @Override
    public CompletableFuture<Long> getApproximateSize() {
        return ((Transaction)this.underlying).getApproximateSize();
    }

    @Override
    public CompletableFuture<Transaction> onError(Throwable throwable) {
        return ((Transaction)this.underlying).onError(throwable);
    }

    @Override
    public void cancel() {
        ((Transaction)this.underlying).cancel();
    }

    @Override
    public CompletableFuture<Void> watch(byte[] bytes) throws FDBException {
        return ((Transaction)this.underlying).watch(this.checkKey(bytes));
    }

    @Override
    public Database getDatabase() {
        return ((Transaction)this.underlying).getDatabase();
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function) {
        return function.apply(this);
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function) {
        return AsyncUtil.applySafely(function, this);
    }

    @Override
    public void close() {
        ((Transaction)this.underlying).close();
        this.recordEndTime();
        if (this.listener != null) {
            this.listener.close(this.database, this, this.timer);
        }
    }

    @Override
    public boolean isSnapshot() {
        return ((Transaction)this.underlying).isSnapshot();
    }

    @Override
    public ReadTransaction snapshot() {
        if (this.snapshot == null) {
            this.snapshot = new Snapshot(this.timer, this.delayedTimer, ((Transaction)this.underlying).snapshot(), this.enableAssertions);
        }
        return this.snapshot;
    }

    @Override
    public CompletableFuture<Long> getReadVersion() {
        return ((Transaction)this.underlying).getReadVersion();
    }

    @Override
    public void setReadVersion(long l) {
        ((Transaction)this.underlying).setReadVersion(l);
    }

    private synchronized void recordEndTime() {
        StoreTimer eventTimer = this.getTimerForEvent(FDBStoreTimer.Events.TRANSACTION_TIME);
        if (eventTimer != null && !this.endTimeRecorded) {
            this.endTimeRecorded = true;
            eventTimer.record(FDBStoreTimer.Events.TRANSACTION_TIME, System.nanoTime() - this.startNanos);
        }
    }

    private static class Snapshot
    extends InstrumentedReadTransaction<ReadTransaction>
    implements ReadTransaction {
        public Snapshot(@Nullable StoreTimer timer, @Nullable StoreTimer delayedTimer, @Nonnull ReadTransaction underlying, boolean enableAssertions) {
            super(timer, delayedTimer, underlying, enableAssertions);
        }

        @Override
        public ReadTransaction snapshot() {
            return this;
        }
    }
}

