/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.KeyArrayResult;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.TransactionOptions;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.record.provider.foundationdb.KeyChecker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class KeyCheckingReadTransaction<T extends ReadTransaction>
implements ReadTransaction {
    @Nonnull
    protected final T underlying;
    @Nonnull
    protected final KeyChecker keyChecker;
    @Nullable
    private ReadTransaction snapshot;

    protected KeyCheckingReadTransaction(@Nonnull T underlying, @Nonnull KeyChecker keyChecker) {
        this.underlying = underlying;
        this.keyChecker = keyChecker;
    }

    protected void checkKeyRange(Range range, boolean mutation) {
        this.checkKeyRange(range.begin, range.end, mutation);
    }

    protected void checkKeyRange(byte[] keyBegin, byte[] keyEnd, boolean mutation) {
        this.keyChecker.checkKeyRange(keyBegin, keyEnd, mutation);
    }

    protected void checkKey(byte[] key, boolean mutation) {
        this.keyChecker.checkKey(key, mutation);
    }

    @Override
    public boolean isSnapshot() {
        return this.underlying.isSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadTransaction snapshot() {
        if (this.isSnapshot()) {
            return this;
        }
        KeyCheckingReadTransaction keyCheckingReadTransaction = this;
        synchronized (keyCheckingReadTransaction) {
            if (this.snapshot == null) {
                this.snapshot = new KeyCheckingReadTransaction<ReadTransaction>(this.underlying.snapshot(), this.keyChecker);
            }
            return this.snapshot;
        }
    }

    @Override
    public CompletableFuture<Long> getReadVersion() {
        return this.underlying.getReadVersion();
    }

    @Override
    public void setReadVersion(long version) {
        this.underlying.setReadVersion(version);
    }

    @Override
    public boolean addReadConflictRangeIfNotSnapshot(byte[] keyBegin, byte[] keyEnd) {
        this.checkKeyRange(keyBegin, keyEnd, false);
        return this.underlying.addReadConflictRangeIfNotSnapshot(keyBegin, keyEnd);
    }

    @Override
    public boolean addReadConflictKeyIfNotSnapshot(byte[] key) {
        this.checkKey(key, false);
        return this.underlying.addReadConflictKeyIfNotSnapshot(key);
    }

    @Override
    public CompletableFuture<byte[]> get(byte[] key) {
        this.checkKey(key, false);
        return this.underlying.get(key);
    }

    @Override
    public CompletableFuture<byte[]> getKey(KeySelector selector) {
        this.checkKey(selector.getKey(), false);
        return this.underlying.getKey(selector);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end) {
        this.checkKeyRange(begin.getKey(), end.getKey(), false);
        return this.underlying.getRange(begin, end);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit) {
        this.checkKeyRange(begin.getKey(), end.getKey(), false);
        return this.underlying.getRange(begin, end, limit);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit, boolean reverse) {
        this.checkKeyRange(begin.getKey(), end.getKey(), false);
        return this.underlying.getRange(begin, end, limit, reverse);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(KeySelector begin, KeySelector end, int limit, boolean reverse, StreamingMode mode) {
        this.checkKeyRange(begin.getKey(), end.getKey(), false);
        return this.underlying.getRange(begin, end, limit, reverse, mode);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getRange(begin, end);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getRange(begin, end, limit);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit, boolean reverse) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getRange(begin, end, limit, reverse);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(byte[] begin, byte[] end, int limit, boolean reverse, StreamingMode mode) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getRange(begin, end, limit, reverse, mode);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range) {
        this.checkKeyRange(range, false);
        return this.underlying.getRange(range);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit) {
        this.checkKeyRange(range, false);
        return this.underlying.getRange(range, limit);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit, boolean reverse) {
        this.checkKeyRange(range, false);
        return this.underlying.getRange(range, limit, reverse);
    }

    @Override
    public AsyncIterable<KeyValue> getRange(Range range, int limit, boolean reverse, StreamingMode mode) {
        this.checkKeyRange(range, false);
        return this.underlying.getRange(range, limit, reverse, mode);
    }

    @Override
    public AsyncIterable<MappedKeyValue> getMappedRange(KeySelector begin, KeySelector end, byte[] mapper, int limit, boolean reverse, StreamingMode mode) {
        this.checkKeyRange(begin.getKey(), end.getKey(), false);
        return this.underlying.getMappedRange(begin, end, mapper, limit, reverse, mode);
    }

    @Override
    public CompletableFuture<Long> getEstimatedRangeSizeBytes(byte[] begin, byte[] end) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getEstimatedRangeSizeBytes(begin, end);
    }

    @Override
    public CompletableFuture<Long> getEstimatedRangeSizeBytes(Range range) {
        this.checkKeyRange(range, false);
        return this.underlying.getEstimatedRangeSizeBytes(range);
    }

    @Override
    public CompletableFuture<KeyArrayResult> getRangeSplitPoints(byte[] begin, byte[] end, long chunkSize) {
        this.checkKeyRange(begin, end, false);
        return this.underlying.getRangeSplitPoints(begin, end, chunkSize);
    }

    @Override
    public CompletableFuture<KeyArrayResult> getRangeSplitPoints(Range range, long chunkSize) {
        this.checkKeyRange(range, false);
        return this.underlying.getRangeSplitPoints(range, chunkSize);
    }

    @Override
    public TransactionOptions options() {
        return this.underlying.options();
    }

    @Override
    public <T> T read(Function<? super ReadTransaction, T> retryable) {
        return retryable.apply(this);
    }

    @Override
    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> retryable) {
        return retryable.apply(this);
    }

    @Override
    public Executor getExecutor() {
        return this.underlying.getExecutor();
    }
}

