/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.foundationdb.KeyChecker;
import com.apple.foundationdb.record.provider.foundationdb.KeyCheckingReadTransaction;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class KeyCheckingTransaction
extends KeyCheckingReadTransaction<Transaction>
implements Transaction {
    public KeyCheckingTransaction(@Nonnull Transaction underlying, @Nonnull KeyChecker keyChecker) {
        super(underlying, keyChecker);
    }

    @Override
    public void addReadConflictRange(byte[] keyBegin, byte[] keyEnd) {
        this.checkKeyRange(keyBegin, keyEnd, false);
        ((Transaction)this.underlying).addReadConflictRange(keyBegin, keyEnd);
    }

    @Override
    public void addReadConflictKey(byte[] key) {
        this.checkKey(key, false);
        ((Transaction)this.underlying).addReadConflictKey(key);
    }

    @Override
    public void addWriteConflictRange(byte[] keyBegin, byte[] keyEnd) {
        this.checkKeyRange(keyBegin, keyEnd, true);
        ((Transaction)this.underlying).addWriteConflictRange(keyBegin, keyEnd);
    }

    @Override
    public void addWriteConflictKey(byte[] key) {
        this.checkKey(key, true);
        ((Transaction)this.underlying).addWriteConflictKey(key);
    }

    @Override
    public void set(byte[] key, byte[] value) {
        this.checkKey(key, true);
        ((Transaction)this.underlying).set(key, value);
    }

    @Override
    public void clear(byte[] key) {
        this.checkKey(key, true);
        ((Transaction)this.underlying).clear(key);
    }

    @Override
    public void clear(byte[] beginKey, byte[] endKey) {
        this.checkKeyRange(beginKey, endKey, true);
        ((Transaction)this.underlying).clear(beginKey, endKey);
    }

    @Override
    public void clear(Range range) {
        this.checkKeyRange(range, true);
        ((Transaction)this.underlying).clear(range);
    }

    @Override
    public void clearRangeStartsWith(byte[] prefix) {
        this.checkKey(prefix, true);
        ((Transaction)this.underlying).clearRangeStartsWith(prefix);
    }

    @Override
    public void mutate(MutationType optype, byte[] key, byte[] param) {
        this.checkKey(key, true);
        ((Transaction)this.underlying).mutate(optype, key, param);
    }

    @Override
    public CompletableFuture<Void> commit() {
        return ((Transaction)this.underlying).commit();
    }

    @Override
    public Long getCommittedVersion() {
        return ((Transaction)this.underlying).getCommittedVersion();
    }

    @Override
    public CompletableFuture<byte[]> getVersionstamp() {
        return ((Transaction)this.underlying).getVersionstamp();
    }

    @Override
    public CompletableFuture<Long> getApproximateSize() {
        return ((Transaction)this.underlying).getApproximateSize();
    }

    @Override
    public CompletableFuture<Transaction> onError(Throwable e) {
        return ((Transaction)this.underlying).onError(e);
    }

    @Override
    public void cancel() {
        ((Transaction)this.underlying).cancel();
    }

    @Override
    public CompletableFuture<Void> watch(byte[] key) throws FDBException {
        this.checkKey(key, false);
        return ((Transaction)this.underlying).watch(key);
    }

    @Override
    public Database getDatabase() {
        return ((Transaction)this.underlying).getDatabase();
    }

    @Override
    public <T> T run(Function<? super Transaction, T> retryable) {
        return retryable.apply(this);
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> retryable) {
        return retryable.apply(this);
    }

    @Override
    public void close() {
        try (AutoCloseable autoCloseable = (AutoCloseable)((Object)this.underlying);){
            this.keyChecker.close();
        }
    }
}

