/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.KeyRange;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.cursors.AsyncIteratorCursor;
import com.apple.foundationdb.record.cursors.BaseCursor;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class KeyValueCursorBase<K extends KeyValue>
extends AsyncIteratorCursor<K>
implements BaseCursor<K> {
    @Nonnull
    private final FDBRecordContext context;
    private final int prefixLength;
    @Nonnull
    private final CursorLimitManager limitManager;
    private final int valuesLimit;
    @Nullable
    private byte[] lastKey;
    @Nonnull
    private final SerializationMode serializationMode;

    protected KeyValueCursorBase(@Nonnull FDBRecordContext context, @Nonnull AsyncIterator<K> iterator, int prefixLength, @Nonnull CursorLimitManager limitManager, int valuesLimit, @Nonnull SerializationMode serializationMode) {
        super(context.getExecutor(), iterator);
        this.context = context;
        this.prefixLength = prefixLength;
        this.limitManager = limitManager;
        this.valuesLimit = valuesLimit;
        this.serializationMode = serializationMode;
        context.instrument((StoreTimer.Event)FDBStoreTimer.DetailEvents.GET_SCAN_RANGE_RAW_FIRST_CHUNK, iterator.onHasNext());
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<K>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        if (this.limitManager.tryRecordScan()) {
            return ((AsyncIterator)this.iterator).onHasNext().thenApply(hasNext -> {
                if (hasNext.booleanValue()) {
                    KeyValue kv = (KeyValue)((AsyncIterator)this.iterator).next();
                    if (this.context != null) {
                        this.context.increment(FDBStoreTimer.Counts.LOAD_SCAN_ENTRY);
                        this.context.increment(FDBStoreTimer.Counts.LOAD_KEY_VALUE);
                    }
                    this.limitManager.reportScannedBytes((long)kv.getKey().length + (long)kv.getValue().length);
                    this.lastKey = kv.getKey();
                    ++this.valuesSeen;
                    this.nextResult = RecordCursorResult.withNextValue(kv, this.continuationHelper());
                } else {
                    this.nextResult = this.valuesSeen >= this.valuesLimit ? RecordCursorResult.withoutNextValue(this.continuationHelper(), RecordCursor.NoNextReason.RETURN_LIMIT_REACHED) : RecordCursorResult.exhausted();
                }
                return this.nextResult;
            });
        }
        Optional<RecordCursor.NoNextReason> stoppedReason = this.limitManager.getStoppedReason();
        if (!stoppedReason.isPresent()) {
            throw new RecordCoreException("limit manager stopped KeyValueCursor but did not report a reason", new Object[0]);
        }
        this.nextResult = RecordCursorResult.withoutNextValue(this.continuationHelper(), stoppedReason.get());
        return CompletableFuture.completedFuture(this.nextResult);
    }

    @Override
    @Nonnull
    public RecordCursorResult<K> getNext() {
        return this.context.asyncToSync(FDBStoreTimer.Waits.WAIT_ADVANCE_CURSOR, this.onNext());
    }

    @Nonnull
    private RecordCursorContinuation continuationHelper() {
        return new Continuation(this.lastKey, this.prefixLength, this.serializationMode);
    }

    public static enum SerializationMode {
        TO_OLD,
        TO_NEW;

    }

    public static class Continuation
    implements RecordCursorContinuation {
        @Nullable
        private final byte[] lastKey;
        private final int prefixLength;
        private final SerializationMode serializationMode;
        private static final long MAGIC_NUMBER = 6773487359078157740L;

        public Continuation(@Nullable byte[] lastKey, int prefixLength, SerializationMode serializationMode) {
            this.lastKey = lastKey;
            this.prefixLength = prefixLength;
            this.serializationMode = serializationMode;
        }

        @Override
        public boolean isEnd() {
            return this.lastKey == null;
        }

        @Override
        @Nonnull
        public ByteString toByteString() {
            if (this.serializationMode == SerializationMode.TO_OLD) {
                if (this.lastKey == null) {
                    return ByteString.EMPTY;
                }
                ByteString base = ZeroCopyByteString.wrap(this.lastKey);
                return base.substring(this.prefixLength, this.lastKey.length);
            }
            return this.toProto().toByteString();
        }

        @Override
        @Nullable
        public byte[] toBytes() {
            if (this.lastKey == null) {
                return null;
            }
            ByteString byteString = this.toByteString();
            return byteString.isEmpty() ? new byte[]{} : byteString.toByteArray();
        }

        public static byte[] getInnerContinuation(@Nullable byte[] rawBytes) {
            if (rawBytes == null) {
                return null;
            }
            try {
                RecordCursorProto.KeyValueCursorContinuation continuationProto = RecordCursorProto.KeyValueCursorContinuation.parseFrom(rawBytes);
                if (continuationProto.getMagicNumber() != 6773487359078157740L) {
                    return rawBytes;
                }
                return continuationProto.getInnerContinuation().toByteArray();
            }
            catch (InvalidProtocolBufferException ipbe) {
                return rawBytes;
            }
        }

        @Nonnull
        private RecordCursorProto.KeyValueCursorContinuation toProto() {
            RecordCursorProto.KeyValueCursorContinuation.Builder builder = RecordCursorProto.KeyValueCursorContinuation.newBuilder();
            if (this.lastKey == null) {
                return builder.setMagicNumber(6773487359078157740L).build();
            }
            ByteString base = ZeroCopyByteString.wrap(Objects.requireNonNull(this.lastKey));
            return builder.setInnerContinuation(base.substring(this.prefixLength, this.lastKey.length)).setMagicNumber(6773487359078157740L).build();
        }
    }

    @API(value=API.Status.UNSTABLE)
    public static abstract class Builder<T extends Builder<T>> {
        private int prefixLength;
        private FDBRecordContext context = null;
        private final Subspace subspace;
        private byte[] continuation = null;
        private ScanProperties scanProperties = null;
        private byte[] lowBytes = null;
        private byte[] highBytes = null;
        private EndpointType lowEndpoint = null;
        private EndpointType highEndpoint = null;
        private ReadTransaction transaction;
        private CursorLimitManager limitManager;
        private int valuesLimit;
        private int limit;
        private boolean reverse;
        private StreamingMode streamingMode;
        private KeySelector begin;
        private KeySelector end;
        protected SerializationMode serializationMode;

        protected Builder(@Nonnull Subspace subspace) {
            this.subspace = subspace;
            this.serializationMode = SerializationMode.TO_OLD;
        }

        protected void prepare() {
            if (this.subspace == null) {
                throw new RecordCoreException("record subspace must be supplied", new Object[0]);
            }
            if (this.context == null) {
                throw new RecordCoreException("record context must be supplied", new Object[0]);
            }
            if (this.scanProperties == null) {
                throw new RecordCoreException("record scanProperties must be supplied", new Object[0]);
            }
            if (this.lowBytes == null) {
                this.lowBytes = this.subspace.pack();
            }
            if (this.highBytes == null) {
                this.highBytes = this.subspace.pack();
            }
            if (this.lowEndpoint == null) {
                this.lowEndpoint = EndpointType.TREE_START;
            }
            if (this.highEndpoint == null) {
                this.highEndpoint = EndpointType.TREE_END;
            }
            this.prefixLength = this.calculatePrefixLength();
            if (this.lowEndpoint == EndpointType.PREFIX_STRING && this.highEndpoint == EndpointType.PREFIX_STRING) {
                --this.prefixLength;
            }
            this.reverse = this.scanProperties.isReverse();
            if (this.continuation != null) {
                byte[] realContinuation = Continuation.getInnerContinuation(this.continuation);
                byte[] continuationBytes = new byte[this.prefixLength + realContinuation.length];
                System.arraycopy(this.lowBytes, 0, continuationBytes, 0, this.prefixLength);
                System.arraycopy(realContinuation, 0, continuationBytes, this.prefixLength, realContinuation.length);
                if (this.reverse) {
                    this.highBytes = continuationBytes;
                    this.highEndpoint = EndpointType.CONTINUATION;
                } else {
                    this.lowBytes = continuationBytes;
                    this.lowEndpoint = EndpointType.CONTINUATION;
                }
            }
            Range byteRange = TupleRange.toRange(this.lowBytes, this.highBytes, this.lowEndpoint, this.highEndpoint);
            this.lowBytes = byteRange.begin;
            this.highBytes = byteRange.end;
            this.begin = KeySelector.firstGreaterOrEqual(this.lowBytes);
            this.end = KeySelector.firstGreaterOrEqual(this.highBytes);
            if (this.scanProperties.getExecuteProperties().getSkip() > 0) {
                if (this.reverse) {
                    this.end = this.end.add(-this.scanProperties.getExecuteProperties().getSkip());
                } else {
                    this.begin = this.begin.add(this.scanProperties.getExecuteProperties().getSkip());
                }
            }
            this.limit = this.scanProperties.getExecuteProperties().getReturnedRowLimit();
            this.streamingMode = this.calcStreamingMode(this.scanProperties.getCursorStreamingMode(), this.limit);
            this.transaction = this.context.readTransaction(this.scanProperties.getExecuteProperties().getIsolationLevel().isSnapshot());
            this.limitManager = new CursorLimitManager(this.context, this.scanProperties);
            this.valuesLimit = this.scanProperties.getExecuteProperties().getReturnedRowLimitOrMax();
        }

        public T setContext(FDBRecordContext context) {
            this.context = context;
            return this.self();
        }

        @SpotBugsSuppressWarnings(value={"EI2"}, justification="copies are expensive")
        public T setContinuation(@Nullable byte[] continuation) {
            this.continuation = continuation;
            return this.self();
        }

        public T setScanProperties(@Nonnull ScanProperties scanProperties) {
            this.scanProperties = scanProperties;
            return this.self();
        }

        public T setRange(@Nonnull KeyRange range) {
            this.setLow(range.getLowKey(), range.getLowEndpoint());
            this.setHigh(range.getHighKey(), range.getHighEndpoint());
            return this.self();
        }

        public T setRange(@Nonnull TupleRange range) {
            this.setLow(range.getLow(), range.getLowEndpoint());
            this.setHigh(range.getHigh(), range.getHighEndpoint());
            return this.self();
        }

        public T setLow(@Nullable Tuple low, @Nonnull EndpointType lowEndpoint) {
            this.setLow(low != null ? this.subspace.pack(low) : this.subspace.pack(), lowEndpoint);
            return this.self();
        }

        @SpotBugsSuppressWarnings(value={"EI2"}, justification="copies are expensive")
        public T setLow(@Nonnull byte[] lowBytes, @Nonnull EndpointType lowEndpoint) {
            this.lowBytes = lowBytes;
            this.lowEndpoint = lowEndpoint;
            return this.self();
        }

        public T setHigh(@Nullable Tuple high, @Nonnull EndpointType highEndpoint) {
            this.setHigh(high != null ? this.subspace.pack(high) : this.subspace.pack(), highEndpoint);
            return this.self();
        }

        @SpotBugsSuppressWarnings(value={"EI2"}, justification="copies are expensive")
        public T setHigh(@Nonnull byte[] highBytes, @Nonnull EndpointType highEndpoint) {
            this.highBytes = highBytes;
            this.highEndpoint = highEndpoint;
            return this.self();
        }

        public T setSerializationMode(@Nonnull SerializationMode serializationMode) {
            this.serializationMode = serializationMode;
            return this.self();
        }

        protected int calculatePrefixLength() {
            int prefixLength;
            for (prefixLength = this.subspace.pack().length; prefixLength < this.lowBytes.length && prefixLength < this.highBytes.length && this.lowBytes[prefixLength] == this.highBytes[prefixLength]; ++prefixLength) {
            }
            return prefixLength;
        }

        public FDBRecordContext getContext() {
            return this.context;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }

        public ReadTransaction getTransaction() {
            return this.transaction;
        }

        public CursorLimitManager getLimitManager() {
            return this.limitManager;
        }

        public int getValuesLimit() {
            return this.valuesLimit;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public StreamingMode getStreamingMode() {
            return this.streamingMode;
        }

        public KeySelector getBegin() {
            return this.begin;
        }

        public KeySelector getEnd() {
            return this.end;
        }

        private StreamingMode calcStreamingMode(CursorStreamingMode propertiesStreamingMode, int limit) {
            if (propertiesStreamingMode == CursorStreamingMode.ITERATOR) {
                return StreamingMode.ITERATOR;
            }
            if (propertiesStreamingMode == CursorStreamingMode.LARGE) {
                return StreamingMode.LARGE;
            }
            if (propertiesStreamingMode == CursorStreamingMode.MEDIUM) {
                return StreamingMode.MEDIUM;
            }
            if (propertiesStreamingMode == CursorStreamingMode.SMALL) {
                return StreamingMode.SMALL;
            }
            if (limit == 0) {
                return StreamingMode.WANT_ALL;
            }
            return StreamingMode.EXACT;
        }

        protected abstract T self();
    }
}

