/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataOptionsProto;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.UnnestedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MetaDataProtoEditor {
    public static void addRecordType(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull DescriptorProtos.DescriptorProto newRecordType, @Nonnull KeyExpression primaryKey) {
        RecordMetaDataOptionsProto.RecordTypeOptions.Usage newRecordTypeUsage = MetaDataProtoEditor.getMessageTypeUsage(newRecordType);
        if ("RecordTypeUnion".equals(newRecordType.getName()) || newRecordTypeUsage == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION) {
            throw new MetaDataException("Adding UNION record type not allowed", new Object[0]);
        }
        if (newRecordTypeUsage == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED) {
            throw new MetaDataException("Use addNestedRecordType for adding NESTED record types", new Object[0]);
        }
        if (MetaDataProtoEditor.findMessageTypeByName(metaDataBuilder.getRecordsBuilder(), newRecordType.getName()) != null) {
            throw new MetaDataException("Record type " + newRecordType.getName() + " already exists", new Object[0]);
        }
        DescriptorProtos.FileDescriptorProto.Builder recordsBuilder = metaDataBuilder.getRecordsBuilder();
        recordsBuilder.addMessageType(newRecordType);
        metaDataBuilder.setVersion(metaDataBuilder.getVersion() + 1);
        metaDataBuilder.addRecordTypes(RecordMetaDataProto.RecordType.newBuilder().setName(newRecordType.getName()).setPrimaryKey(primaryKey.toKeyExpression()).setSinceVersion(metaDataBuilder.getVersion()).build());
        MetaDataProtoEditor.addFieldToUnion(MetaDataProtoEditor.fetchUnionBuilder(recordsBuilder), recordsBuilder, newRecordType.getName());
    }

    private static void addFieldToUnion(@Nonnull DescriptorProtos.DescriptorProto.Builder unionBuilder, @Nonnull DescriptorProtos.FileDescriptorProtoOrBuilder fileBuilder, @Nonnull String typeName) {
        if (unionBuilder.getOneofDeclCount() > 0) {
            throw new MetaDataException("Adding record type to oneof is not allowed", new Object[0]);
        }
        DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(MetaDataProtoEditor.fullyQualifiedTypeName(fileBuilder, typeName)).setName("_" + typeName).setNumber(MetaDataProtoEditor.assignFieldNumber(unionBuilder));
        unionBuilder.addField(fieldBuilder);
    }

    @Nonnull
    public static List<String> getRecordTypes(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder) {
        return metaDataBuilder.getRecordTypesBuilderList().stream().map(RecordMetaDataProto.RecordType.Builder::getName).collect(Collectors.toList());
    }

    @Nonnull
    private static DescriptorProtos.DescriptorProto.Builder fetchUnionBuilder(@Nonnull DescriptorProtos.FileDescriptorProto.Builder fileBuilder) {
        for (DescriptorProtos.DescriptorProto.Builder messageTypeBuilder : fileBuilder.getMessageTypeBuilderList()) {
            if (!MetaDataProtoEditor.isUnion(messageTypeBuilder)) continue;
            return messageTypeBuilder;
        }
        throw new MetaDataException("Union descriptor not found", new Object[0]);
    }

    @Nullable
    private static DescriptorProtos.FieldDescriptorProto.Builder fetchUnionFieldBuilder(@Nonnull DescriptorProtos.FileDescriptorProto.Builder recordsBuilder, @Nonnull DescriptorProtos.DescriptorProto.Builder unionBuilder, @Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull String recordTypeName) {
        DescriptorProtos.FieldDescriptorProto.Builder foundField = null;
        if (recordTypeName.contains(".")) {
            throw new MetaDataException("Record Type Name cannot contain '.'", new Object[0]);
        }
        if (unionBuilder.getNestedTypeCount() > 0) {
            throw new MetaDataException("Nested types in union type not supported", new Object[0]);
        }
        for (DescriptorProtos.FieldDescriptorProto.Builder field : unionBuilder.getFieldBuilderList()) {
            FieldTypeMatch unionFieldMatch = MetaDataProtoEditor.fieldIsType(recordsBuilder, unionDescriptor, field, recordTypeName);
            if (!FieldTypeMatch.MATCHES.equals((Object)unionFieldMatch) || foundField != null && !field.getName().equals("_" + recordTypeName) && field.getNumber() <= foundField.getNumber()) continue;
            foundField = field;
        }
        return foundField;
    }

    private static boolean isUnion(@Nonnull DescriptorProtos.DescriptorProtoOrBuilder messageType) {
        if ("RecordTypeUnion".equals(messageType.getName())) {
            return true;
        }
        RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = messageType.getOptions().getExtension(RecordMetaDataOptionsProto.record);
        return recordTypeOptions != null && recordTypeOptions.hasUsage() && recordTypeOptions.getUsage() == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION;
    }

    private static boolean isUnion(@Nonnull Descriptors.Descriptor messageType) {
        if ("RecordTypeUnion".equals(messageType.getName())) {
            return true;
        }
        RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = messageType.getOptions().getExtension(RecordMetaDataOptionsProto.record);
        return recordTypeOptions != null && recordTypeOptions.hasUsage() && recordTypeOptions.getUsage() == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION;
    }

    @Nonnull
    private static String fullyQualifiedTypeName(@Nonnull String namespace, @Nonnull String typeName) {
        if (typeName.startsWith(".")) {
            return typeName;
        }
        if (!namespace.isEmpty()) {
            return "." + namespace + "." + typeName;
        }
        return "." + typeName;
    }

    @Nonnull
    private static String fullyQualifiedTypeName(@Nonnull DescriptorProtos.FileDescriptorProtoOrBuilder file, @Nonnull String typeName) {
        return MetaDataProtoEditor.fullyQualifiedTypeName(file.getPackage(), typeName);
    }

    @Nonnull
    private static FieldTypeMatch fieldIsType(@Nonnull Descriptors.Descriptor messageDescriptor, @Nonnull DescriptorProtos.FieldDescriptorProtoOrBuilder field, @Nonnull String fullTypeName) {
        if (field.hasTypeName() && !field.getTypeName().isEmpty()) {
            String fullyQualifiedName = "." + Objects.requireNonNull(messageDescriptor.findFieldByNumber(field.getNumber()), "Could not find field from protobuf in descriptor").getMessageType().getFullName();
            if (fullyQualifiedName.equals(fullTypeName)) {
                return FieldTypeMatch.MATCHES;
            }
            if (fullyQualifiedName.startsWith(fullTypeName) && fullyQualifiedName.charAt(fullTypeName.length()) == '.') {
                return FieldTypeMatch.MATCHES_AS_NESTED;
            }
            return FieldTypeMatch.DOES_NOT_MATCH;
        }
        return FieldTypeMatch.DOES_NOT_MATCH;
    }

    @Nonnull
    @VisibleForTesting
    static FieldTypeMatch fieldIsType(@Nonnull DescriptorProtos.FileDescriptorProtoOrBuilder file, @Nonnull Descriptors.Descriptor descriptorForMessage, @Nonnull DescriptorProtos.FieldDescriptorProtoOrBuilder field, @Nonnull String typeName) {
        return MetaDataProtoEditor.fieldIsType(descriptorForMessage, field, MetaDataProtoEditor.fullyQualifiedTypeName(file, typeName));
    }

    private static int assignFieldNumber(@Nonnull DescriptorProtos.DescriptorProto.Builder messageType) {
        if (messageType.getFieldCount() == 0) {
            return 1;
        }
        return messageType.getFieldList().stream().mapToInt(DescriptorProtos.FieldDescriptorProto::getNumber).max().getAsInt() + 1;
    }

    public static void addNestedRecordType(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull DescriptorProtos.DescriptorProto newRecordType) {
        RecordMetaDataOptionsProto.RecordTypeOptions.Usage newRecordTypeUsage = MetaDataProtoEditor.getMessageTypeUsage(newRecordType);
        if (newRecordTypeUsage != RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED && newRecordTypeUsage != RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNSET) {
            throw new MetaDataException("Record type is not NESTED", new Object[0]);
        }
        if (MetaDataProtoEditor.findMessageTypeByName(metaDataBuilder.getRecordsBuilder(), newRecordType.getName()) != null) {
            throw new MetaDataException("Record type " + newRecordType.getName() + " already exists", new Object[0]);
        }
        metaDataBuilder.getRecordsBuilder().addMessageType(newRecordType);
    }

    @Nonnull
    private static RecordMetaDataOptionsProto.RecordTypeOptions.Usage getMessageTypeUsage(@Nonnull DescriptorProtos.DescriptorProtoOrBuilder messageType) {
        RecordMetaDataOptionsProto.RecordTypeOptions recordTypeOptions = messageType.getOptions().getExtension(RecordMetaDataOptionsProto.record);
        if (recordTypeOptions != null && recordTypeOptions.hasUsage()) {
            return recordTypeOptions.getUsage();
        }
        return RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNSET;
    }

    @Nullable
    private static DescriptorProtos.DescriptorProto.Builder findMessageTypeByName(@Nonnull DescriptorProtos.FileDescriptorProto.Builder recordsBuilder, @Nonnull String recordType) {
        return recordsBuilder.getMessageTypeBuilderList().stream().filter(m4 -> m4.getName().equals(recordType)).findAny().orElse(null);
    }

    public static void deprecateRecordType(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String recordType, @Nonnull Descriptors.FileDescriptor[] dependencies) {
        DescriptorProtos.FileDescriptorProto.Builder fileBuilder = metaDataBuilder.getRecordsBuilder();
        DescriptorProtos.DescriptorProto.Builder unionBuilder = MetaDataProtoEditor.fetchUnionBuilder(fileBuilder);
        if (unionBuilder.getName().equals(recordType)) {
            throw new MetaDataException("Cannot deprecate the union", new Object[0]);
        }
        Descriptors.FileDescriptor fileDescriptor = RecordMetaDataBuilder.buildFileDescriptor(metaDataBuilder.getRecords(), dependencies);
        Descriptors.Descriptor unionDescriptor = fileDescriptor.findMessageTypeByName(unionBuilder.getName());
        boolean found = false;
        for (DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder : unionBuilder.getFieldBuilderList()) {
            FieldTypeMatch fieldTypeMatch = MetaDataProtoEditor.fieldIsType(fileBuilder, unionDescriptor, fieldBuilder, recordType);
            if (!FieldTypeMatch.MATCHES.equals((Object)fieldTypeMatch) && !FieldTypeMatch.MATCHES_AS_NESTED.equals((Object)fieldTypeMatch)) continue;
            MetaDataProtoEditor.setDeprecated(fieldBuilder);
            found = true;
        }
        if (!found) {
            throw new MetaDataException("Record type " + recordType + " not found", new Object[0]);
        }
    }

    public static void renameRecordTypes(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull Function<String, String> renamer, @Nonnull Descriptors.FileDescriptor[] dependencies) {
        for (String recordType : MetaDataProtoEditor.getRecordTypes(metaDataBuilder)) {
            MetaDataProtoEditor.renameRecordType(metaDataBuilder, recordType, renamer.apply(recordType), dependencies);
        }
    }

    public static void renameRecordType(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String recordTypeName, @Nonnull String newRecordTypeName, @Nonnull Descriptors.FileDescriptor[] dependencies) {
        RecordMetaDataOptionsProto.RecordTypeOptions.Usage usage;
        DescriptorProtos.FileDescriptorProto records = metaDataBuilder.getRecords();
        boolean found = false;
        for (DescriptorProtos.DescriptorProto messageType : records.getMessageTypeList()) {
            if (messageType.getName().equals(recordTypeName)) {
                found = true;
                continue;
            }
            if (!messageType.getName().equals(newRecordTypeName)) continue;
            throw new MetaDataException("Cannot rename record type to " + newRecordTypeName + " as it already exists", new Object[0]);
        }
        if (!found) {
            throw new MetaDataException("No record type found with name " + recordTypeName, new Object[0]);
        }
        if (recordTypeName.equals(newRecordTypeName)) {
            return;
        }
        Descriptors.FileDescriptor fileDescriptor = RecordMetaDataBuilder.buildFileDescriptor(records, dependencies);
        DescriptorProtos.FileDescriptorProto.Builder recordsBuilder = records.toBuilder();
        DescriptorProtos.DescriptorProto.Builder unionBuilder = MetaDataProtoEditor.fetchUnionBuilder(recordsBuilder);
        if (unionBuilder.getName().equals(recordTypeName)) {
            usage = RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION;
        } else {
            Descriptors.Descriptor unionDescriptor = MetaDataProtoEditor.getDescriptor(fileDescriptor, unionBuilder.getName());
            DescriptorProtos.FieldDescriptorProto.Builder unionFieldBuilder = MetaDataProtoEditor.fetchUnionFieldBuilder(recordsBuilder, unionBuilder, unionDescriptor, recordTypeName);
            if (unionFieldBuilder == null) {
                usage = RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED;
            } else {
                usage = RecordMetaDataOptionsProto.RecordTypeOptions.Usage.RECORD;
                if (unionFieldBuilder.getName().equals("_" + recordTypeName)) {
                    String newFieldName = "_" + newRecordTypeName;
                    if (unionBuilder.getFieldBuilderList().stream().noneMatch(otherUnionField -> otherUnionField != unionFieldBuilder && otherUnionField.getName().equals(newFieldName))) {
                        unionFieldBuilder.setName(newFieldName);
                    }
                }
            }
        }
        if ("RecordTypeUnion".equals(newRecordTypeName) && !RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION.equals(usage)) {
            throw new MetaDataException("Cannot rename record type to the default union name", new Object[]{LogMessageKeys.RECORD_TYPE, recordTypeName});
        }
        MetaDataProtoEditor.renameRecordTypeUsages(recordsBuilder, recordTypeName, newRecordTypeName, fileDescriptor);
        if (RecordMetaDataOptionsProto.RecordTypeOptions.Usage.RECORD.equals(usage)) {
            MetaDataProtoEditor.renameTopLevelRecordType(metaDataBuilder, recordTypeName, newRecordTypeName);
        }
        MetaDataProtoEditor.renameRecordTypeUsagesInUnnested(metaDataBuilder, fileDescriptor, recordTypeName, newRecordTypeName, MetaDataProtoEditor.getDescriptor(fileDescriptor, recordTypeName));
        metaDataBuilder.setRecords(recordsBuilder);
    }

    private static Descriptors.Descriptor getDescriptor(Descriptors.FileDescriptor fileDescriptor, String name) {
        Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(name);
        if (descriptor == null) {
            throw new MetaDataException("Could not find descriptor", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.NAME, name});
        }
        return descriptor;
    }

    private static void renameRecordTypeUsages(@Nonnull DescriptorProtos.FileDescriptorProto.Builder recordsBuilder, @Nonnull String oldRecordTypeName, @Nonnull String newRecordTypeName, @Nonnull Descriptors.FileDescriptor fileDescriptor) {
        String namespace = recordsBuilder.getPackage();
        String fullOldRecordTypeName = MetaDataProtoEditor.fullyQualifiedTypeName(namespace, oldRecordTypeName);
        String fullNewRecordTypeName = MetaDataProtoEditor.fullyQualifiedTypeName(namespace, newRecordTypeName);
        for (DescriptorProtos.DescriptorProto.Builder messageTypeBuilder : recordsBuilder.getMessageTypeBuilderList()) {
            Descriptors.Descriptor descriptor = MetaDataProtoEditor.getDescriptor(fileDescriptor, messageTypeBuilder.getName());
            MetaDataProtoEditor.renameRecordTypeUsages(namespace, messageTypeBuilder, fullOldRecordTypeName, fullNewRecordTypeName, descriptor);
            if (!messageTypeBuilder.getName().equals(oldRecordTypeName)) continue;
            if (MetaDataProtoEditor.isUnion(messageTypeBuilder)) {
                RecordMetaDataOptionsProto.RecordTypeOptions recordOptions = null;
                if (messageTypeBuilder.getOptions().hasExtension(RecordMetaDataOptionsProto.record)) {
                    recordOptions = messageTypeBuilder.getOptionsBuilder().getExtension(RecordMetaDataOptionsProto.record);
                }
                if (recordOptions == null || !recordOptions.hasUsage() || !recordOptions.getUsage().equals(RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION)) {
                    RecordMetaDataOptionsProto.RecordTypeOptions.Builder recordOptionsBuilder = recordOptions == null ? RecordMetaDataOptionsProto.RecordTypeOptions.newBuilder() : recordOptions.toBuilder();
                    recordOptionsBuilder.setUsage(RecordMetaDataOptionsProto.RecordTypeOptions.Usage.UNION);
                    messageTypeBuilder.getOptionsBuilder().setExtension(RecordMetaDataOptionsProto.record, recordOptionsBuilder.build());
                }
            }
            messageTypeBuilder.setName(newRecordTypeName);
        }
    }

    private static void renameRecordTypeUsages(@Nonnull String namespace, @Nonnull DescriptorProtos.DescriptorProto.Builder messageTypeBuilder, @Nonnull String fullOldRecordTypeName, @Nonnull String fullNewRecordTypeName, Descriptors.Descriptor descriptorForMessage) {
        for (DescriptorProtos.FieldDescriptorProto.Builder field : messageTypeBuilder.getFieldBuilderList()) {
            FieldTypeMatch fieldTypeMatch = MetaDataProtoEditor.fieldIsType(descriptorForMessage, field, fullOldRecordTypeName);
            if (FieldTypeMatch.MATCHES.equals((Object)fieldTypeMatch)) {
                field.setTypeName(fullNewRecordTypeName);
                continue;
            }
            if (!FieldTypeMatch.MATCHES_AS_NESTED.equals((Object)fieldTypeMatch)) continue;
            String fullOldFieldTypeName = "." + descriptorForMessage.findFieldByNumber(field.getNumber()).getMessageType().getFullName();
            String newFieldTypeName = fullNewRecordTypeName + fullOldFieldTypeName.substring(fullOldRecordTypeName.length());
            field.setTypeName(newFieldTypeName);
        }
        if (messageTypeBuilder.getNestedTypeCount() > 0) {
            String nestedNamespace = namespace.isEmpty() ? messageTypeBuilder.getName() : namespace + "." + messageTypeBuilder.getName();
            for (DescriptorProtos.DescriptorProto.Builder nestedTypeBuilder : messageTypeBuilder.getNestedTypeBuilderList()) {
                Descriptors.Descriptor nestedDescriptor = Objects.requireNonNull(descriptorForMessage.findNestedTypeByName(nestedTypeBuilder.getName()), "FileDescriptor does not have nested type that exists in protobuf");
                MetaDataProtoEditor.renameRecordTypeUsages(nestedNamespace, nestedTypeBuilder, fullOldRecordTypeName, fullNewRecordTypeName, nestedDescriptor);
            }
        }
    }

    private static void renameTopLevelRecordType(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String recordTypeName, @Nonnull String newRecordTypeName) {
        boolean foundRecordType = false;
        ArrayList<RecordMetaDataProto.RecordType> recordTypes = new ArrayList<RecordMetaDataProto.RecordType>(metaDataBuilder.getRecordTypesBuilderList().size());
        for (RecordMetaDataProto.RecordType recordType : metaDataBuilder.getRecordTypesList()) {
            if (recordType.getName().equals(newRecordTypeName)) {
                throw new MetaDataException("Cannot rename record type to " + newRecordTypeName + " as an imported record type of that name already exists", new Object[0]);
            }
            if (recordType.getName().equals(recordTypeName)) {
                recordTypes.add(recordType.toBuilder().setName(newRecordTypeName).build());
                foundRecordType = true;
                continue;
            }
            recordTypes.add(recordType);
        }
        if (!foundRecordType) {
            throw new MetaDataException("Missing " + recordTypeName + " in record type list", new Object[0]);
        }
        ArrayList<RecordMetaDataProto.Index> indexes = new ArrayList<RecordMetaDataProto.Index>(metaDataBuilder.getIndexesList());
        indexes.replaceAll(index -> {
            if (index.getRecordTypeList().contains(recordTypeName)) {
                ArrayList<String> indexRecordTypes = new ArrayList<String>(index.getRecordTypeList());
                indexRecordTypes.replaceAll(indexRecordType -> indexRecordType.equals(recordTypeName) ? newRecordTypeName : indexRecordType);
                return index.toBuilder().clearRecordType().addAllRecordType(indexRecordTypes).build();
            }
            return index;
        });
        metaDataBuilder.clearRecordTypes();
        metaDataBuilder.addAllRecordTypes(recordTypes);
        metaDataBuilder.clearIndexes();
        metaDataBuilder.addAllIndexes(indexes);
        MetaDataProtoEditor.updateJoinedRecordTypes(metaDataBuilder, recordTypeName, newRecordTypeName);
        if (metaDataBuilder.getUserDefinedFunctionsCount() > 0) {
            throw new MetaDataException("Renaming record types with UserDefinedFunctions is not supported", new Object[0]);
        }
    }

    private static void renameRecordTypeUsagesInUnnested(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull String oldRecordTypeName, @Nonnull String newRecordTypeName, @Nonnull Descriptors.Descriptor oldTypeDescriptor) {
        for (RecordMetaDataProto.UnnestedRecordType.Builder unnested : metaDataBuilder.getUnnestedRecordTypesBuilderList()) {
            for (RecordMetaDataProto.UnnestedRecordType.NestedConstituent.Builder constituent : unnested.getNestedConstituentsBuilderList()) {
                if (constituent.getParent().isEmpty() && constituent.getTypeName().equals(oldRecordTypeName)) {
                    constituent.setTypeName(newRecordTypeName);
                    continue;
                }
                Descriptors.Descriptor constituentTypeDescriptor = UnnestedRecordTypeBuilder.findDescriptorByName(fileDescriptor, constituent.getTypeName());
                if (constituentTypeDescriptor == null) {
                    throw new MetaDataException("missing descriptor for nested constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, constituent.getTypeName()}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituent.getName()});
                }
                if (!MetaDataProtoEditor.isNested(constituentTypeDescriptor, oldTypeDescriptor)) continue;
                throw new MetaDataException("Renaming types used by non-parent unnested constituents is not supported", new Object[0]);
            }
        }
    }

    private static boolean isNested(@Nonnull Descriptors.Descriptor typeDescriptor, @Nonnull Descriptors.Descriptor targetDescriptor) {
        if (typeDescriptor.equals(targetDescriptor)) {
            return true;
        }
        if (typeDescriptor.getContainingType() == null) {
            return false;
        }
        return MetaDataProtoEditor.isNested(typeDescriptor.getContainingType(), targetDescriptor);
    }

    private static void updateJoinedRecordTypes(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String oldRecordTypeName, @Nonnull String newRecordTypeName) {
        for (RecordMetaDataProto.JoinedRecordType.Builder joined : metaDataBuilder.getJoinedRecordTypesBuilderList()) {
            for (RecordMetaDataProto.JoinedRecordType.JoinConstituent.Builder constituent : joined.getJoinConstituentsBuilderList()) {
                if (!constituent.getRecordType().equals(oldRecordTypeName)) continue;
                constituent.setRecordType(newRecordTypeName);
            }
        }
    }

    public static void addField(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String recordType, @Nonnull DescriptorProtos.FieldDescriptorProto field) {
        DescriptorProtos.DescriptorProto.Builder messageType = MetaDataProtoEditor.findMessageTypeByName(metaDataBuilder.getRecordsBuilder(), recordType);
        if (messageType == null) {
            throw new MetaDataException("Record type " + recordType + " does not exist", new Object[0]);
        }
        DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = MetaDataProtoEditor.findFieldByName(messageType, field.getName());
        if (fieldBuilder != null) {
            throw new MetaDataException("Field " + field.getName() + " already exists in record type " + recordType, new Object[0]);
        }
        messageType.addField(field);
    }

    public static void deprecateField(@Nonnull RecordMetaDataProto.MetaData.Builder metaDataBuilder, @Nonnull String recordType, @Nonnull String fieldName) {
        DescriptorProtos.DescriptorProto.Builder messageType = MetaDataProtoEditor.findMessageTypeByName(metaDataBuilder.getRecordsBuilder(), recordType);
        if (messageType == null) {
            throw new MetaDataException("Record type " + recordType + " does not exist", new Object[0]);
        }
        DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = MetaDataProtoEditor.findFieldByName(messageType, fieldName);
        if (fieldBuilder == null) {
            throw new MetaDataException("Field " + fieldName + " not found in record type " + recordType, new Object[0]);
        }
        MetaDataProtoEditor.setDeprecated(fieldBuilder);
    }

    private static void setDeprecated(DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder) {
        if (fieldBuilder.hasOptions()) {
            fieldBuilder.getOptionsBuilder().setDeprecated(true);
        } else {
            fieldBuilder.setOptions(DescriptorProtos.FieldOptions.newBuilder().setDeprecated(true).build());
        }
    }

    @Nullable
    private static DescriptorProtos.FieldDescriptorProto.Builder findFieldByName(@Nonnull DescriptorProtos.DescriptorProto.Builder messageType, @Nonnull String fieldName) {
        return messageType.getFieldBuilderList().stream().filter(m4 -> m4.getName().equals(fieldName)).findAny().orElse(null);
    }

    @Nonnull
    public static Descriptors.FileDescriptor addDefaultUnionIfMissing(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        if (MetaDataProtoEditor.hasUnion(fileDescriptor)) {
            return fileDescriptor;
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = fileDescriptor.toProto();
        DescriptorProtos.FileDescriptorProto.Builder fileBuilder = fileDescriptorProto.toBuilder();
        fileBuilder.addMessageType(MetaDataProtoEditor.createDefaultUnion(fileBuilder));
        try {
            return Descriptors.FileDescriptor.buildFrom(fileBuilder.build(), fileDescriptor.getDependencies().toArray(new Descriptors.FileDescriptor[0]));
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new MetaDataException("Failed to add a default union", e);
        }
    }

    @Nonnull
    public static Descriptors.FileDescriptor addDefaultUnionIfMissing(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Descriptors.Descriptor baseUnionDescriptor) {
        if (MetaDataProtoEditor.hasUnion(fileDescriptor)) {
            return fileDescriptor;
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = fileDescriptor.toProto();
        DescriptorProtos.FileDescriptorProto.Builder fileBuilder = fileDescriptorProto.toBuilder();
        DescriptorProtos.DescriptorProto.Builder unionDescriptorBuilder = MetaDataProtoEditor.createSyntheticUnion(fileDescriptor, baseUnionDescriptor);
        int unionTypeIndex = fileBuilder.getMessageTypeCount();
        fileBuilder.addMessageType(unionDescriptorBuilder);
        Descriptors.FileDescriptor[] dependencies = fileDescriptor.getDependencies().toArray(new Descriptors.FileDescriptor[0]);
        try {
            fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileBuilder.build(), dependencies);
            Descriptors.Descriptor unionDescriptor = fileDescriptor.findMessageTypeByName(unionDescriptorBuilder.getName());
            for (Descriptors.Descriptor messageType : fileDescriptor.getMessageTypes()) {
                if (Objects.equals(unionDescriptor, messageType) || MetaDataProtoEditor.getMessageTypeUsage(messageType.toProto()) == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED || !unionDescriptor.getFields().stream().noneMatch(field -> field.getMessageType() == messageType)) continue;
                MetaDataProtoEditor.addFieldToUnion(unionDescriptorBuilder, fileBuilder, messageType.getName());
            }
            fileBuilder.removeMessageType(unionTypeIndex);
            fileBuilder.addMessageType(unionDescriptorBuilder);
            return Descriptors.FileDescriptor.buildFrom(fileBuilder.build(), dependencies);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new MetaDataException("Failed to add a default union", e);
        }
    }

    @Nonnull
    private static DescriptorProtos.DescriptorProto.Builder createDefaultUnion(@Nonnull DescriptorProtos.FileDescriptorProtoOrBuilder recordsDescriptor) {
        DescriptorProtos.DescriptorProto.Builder unionMessageType = DescriptorProtos.DescriptorProto.newBuilder();
        unionMessageType.setName("RecordTypeUnion");
        for (DescriptorProtos.DescriptorProtoOrBuilder descriptorProtoOrBuilder : recordsDescriptor.getMessageTypeOrBuilderList()) {
            RecordMetaDataOptionsProto.RecordTypeOptions.Usage messageTypeUsage = MetaDataProtoEditor.getMessageTypeUsage(descriptorProtoOrBuilder);
            if (messageTypeUsage == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED) continue;
            MetaDataProtoEditor.addFieldToUnion(unionMessageType, recordsDescriptor, descriptorProtoOrBuilder.getName());
        }
        return unionMessageType;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public static DescriptorProtos.DescriptorProto.Builder createSyntheticUnion(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull Descriptors.Descriptor baseUnionDescriptor) {
        DescriptorProtos.DescriptorProto.Builder unionMessageType = DescriptorProtos.DescriptorProto.newBuilder();
        unionMessageType.setName("RecordTypeUnion");
        if (!baseUnionDescriptor.getOneofs().isEmpty()) {
            throw new MetaDataException("Adding record type to oneof is not allowed", new Object[0]);
        }
        for (Descriptors.FieldDescriptor field : baseUnionDescriptor.getFields()) {
            Descriptors.Descriptor messageType = fileDescriptor.findMessageTypeByName(field.getMessageType().getName());
            if (messageType == null) {
                throw new MetaDataException("Record type " + field.getMessageType().getName() + " removed", new Object[0]);
            }
            RecordMetaDataOptionsProto.RecordTypeOptions.Usage messageTypeUsage = MetaDataProtoEditor.getMessageTypeUsage(messageType.toProto());
            if (messageTypeUsage == RecordMetaDataOptionsProto.RecordTypeOptions.Usage.NESTED) continue;
            unionMessageType.addField(field.toProto().toBuilder().setTypeName(MetaDataProtoEditor.fullyQualifiedTypeName(messageType.getFile().getPackage(), messageType.getName())));
        }
        return unionMessageType;
    }

    public static boolean hasUnion(@Nonnull Descriptors.FileDescriptor fileDescriptor) {
        for (Descriptors.Descriptor messageType : fileDescriptor.getMessageTypes()) {
            if (!MetaDataProtoEditor.isUnion(messageType)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static enum FieldTypeMatch {
        DOES_NOT_MATCH,
        MATCHES,
        MATCHES_AS_NESTED;

    }
}

