/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.provider.foundationdb.KeyChecker;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimumTupleSizeKeyChecker
implements KeyChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimumTupleSizeKeyChecker.class);
    private final List<CheckedSubspace> checks;
    private final List<byte[]> prefixes = new ArrayList<byte[]>();

    public MinimumTupleSizeKeyChecker(@Nonnull List<CheckedSubspace> checks) {
        this.checks = checks;
    }

    @Override
    public void checkKey(byte[] key, boolean write) {
        CheckedSubspace checkedSubspace = this.findCheckedSubspace(key);
        if (checkedSubspace == null) {
            return;
        }
        if (!checkedSubspace.checkReads && !write) {
            return;
        }
        this.checkKeyLength(checkedSubspace, key);
    }

    @Override
    public void checkKeyRange(byte[] keyBegin, byte[] keyEnd, boolean write) {
        CheckedSubspace checkedSubspace = this.findCheckedSubspace(keyBegin);
        if (checkedSubspace == null) {
            return;
        }
        if (!checkedSubspace.checkReads && !write) {
            return;
        }
        byte[] prefix = this.checkKeyLength(checkedSubspace, keyBegin);
        if (prefix != null && !MinimumTupleSizeKeyChecker.keyHasPrefix(keyEnd, prefix)) {
            this.checkFails(checkedSubspace, "key range not limited to single subspace", "keyBegin", ByteArrayUtil2.loggable(keyBegin), "keyEnd", ByteArrayUtil2.loggable(keyEnd));
        }
    }

    @Override
    public void close() {
        for (CheckedSubspace checkedSubspace : this.checks) {
            if (!checkedSubspace.dryRun) continue;
            this.checkPrefixesCount(checkedSubspace);
        }
    }

    @Nullable
    private CheckedSubspace findCheckedSubspace(@Nonnull byte[] key) {
        for (CheckedSubspace checkedSubspace : this.checks) {
            if (!MinimumTupleSizeKeyChecker.keyHasPrefix(key, checkedSubspace.prefix)) continue;
            return checkedSubspace;
        }
        return null;
    }

    @Nullable
    private synchronized byte[] checkKeyLength(@Nonnull CheckedSubspace checkedSubspace, byte[] key) {
        int prefixLength = TupleHelpers.prefixLengthOfSize(key, checkedSubspace.minTupleSize);
        if (prefixLength < 0) {
            this.checkFails(checkedSubspace, "key not long enough", "key", ByteArrayUtil2.loggable(key));
            return null;
        }
        for (byte[] prefix : this.prefixes) {
            if (prefix.length != prefixLength || !Arrays.equals(key, 0, prefixLength, prefix, 0, prefixLength)) continue;
            return prefix;
        }
        byte[] prefix = Arrays.copyOfRange(key, 0, prefixLength);
        this.prefixes.add(prefix);
        if (!checkedSubspace.dryRun) {
            this.checkPrefixesCount(checkedSubspace);
        }
        return prefix;
    }

    private static boolean keyHasPrefix(@Nonnull byte[] key, @Nonnull byte[] prefix) {
        return key.length >= prefix.length && Arrays.equals(key, 0, prefix.length, prefix, 0, prefix.length);
    }

    private synchronized void checkPrefixesCount(@Nonnull CheckedSubspace checkedSubspace) {
        int count = 0;
        for (byte[] prefix : this.prefixes) {
            if (!MinimumTupleSizeKeyChecker.keyHasPrefix(prefix, checkedSubspace.prefix)) continue;
            ++count;
        }
        if (count > checkedSubspace.maxTuplePrefixCount) {
            String loggable = this.prefixes.stream().map(ByteArrayUtil2::loggable).collect(Collectors.joining("\n"));
            this.checkFails(checkedSubspace, "too many subspaces", "prefixes", loggable);
        }
    }

    private void checkFails(@Nonnull CheckedSubspace checkedSubspace, @Nonnull String message, Object ... keysAndValues) {
        if (checkedSubspace.dryRun) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.of(message, keysAndValues), new Throwable("not thrown"));
            }
        } else {
            throw new RecordCoreException(message, new Object[0]).addLogInfo(keysAndValues);
        }
    }

    public static class CheckedSubspace {
        @Nonnull
        private final byte[] prefix;
        private final boolean dryRun;
        private final boolean checkReads;
        private final int minTupleSize;
        private final int maxTuplePrefixCount;

        public CheckedSubspace(@Nonnull byte[] prefix, boolean dryRun, boolean checkReads, int minTupleSize, int maxTuplePrefixCount) {
            this.prefix = prefix;
            this.dryRun = dryRun;
            this.checkReads = checkReads;
            this.minTupleSize = minTupleSize;
            this.maxTuplePrefixCount = maxTuplePrefixCount;
        }
    }
}

