/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MultidimensionalIndexScanBounds
implements IndexScanBounds {
    @Nonnull
    private final TupleRange prefixRange;
    @Nonnull
    private final SpatialPredicate spatialPredicate;
    @Nonnull
    private final TupleRange suffixRange;

    public MultidimensionalIndexScanBounds(@Nonnull TupleRange prefixRange, @Nonnull SpatialPredicate spatialPredicate, @Nonnull TupleRange suffixRange) {
        this.prefixRange = prefixRange;
        this.spatialPredicate = spatialPredicate;
        this.suffixRange = suffixRange;
    }

    @Override
    @Nonnull
    public IndexScanType getScanType() {
        return IndexScanType.BY_VALUE;
    }

    @Nonnull
    public TupleRange getPrefixRange() {
        return this.prefixRange;
    }

    @Nonnull
    public SpatialPredicate getSpatialPredicate() {
        return this.spatialPredicate;
    }

    @Nonnull
    public TupleRange getSuffixRange() {
        return this.suffixRange;
    }

    public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle mbr) {
        return this.spatialPredicate.overlapsMbrApproximately(mbr);
    }

    public boolean containsPosition(@Nonnull RTree.Point position) {
        return this.spatialPredicate.containsPosition(position);
    }

    public static interface SpatialPredicate {
        public static final SpatialPredicate TAUTOLOGY = new SpatialPredicate(){

            @Override
            public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle mbr) {
                return true;
            }

            @Override
            public boolean containsPosition(@Nonnull RTree.Point position) {
                return true;
            }
        };

        public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle var1);

        public boolean containsPosition(@Nonnull RTree.Point var1);
    }

    public static class Hypercube
    implements SpatialPredicate {
        @Nonnull
        private final List<TupleRange> dimensionRanges;

        public Hypercube(@Nonnull List<TupleRange> dimensionRanges) {
            this.dimensionRanges = ImmutableList.copyOf(dimensionRanges);
        }

        @Override
        public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle mbr) {
            Preconditions.checkArgument(mbr.getNumDimensions() == this.dimensionRanges.size());
            for (int d = 0; d < mbr.getNumDimensions(); ++d) {
                Tuple lowTuple = Tuple.from(mbr.getLow(d));
                Tuple highTuple = Tuple.from(mbr.getHigh(d));
                TupleRange dimensionRange = this.dimensionRanges.get(d);
                if (dimensionRange.overlaps(lowTuple, highTuple)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsPosition(@Nonnull RTree.Point position) {
            Preconditions.checkArgument(position.getNumDimensions() == this.dimensionRanges.size());
            for (int d = 0; d < position.getNumDimensions(); ++d) {
                Tuple coordinate = Tuple.from(position.getCoordinate(d));
                TupleRange dimensionRange = this.dimensionRanges.get(d);
                if (dimensionRange.contains(coordinate)) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        public List<TupleRange> getDimensionRanges() {
            return this.dimensionRanges;
        }

        public String toString() {
            return "HyperCube:[" + String.valueOf(this.dimensionRanges) + "]";
        }
    }

    public static class And
    implements SpatialPredicate {
        @Nonnull
        private final List<SpatialPredicate> children;

        public And(@Nonnull List<SpatialPredicate> children) {
            this.children = ImmutableList.copyOf(children);
        }

        @Override
        public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle mbr) {
            return this.children.stream().allMatch(child -> child.overlapsMbrApproximately(mbr));
        }

        @Override
        public boolean containsPosition(@Nonnull RTree.Point position) {
            return this.children.stream().allMatch(child -> child.containsPosition(position));
        }

        public String toString() {
            return this.children.stream().map(Object::toString).collect(Collectors.joining(" and "));
        }
    }

    public static class Or
    implements SpatialPredicate {
        @Nonnull
        private final List<SpatialPredicate> children;

        public Or(@Nonnull List<SpatialPredicate> children) {
            this.children = ImmutableList.copyOf(children);
        }

        @Override
        public boolean overlapsMbrApproximately(@Nonnull RTree.Rectangle mbr) {
            return this.children.stream().anyMatch(child -> child.overlapsMbrApproximately(mbr));
        }

        @Override
        public boolean containsPosition(@Nonnull RTree.Point position) {
            return this.children.stream().anyMatch(child -> child.containsPosition(position));
        }

        public String toString() {
            return this.children.stream().map(Object::toString).collect(Collectors.joining(" or "));
        }
    }
}

